/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import org.cojen.tupl.Index;
import org.cojen.tupl.core.CoreDeadlockInfo;
import org.cojen.tupl.core.DeadlockInfoSet;
import org.cojen.tupl.core.DetachedDeadlockInfo;
import org.cojen.tupl.core.DetachedLock;
import org.cojen.tupl.core._LocalDatabase;
import org.cojen.tupl.core._Lock;
import org.cojen.tupl.core._LockManager;
import org.cojen.tupl.core._Locker;
import org.cojen.tupl.diag.DeadlockInfo;
import org.cojen.tupl.rows.RowStore;

final class _DeadlockDetector
extends HashMap<_Locker, Boolean> {
    private final _Locker mOrigin;
    private final LinkedHashMap<_Lock, Boolean> mLocks;
    boolean mGuilty;

    _DeadlockDetector(_Locker locker, boolean gatherLocks) {
        this.mOrigin = locker;
        this.mLocks = gatherLocks ? new LinkedHashMap() : null;
    }

    Set<DeadlockInfo> newDeadlockSet(int lockType) {
        if (this.mLocks == null || this.mLocks.isEmpty()) {
            return Collections.emptySet();
        }
        DeadlockInfo[] infos = new DeadlockInfo[this.mLocks.size()];
        _LockManager manager = this.mOrigin.mManager;
        int i = 0;
        for (_Lock lock : this.mLocks.keySet()) {
            Object attachment = lock.findOwnerAttachment(this.mOrigin, false, lockType);
            infos[i++] = _DeadlockDetector.newDeadlockInfo(manager, lock, attachment);
        }
        return new DeadlockInfoSet(infos);
    }

    static DeadlockInfo newDeadlockInfo(_LockManager manager, _Lock lock, Object attachment) {
        RowStore rs;
        _LocalDatabase db;
        byte[] key;
        if (lock instanceof DetachedLock) {
            return new DetachedDeadlockInfo(lock.toString(), attachment);
        }
        CoreDeadlockInfo info = new CoreDeadlockInfo();
        info.mIndexId = lock.mIndexId;
        info.mAttachment = attachment;
        Index ix = manager.indexById(info.mIndexId);
        if (ix != null) {
            info.mIndexName = ix.name();
        }
        if ((key = lock.mKey) != null) {
            key = (byte[])key.clone();
        }
        info.mKey = key;
        WeakReference<_LocalDatabase> dbRef = manager.mDatabaseRef;
        if (dbRef != null && (db = (_LocalDatabase)dbRef.get()) != null && (rs = db.tryRowStore()) != null) {
            info.mRow = rs.toRow(ix, key);
        }
        return info;
    }

    boolean scan() {
        return this.scan(this.mOrigin);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean scan(_Locker locker) {
        boolean found = false;
        _Lock lock;
        block0: while ((lock = locker.mWaitingFor) != null) {
            if (this.mLocks != null) {
                this.mLocks.put(lock, Boolean.TRUE);
            }
            if (this.put(locker, Boolean.TRUE) != null) {
                if (locker == this.mOrigin) {
                    this.mGuilty = true;
                }
                return true;
            }
            _Locker owner = lock.mOwner;
            Object shared = lock.getSharedLocker();
            if (owner != null && owner != locker) {
                if (shared == null) {
                    locker = owner;
                    continue;
                }
                found |= this.scan(owner);
            }
            if (shared instanceof _Locker) {
                locker = (_Locker)shared;
                continue;
            }
            if (!(shared instanceof _Lock.LockerHTEntry[])) {
                return found;
            }
            _Lock.LockerHTEntry[] entries = (_Lock.LockerHTEntry[])shared;
            int i = entries.length;
            block1: while (true) {
                if (--i < 0) {
                    return found;
                }
                _Lock.LockerHTEntry e = entries[i];
                while (true) {
                    if (e == null) continue block1;
                    _Lock.LockerHTEntry next = e.mNext;
                    if (i == 0 && next == null) {
                        locker = e.mOwner;
                        continue block0;
                    }
                    found |= this.scan(e.mOwner);
                    e = next;
                }
                break;
            }
            break;
        }
        return found;
    }
}

