/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.util.concurrent.TimeUnit;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.DetachedLock;
import org.cojen.tupl.core._LocalTransaction;
import org.cojen.tupl.core._Lock;
import org.cojen.tupl.core._LockManager;
import org.cojen.tupl.core._Locker;
import org.cojen.tupl.util.LatchCondition;

class _DetachedLockImpl
extends _Lock
implements DetachedLock {
    _LockManager.Bucket mBucket;

    _DetachedLockImpl() {
    }

    void init(int hash, _LocalTransaction owner, _LockManager.Bucket bucket) {
        this.mHashCode = hash;
        this.mLockCount = Integer.MIN_VALUE;
        this.mOwner = owner;
        this.mBucket = bucket;
    }

    @Override
    public final void acquireShared(Transaction txn) throws LockFailureException {
        this.acquireShared((_LocalTransaction)txn);
    }

    final void acquireShared(_LocalTransaction txn) throws LockFailureException {
        long nanosTimeout = txn.lockTimeout(TimeUnit.NANOSECONDS);
        LockResult result = this.tryAcquireShared(txn, nanosTimeout);
        if (!result.isHeld()) {
            throw txn.failed(1, result, nanosTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final _Lock acquireSharedNoPush(_LocalTransaction txn) throws LockFailureException {
        LockResult result;
        long nanosTimeout = txn.lockTimeout(TimeUnit.NANOSECONDS);
        _LockManager.Bucket bucket = this.mBucket;
        bucket.acquireExclusive();
        try {
            result = this.tryLockShared(bucket, txn, nanosTimeout);
        }
        finally {
            bucket.releaseExclusive();
        }
        if (!result.isHeld()) {
            throw txn.failed(1, result, nanosTimeout);
        }
        return result == LockResult.ACQUIRED ? this : null;
    }

    @Override
    public final LockResult tryAcquireShared(Transaction txn, long nanosTimeout) {
        return this.tryAcquireShared((_LocalTransaction)txn, nanosTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LockResult tryAcquireShared(_LocalTransaction txn, long nanosTimeout) {
        LockResult result;
        _LockManager.Bucket bucket = this.mBucket;
        bucket.acquireExclusive();
        try {
            result = this.tryLockShared(bucket, txn, nanosTimeout);
        }
        finally {
            bucket.releaseExclusive();
        }
        if (result == LockResult.ACQUIRED) {
            txn.push(this);
        }
        return result;
    }

    @Override
    public final void acquireExclusive() throws LockFailureException {
        long nanosTimeout = ((_LocalTransaction)this.mOwner).lockTimeout(TimeUnit.NANOSECONDS);
        LockResult result = this.tryAcquireExclusive(nanosTimeout);
        if (!result.isHeld()) {
            throw this.mOwner.failed(-1, result, nanosTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockResult tryAcquireExclusive(long nanosTimeout) {
        LockResult result;
        _Locker locker = this.mOwner;
        _LockManager.Bucket bucket = this.mBucket;
        bucket.acquireExclusive();
        try {
            result = this.tryLockExclusive(bucket, locker, nanosTimeout);
        }
        finally {
            bucket.releaseExclusive();
        }
        if (result == LockResult.UPGRADED) {
            locker.push(this);
            result = LockResult.ACQUIRED;
        }
        return result;
    }

    @Override
    protected void doUnlockOwnedUnrestricted(_LockManager.Bucket bucket) {
        if (this.mLockCount == -1) {
            this.mLockCount = Integer.MIN_VALUE;
            LatchCondition queueSX = this.mQueueSX;
            if (queueSX != null) {
                queueSX.signalTagged(bucket);
            }
        }
        bucket.releaseExclusive();
    }
}

