/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.util.Arrays;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.core.CommitLock;
import org.cojen.tupl.core.DirectPageOps;
import org.cojen.tupl.core.LHashTable;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._BTree;
import org.cojen.tupl.core._BTreeCursor;
import org.cojen.tupl.core._LocalDatabase;
import org.cojen.tupl.core._LocalTransaction;
import org.cojen.tupl.core._Node;

final class _FragmentedTrash {
    private _FragmentedTrash() {
    }

    static void add(_BTree trash, _LocalTransaction txn, long indexId, long entry, int keyStart, int keyLen, int valueStart, int valueLen) throws IOException {
        byte[] payload = new byte[valueLen];
        DirectPageOps.p_copyToArray(entry, valueStart, payload, 0, valueLen);
        _BTreeCursor cursor = _FragmentedTrash.prepareEntry(trash, txn.txnId());
        byte[] key = cursor.key();
        try {
            txn.setHasTrash();
            cursor.store(payload);
            cursor.reset();
        }
        catch (Throwable e) {
            try {
                txn.borked(e);
            }
            catch (Throwable e2) {
                e = e2;
            }
            throw Utils.closeOnFailure(cursor, e);
        }
        int tidLen = key.length - 8;
        int payloadLen = keyLen + tidLen;
        if (payloadLen > payload.length) {
            payload = new byte[payloadLen];
        }
        DirectPageOps.p_copyToArray(entry, keyStart, payload, 0, keyLen);
        System.arraycopy(key, 8, payload, keyLen, tidLen);
        txn.pushUndeleteFragmented(indexId, payload, 0, payloadLen);
    }

    private static _BTreeCursor prepareEntry(_BTree trash, long txnId) throws IOException {
        byte[] prefix = new byte[8];
        Utils.encodeLongBE(prefix, 0, txnId);
        _BTreeCursor cursor = new _BTreeCursor(trash, Transaction.BOGUS);
        try {
            cursor.autoload(false);
            cursor.findGt(prefix);
            byte[] key = cursor.key();
            if (key == null || Arrays.compareUnsigned(key, 0, 8, prefix, 0, 8) != 0) {
                key = new byte[9];
                System.arraycopy(prefix, 0, key, 0, 8);
                key[8] = -1;
                cursor.findNearby(key);
            } else {
                cursor.findNearby(Utils.decrementReverseUnsignedVar(key, 8));
            }
            return cursor;
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(cursor, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(_BTree trash, long txnId, _BTree index, byte[] undoEntry) throws IOException {
        byte[] trashKey;
        byte[] indexKey;
        long undo = DirectPageOps.p_transfer(undoEntry);
        try {
            _Node dbAccess = trash.mRoot;
            indexKey = _Node.retrieveKeyAtLoc(dbAccess, undo, 0);
            int tidLoc = _Node.keyLengthAtLoc(undo, 0);
            int tidLen = undoEntry.length - tidLoc;
            trashKey = new byte[8 + tidLen];
            Utils.encodeLongBE(trashKey, 0, txnId);
            DirectPageOps.p_copyToArray(undo, tidLoc, trashKey, 8, tidLen);
        }
        finally {
            DirectPageOps.p_delete(undo);
        }
        _FragmentedTrash.remove(trash, index, indexKey, trashKey);
    }

    static void remove(_BTree trash, _BTree index, byte[] indexKey, byte[] trashKey) throws IOException {
        _BTreeCursor trashCursor = new _BTreeCursor(trash, Transaction.BOGUS);
        try {
            trashCursor.find(trashKey);
            if (index == null) {
                _FragmentedTrash.deleteFragmented(trash.mDatabase, trashCursor);
            } else {
                byte[] fragmented = trashCursor.value();
                if (fragmented != null) {
                    _BTreeCursor ixCursor = new _BTreeCursor(index, Transaction.BOGUS);
                    try {
                        ixCursor.find(indexKey);
                        ixCursor.storeFragmented(fragmented);
                        ixCursor.reset();
                    }
                    catch (Throwable e) {
                        throw Utils.closeOnFailure(ixCursor, e);
                    }
                    trashCursor.store(null);
                }
            }
            trashCursor.reset();
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(trashCursor, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void emptyTrash(_BTree trash, long txnId) throws IOException {
        byte[] prefix = new byte[8];
        Utils.encodeLongBE(prefix, 0, txnId);
        _LocalDatabase db = trash.mDatabase;
        CommitLock commitLock = db.commitLock();
        _BTreeCursor cursor = new _BTreeCursor(trash, Transaction.BOGUS);
        try {
            byte[] key;
            cursor.autoload(false);
            cursor.findGt(prefix);
            while ((key = cursor.key()) != null && Arrays.compareUnsigned(key, 0, 8, prefix, 0, 8) == 0) {
                CommitLock.Shared shared = commitLock.acquireShared();
                try {
                    _FragmentedTrash.deleteFragmented(db, cursor);
                }
                finally {
                    shared.release();
                }
                cursor.next();
            }
            cursor.reset();
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(cursor, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void emptyLingeringTrash(_BTree trash, LHashTable<?> activeTxns) throws IOException {
        _LocalDatabase db = trash.mDatabase;
        CommitLock commitLock = db.commitLock();
        byte[] boundary = new byte[8];
        Utils.encodeLongBE(boundary, 0, Long.MIN_VALUE);
        View view = activeTxns == null ? trash.viewGe(boundary) : trash.viewLt(boundary);
        try (Cursor cursor = view.newCursor(Transaction.BOGUS);){
            cursor.autoload(false);
            cursor.first();
            while (cursor.key() != null) {
                if (activeTxns == null || activeTxns.get(Utils.decodeLongBE(cursor.key(), 0)) == null) {
                    CommitLock.Shared shared = commitLock.acquireShared();
                    try {
                        _FragmentedTrash.deleteFragmented(db, cursor);
                    }
                    finally {
                        shared.release();
                    }
                }
                cursor.next();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFragmented(_LocalDatabase db, Cursor cursor) throws IOException {
        cursor.load();
        byte[] value = cursor.value();
        if (value != null) {
            long fragmented = DirectPageOps.p_transfer(value);
            try {
                db.deleteFragments(fragmented, 0, value.length);
                cursor.store(null);
            }
            finally {
                DirectPageOps.p_delete(fragmented);
            }
        }
    }
}

