/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.cojen.tupl.core.DirectPageOps;
import org.cojen.tupl.core.IntegerRef;

final class _IdHeap {
    private final int mDrainSize;
    private long[] mIds;
    private int mSize;

    public _IdHeap(int drainSize) {
        this.mDrainSize = drainSize;
        this.mIds = new long[drainSize + 1];
    }

    public int size() {
        return this.mSize;
    }

    public void add(long id) {
        int parentPos;
        long parentId;
        int pos = this.mSize;
        long[] ids = this.mIds;
        if (pos >= ids.length) {
            this.mIds = ids = Arrays.copyOf(ids, (int)((double)ids.length * 1.5));
        }
        while (pos > 0 && id < (parentId = ids[parentPos = pos - 1 >>> 1])) {
            ids[pos] = parentId;
            pos = parentPos;
        }
        ids[pos] = id;
        ++this.mSize;
    }

    public long remove() {
        long id = this.tryRemove();
        if (id == 0L) {
            throw new NoSuchElementException();
        }
        return id;
    }

    public long tryRemove() {
        int size = this.mSize;
        if (size <= 0) {
            return 0L;
        }
        int pos = size - 1;
        long[] ids = this.mIds;
        long result = ids[0];
        if (pos != 0) {
            long id = ids[pos];
            pos = 0;
            int half = size >>> 1;
            while (pos < half) {
                int childPos = (pos << 1) + 1;
                long child = ids[childPos];
                int rightPos = childPos + 1;
                if (rightPos < size && child > ids[rightPos]) {
                    childPos = rightPos;
                    child = ids[childPos];
                }
                if (id <= child) break;
                ids[pos] = child;
                pos = childPos;
            }
            ids[pos] = id;
        }
        this.mSize = size - 1;
        return result;
    }

    public void remove(long id) {
        long removed;
        long[] copy = new long[this.mIds.length];
        int pos = 0;
        while ((removed = this.tryRemove()) != 0L) {
            if (removed == id) continue;
            copy[pos++] = removed;
        }
        while (--pos >= 0) {
            this.add(copy[pos]);
        }
    }

    public boolean shouldDrain() {
        return this.mSize >= this.mDrainSize;
    }

    public int drain(long prevId, long buffer, int offset, int length) {
        long id;
        int end = offset + length;
        while (this.mSize > 0 && offset < end && (offset <= end - 9 || offset + DirectPageOps.p_ulongVarSize((id = this.mIds[0]) - prevId) <= end)) {
            id = this.remove();
            offset = DirectPageOps.p_ulongPutVar(buffer, offset, id - prevId);
            prevId = id;
        }
        return offset;
    }

    public void undrain(long id, long buffer, int offset, int endOffset) {
        this.add(id);
        IntegerRef.Value offsetRef = new IntegerRef.Value();
        offsetRef.set(offset);
        while (offsetRef.get() < endOffset) {
            this.add(id += DirectPageOps.p_ulongGetVar(buffer, offsetRef));
        }
    }
}

