/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import java.util.zip.Checksum;
import org.cojen.tupl.CacheExhaustedException;
import org.cojen.tupl.ConfirmationInterruptedException;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DatabaseFullException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Index;
import org.cojen.tupl.LargeKeyException;
import org.cojen.tupl.LargeValueException;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.LockTimeoutException;
import org.cojen.tupl.Server;
import org.cojen.tupl.Snapshot;
import org.cojen.tupl.Sorter;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.UnmodifiableReplicaException;
import org.cojen.tupl.View;
import org.cojen.tupl.core.Checkpointer;
import org.cojen.tupl.core.CommitLock;
import org.cojen.tupl.core.CoreDatabase;
import org.cojen.tupl.core.DetachedLock;
import org.cojen.tupl.core.DirectPageOps;
import org.cojen.tupl.core.LHashTable;
import org.cojen.tupl.core.Launcher;
import org.cojen.tupl.core.LockedFile;
import org.cojen.tupl.core.RedoEventPrinter;
import org.cojen.tupl.core.RedoListener;
import org.cojen.tupl.core.ReplDecoder;
import org.cojen.tupl.core.RowPredicateLock;
import org.cojen.tupl.core.ScanVisitor;
import org.cojen.tupl.core.Servers;
import org.cojen.tupl.core.ShutdownHook;
import org.cojen.tupl.core.TempFileManager;
import org.cojen.tupl.core.Tree;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._BTree;
import org.cojen.tupl.core._BTreeCursor;
import org.cojen.tupl.core._CustomWriter;
import org.cojen.tupl.core._FragmentedTrash;
import org.cojen.tupl.core._HandlerWriter;
import org.cojen.tupl.core._LocalTransaction;
import org.cojen.tupl.core._LockManager;
import org.cojen.tupl.core._Locker;
import org.cojen.tupl.core._Node;
import org.cojen.tupl.core._NodeGroup;
import org.cojen.tupl.core._NonPageDb;
import org.cojen.tupl.core._PageDb;
import org.cojen.tupl.core._ParallelSorter;
import org.cojen.tupl.core._PrepareWriter;
import org.cojen.tupl.core._RedoLog;
import org.cojen.tupl.core._RedoLogApplier;
import org.cojen.tupl.core._RedoWriter;
import org.cojen.tupl.core._ReplController;
import org.cojen.tupl.core._ReplEngine;
import org.cojen.tupl.core._ReplWriter;
import org.cojen.tupl.core._RowPredicateLockImpl;
import org.cojen.tupl.core._StoredPageDb;
import org.cojen.tupl.core._TransactionContext;
import org.cojen.tupl.core._TreeRef;
import org.cojen.tupl.core._UndoLog;
import org.cojen.tupl.diag.CompactionObserver;
import org.cojen.tupl.diag.DatabaseStats;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.diag.VerificationObserver;
import org.cojen.tupl.ev.SafeEventListener;
import org.cojen.tupl.ext.Crypto;
import org.cojen.tupl.ext.CustomHandler;
import org.cojen.tupl.ext.Handler;
import org.cojen.tupl.ext.PrepareHandler;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.jmx.Registration;
import org.cojen.tupl.repl.StreamReplicator;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.Runner;

final class _LocalDatabase
extends CoreDatabase {
    private static final int DEFAULT_CACHE_NODES = 1000;
    private static final int MIN_CACHE_NODES = 5;
    private static final long PRIMER_MAGIC_NUMBER = 4943712973215968399L;
    private static final String LOCK_FILE_SUFFIX = ".lock";
    static final String PRIMER_FILE_SUFFIX = ".primer";
    static final String REDO_FILE_SUFFIX = ".redo.";
    private static final int I_ENCODING_VERSION = 0;
    private static final int I_ROOT_PAGE_ID = 4;
    private static final int I_MASTER_UNDO_LOG_PAGE_ID = 12;
    private static final int I_TRANSACTION_ID = 20;
    private static final int I_CHECKPOINT_NUMBER = 28;
    private static final int I_REDO_TXN_ID = 36;
    private static final int I_REDO_POSITION = 44;
    private static final int I_REPL_ENCODING = 52;
    private static final int HEADER_SIZE = 60;
    private static final int DEFAULT_PAGE_SIZE = 4096;
    private static final int MINIMUM_PAGE_SIZE = 512;
    private static final int MAXIMUM_PAGE_SIZE = 65536;
    private final int mEncodingVersion;
    final EventListener mEventListener;
    private final File mBaseFile;
    private final boolean mReadOnly;
    private final LockedFile mLockFile;
    final DurabilityMode mDurabilityMode;
    final long mDefaultLockTimeoutNanos;
    final _LockManager mLockManager;
    private final ThreadLocal<SoftReference<_LocalTransaction>> mLocalTransaction;
    final _RedoWriter mRedoWriter;
    final _PageDb mPageDb;
    final int mPageSize;
    private final Object mArena;
    private final _NodeGroup[] mNodeGroups;
    private final CommitLock mCommitLock;
    private byte mCommitState;
    private volatile byte mInitialReadState = 0;
    private long mCommitHeader = DirectPageOps.p_null();
    private static final VarHandle cCommitHeaderHandle;
    private _UndoLog mCommitMasterUndoLog;
    private volatile int mCheckpointFlushState = -1;
    private static final int CHECKPOINT_FLUSH_PREPARE = -2;
    private static final int CHECKPOINT_NOT_FLUSHING = -1;
    private final _BTree mRegistry;
    static final byte RK_INDEX_NAME = 0;
    static final byte RK_INDEX_ID = 1;
    static final byte RK_TREE_ID_MASK = 2;
    static final byte RK_NEXT_TREE_ID = 3;
    static final byte RK_TRASH_ID = 4;
    static final byte RK_NEXT_TEMP_ID = 5;
    static final byte RK_CUSTOM_NAME = 6;
    static final byte RK_CUSTOM_ID = 7;
    static final byte RK_PREPARE_NAME = 8;
    static final byte RK_PREPARE_ID = 9;
    private final _BTree mRegistryKeyMap;
    private final Latch mOpenTreesLatch;
    private final Map<byte[], _TreeRef> mOpenTrees;
    private final LHashTable.Obj<_TreeRef> mOpenTreesById;
    private final ReferenceQueue<Object> mOpenTreesRefQueue;
    private _Node[] mNodeMapTable;
    private static final _Node NM_LOCK;
    private static final VarHandle cNodeMapElementHandle;
    final int mMaxKeySize;
    final int mMaxEntrySize;
    final int mMaxFragmentedEntrySize;
    private _BTree mFragmentedTrash;
    private final long[] mFragmentInodeLevelCaps;
    private final _TransactionContext[] mTxnContexts;
    private final ReentrantLock mCheckpointLock = new ReentrantLock(true);
    private long mLastCheckpointStartNanos;
    private volatile long mLastCheckpointDurationNanos;
    private final Checkpointer mCheckpointer;
    final TempFileManager mTempFileManager;
    final boolean mFullyMapped;
    private _BTree mCursorRegistry;
    private final Map<String, CustomHandler> mCustomHandlers;
    private final LHashTable.Obj<CustomHandler> mCustomHandlersById;
    private final Map<String, PrepareHandler> mPrepareHandlers;
    private final LHashTable.Obj<PrepareHandler> mPrepareHandlersById;
    private _BTree mPreparedTxns;
    private RowStore mRowStore;
    private volatile Servers mServers;
    private volatile int mClosed;
    private volatile Throwable mClosedCause;
    private static final VarHandle cClosedHandle;

    private static int nodeCountFromBytes(long bytes, int pageSize) {
        if (bytes <= 0L) {
            return 0;
        }
        if ((bytes += (long)((pageSize += 76) - 1)) <= 0L) {
            return Integer.MAX_VALUE;
        }
        long count = bytes / (long)pageSize;
        return count <= Integer.MAX_VALUE ? (int)count : Integer.MAX_VALUE;
    }

    private static long byteCountFromNodes(int nodes, int pageSize) {
        return (long)nodes * (long)(pageSize + 76);
    }

    static _LocalDatabase open(Launcher launcher) throws IOException {
        _LocalDatabase db = new _LocalDatabase(launcher, false);
        try {
            db.finishInit(launcher);
            return db;
        }
        catch (Throwable e) {
            Utils.closeQuietly(db);
            throw e;
        }
    }

    static _LocalDatabase destroy(Launcher launcher) throws IOException {
        if (launcher.mReadOnly) {
            throw new IllegalArgumentException("Cannot destroy read-only database");
        }
        _LocalDatabase db = new _LocalDatabase(launcher, true);
        try {
            db.finishInit(launcher);
            return db;
        }
        catch (Throwable e) {
            Utils.closeQuietly(db);
            throw e;
        }
    }

    static _BTree openTemp(TempFileManager tfm, Launcher launcher) throws IOException {
        File file = tfm.createTempFile();
        launcher.baseFile(file);
        launcher.dataFiles(file);
        launcher.createFilePath(false);
        launcher.durabilityMode(DurabilityMode.NO_FLUSH);
        launcher.mBasicMode = true;
        _LocalDatabase db = new _LocalDatabase(launcher, false);
        tfm.register(file, db);
        db.mCheckpointer.start(false);
        return db.mRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private _LocalDatabase(Launcher launcher, boolean destroy) throws IOException {
        int minCache;
        int maxCache;
        this.mEncodingVersion = launcher.mBasicMode ? 20130113 : 20130112;
        launcher.mEventListener = this.mEventListener = SafeEventListener.makeSafe(launcher.mEventListener);
        this.mCustomHandlers = Launcher.mapClone(launcher.mCustomHandlers);
        this.mCustomHandlersById = Launcher.newByIdMap(this.mCustomHandlers);
        this.mPrepareHandlers = Launcher.mapClone(launcher.mPrepareHandlers);
        this.mPrepareHandlersById = Launcher.newByIdMap(this.mPrepareHandlers);
        this.mBaseFile = launcher.mBaseFile;
        this.mReadOnly = launcher.mReadOnly;
        File[] dataFiles = launcher.dataFiles();
        int pageSize = launcher.mPageSize;
        boolean explicitPageSize = true;
        if (pageSize <= 0) {
            pageSize = 4096;
            launcher.pageSize(4096);
            explicitPageSize = false;
        } else {
            if (pageSize < 512) {
                throw new IllegalArgumentException("Page size is too small: " + pageSize + " < 512");
            }
            if (pageSize > 65536) {
                throw new IllegalArgumentException("Page size is too large: " + pageSize + " > 65536");
            }
            if ((pageSize & 1) != 0) {
                throw new IllegalArgumentException("Page size must be even: " + pageSize);
            }
        }
        long minCacheBytes = Math.max(0L, launcher.mMinCacheBytes);
        long maxCacheBytes = Math.max(0L, launcher.mMaxCacheBytes);
        if (maxCacheBytes == 0L && (maxCacheBytes = minCacheBytes) == 0L) {
            maxCache = 1000;
            minCache = 1000;
        } else {
            if (minCacheBytes > maxCacheBytes) {
                throw new IllegalArgumentException("Minimum cache size exceeds maximum: " + minCacheBytes + " > " + maxCacheBytes);
            }
            minCache = _LocalDatabase.nodeCountFromBytes(minCacheBytes, pageSize);
            maxCache = _LocalDatabase.nodeCountFromBytes(maxCacheBytes, pageSize);
            minCache = Math.max(5, minCache);
            maxCache = Math.max(5, maxCache);
        }
        launcher.mMinCacheBytes = _LocalDatabase.byteCountFromNodes(minCache, pageSize);
        launcher.mMaxCacheBytes = _LocalDatabase.byteCountFromNodes(maxCache, pageSize);
        this.mDurabilityMode = launcher.mDurabilityMode;
        this.mDefaultLockTimeoutNanos = launcher.mLockTimeoutNanos;
        this.mLockManager = new _LockManager(this, launcher.mLockUpgradeRule, this.mDefaultLockTimeoutNanos);
        this.mLocalTransaction = new ThreadLocal();
        int capacity = Utils.roundUpPower2(maxCache);
        if (capacity < 0) {
            capacity = 0x40000000;
        }
        this.mNodeMapTable = new _Node[capacity];
        if (this.mBaseFile != null && !this.mReadOnly && launcher.mMkdirs) {
            File baseDir = this.mBaseFile.getParentFile();
            boolean baseDirectoriesCreated = baseDir.mkdirs();
            if (!baseDirectoriesCreated && !baseDir.exists()) {
                throw new FileNotFoundException("Could not create directory: " + baseDir);
            }
            if (dataFiles != null) {
                for (File f : dataFiles) {
                    File dataDir = f.getParentFile();
                    boolean dataDirectoriesCreated = dataDir.mkdirs();
                    if (dataDirectoriesCreated || dataDir.exists()) continue;
                    throw new FileNotFoundException("Could not create directory: " + dataDir);
                }
            }
        }
        int procCount = Runtime.getRuntime().availableProcessors();
        LockedFile attemptCreate = null;
        try {
            _NodeGroup[] groups;
            if (this.mBaseFile == null || launcher.mBasicMode) {
                this.mLockFile = null;
            } else {
                File lockFile = new File(this.lockFilePath());
                boolean didExist = lockFile.exists();
                this.mLockFile = new LockedFile(lockFile, this.mReadOnly);
                if (!didExist) {
                    attemptCreate = this.mLockFile;
                }
            }
            if (destroy) {
                this.deleteRedoLogFiles();
            }
            long cacheInitStart = System.nanoTime();
            boolean fullyMapped = false;
            EventListener debugListener = null;
            if (launcher.mDebugOpen != null) {
                debugListener = this.mEventListener;
            }
            if (dataFiles == null) {
                PageArray dataPageArray = launcher.mDataPageArray;
                if (dataPageArray == null) {
                    this.mPageDb = new _NonPageDb(pageSize);
                } else {
                    dataPageArray = dataPageArray.open();
                    Crypto crypto = launcher.mDataCrypto;
                    this.mPageDb = _StoredPageDb.open(debugListener, dataPageArray, launcher.mChecksumFactory, crypto, destroy);
                    fullyMapped = crypto == null && dataPageArray.isFullyMapped();
                }
            } else {
                _PageDb pageDb;
                EnumSet<OpenOption> options = launcher.createOpenOptions();
                try {
                    pageDb = _StoredPageDb.open(debugListener, explicitPageSize, pageSize, dataFiles, options, launcher.mChecksumFactory, launcher.mDataCrypto, destroy);
                }
                catch (FileNotFoundException e) {
                    if (!this.mReadOnly) {
                        throw e;
                    }
                    pageDb = new _NonPageDb(pageSize);
                }
                this.mPageDb = pageDb;
            }
            this.mFullyMapped = fullyMapped;
            pageSize = this.mPageSize = this.mPageDb.pageSize();
            launcher.mDirectPageAccess = true;
            this.mCommitLock = this.mPageDb.commitLock();
            if (this.mEventListener != null) {
                this.mEventListener.notify(EventType.CACHE_INIT_BEGIN, "Initializing %1$d cache nodes", minCache);
            }
            try {
                int stripeSize;
                if (this.mFullyMapped) {
                    this.mArena = null;
                } else {
                    try {
                        this.mArena = DirectPageOps.p_arenaAlloc(this.mPageDb.directPageSize(), minCache);
                    }
                    catch (IOException e) {
                        OutOfMemoryError oom = new OutOfMemoryError();
                        oom.initCause(e);
                        throw oom;
                    }
                }
                long usedRate = this.isCacheOnly() ? -1L : Utils.roundUpPower2((long)Math.ceil((double)maxCache / 32768.0)) - 1L;
                int stripes = Utils.roundUpPower2(procCount * 16);
                while (true) {
                    stripeSize = maxCache / stripes;
                    if (stripes <= 1 || stripeSize >= 100) break;
                    stripes >>= 1;
                }
                int rem = maxCache % stripes;
                groups = new _NodeGroup[stripes];
                for (int i = 0; i < stripes; ++i) {
                    int size = stripeSize;
                    if (rem > 0) {
                        ++size;
                        --rem;
                    }
                    groups[i] = new _NodeGroup(this, usedRate, size);
                }
                stripeSize = minCache / stripes;
                rem = minCache % stripes;
                for (_NodeGroup group : groups) {
                    int size = stripeSize;
                    if (rem > 0) {
                        ++size;
                        --rem;
                    }
                    group.initialize(this.mArena, size);
                }
            }
            catch (OutOfMemoryError e) {
                groups = null;
                OutOfMemoryError oom = new OutOfMemoryError("Unable to allocate the minimum required number of cache nodes: " + minCache + " (" + (long)minCache * (long)(pageSize + 76) + " bytes)");
                oom.initCause(e.getCause());
                throw oom;
            }
            this.mNodeGroups = groups;
            if (this.mEventListener != null) {
                double duration = (double)(System.nanoTime() - cacheInitStart) / 1.0E9;
                this.mEventListener.notify(EventType.CACHE_INIT_COMPLETE, "Cache initialization completed in %1$1.3f seconds", new Object[]{duration, TimeUnit.SECONDS});
            }
            this.mTxnContexts = new _TransactionContext[procCount * 4];
            for (int i = 0; i < this.mTxnContexts.length; ++i) {
                this.mTxnContexts[i] = new _TransactionContext(this.mTxnContexts.length, 4096);
            }
            this.mCommitLock.acquireExclusive();
            try {
                this.mCommitState = (byte)2;
            }
            finally {
                this.mCommitLock.releaseExclusive();
            }
            byte[] header = new byte[60];
            this.mPageDb.readExtraCommitData(header);
            _Node rootNode = this.loadRegistryRoot(launcher, header);
            this.mRegistry = launcher.mRepl != null ? new _BTree.Repl(this, 0L, null, rootNode) : new _BTree(this, 0L, null, rootNode);
            this.mOpenTreesLatch = new Latch();
            if (launcher.mBasicMode) {
                this.mOpenTrees = Collections.emptyMap();
                this.mOpenTreesById = new LHashTable.Obj(0);
                this.mOpenTreesRefQueue = null;
            } else {
                this.mOpenTrees = new ConcurrentSkipListMap<byte[], _TreeRef>(Utils.KEY_COMPARATOR);
                this.mOpenTreesById = new LHashTable.Obj(16);
                this.mOpenTreesRefQueue = new ReferenceQueue();
            }
            long txnId = Utils.decodeLongLE(header, 20);
            if (txnId < 0L) {
                throw new CorruptDatabaseException("Invalid transaction id: " + txnId);
            }
            long redoNum = Utils.decodeLongLE(header, 28);
            long redoPos = Utils.decodeLongLE(header, 44);
            long redoTxnId = Utils.decodeLongLE(header, 36);
            if (debugListener != null) {
                debugListener.notify(EventType.DEBUG, "MASTER_UNDO_LOG_PAGE_ID: %1$d", Utils.decodeLongLE(header, 12));
                debugListener.notify(EventType.DEBUG, "TRANSACTION_ID: %1$d", txnId);
                debugListener.notify(EventType.DEBUG, "CHECKPOINT_NUMBER: %1$d", redoNum);
                debugListener.notify(EventType.DEBUG, "REDO_TXN_ID: %1$d", redoTxnId);
                debugListener.notify(EventType.DEBUG, "REDO_POSITION: %1$d", redoPos);
            }
            if (launcher.mBasicMode) {
                this.mRegistryKeyMap = null;
            } else {
                this.mRegistryKeyMap = this.openInternalTree(1L, true, launcher);
                if (debugListener != null) {
                    Cursor c = this.indexRegistryById().newCursor(Transaction.BOGUS);
                    try {
                        c.first();
                        while (c.key() != null) {
                            long indexId = Utils.decodeLongBE(c.key(), 0);
                            String nameStr = Utils.utf8(c.value());
                            debugListener.notify(EventType.DEBUG, "Index: id=%1$d, name=%2$s", indexId, nameStr);
                            c.next();
                        }
                    }
                    finally {
                        c.reset();
                    }
                }
            }
            _BTree cursorRegistry = null;
            if (!launcher.mBasicMode) {
                cursorRegistry = this.openInternalTree(2L, false, launcher);
            }
            this.mMaxEntrySize = (pageSize - 12) * 3 >> 2;
            this.mMaxFragmentedEntrySize = pageSize - 12 - 10 >> 1;
            this.mMaxKeySize = Math.min(16383, this.mMaxFragmentedEntrySize - 13);
            this.mFragmentInodeLevelCaps = _LocalDatabase.calculateInodeLevelCaps(this.mPageSize);
            this.mPageDb.pageCache(this);
            this.mTempFileManager = launcher.tempFileManager();
            long recoveryStart = 0L;
            if (this.mBaseFile == null) {
                this.mRedoWriter = null;
                this.mCheckpointer = null;
            } else if (launcher.mBasicMode) {
                this.mRedoWriter = null;
                this.mCheckpointer = new Checkpointer(this, launcher, this.mNodeGroups.length);
            } else {
                this.mCheckpointer = this.mReadOnly ? null : new Checkpointer(this, launcher, this.mNodeGroups.length);
                if (this.mEventListener != null) {
                    this.mEventListener.notify(EventType.RECOVERY_BEGIN, "Database recovery begin", new Object[0]);
                    recoveryStart = System.nanoTime();
                }
                LHashTable.Obj<_LocalTransaction> txns = new LHashTable.Obj<_LocalTransaction>(16);
                long masterNodeId = Utils.decodeLongLE(header, 12);
                if (masterNodeId != 0L) {
                    if (this.mEventListener != null) {
                        this.mEventListener.notify(EventType.RECOVERY_LOAD_UNDO_LOGS, "Loading undo logs", new Object[0]);
                    }
                    _UndoLog master = _UndoLog.recoverMasterUndoLog(this, masterNodeId);
                    boolean trace = debugListener != null && Boolean.TRUE.equals(launcher.mDebugOpen.get("traceUndo"));
                    master.recoverTransactions(debugListener, trace, txns);
                }
                LHashTable.Obj<_BTreeCursor> cursors = new LHashTable.Obj<_BTreeCursor>(4);
                if (cursorRegistry != null) {
                    _BTreeCursor c = cursorRegistry.newCursor(Transaction.BOGUS);
                    c.first();
                    while (c.key() != null) {
                        long cursorId = Utils.decodeLongBE(c.key(), 0);
                        byte[] regValue = c.value();
                        long indexId = Utils.decodeLongBE(regValue, 0);
                        _BTree tree = (_BTree)this.anyIndexById(indexId);
                        _BTreeCursor cursor = new _BTreeCursor(tree, Transaction.BOGUS);
                        cursor.mKeyOnly = true;
                        if (regValue.length >= 9) {
                            byte[] key = new byte[regValue.length - 9];
                            System.arraycopy(regValue, 9, key, 0, key.length);
                            cursor.find(key);
                        }
                        cursor.mCursorId = cursorId;
                        ((LHashTable.ObjEntry)cursors.insert((long)cursorId)).value = cursor;
                        c.next();
                    }
                    cursorRegistry.forceClose();
                }
                Utils.initHandlers(this, this.mCustomHandlers, this.mPrepareHandlers);
                if (launcher.mEnableJMX) {
                    String base = this.mBaseFile != null ? this.mBaseFile.toString() : UUID.randomUUID().toString();
                    Registration.register(this, base);
                }
                this.tagTrashedTrees();
                StreamReplicator repl = launcher.mRepl;
                if (repl != null) {
                    if (this.mEventListener != null) {
                        this.mEventListener.notify(EventType.REPLICATION_DEBUG, "Starting at: %1$d", redoPos);
                    }
                    repl.start();
                    if (this.mReadOnly) {
                        this.mRedoWriter = null;
                        if (debugListener != null && Boolean.TRUE.equals(launcher.mDebugOpen.get("traceRedo"))) {
                            RedoEventPrinter printer = new RedoEventPrinter(debugListener, EventType.DEBUG);
                            new ReplDecoder(repl, redoPos, redoTxnId, new Latch()).run(printer);
                        }
                    } else {
                        _ReplEngine engine = new _ReplEngine(repl, launcher.mMaxReplicaThreads, this, txns, cursors);
                        this.mRedoWriter = engine.initWriter(redoNum);
                        launcher.mReplRecoveryStartNanos = recoveryStart;
                        launcher.mReplInitialPosition = redoPos;
                        launcher.mReplInitialTxnId = redoTxnId;
                    }
                } else {
                    this.applyCachePrimer(launcher);
                    long logId = redoNum;
                    if (this.mReadOnly) {
                        this.mRedoWriter = null;
                        if (debugListener != null && Boolean.TRUE.equals(launcher.mDebugOpen.get("traceRedo"))) {
                            RedoEventPrinter printer = new RedoEventPrinter(debugListener, EventType.DEBUG);
                            _RedoLog replayLog = new _RedoLog(launcher, logId, redoPos);
                            replayLog.replay(printer, debugListener, EventType.RECOVERY_APPLY_REDO_LOG, "Applying redo log: %1$d");
                        }
                    } else {
                        Utils.deleteNumberedFiles(this.mBaseFile, REDO_FILE_SUFFIX, 0L, logId - 1L);
                        boolean doCheckpoint = txns.size() != 0;
                        _RedoLogApplier applier = new _RedoLogApplier(launcher.mMaxReplicaThreads, this, txns, cursors);
                        _RedoLog replayLog = new _RedoLog(launcher, logId, redoPos);
                        TreeMap<Long, File> redoFiles = replayLog.replay(applier, this.mEventListener, EventType.RECOVERY_APPLY_REDO_LOG, "Applying redo log: %1$d");
                        doCheckpoint |= !redoFiles.isEmpty();
                        launcher.mUnfinished = applier.finish();
                        this.checkClosedCause();
                        txnId = applier.highestTxnId(txnId);
                        _RedoLog log = new _RedoLog(launcher, replayLog, this.mTxnContexts[0]);
                        this.mRedoWriter = log;
                        if (doCheckpoint) {
                            this.resetTransactionContexts(txnId);
                            txnId = -1L;
                            try {
                                this.forceCheckpoint();
                            }
                            catch (Throwable e) {
                                log.initialCheckpointFailed(e);
                                throw e;
                            }
                            Utils.deleteReverseOrder(redoFiles);
                        }
                    }
                    this.recoveryComplete(recoveryStart);
                }
            }
            if (txnId >= 0L) {
                this.resetTransactionContexts(txnId);
            }
        }
        catch (Throwable e) {
            Utils.closeQuietly(this);
            this.deleteLockFile(attemptCreate, null);
            throw e;
        }
    }

    private String lockFilePath() {
        return this.mBaseFile.getPath() + LOCK_FILE_SUFFIX;
    }

    private IOException deleteLockFile(LockedFile file, IOException ex) {
        if (file != null) {
            ex = file.delete(this.lockFilePath(), ex);
        }
        return ex;
    }

    private void finishInit(Launcher launcher) throws IOException {
        _RedoWriter _RedoWriter2;
        if (this.mCheckpointer == null) {
            return;
        }
        this.mCheckpointer.register(new RedoClose(this));
        this.mCheckpointer.register(this.mTempFileManager);
        if (this.mRedoWriter instanceof _ReplWriter) {
            this.applyCachePrimer(launcher);
        }
        if (!this.isCacheOnly() && !this.mReadOnly) {
            int mode = 0;
            if (launcher.mCachePriming) {
                mode |= 1;
            }
            if (launcher.mCleanShutdown) {
                mode |= 2;
            }
            if (mode != 0) {
                this.mCheckpointer.register(new ShutdownPrimer(this, mode));
            }
        }
        if (!((_RedoWriter2 = this.mRedoWriter) instanceof _ReplController)) {
            this.finishInit2(launcher);
            return;
        }
        _ReplController controller = (_ReplController)_RedoWriter2;
        if (this.mEventListener != null) {
            this.mEventListener.notify(EventType.RECOVERY_PROGRESS, "Starting replication recovery", new Object[0]);
        }
        ReplDecoder decoder = controller.ready(launcher.mReplInitialPosition, launcher.mReplInitialTxnId);
        this.finishInit2(launcher);
        controller.catchup(decoder);
        this.recoveryComplete(launcher.mReplRecoveryStartNanos);
        launcher.mRepl.socketAcceptor(this::replServerAccepted);
    }

    private void finishInit2(Launcher launcher) throws IOException {
        LHashTable.Obj unfinished;
        this.mCheckpointer.start(false);
        _BTree trashed = this.openNextTrashedTree(null);
        if (trashed != null) {
            Runner.start("IndexDeletion", new Deletion(trashed, true, this.mEventListener));
        }
        if (!(this.mRedoWriter instanceof _ReplController) && (unfinished = launcher.mUnfinished) != null) {
            Runner.start(() -> this.invokeRecoveryHandler(unfinished, this.mRedoWriter));
            launcher.mUnfinished = null;
        }
        this.emptyLingeringTrash(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long writeControlMessage(byte[] message) throws IOException {
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            _RedoWriter redo = this.txnRedoWriter();
            _TransactionContext context = this.anyTransactionContext();
            long commitPos = context.redoControl(redo, message);
            redo.txnCommitSync(commitPos);
            try {
                ((_ReplController)this.mRedoWriter).mRepl.controlMessageReceived(commitPos, message);
            }
            catch (Throwable e) {
                Utils.closeQuietly(this, e);
                throw e;
            }
            long l = commitPos;
            return l;
        }
        finally {
            shared.release();
        }
    }

    void invokeRecoveryHandler(LHashTable.Obj<_LocalTransaction> txns, _RedoWriter redo) {
        txns.traverse(entry -> {
            block6: {
                _LocalTransaction txn = (_LocalTransaction)entry.value;
                try {
                    _UndoLog.RTP rtp = txn.rollbackForRecovery(redo, this.mDurabilityMode, LockMode.UPGRADABLE_READ, this.mDefaultLockTimeoutNanos);
                    int handlerId = rtp.handlerId;
                    byte[] message = rtp.message;
                    PrepareHandler recovery = this.findPrepareRecoveryHandler(handlerId);
                    if (redo == null) break block6;
                    try {
                        if (rtp.commit) {
                            recovery.prepareCommit(txn, message);
                            break block6;
                        }
                        recovery.prepare(txn, message);
                    }
                    catch (UnmodifiableReplicaException e) {
                        txn.reset(e);
                    }
                }
                catch (Throwable e2) {
                    if (this.isClosed()) break block6;
                    CorruptDatabaseException e2 = new CorruptDatabaseException("Malformed prepared transaction: " + txn, e2);
                    EventListener listener = this.mEventListener;
                    if (listener == null) {
                        Utils.uncaught(e2);
                    }
                    listener.notify(EventType.RECOVERY_HANDLER_UNCAUGHT, "Uncaught exception when recovering a prepared transaction: %1$s", e2);
                }
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCachePrimer(Launcher launcher) {
        block15: {
            if (!this.isCacheOnly()) {
                File primer = this.primerFile();
                try {
                    if (!launcher.mCachePriming || !primer.exists()) break block15;
                    if (this.mEventListener != null) {
                        this.mEventListener.notify(EventType.RECOVERY_CACHE_PRIMING, "Cache priming", new Object[0]);
                    }
                    try {
                        FileInputStream fin = new FileInputStream(primer);
                        try (BufferedInputStream bin = new BufferedInputStream(fin);){
                            this.applyCachePrimer(bin);
                        }
                        catch (IOException e) {
                            fin.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    if (!this.mReadOnly) {
                        primer.delete();
                    }
                }
            }
        }
    }

    File primerFile() {
        return new File(this.mBaseFile.getPath() + PRIMER_FILE_SUFFIX);
    }

    private void recoveryComplete(long recoveryStart) {
        if (this.mEventListener != null) {
            double duration = (double)(System.nanoTime() - recoveryStart) / 1.0E9;
            this.mEventListener.notify(EventType.RECOVERY_COMPLETE, "Recovery completed in %1$1.3f seconds", new Object[]{duration, TimeUnit.SECONDS});
        }
    }

    private void deleteRedoLogFiles() throws IOException {
        if (this.mBaseFile != null && !this.mReadOnly) {
            Utils.deleteNumberedFiles(this.mBaseFile, REDO_FILE_SUFFIX);
        }
    }

    private boolean hasRedoLogFiles() throws IOException {
        return this.mBaseFile != null && !Utils.findNumberedFiles(this.mBaseFile, REDO_FILE_SUFFIX, 0L, Long.MAX_VALUE).isEmpty();
    }

    @Override
    public Index findIndex(byte[] name) throws IOException {
        return this.openTree(name, false);
    }

    @Override
    public Index openIndex(byte[] name) throws IOException {
        return this.openTree(name, true);
    }

    @Override
    public Index indexById(long id) throws IOException {
        return this.indexById(null, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index indexById(Transaction txn, long id) throws IOException {
        if (Tree.isInternal(id)) {
            throw new IllegalArgumentException("Invalid id: " + id);
        }
        Tree index = this.lookupIndexById(id);
        if (index != null) {
            return index;
        }
        byte[] idKey = _LocalDatabase.newKey((byte)1, id);
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            _Locker locker;
            byte[] name;
            if (txn != null) {
                name = this.mRegistryKeyMap.load(txn, idKey);
            } else {
                locker = this.mLockManager.localLocker();
                while (!locker.doTryLockExclusive(this.mRegistryKeyMap.id(), idKey, 0L).isHeld()) {
                    shared.release();
                    Thread.yield();
                    this.mCommitLock.acquireShared(shared);
                }
                try {
                    name = this.mRegistryKeyMap.load(Transaction.BOGUS, idKey);
                }
                finally {
                    locker.doUnlock();
                }
            }
            if (name == null) {
                this.checkClosed();
                locker = null;
                return locker;
            }
            if (this.isAnonymousIndex(txn, name)) {
                name = null;
            }
            byte[] treeIdBytes = new byte[8];
            Utils.encodeLongBE(treeIdBytes, 0, id);
            index = this.openTree(txn, treeIdBytes, name, false);
        }
        catch (Throwable e) {
            Utils.rethrowIfRecoverable(e);
            throw Utils.closeOnFailure(this, e);
        }
        finally {
            shared.release();
        }
        if (index == null) {
            throw new CorruptDatabaseException("Unable to find index in registry");
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tree lookupIndexById(long id) {
        this.mOpenTreesLatch.acquireShared();
        try {
            LHashTable.ObjEntry entry = (LHashTable.ObjEntry)this.mOpenTreesById.get(id);
            Tree tree = entry == null ? null : (Tree)((_TreeRef)entry.value).get();
            return tree;
        }
        finally {
            this.mOpenTreesLatch.releaseShared();
        }
    }

    Index anyIndexById(long id) throws IOException {
        return this.anyIndexById(null, id);
    }

    Index anyIndexById(Transaction txn, long id) throws IOException {
        return Tree.isInternal(id) ? this.internalIndex(id) : this.indexById(txn, id);
    }

    private Index internalIndex(long id) throws IOException {
        if (id == 1L) {
            return this.mRegistryKeyMap;
        }
        if (id == 3L) {
            return this.fragmentedTrash();
        }
        if (id == 4L) {
            return this.preparedTxns();
        }
        if (id == 5L) {
            return this.rowStore().schemata();
        }
        throw new CorruptDatabaseException("Internal index referenced by redo log: " + id);
    }

    @Override
    public void renameIndex(Index index, byte[] newName) throws IOException {
        this.renameIndex(index, (byte[])newName.clone(), 0L);
    }

    void renameIndex(Index index, byte[] newName, long redoTxnId) throws IOException {
        this.accessTree(index).rename(newName, redoTxnId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameBTree(_BTree tree, byte[] newName, long redoTxnId) throws IOException {
        _LocalTransaction txn;
        byte[] newNameKey;
        byte[] oldNameKey;
        byte[] trashIdKey;
        byte[] idKey;
        byte[] oldName;
        _Node root = tree.mRoot;
        root.acquireExclusive();
        try {
            DirectPageOps.checkClosedIndexException(root.mPage);
            if (Tree.isInternal(tree.mId)) {
                throw new IllegalStateException("Cannot rename an internal index");
            }
            oldName = tree.mName;
            if (oldName == null) {
                String message = this.mRegistryKeyMap.exists(null, _LocalDatabase.newKey((byte)1, tree.mId)) ? "Cannot rename an anonymous index" : "Cannot rename a temporary index";
                throw new IllegalStateException(message);
            }
            if (Arrays.equals(oldName, newName)) {
                return;
            }
            idKey = _LocalDatabase.newKey((byte)1, tree.mIdBytes);
            trashIdKey = _LocalDatabase.newKey((byte)4, tree.mIdBytes);
            oldNameKey = _LocalDatabase.newKey((byte)0, oldName);
            newNameKey = _LocalDatabase.newKey((byte)0, newName);
            txn = this.newNoRedoTransaction(redoTxnId);
            try {
                txn.lockTimeout(-1L, null);
                txn.doLockExclusive(this.mRegistryKeyMap.mId, idKey);
                txn.doLockExclusive(this.mRegistryKeyMap.mId, trashIdKey);
                if (Arrays.compareUnsigned(oldNameKey, newNameKey) <= 0) {
                    txn.doLockExclusive(this.mRegistryKeyMap.mId, oldNameKey);
                    txn.doLockExclusive(this.mRegistryKeyMap.mId, newNameKey);
                } else {
                    txn.doLockExclusive(this.mRegistryKeyMap.mId, newNameKey);
                    txn.doLockExclusive(this.mRegistryKeyMap.mId, oldNameKey);
                }
            }
            catch (Throwable e) {
                txn.reset();
                throw e;
            }
        }
        finally {
            root.releaseExclusive();
        }
        try {
            _BTreeCursor c = this.mRegistryKeyMap.newCursor(txn);
            try {
                c.autoload(false);
                c.find(trashIdKey);
                if (c.value() != null) {
                    throw new IllegalStateException("Index is deleted");
                }
                c.find(newNameKey);
                if (c.value() != null) {
                    throw new IllegalStateException("New name is used by another index");
                }
                c.store(tree.mIdBytes);
            }
            finally {
                c.reset();
            }
            LongConsumer finishTask = pos -> {
                block8: {
                    try {
                        if (pos < 0L) break block8;
                        txn.durabilityMode(DurabilityMode.NO_REDO);
                        this.mRegistryKeyMap.delete(txn, oldNameKey);
                        this.mRegistryKeyMap.store(txn, idKey, newName);
                        this.mOpenTreesLatch.acquireExclusive();
                        try {
                            txn.commit();
                            tree.mName = newName;
                            this.mOpenTrees.put(newName, this.mOpenTrees.remove(oldName));
                        }
                        finally {
                            this.mOpenTreesLatch.releaseExclusive();
                        }
                    }
                    catch (Throwable e) {
                        Utils.rethrow(e);
                    }
                    finally {
                        txn.reset();
                    }
                }
            };
            if (redoTxnId == 0L && txn.mRedo != null) {
                long commitPos;
                txn.durabilityMode(Utils.alwaysRedo(this.mDurabilityMode));
                CommitLock.Shared shared = this.mCommitLock.acquireShared();
                try {
                    txn.check();
                    commitPos = txn.mContext.redoRenameIndexCommitFinal(txn.mRedo, txn.txnId(), tree.mId, newName, txn.durabilityMode());
                }
                finally {
                    shared.release();
                }
                if (commitPos != 0L) {
                    try {
                        txn.mRedo.txnCommitSync(commitPos);
                    }
                    catch (ConfirmationInterruptedException e) {
                        ((_ReplWriter)txn.mRedo).mReplWriter.uponCommit(commitPos, finishTask);
                        throw e;
                    }
                }
            }
            finishTask.accept(0L);
        }
        catch (Throwable e) {
            if (!(e instanceof ConfirmationInterruptedException)) {
                txn.reset();
            }
            if (e instanceof IllegalStateException) {
                throw e;
            }
            Utils.rethrowIfRecoverable(e);
            throw Utils.closeOnFailure(this, e);
        }
    }

    private Tree accessTree(Index index) {
        try {
            Tree tree = (Tree)index;
            if (tree.isMemberOf(this)) {
                return tree;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new IllegalStateException("Index belongs to a different database");
    }

    @Override
    public Runnable deleteIndex(Index index) throws IOException {
        return this.accessTree(index).drop(false);
    }

    Runnable replicaDeleteTree(long treeId, Index ix) throws IOException {
        RowStore rs;
        if (ix instanceof _BTree) {
            _BTree bt = (_BTree)ix;
            bt.closeAsDeleted();
        } else if (ix != null) {
            ix.close();
        }
        byte[] treeIdBytes = new byte[8];
        Utils.encodeLongBE(treeIdBytes, 0, treeId);
        _BTree trashed = this.openTrashedTree(treeIdBytes, false);
        if (trashed == null && (rs = this.openRowStore(false)) != null) {
            return rs.deleteSchema(treeIdBytes);
        }
        boolean resumed = false;
        EventListener listener = null;
        if (this.mCheckpointer == null || !this.mCheckpointer.isStarted()) {
            resumed = true;
            listener = this.mEventListener;
        }
        return new Deletion(trashed, resumed, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable deleteTree(_BTree tree, CommitLock.Shared shared) throws IOException {
        block14: {
            try {
                if (tree instanceof _BTree.Temp) break block14;
                _LocalTransaction txn = this.newNoRedoTransaction();
                try {
                    txn.lockTimeout(-1L, null);
                    if (!this.doMoveToTrash(txn, tree.mIdBytes)) {
                        throw DirectPageOps.newClosedIndexException(tree.mRoot.mPage);
                    }
                    if (txn.mRedo != null) {
                        txn.durabilityMode(Utils.alwaysRedo(this.mDurabilityMode));
                        txn.check();
                        long commitPos = txn.mContext.redoDeleteIndexCommitFinal(txn.mRedo, txn.txnId(), tree.mId, txn.durabilityMode());
                        shared.release();
                        shared = null;
                        if (commitPos != 0L) {
                            txn.mRedo.txnCommitSync(commitPos);
                        }
                    }
                    txn.commit();
                }
                catch (Throwable e) {
                    Utils.rethrowIfRecoverable(e);
                    throw Utils.closeOnFailure(this, e);
                }
                finally {
                    txn.reset();
                }
            }
            finally {
                if (shared != null) {
                    shared.release();
                }
            }
        }
        _Node root = tree.close(true, true);
        if (root == null) {
            throw DirectPageOps.newClosedIndexException(tree.mRoot.mPage);
        }
        _BTree trashed = this.newBTreeInstance(tree.mId, tree.mIdBytes, tree.mName, root);
        return new Deletion(trashed, false, null);
    }

    void quickDeleteTemporaryTree(_BTree tree) throws IOException {
        this.mOpenTreesLatch.acquireExclusive();
        try {
            _TreeRef ref = this.mOpenTreesById.removeValue(tree.mId);
            if (ref == null || ref.get() != tree) {
                return;
            }
            ref.clear();
        }
        finally {
            this.mOpenTreesLatch.releaseExclusive();
        }
        _Node root = tree.mRoot;
        byte[] trashIdKey = _LocalDatabase.newKey((byte)4, tree.mIdBytes);
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            root.acquireExclusive();
            if (!root.hasKeys() && !DirectPageOps.isClosedOrDeleted(root.mPage)) {
                this.prepareToDelete(root);
                this.deleteNode(root);
                this.mRegistryKeyMap.delete(Transaction.BOGUS, trashIdKey);
                this.mRegistry.delete(Transaction.BOGUS, tree.mIdBytes);
                return;
            }
            root.releaseExclusive();
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(this, e);
        }
        finally {
            shared.release();
        }
        tree.deleteAll();
        this.removeFromTrash(tree, root);
    }

    private View trash() {
        return this.mRegistryKeyMap.viewPrefix(new byte[]{4}, 1);
    }

    private void tagTrashedTrees() throws IOException {
        try (Cursor c = this.trash().newCursor(Transaction.BOGUS);){
            c.first();
            while (c.key() != null) {
                byte[] name = c.value();
                if (name.length != 0) {
                    name[0] = (byte)(name[0] | 0x80);
                    c.store(name);
                }
                c.next();
            }
        }
    }

    private _BTree openNextTrashedTree(byte[] lastIdBytes) throws IOException {
        return this.openTrashedTree(lastIdBytes, true);
    }

    private _BTree openTrashedTree(byte[] idBytes, boolean next) throws IOException {
        long rootId;
        byte[] name;
        byte[] rootIdBytes;
        byte[] treeIdBytes;
        block19: {
            if (this.mRegistryKeyMap == null) {
                return null;
            }
            try (Cursor c = this.trash().newCursor(Transaction.BOGUS);){
                if (idBytes == null) {
                    c.first();
                } else if (next) {
                    c.findGt(idBytes);
                } else {
                    c.find(idBytes);
                }
                while (true) {
                    if ((treeIdBytes = c.key()) == null) {
                        _BTree _BTree2 = null;
                        return _BTree2;
                    }
                    rootIdBytes = this.mRegistry.load(Transaction.BOGUS, treeIdBytes);
                    if (rootIdBytes == null) {
                        c.store(null);
                    } else {
                        name = c.value();
                        if (name[0] < 0) break block19;
                        if (idBytes != null && !next) {
                            break block19;
                        }
                    }
                    if (!next) break;
                    c.next();
                }
                _BTree _BTree3 = null;
                return _BTree3;
            }
        }
        long l = rootId = rootIdBytes.length == 0 ? 0L : Utils.decodeLongLE(rootIdBytes, 0);
        if ((name[0] & 0x7F) == 0) {
            name = null;
        } else {
            byte[] actual = new byte[name.length - 1];
            System.arraycopy(name, 1, actual, 0, actual.length);
            name = actual;
        }
        long treeId = Utils.decodeLongBE(treeIdBytes, 0);
        return this.newBTreeInstance(treeId, treeIdBytes, name, this.loadTreeRoot(rootId));
    }

    @Override
    public _BTree newTemporaryIndex() throws IOException {
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            _BTree _BTree2 = this.newTemporaryTree(false);
            return _BTree2;
        }
        finally {
            shared.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    _BTree newTemporaryTree(boolean preallocate) throws IOException {
        byte[] rootIdBytes;
        long rootId;
        this.checkClosed();
        this.cleanupUnreferencedTrees();
        byte[] treeIdBytes = new byte[8];
        if (preallocate) {
            rootId = this.mPageDb.allocPage();
            rootIdBytes = new byte[8];
            Utils.encodeLongLE(rootIdBytes, 0, rootId);
        } else {
            rootId = 0L;
            rootIdBytes = Utils.EMPTY_BYTES;
        }
        try {
            long treeId;
            do {
                treeId = this.nextTreeId((byte)5);
                Utils.encodeLongBE(treeIdBytes, 0, treeId);
            } while (!this.mRegistry.insert(Transaction.BOGUS, treeIdBytes, rootIdBytes));
            try {
                _Node root;
                _LocalTransaction createTxn = this.newNoRedoTransaction();
                try {
                    createTxn.lockTimeout(-1L, null);
                    byte[] trashIdKey = _LocalDatabase.newKey((byte)4, treeIdBytes);
                    if (!this.mRegistryKeyMap.insert(createTxn, trashIdKey, new byte[1])) {
                        throw new DatabaseException("Unable to register temporary index");
                    }
                    createTxn.commit();
                }
                finally {
                    createTxn.reset();
                }
                if (rootId != 0L) {
                    root = this.allocLatchedNode(1);
                    root.id(rootId);
                    try {
                        if (this.mFullyMapped) {
                            root.mPage = this.mPageDb.dirtyPage(rootId);
                        }
                        root.mGroup.addDirty(root, this.mCommitState);
                    }
                    catch (Throwable e) {
                        root.releaseExclusive();
                        throw e;
                    }
                } else {
                    root = this.loadTreeRoot(0L);
                }
                try {
                    _BTree.Temp tree = new _BTree.Temp(this, treeId, treeIdBytes, root);
                    _TreeRef treeRef = new _TreeRef(tree, tree, this.mOpenTreesRefQueue);
                    this.mOpenTreesLatch.acquireExclusive();
                    try {
                        ((LHashTable.ObjEntry)this.mOpenTreesById.insert((long)treeId)).value = treeRef;
                    }
                    finally {
                        this.mOpenTreesLatch.releaseExclusive();
                    }
                    return tree;
                }
                catch (Throwable e) {
                    if (rootId != 0L) {
                        root.releaseExclusive();
                    }
                    throw e;
                }
            }
            catch (Throwable e) {
                try {
                    this.mRegistry.delete(Transaction.BOGUS, treeIdBytes);
                }
                catch (Throwable e2) {
                    Utils.suppress(e, e2);
                    throw Utils.closeOnFailure(this, e);
                }
                throw e;
            }
        }
        catch (Throwable e) {
            if (rootId != 0L) {
                try {
                    this.mPageDb.recyclePage(rootId);
                }
                catch (Throwable e2) {
                    Utils.suppress(e, e2);
                }
            }
            throw e;
        }
    }

    @Override
    public View indexRegistryByName() throws IOException {
        return this.mRegistryKeyMap.viewPrefix(new byte[]{0}, 1).viewUnmodifiable();
    }

    @Override
    public View indexRegistryById() throws IOException {
        return this.mRegistryKeyMap.viewPrefix(new byte[]{1}, 1).viewUnmodifiable().viewFiltered((id, name) -> !this.isAnonymousIndex(Transaction.BOGUS, name));
    }

    @Override
    public Transaction newTransaction() {
        return this.doNewTransaction(this.mDurabilityMode);
    }

    @Override
    public Transaction newTransaction(DurabilityMode durabilityMode) {
        return this.doNewTransaction(durabilityMode == null ? this.mDurabilityMode : durabilityMode);
    }

    private _LocalTransaction doNewTransaction(DurabilityMode durabilityMode) {
        _RedoWriter redo = this.txnRedoWriter();
        return new _LocalTransaction(this, redo, durabilityMode, LockMode.UPGRADABLE_READ, this.mDefaultLockTimeoutNanos);
    }

    _LocalTransaction newAlwaysRedoTransaction() {
        return this.doNewTransaction(Utils.alwaysRedo(this.mDurabilityMode));
    }

    private _LocalTransaction newNoRedoTransaction() {
        return this.doNewTransaction(DurabilityMode.NO_REDO);
    }

    private _LocalTransaction newNoRedoTransaction(long redoTxnId) {
        return redoTxnId == 0L ? this.newNoRedoTransaction() : new _LocalTransaction(this, redoTxnId, LockMode.UPGRADABLE_READ, this.mDefaultLockTimeoutNanos);
    }

    _LocalTransaction threadLocalTransaction(DurabilityMode durabilityMode) {
        _LocalTransaction txn;
        SoftReference<_LocalTransaction> txnRef = this.mLocalTransaction.get();
        if (txnRef == null || (txn = txnRef.get()) == null) {
            txn = this.doNewTransaction(durabilityMode);
            this.mLocalTransaction.set(new SoftReference<_LocalTransaction>(txn));
        } else {
            txn.mRedo = this.txnRedoWriter();
            txn.mDurabilityMode = durabilityMode;
            txn.mLockMode = LockMode.UPGRADABLE_READ;
            txn.mLockTimeoutNanos = this.mDefaultLockTimeoutNanos;
        }
        return txn;
    }

    void removeThreadLocalTransaction() {
        this.mLocalTransaction.remove();
    }

    _RedoWriter txnRedoWriter() {
        _RedoWriter redo = this.mRedoWriter;
        if (redo != null) {
            redo = redo.txnRedoWriter();
        }
        return redo;
    }

    private void resetTransactionContexts(long txnId) {
        for (_TransactionContext txnContext : this.mTxnContexts) {
            txnContext.resetTransactionId(txnId++);
        }
    }

    _TransactionContext anyTransactionContext() {
        return this.selectTransactionContext(ThreadLocalRandom.current().nextInt());
    }

    _TransactionContext selectTransactionContext(_LocalTransaction txn) {
        return this.selectTransactionContext(txn.hashCode());
    }

    private _TransactionContext selectTransactionContext(int num) {
        return this.mTxnContexts[(num & Integer.MAX_VALUE) % this.mTxnContexts.length];
    }

    void discardRedoWriter(_RedoWriter expect) {
        for (_TransactionContext context : this.mTxnContexts) {
            context.discardRedoWriter(expect);
        }
    }

    @Override
    public CustomHandler customWriter(String name) throws IOException {
        return (CustomHandler)((Object)this.findOrCreateWriter(name, (byte)6, this.mCustomHandlers));
    }

    CustomHandler findCustomRecoveryHandler(int handlerId) throws IOException {
        return this.findRecoveryHandler(handlerId, (byte)7, this.mCustomHandlers, this.mCustomHandlersById);
    }

    @Override
    public PrepareHandler prepareWriter(String name) throws IOException {
        return (PrepareHandler)((Object)this.findOrCreateWriter(name, (byte)8, this.mPrepareHandlers));
    }

    PrepareHandler findPrepareRecoveryHandler(int handlerId) throws IOException {
        return this.findRecoveryHandler(handlerId, (byte)9, this.mPrepareHandlers, this.mPrepareHandlersById);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String findHandlerName(int handlerId, byte rkIdPrefix) throws IOException {
        byte[] nameBytes;
        byte[] idKey = _LocalDatabase.newKey(rkIdPrefix, handlerId);
        try {
            nameBytes = this.mRegistryKeyMap.load(null, idKey);
        }
        catch (LockTimeoutException e) {
            nameBytes = null;
        }
        if (nameBytes == null) {
            _LocalTransaction txn = this.newNoRedoTransaction();
            try {
                txn.lockTimeout(-1L, null);
                nameBytes = this.mRegistryKeyMap.load(txn, idKey);
            }
            finally {
                txn.reset();
            }
        }
        return Utils.utf8(nameBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <H extends Handler> _HandlerWriter findOrCreateWriter(String name, byte rkNamePrefix, Map<String, H> handlers) throws IOException {
        Handler handler;
        if (handlers == null) {
            throw new IllegalStateException("Recovery handler not installed: " + name);
        }
        Map<String, H> map = handlers;
        synchronized (map) {
            handler = (Handler)handlers.get(name);
        }
        if (handler instanceof _HandlerWriter) {
            _HandlerWriter hw = (_HandlerWriter)handler;
            return hw;
        }
        int handlerId = this.findOrCreateHandlerId(name, rkNamePrefix, handlers);
        handler = switch (rkNamePrefix) {
            case 6 -> new _CustomWriter(this, handlerId, (CustomHandler)handler);
            case 8 -> new _PrepareWriter(this, handlerId, (PrepareHandler)handler);
            default -> throw new AssertionError();
        };
        Map<String, H> map2 = handlers;
        synchronized (map2) {
            Handler existing = (Handler)handlers.get(name);
            if (existing instanceof _HandlerWriter) {
                _HandlerWriter hw = (_HandlerWriter)existing;
                return hw;
            }
            handlers.put(name, handler);
        }
        return (_HandlerWriter)handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findOrCreateHandlerId(String name, byte rkNamePrefix, Map<String, ? extends Handler> handlers) throws IOException {
        byte[] idBytes;
        block19: {
            byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
            byte[] nameKey = _LocalDatabase.newKey(rkNamePrefix, nameBytes);
            idBytes = this.mRegistryKeyMap.load(null, nameKey);
            if (idBytes == null) {
                _LocalDatabase.findRecoveryHandler(name, handlers);
                _LocalTransaction txn = this.newAlwaysRedoTransaction();
                try (_BTreeCursor nameCursor = this.mRegistryKeyMap.newCursor(txn);){
                    txn.durabilityMode(DurabilityMode.SYNC);
                    nameCursor.find(nameKey);
                    idBytes = nameCursor.value();
                    if (idBytes != null) break block19;
                    byte rkIdPrefix = (byte)(rkNamePrefix + 1);
                    View byId = this.mRegistryKeyMap.viewPrefix(new byte[]{rkIdPrefix}, 1);
                    try (Cursor idCursor = byId.newCursor(txn);){
                        idCursor.autoload(false);
                        do {
                            idCursor.last();
                            int lastId = idCursor.key() == null ? 0 : Utils.decodeIntBE(idCursor.key(), 0);
                            idBytes = new byte[4];
                            Utils.encodeIntBE(idBytes, 0, lastId + 1);
                            idCursor.findNearby(idBytes);
                        } while (idCursor.value() != null);
                        idCursor.store(nameBytes);
                    }
                    nameCursor.commit(idBytes);
                }
                finally {
                    txn.reset();
                }
            }
        }
        return Utils.decodeIntBE(idBytes, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <H extends Handler> H findRecoveryHandler(int handlerId, byte rkIdPrefix, Map<String, H> handlers, LHashTable.Obj<H> handlersById) throws IOException {
        String name;
        long scrambledId = Utils.fibHash(handlerId);
        if (handlersById != null) {
            Handler handler;
            LHashTable.Obj<H> obj = handlersById;
            synchronized (obj) {
                handler = (Handler)handlersById.getValue(scrambledId);
            }
            if (handler != null) {
                return (H)handler;
            }
        }
        if ((name = this.findHandlerName(handlerId, rkIdPrefix)) == null) {
            String type = switch (rkIdPrefix) {
                case 7 -> "custom";
                case 9 -> "prepare";
                default -> String.valueOf(rkIdPrefix);
            };
            throw new CorruptDatabaseException("Unable to find " + type + " handler name for id " + handlerId);
        }
        H handler = _LocalDatabase.findRecoveryHandler(name, handlers);
        LHashTable.Obj<H> obj = handlersById;
        synchronized (obj) {
            ((LHashTable.ObjEntry)handlersById.insert((long)scrambledId)).value = handler;
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <H extends Handler> H findRecoveryHandler(String name, Map<String, H> handlers) {
        if (handlers != null) {
            Handler handler;
            Map<String, H> map = handlers;
            synchronized (map) {
                handler = (Handler)handlers.get(name);
            }
            if (handler instanceof _HandlerWriter) {
                _HandlerWriter hw = (_HandlerWriter)handler;
                return hw.mRecoveryHandler;
            }
            if (handler != null) {
                return (H)handler;
            }
        }
        throw new IllegalStateException("Recovery handler not installed: " + name);
    }

    @Override
    public long preallocate(long bytes) throws IOException {
        int pageSize;
        long pageCount;
        if (!this.isClosed() && !this.isCacheOnly() && (pageCount = (bytes + (long)(pageSize = this.mPageSize) - 1L) / (long)pageSize) > 0L) {
            if ((pageCount = this.mPageDb.allocatePages(pageCount)) > 0L) {
                try {
                    this.forceCheckpoint();
                }
                catch (Throwable e) {
                    Utils.rethrowIfRecoverable(e);
                    Utils.closeQuietly(this, e);
                    throw e;
                }
            }
            return pageCount * (long)pageSize;
        }
        return 0L;
    }

    @Override
    public Sorter newSorter() {
        return new _ParallelSorter(this, Runner.current());
    }

    @Override
    public void capacityLimit(long bytes) {
        this.mPageDb.pageLimit(bytes < 0L ? -1L : bytes / (long)this.mPageSize);
    }

    @Override
    public long capacityLimit() {
        long pageLimit = this.mPageDb.pageLimit();
        return pageLimit < 0L ? -1L : pageLimit * (long)this.mPageSize;
    }

    @Override
    public void capacityLimitOverride(long bytes) {
        this.mPageDb.pageLimitOverride(bytes < 0L ? -1L : bytes / (long)this.mPageSize);
    }

    @Override
    public Snapshot beginSnapshot() throws IOException {
        this.checkClosed();
        return this.mPageDb.asStoredPageDb("Snapshot").beginSnapshot(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CoreDatabase restoreFromSnapshot(Launcher launcher, InputStream in) throws IOException {
        if (launcher.mReadOnly) {
            throw new IllegalArgumentException("Cannot restore into a read-only database");
        }
        File[] dataFiles = launcher.dataFiles();
        if (dataFiles == null) {
            PageArray dataPageArray = launcher.mDataPageArray;
            if (dataPageArray == null) {
                throw new UnsupportedOperationException(_PageDb.unsupportedMessage("Restore"));
            }
            dataPageArray = dataPageArray.open();
            dataPageArray.truncatePageCount(0L);
            Utils.deleteNumberedFiles(launcher.mBaseFile, REDO_FILE_SUFFIX);
            _PageDb restored = _StoredPageDb.restoreFromSnapshot(dataPageArray, launcher.mChecksumFactory, launcher.mDataCrypto, in);
            restored.delete();
        } else {
            for (File f : dataFiles) {
                Utils.delete(f);
                if (!launcher.mMkdirs) continue;
                f.getParentFile().mkdirs();
            }
            EnumSet<OpenOption> options = launcher.createOpenOptions();
            Utils.deleteNumberedFiles(launcher.mBaseFile, REDO_FILE_SUFFIX);
            int pageSize = launcher.mPageSize;
            if (pageSize <= 0) {
                pageSize = 4096;
            }
            _PageDb restored = _StoredPageDb.restoreFromSnapshot(pageSize, dataFiles, options, launcher.mChecksumFactory, launcher.mDataCrypto, in);
            try {
                restored.close();
            }
            finally {
                restored.delete();
            }
        }
        return launcher.open(false, null);
    }

    @Override
    public void createCachePrimer(OutputStream out) throws IOException {
        OutputStream original = out;
        out = this.mPageDb.asStoredPageDb("Cache priming").encrypt(original);
        DataOutput dout = out instanceof DataOutput ? (DataOutput)((Object)out) : new DataOutputStream(out);
        dout.writeLong(4943712973215968399L);
        for (_TreeRef treeRef : this.mOpenTrees.values()) {
            Tree tree = (Tree)treeRef.get();
            if (tree == null || Tree.isInternal(tree.id())) continue;
            tree.writeCachePrimer(dout);
        }
        dout.writeInt(-1);
        if (out != original) {
            out.flush();
        }
    }

    @Override
    public void applyCachePrimer(InputStream fin) throws IOException {
        try (InputStream inputStream = fin;){
            int len;
            InputStream in = this.mPageDb.asStoredPageDb("Cache priming").decrypt(fin);
            DataInput din = in instanceof DataInput ? (DataInput)((Object)in) : new DataInputStream(in);
            long magic = din.readLong();
            if (magic != 4943712973215968399L) {
                throw new DatabaseException("Wrong cache primer magic number: " + magic);
            }
            while ((len = din.readInt()) >= 0) {
                byte[] name = new byte[len];
                din.readFully(name);
                Tree tree = this.openTree(name, false);
                if (tree != null) {
                    tree.applyCachePrimer(din);
                    continue;
                }
                _BTree.skipCachePrimer(din);
            }
        }
    }

    @Override
    public Server newServer() throws IOException {
        return this.openServers().newServer(this);
    }

    void replServerAccepted(Socket s) {
        try {
            this.openServers().replServer(this).acceptedAndValidated(s);
        }
        catch (IOException e) {
            Utils.closeQuietly(s);
        }
    }

    private Servers openServers() throws DatabaseException {
        Servers servers = this.mServers;
        if (servers == null) {
            this.checkClosed();
            this.mOpenTreesLatch.acquireExclusive();
            try {
                servers = this.mServers;
                if (servers == null) {
                    this.checkClosed();
                    this.mServers = servers = new Servers();
                }
            }
            finally {
                this.mOpenTreesLatch.releaseExclusive();
            }
        }
        return servers;
    }

    @Override
    public DatabaseStats stats() {
        return this.stats(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseStats stats(boolean strict) {
        DatabaseStats stats = new DatabaseStats();
        stats.pageSize = this.mPageSize;
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            long cursorCount = 0L;
            int openTreesCount = 0;
            for (_TreeRef treeRef : this.mOpenTrees.values()) {
                Tree tree = (Tree)treeRef.get();
                if (tree == null) continue;
                ++openTreesCount;
                cursorCount += tree.countCursors(strict);
            }
            cursorCount += _LocalDatabase.countCursors(this.mRegistry, strict) + _LocalDatabase.countCursors(this.mRegistryKeyMap, strict) + _LocalDatabase.countCursors(this.mFragmentedTrash, strict) + _LocalDatabase.countCursors(this.mCursorRegistry, strict) + _LocalDatabase.countCursors(this.mPreparedTxns, strict);
            RowStore rs = this.mRowStore;
            if (rs != null) {
                cursorCount += _LocalDatabase.countCursors((_BTree)rs.schemata(), strict);
            }
            stats.openIndexes = openTreesCount;
            stats.cursorCount = cursorCount;
            _PageDb.Stats pstats = this.mPageDb.stats();
            stats.freePages = pstats.freePages;
            stats.totalPages = pstats.totalPages;
            stats.lockCount = this.mLockManager.numLocksHeld();
            for (_TransactionContext txnContext : this.mTxnContexts) {
                txnContext.addStats(stats);
            }
        }
        finally {
            shared.release();
        }
        for (_NodeGroup group : this.mNodeGroups) {
            if (group == null) continue;
            stats.cachePages += (long)group.nodeCount();
            stats.dirtyPages += group.dirtyCount();
        }
        if (stats.dirtyPages > stats.totalPages) {
            stats.dirtyPages = stats.totalPages;
        }
        stats.checkpointDuration = this.mLastCheckpointDurationNanos / 1000000L;
        _RedoWriter redo = this.mRedoWriter;
        if (redo != null) {
            redo.addStats(stats);
        }
        return stats;
    }

    private static long countCursors(_BTree tree, boolean strict) {
        return tree == null ? 0L : tree.countCursors(strict);
    }

    private void redoClose(byte op, Throwable cause) {
        _RedoWriter redo = this.mRedoWriter;
        if (redo == null) {
            return;
        }
        redo.closeCause(cause);
        redo = redo.txnRedoWriter();
        redo.closeCause(cause);
        try {
            redo.alwaysFlush(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            _TransactionContext context = this.anyTransactionContext();
            context.redoTimestamp(redo, op);
            context.flush();
            redo.force(true, TimeUnit.SECONDS.toNanos(5L));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (op == 4) {
            Utils.closeQuietly(redo);
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(0);
    }

    @Override
    public void sync() throws IOException {
        this.flush(1);
    }

    private void flush(int level) throws IOException {
        if (!this.isClosed() && this.mRedoWriter != null) {
            this.mRedoWriter.flush();
            if (level > 0) {
                this.mRedoWriter.force(level > 1, -1L);
            }
        }
    }

    @Override
    public void checkpoint() throws IOException {
        try {
            this.checkpoint(0L, 0L);
        }
        catch (Throwable e) {
            Utils.rethrowIfRecoverable(e);
            Utils.closeQuietly(this, e);
            throw e;
        }
    }

    @Override
    public void suspendCheckpoints() {
        Checkpointer c = this.mCheckpointer;
        if (c != null) {
            c.suspend();
            this.mCheckpointLock.lock();
            this.mCheckpointLock.unlock();
        }
    }

    @Override
    public void resumeCheckpoints() {
        Checkpointer c = this.mCheckpointer;
        if (c != null) {
            c.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compactFile(CompactionObserver observer, double target) throws IOException {
        if (target < 0.0 || target > 1.0) {
            throw new IllegalArgumentException("Illegal compaction target: " + target);
        }
        if (this.mCheckpointer == null) {
            return false;
        }
        if (target == 0.0) {
            return true;
        }
        this.mCheckpointer.acquireExclusive();
        try {
            if (this.mCheckpointer.isSuspended()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.doCompactFile(observer, target);
            return bl;
        }
        finally {
            this.mCheckpointer.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCompactFile(CompactionObserver observer, double target) throws IOException {
        long targetPageCount;
        this.mCheckpointLock.lock();
        try {
            _PageDb.Stats stats = this.mPageDb.stats();
            long usedPages = stats.totalPages - stats.freePages;
            targetPageCount = Math.max(usedPages, (long)((double)usedPages / target));
            long freed = stats.totalPages - targetPageCount;
            long reserve = (freed *= (long)Utils.calcUnsignedVarLongLength(stats.totalPages << 1)) / (long)(this.mPageSize - 16);
            if ((targetPageCount += (reserve += 6L)) >= stats.totalPages && targetPageCount >= this.mPageDb.pageCount()) {
                boolean bl = true;
                return bl;
            }
            if (!this.mPageDb.compactionStart(targetPageCount)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.mCheckpointLock.unlock();
        }
        boolean completed = this.mPageDb.compactionScanFreeList();
        if (completed) {
            this.checkpoint();
            if (observer == null) {
                observer = new CompactionObserver();
            }
            long highestNodeId = targetPageCount - 1L;
            CompactionObserver fobserver = observer;
            completed = this.scanAllIndexes(ix -> {
                Tree tree = (Tree)ix;
                return tree.compactTree(tree.observableView(), highestNodeId, fobserver);
            });
            this.forceCheckpoint();
            if (completed && this.mPageDb.compactionScanFreeList() && !this.mPageDb.compactionVerify() && this.mPageDb.compactionScanFreeList()) {
                this.forceCheckpoint();
            }
        }
        this.mCheckpointLock.lock();
        try {
            this.forceCheckpoint();
            this.mPageDb.compactionReclaim();
            this.forceCheckpoint();
            if (completed &= this.mPageDb.compactionEnd()) {
                boolean bl = this.mPageDb.truncatePages();
                return bl;
            }
        }
        finally {
            this.mCheckpointLock.unlock();
        }
        return false;
    }

    @Override
    public boolean verify(VerificationObserver observer) throws IOException {
        FreeListScan fls = new FreeListScan();
        Runner.start(fls);
        if (observer == null) {
            observer = new VerificationObserver();
        }
        boolean[] passedRef = new boolean[]{true};
        VerificationObserver fobserver = observer;
        this.scanAllIndexes(ix -> {
            Tree tree = (Tree)ix;
            Index view = tree.observableView();
            fobserver.failed = false;
            boolean keepGoing = tree.verifyTree(view, fobserver);
            passedRef[0] = passedRef[0] & !fobserver.failed;
            if (keepGoing) {
                keepGoing = fobserver.indexComplete(view, !fobserver.failed, null);
            }
            return keepGoing;
        });
        fls.waitFor();
        return passedRef[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanAllIndexes(ScanVisitor visitor) throws IOException {
        if (!(_LocalDatabase.scan(visitor, this.mRegistry) && _LocalDatabase.scan(visitor, this.mRegistryKeyMap) && _LocalDatabase.scan(visitor, this.openFragmentedTrash(false)) && _LocalDatabase.scan(visitor, this.openCursorRegistry(false)) && _LocalDatabase.scan(visitor, this.openPreparedTxns(false)))) {
            return false;
        }
        RowStore rs = this.openRowStore(false);
        if (rs != null) {
            rs.scanAllIndexes(visitor);
        }
        Cursor all = this.indexRegistryByName().newCursor(null);
        try {
            all.first();
            while (all.key() != null) {
                Tree tree;
                long id = Utils.decodeLongBE(all.value(), 0);
                Index index = this.indexById(id);
                if (index instanceof Tree && !visitor.apply(tree = (Tree)index)) {
                    boolean bl = false;
                    return bl;
                }
                all.next();
            }
        }
        finally {
            all.reset();
        }
        return true;
    }

    private static boolean scan(ScanVisitor visitor, _BTree tree) throws IOException {
        return tree == null || visitor.apply(tree);
    }

    @Override
    public boolean isLeader() {
        return this.mRedoWriter == null || this.mRedoWriter.isLeader();
    }

    @Override
    public void uponLeader(Runnable acquired, Runnable lost) {
        if (this.mRedoWriter == null) {
            if (acquired != null) {
                Runner.start(acquired);
            }
        } else {
            this.mRedoWriter.uponLeader(acquired, lost);
        }
    }

    @Override
    public boolean failover() throws IOException {
        return this.mRedoWriter != null && this.mRedoWriter.failover();
    }

    @Override
    public void close(Throwable cause) throws IOException {
        this.close(cause, false);
    }

    @Override
    public void shutdown() throws IOException {
        this.close(null, !this.isCacheOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Throwable cause, boolean shutdown) throws IOException {
        Thread ct;
        Servers servers;
        if (!cClosedHandle.compareAndSet(this, 0, 1)) {
            return;
        }
        if (cause != null) {
            this.mClosedCause = cause;
            Throwable rootCause = Utils.rootCause(cause);
            if (this.mEventListener == null) {
                Utils.uncaught(rootCause);
            } else {
                this.mEventListener.notify(EventType.PANIC_UNHANDLED_EXCEPTION, "Closing database due to unhandled exception: %1$s", rootCause);
            }
        }
        if ((servers = this.mServers) != null) {
            servers.close();
        }
        boolean lockedCheckpointer = false;
        try {
            if (this.mCheckpointer != null) {
                this.mCheckpointer.close(cause);
            }
            if (this.mCheckpointLock.tryLock()) {
                lockedCheckpointer = true;
            } else if (cause == null && !(this.mRedoWriter instanceof _ReplController)) {
                this.mCheckpointLock.lock();
                lockedCheckpointer = true;
            }
            Thread thread = ct = this.mCheckpointer == null ? null : this.mCheckpointer.interrupt();
        }
        catch (Throwable throwable) {
            Thread ct2;
            Thread thread = ct2 = this.mCheckpointer == null ? null : this.mCheckpointer.interrupt();
            if (lockedCheckpointer) {
                this.mCheckpointLock.unlock();
                if (ct2 != null) {
                    try {
                        ct2.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            throw throwable;
        }
        if (lockedCheckpointer) {
            this.mCheckpointLock.unlock();
            if (ct != null) {
                try {
                    ct.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            CommitLock lock = this.mCommitLock;
            if (this.mOpenTrees != null) {
                ArrayList<Tree> trees;
                if (lock == null) {
                    this.mOpenTreesLatch.acquireExclusive();
                } else {
                    while (true) {
                        lock.acquireExclusive();
                        if (this.mOpenTreesLatch.tryAcquireExclusive()) break;
                        lock.releaseExclusive();
                        Thread.yield();
                    }
                }
                try {
                    trees = new ArrayList<Tree>(this.mOpenTreesById.size());
                    this.mOpenTreesById.traverse(entry -> {
                        Tree tree = (Tree)((_TreeRef)entry.value).get();
                        if (tree != null) {
                            trees.add(tree);
                            ((_TreeRef)entry.value).clear();
                        }
                        return true;
                    });
                    this.mOpenTrees.clear();
                    trees.add(this.mRegistryKeyMap);
                    trees.add(this.mFragmentedTrash);
                    this.mFragmentedTrash = null;
                    trees.add(this.mCursorRegistry);
                    this.mCursorRegistry = null;
                    trees.add(this.mPreparedTxns);
                    this.mPreparedTxns = null;
                    if (this.mRowStore != null) {
                        trees.add((Tree)this.mRowStore.schemata());
                        this.mRowStore = null;
                    }
                }
                finally {
                    this.mOpenTreesLatch.releaseExclusive();
                    if (lock != null) {
                        lock.releaseExclusive();
                    }
                }
                for (Tree tree : trees) {
                    if (tree == null) continue;
                    tree.forceClose();
                }
                if (shutdown) {
                    this.mCheckpointLock.lock();
                    try {
                        this.doCheckpoint(-1, 0L, 0L);
                    }
                    catch (Throwable e) {
                        shutdown = false;
                    }
                    finally {
                        this.mCheckpointLock.unlock();
                    }
                }
                if (this.mRegistry != null) {
                    this.mRegistry.forceClose();
                }
            }
            if (lock != null) {
                lock.acquireExclusive();
            }
            try {
                _UndoLog masterUndoLog;
                if (this.mNodeGroups != null) {
                    for (int i = 0; i < this.mNodeGroups.length; ++i) {
                        _NodeGroup group = this.mNodeGroups[i];
                        if (group == null) continue;
                        group.delete();
                        this.mNodeGroups[i] = null;
                    }
                }
                if (this.mTxnContexts != null) {
                    for (_TransactionContext txnContext : this.mTxnContexts) {
                        if (txnContext == null) continue;
                        txnContext.deleteUndoLogs();
                    }
                }
                if ((masterUndoLog = this.mCommitMasterUndoLog) != null) {
                    masterUndoLog.delete();
                }
                this.nodeMapDeleteAll();
                this.redoClose((byte)4, cause);
                IOException ex = null;
                ex = Utils.closeQuietly(ex, this.mPageDb, cause);
                ex = Utils.closeQuietly(ex, this.mTempFileManager, cause);
                if (shutdown && this.mBaseFile != null && !this.mReadOnly) {
                    this.deleteRedoLogFiles();
                    ex = this.deleteLockFile(this.mLockFile, ex);
                } else {
                    ex = Utils.closeQuietly(ex, this.mLockFile, cause);
                }
                if (this.mLockManager != null) {
                    this.mLockManager.close();
                }
                this.removeThreadLocalTransaction();
                if (ex != null) {
                    throw ex;
                }
            }
            finally {
                if (lock != null) {
                    lock.releaseExclusive();
                }
            }
        }
        finally {
            if (this.mCheckpointer != null) {
                this.mCheckpointer.shutdown();
            }
            if (this.mPageDb != null) {
                this.mPageDb.delete();
            }
            this.deleteCommitHeader();
            DirectPageOps.p_arenaDelete(this.mArena);
        }
    }

    private void deleteCommitHeader() {
        DirectPageOps.p_delete(cCommitHeaderHandle.getAndSet(this, DirectPageOps.p_null()));
    }

    @Override
    public boolean isClosed() {
        return this.mClosed != 0;
    }

    void checkClosed() throws DatabaseException {
        this.checkClosed(null);
    }

    void checkClosed(Throwable caught) throws DatabaseException {
        if (this.isClosed()) {
            this.throwClosed(caught);
        }
    }

    private void throwClosed(Throwable caught) throws DatabaseException {
        if (caught != null && caught == this.mClosedCause) {
            throw Utils.rethrow(caught);
        }
        Object message = "Closed";
        Throwable cause = this.mClosedCause;
        if (cause != null) {
            message = (String)message + "; " + Utils.rootCause(cause);
        }
        throw new DatabaseException((String)message, cause);
    }

    void checkClosedCause() throws IOException {
        Throwable cause = this.mClosedCause;
        if (cause != null) {
            try {
                throw cause;
            }
            catch (IOException | Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new DatabaseException(cause);
            }
        }
    }

    Throwable closedCause() {
        return this.mClosedCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void treeClosed(_BTree tree) {
        this.mOpenTreesLatch.acquireExclusive();
        try {
            Tree actual;
            _TreeRef ref = this.mOpenTreesById.getValue(tree.mId);
            if (ref != null && (actual = (Tree)ref.get()) != null && actual.isUserOf(tree)) {
                ref.clear();
                if (tree.mName != null) {
                    this.mOpenTrees.remove(tree.mName);
                }
                this.mOpenTreesById.remove(tree.mId);
            }
        }
        finally {
            this.mOpenTreesLatch.releaseExclusive();
        }
    }

    void redoMoveToTrash(_LocalTransaction txn, long treeId) throws IOException {
        byte[] treeIdBytes = new byte[8];
        Utils.encodeLongBE(treeIdBytes, 0, treeId);
        this.doMoveToTrash(txn, treeIdBytes);
    }

    private boolean doMoveToTrash(_LocalTransaction txn, byte[] treeIdBytes) throws IOException {
        byte[] trashEntry;
        byte[] nameKey;
        byte[] trashIdKey = _LocalDatabase.newKey((byte)4, treeIdBytes);
        if (this.mRegistryKeyMap.exists(txn, trashIdKey)) {
            return false;
        }
        byte[] treeName = this.mRegistryKeyMap.exchange(txn, _LocalDatabase.newKey((byte)1, treeIdBytes), null);
        if (treeName != null && (this.mRegistryKeyMap.remove(txn, nameKey = _LocalDatabase.newKey((byte)0, treeName), treeIdBytes) || treeName.length > 0)) {
            trashEntry = (byte[])nameKey.clone();
            trashEntry[0] = 1;
        } else {
            trashEntry = new byte[1];
        }
        this.mRegistryKeyMap.store(txn, trashIdKey, trashEntry);
        return true;
    }

    @Override
    public boolean isInTrash(Transaction txn, long treeId) throws IOException {
        return this.mRegistryKeyMap.exists(txn, _LocalDatabase.newKey((byte)4, treeId));
    }

    private void removeFromTrash(_BTree tree, _Node root) throws IOException {
        byte[] trashIdKey = _LocalDatabase.newKey((byte)4, tree.mIdBytes);
        Runnable task = null;
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            if (root != null) {
                root.acquireExclusive();
                if (DirectPageOps.isClosedOrDeleted(root.mPage)) {
                    root.releaseExclusive();
                    return;
                }
                this.deleteNode(root);
            }
            this.mRegistryKeyMap.delete(Transaction.BOGUS, trashIdKey);
            this.mRegistry.delete(Transaction.BOGUS, tree.mIdBytes);
            RowStore rs = this.openRowStore(false);
            if (rs != null) {
                task = rs.deleteSchema(tree.mIdBytes);
            }
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(this, e);
        }
        finally {
            shared.release();
        }
        if (task != null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                throw Utils.closeOnFailure(this, e);
            }
        }
    }

    void removeGraftedTempTree(_BTree tree) throws IOException {
        try {
            this.mOpenTreesLatch.acquireExclusive();
            try {
                _TreeRef ref = this.mOpenTreesById.removeValue(tree.mId);
                if (ref != null && ref.get() == tree) {
                    ref.clear();
                }
            }
            finally {
                this.mOpenTreesLatch.releaseExclusive();
            }
            byte[] trashIdKey = _LocalDatabase.newKey((byte)4, tree.mIdBytes);
            this.mRegistryKeyMap.delete(Transaction.BOGUS, trashIdKey);
            this.mRegistry.delete(Transaction.BOGUS, tree.mIdBytes);
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(this, e);
        }
    }

    _BTree cursorRegistry() throws IOException {
        _BTree cursorRegistry = this.mCursorRegistry;
        return cursorRegistry != null ? cursorRegistry : this.openCursorRegistry(true);
    }

    private _BTree openCursorRegistry(boolean create) throws IOException {
        _BTree cursorRegistry;
        this.mOpenTreesLatch.acquireExclusive();
        try {
            cursorRegistry = this.mCursorRegistry;
            if (cursorRegistry == null) {
                cursorRegistry = this.openInternalTree(2L, create);
                VarHandle.storeStoreFence();
                this.mCursorRegistry = cursorRegistry;
            }
        }
        finally {
            this.mOpenTreesLatch.releaseExclusive();
        }
        return cursorRegistry;
    }

    void registerCursor(_BTree cursorRegistry, _BTreeCursor cursor) throws IOException {
        try {
            byte[] cursorIdBytes = new byte[8];
            Utils.encodeLongBE(cursorIdBytes, 0, cursor.mCursorId);
            byte[] regValue = cursor.mTree.mIdBytes;
            byte[] key = cursor.key();
            if (key != null) {
                byte[] newReg = new byte[regValue.length + 1 + key.length];
                System.arraycopy(regValue, 0, newReg, 0, regValue.length);
                System.arraycopy(key, 0, newReg, regValue.length + 1, key.length);
                regValue = newReg;
            }
            cursorRegistry.store(Transaction.BOGUS, cursorIdBytes, regValue);
        }
        catch (Throwable e) {
            try {
                cursor.unregister();
            }
            catch (Throwable e2) {
                Utils.suppress(e, e2);
            }
            throw e;
        }
    }

    void unregisterCursor(long cursorId) {
        try {
            byte[] cursorIdBytes = new byte[8];
            Utils.encodeLongBE(cursorIdBytes, 0, cursorId);
            this.cursorRegistry().store(Transaction.BOGUS, cursorIdBytes, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    _BTree preparedTxns() throws IOException {
        _BTree preparedTxns = this.mPreparedTxns;
        return preparedTxns != null ? preparedTxns : this.openPreparedTxns(true);
    }

    _BTree tryPreparedTxns() throws IOException {
        _BTree preparedTxns = this.mPreparedTxns;
        return preparedTxns != null ? preparedTxns : this.openPreparedTxns(false);
    }

    private _BTree openPreparedTxns(boolean create) throws IOException {
        _BTree preparedTxns;
        this.mOpenTreesLatch.acquireExclusive();
        try {
            preparedTxns = this.mPreparedTxns;
            if (preparedTxns == null) {
                preparedTxns = this.openInternalTree(4L, create);
                VarHandle.storeStoreFence();
                this.mPreparedTxns = preparedTxns;
            }
        }
        finally {
            this.mOpenTreesLatch.releaseExclusive();
        }
        return preparedTxns;
    }

    @Override
    public RowStore rowStore() throws IOException {
        return this.rowStore(true);
    }

    RowStore rowStore(boolean create) throws IOException {
        RowStore rs = this.mRowStore;
        return rs != null ? rs : this.openRowStore(create);
    }

    RowStore tryRowStore() {
        return this.mRowStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowStore openRowStore(boolean create) throws IOException {
        RowStore rs;
        this.mOpenTreesLatch.acquireExclusive();
        try {
            _BTree schemata;
            rs = this.mRowStore;
            if (rs == null && (schemata = this.openInternalTree(5L, create)) != null) {
                rs = new RowStore(this, schemata);
                VarHandle.storeStoreFence();
                this.mRowStore = rs;
            }
        }
        finally {
            this.mOpenTreesLatch.releaseExclusive();
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private _Node loadTreeRoot(long rootId) throws IOException {
        if (rootId == 0L) {
            _Node rootNode = this.allocLatchedNode(1);
            try {
                if (this.mFullyMapped) {
                    rootNode.mPage = DirectPageOps.p_nonTreePage();
                    rootNode.id(0L);
                    rootNode.mCachedState = 0;
                } else {
                    rootNode.asEmptyRoot();
                }
                _Node _Node2 = rootNode;
                return _Node2;
            }
            finally {
                rootNode.releaseExclusive();
            }
        }
        _Node rootNode = this.nodeMapGetAndRemove(rootId);
        if (rootNode != null) {
            try {
                rootNode.makeUnevictable();
                _Node _Node3 = rootNode;
                return _Node3;
            }
            finally {
                rootNode.releaseExclusive();
            }
        }
        rootNode = this.allocLatchedNode(1);
        try {
            try {
                rootNode.read(this, rootId);
            }
            finally {
                rootNode.releaseExclusive();
            }
            return rootNode;
        }
        catch (Throwable e) {
            rootNode.makeEvictableNow();
            throw e;
        }
    }

    private _Node loadRegistryRoot(Launcher launcher, byte[] header) throws IOException {
        long rootId;
        int version = Utils.decodeIntLE(header, 0);
        if (launcher.mDebugOpen != null) {
            this.mEventListener.notify(EventType.DEBUG, "ENCODING_VERSION: %1$d", version);
        }
        if (version == 0) {
            rootId = 0L;
            this.mInitialReadState = (byte)2;
        } else {
            if (version != this.mEncodingVersion) {
                throw new CorruptDatabaseException("Unknown encoding version: " + version);
            }
            rootId = Utils.decodeLongLE(header, 4);
            if (launcher.mDebugOpen != null) {
                this.mEventListener.notify(EventType.DEBUG, "ROOT_PAGE_ID: %1$d", rootId);
            }
        }
        long replEncoding = Utils.decodeLongLE(header, 52);
        StreamReplicator repl = launcher.mRepl;
        if ((replEncoding != 0L || repl != null) && launcher.mDebugOpen != null) {
            this.mEventListener.notify(EventType.DEBUG, "REPL_ENCODING: %1$d", replEncoding);
        }
        if (repl == null) {
            if (replEncoding != 0L && !this.hasRedoLogFiles()) {
                throw new DatabaseException("Database must be configured with a replicator, identified by: " + replEncoding);
            }
        } else if (replEncoding == 0L) {
            Object msg = "Database was created initially without a replicator. Conversion isn't possible ";
            if (!repl.isReadable(0L)) {
                msg = (String)msg + "without complete replication data.";
                throw new DatabaseException((String)msg);
            }
            if (this.hasRedoLogFiles()) {
                msg = (String)msg + "when redo log files exist. A clean shutdown is required.";
                throw new DatabaseException((String)msg);
            }
            Utils.encodeLongLE(header, 44, 0L);
        } else if (replEncoding != repl.encoding()) {
            throw new DatabaseException("Database was created initially with a different replicator, identified by: " + replEncoding);
        }
        return this.loadTreeRoot(rootId);
    }

    private _BTree openInternalTree(long treeId, boolean create) throws IOException {
        return this.openInternalTree(treeId, create, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private _BTree openInternalTree(long treeId, boolean create, Launcher launcher) throws IOException {
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            long rootId;
            this.checkClosed();
            byte[] treeIdBytes = new byte[8];
            Utils.encodeLongBE(treeIdBytes, 0, treeId);
            byte[] rootIdBytes = this.mRegistry.load(Transaction.BOGUS, treeIdBytes);
            if (rootIdBytes != null) {
                rootId = Utils.decodeLongLE(rootIdBytes, 0);
            } else {
                if (!create) {
                    _BTree _BTree2 = null;
                    return _BTree2;
                }
                rootId = 0L;
            }
            _Node root = this.loadTreeRoot(rootId);
            if (launcher != null && launcher.mRepl != null) {
                _BTree.Repl repl = new _BTree.Repl(this, treeId, treeIdBytes, root);
                return repl;
            }
            _BTree _BTree3 = this.newBTreeInstance(treeId, treeIdBytes, null, root);
            return _BTree3;
        }
        finally {
            shared.release();
        }
    }

    private Tree openTree(byte[] name, boolean create) throws IOException {
        return this.openTree(null, null, name, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tree openTree(Transaction findTxn, byte[] treeIdBytes, byte[] name, boolean create) throws IOException {
        block9: {
            if (name != null) {
                _TreeRef treeRef;
                this.mOpenTreesLatch.acquireShared();
                try {
                    treeRef = this.mOpenTrees.get(name);
                    if (treeRef == null) break block9;
                    Tree tree = (Tree)treeRef.get();
                    if (tree != null) {
                        Tree tree2 = tree;
                        return tree2;
                    }
                }
                finally {
                    this.mOpenTreesLatch.releaseShared();
                }
                this.cleanupUnreferencedTree(treeRef);
            }
        }
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            Tree tree = this.doOpenTree(findTxn, treeIdBytes, name, create);
            return tree;
        }
        finally {
            shared.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tree doOpenTree(Transaction findTxn, byte[] treeIdBytes, byte[] name, boolean create) throws IOException {
        long treeId;
        byte[] idKey;
        byte[] nameKey;
        block50: {
            this.checkClosed();
            this.cleanupUnreferencedTrees();
            name = Utils.cloneArray(name);
            nameKey = null;
            if (treeIdBytes == null) {
                nameKey = _LocalDatabase.newKey((byte)0, name);
                treeIdBytes = this.mRegistryKeyMap.load(findTxn, nameKey);
            }
            if (treeIdBytes != null) {
                idKey = null;
                treeId = Utils.decodeLongBE(treeIdBytes, 0);
            } else {
                if (!create) {
                    return null;
                }
                if (findTxn != null) {
                    throw new AssertionError();
                }
                Transaction createTxn = null;
                _Locker locker = this.mLockManager.localLocker();
                this.mOpenTreesLatch.acquireExclusive();
                try {
                    while (!locker.doTryLockShared(this.mRegistryKeyMap.id(), nameKey, 0L).isHeld()) {
                        this.mOpenTreesLatch.releaseExclusive();
                        this.mCommitLock.releaseShared();
                        Thread.yield();
                        this.mCommitLock.acquireShared();
                        this.mOpenTreesLatch.acquireExclusive();
                    }
                    try {
                        treeIdBytes = this.mRegistryKeyMap.load(Transaction.BOGUS, nameKey);
                    }
                    finally {
                        locker.doUnlock();
                    }
                    if (treeIdBytes != null) {
                        idKey = null;
                        treeId = Utils.decodeLongBE(treeIdBytes, 0);
                        break block50;
                    }
                    treeIdBytes = new byte[8];
                    boolean critical = true;
                    try {
                        do {
                            critical = false;
                            treeId = this.nextTreeId((byte)3);
                            Utils.encodeLongBE(treeIdBytes, 0, treeId);
                            critical = true;
                        } while (!this.mRegistry.insert(Transaction.BOGUS, treeIdBytes, Utils.EMPTY_BYTES));
                        critical = false;
                        try {
                            idKey = _LocalDatabase.newKey((byte)1, treeIdBytes);
                            createTxn = this.mRedoWriter instanceof _ReplController ? this.newTransaction(DurabilityMode.SYNC) : this.newAlwaysRedoTransaction();
                            createTxn.lockTimeout(-1L, null);
                            if (!this.mRegistryKeyMap.insert(createTxn, idKey, name)) {
                                throw new DatabaseException("Unable to insert index id");
                            }
                            if (!this.mRegistryKeyMap.insert(createTxn, nameKey, treeIdBytes)) {
                                throw new DatabaseException("Unable to insert index name");
                            }
                        }
                        catch (Throwable e) {
                            critical = true;
                            try {
                                if (createTxn != null) {
                                    createTxn.reset();
                                }
                                this.mRegistry.delete(Transaction.BOGUS, treeIdBytes);
                                critical = false;
                            }
                            catch (Throwable e2) {
                                Utils.suppress(e, e2);
                            }
                            throw e;
                        }
                    }
                    catch (Throwable e) {
                        if (!critical) {
                            Utils.rethrowIfRecoverable(e);
                        }
                        throw Utils.closeOnFailure(this, e);
                    }
                }
                finally {
                    this.mOpenTreesLatch.releaseExclusive();
                }
                try {
                    createTxn.commit();
                }
                catch (Throwable e) {
                    try {
                        createTxn.reset();
                        this.mRegistry.delete(Transaction.BOGUS, treeIdBytes);
                    }
                    catch (Throwable e2) {
                        Utils.suppress(e, e2);
                        throw Utils.closeOnFailure(this, e);
                    }
                    Utils.rethrowIfRecoverable(e);
                    throw Utils.closeOnFailure(this, e);
                }
            }
        }
        _LocalTransaction txn = this.doNewTransaction(DurabilityMode.NO_REDO);
        try {
            txn.lockTimeout(-1L, null);
            if (txn.lockCheck(this.mRegistry.id(), treeIdBytes) != LockResult.UNOWNED) {
                throw new LockFailureException("Index open listener self deadlock");
            }
            byte[] rootIdBytes = this.mRegistry.load(txn, treeIdBytes);
            Tree tree = this.lookupIndexById(treeId);
            if (tree != null) {
                Tree e2 = tree;
                return e2;
            }
            long rootId = rootIdBytes == null || rootIdBytes.length == 0 ? 0L : Utils.decodeLongLE(rootIdBytes, 0);
            _Node root = this.loadTreeRoot(rootId);
            _BTree btree = this.newBTreeInstance(treeId, treeIdBytes, name, root);
            tree = btree;
            try {
                _TreeRef treeRef = new _TreeRef(tree, btree, this.mOpenTreesRefQueue);
                this.mOpenTreesLatch.acquireExclusive();
                try {
                    if (name != null) {
                        this.mOpenTrees.put(name, treeRef);
                    }
                    try {
                        ((LHashTable.ObjEntry)this.mOpenTreesById.insert((long)treeId)).value = treeRef;
                    }
                    catch (Throwable e) {
                        if (name != null) {
                            this.mOpenTrees.remove(name);
                        }
                        throw e;
                    }
                }
                finally {
                    this.mOpenTreesLatch.releaseExclusive();
                }
            }
            catch (Throwable e) {
                btree.close();
                throw e;
            }
            Tree tree2 = tree;
            return tree2;
        }
        catch (Throwable e) {
            if (idKey != null) {
                try {
                    this.mRegistryKeyMap.delete(null, idKey);
                    this.mRegistryKeyMap.delete(null, nameKey);
                    this.mRegistry.delete(Transaction.BOGUS, treeIdBytes);
                }
                catch (Throwable e2) {
                    Utils.suppress(e, e2);
                }
            }
            throw e;
        }
        finally {
            txn.reset();
        }
    }

    private _BTree newBTreeInstance(long id, byte[] idBytes, byte[] name, _Node root) {
        _BTree tree = this.mRedoWriter instanceof _ReplWriter ? new _BTree.Repl(this, id, idBytes, root) : new _BTree(this, id, idBytes, root);
        tree.mName = name;
        return tree;
    }

    private long nextTreeId(byte type) throws IOException {
        _LocalTransaction txn;
        long treeIdMask = this.mPageDb.databaseId();
        if (treeIdMask == 0L) {
            byte[] key = new byte[]{2};
            byte[] treeIdMaskBytes = this.mRegistryKeyMap.load(Transaction.BOGUS, key);
            treeIdMask = Utils.decodeLongLE(treeIdMaskBytes, 0);
        }
        if (type == 5) {
            txn = this.newNoRedoTransaction();
            treeIdMask ^= 0xFFFFFFFFFFFFFFFFL;
        } else {
            txn = this.newAlwaysRedoTransaction();
        }
        try {
            long l;
            block14: {
                _BTreeCursor c = this.mRegistryKeyMap.newCursor(txn);
                try {
                    long treeId;
                    txn.lockTimeout(-1L, null);
                    c.find(new byte[]{type});
                    byte[] nextTreeIdBytes = c.value();
                    if (nextTreeIdBytes == null) {
                        nextTreeIdBytes = new byte[8];
                    }
                    long nextTreeId = Utils.decodeLongLE(nextTreeIdBytes, 0);
                    while (Tree.isInternal(treeId = Utils.scramble(nextTreeId++ ^ treeIdMask))) {
                    }
                    Utils.encodeLongLE(nextTreeIdBytes, 0, nextTreeId);
                    c.commit(nextTreeIdBytes);
                    l = treeId;
                    if (c == null) break block14;
                }
                catch (Throwable throwable) {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                c.close();
            }
            return l;
        }
        finally {
            txn.reset();
        }
    }

    private void cleanupUnreferencedTrees() throws IOException {
        block4: {
            ReferenceQueue<Object> queue = this.mOpenTreesRefQueue;
            if (queue == null) {
                return;
            }
            try {
                Reference<Object> ref;
                while ((ref = queue.poll()) != null) {
                    if (!(ref instanceof _TreeRef)) continue;
                    _TreeRef treeRef = (_TreeRef)ref;
                    this.cleanupUnreferencedTree(treeRef);
                }
            }
            catch (Exception e) {
                if (this.isClosed()) break block4;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupUnreferencedTree(_TreeRef ref) throws IOException {
        _Node root = ref.mRoot;
        root.acquireShared();
        try {
            this.mOpenTreesLatch.acquireExclusive();
            try {
                LHashTable.ObjEntry entry = (LHashTable.ObjEntry)this.mOpenTreesById.get(ref.mId);
                if (entry == null || entry.value != ref) {
                    return;
                }
                if (ref.mName != null) {
                    this.mOpenTrees.remove(ref.mName);
                }
                this.mOpenTreesById.remove(ref.mId);
                root.makeEvictableNow();
                if (root.id() > 0L) {
                    this.nodeMapPut(root);
                }
            }
            finally {
                this.mOpenTreesLatch.releaseExclusive();
            }
        }
        finally {
            root.releaseShared();
        }
    }

    @Override
    public DetachedLock newDetachedLock(Transaction owner) {
        return this.mLockManager.newDetachedLock((_LocalTransaction)owner);
    }

    @Override
    public <R> RowPredicateLock<R> newRowPredicateLock(long indexId) {
        return new _RowPredicateLockImpl(this.mLockManager, indexId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSecondaryIndexes(Transaction txn, long primaryIndexId, long[] ids, Runnable callback) throws IOException {
        Objects.requireNonNull(txn);
        Objects.requireNonNull(ids);
        Objects.requireNonNull(callback);
        _LocalTransaction localTxn = (_LocalTransaction)txn;
        if (this.mRedoWriter instanceof _ReplController) {
            localTxn.durabilityMode(DurabilityMode.SYNC);
        } else {
            localTxn.durabilityMode(Utils.alwaysRedo(localTxn.durabilityMode()));
        }
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            this.checkClosed();
            byte[] treeIdBytes = new byte[8];
            int pos = 0;
            try {
                while (pos < ids.length) {
                    long treeId;
                    do {
                        treeId = this.nextTreeId((byte)3);
                        Utils.encodeLongBE(treeIdBytes, 0, treeId);
                    } while (!this.mRegistry.insert(Transaction.BOGUS, treeIdBytes, Utils.EMPTY_BYTES));
                    ids[pos++] = treeId;
                }
                for (long id : ids) {
                    if (this.mRegistryKeyMap.insert(localTxn, _LocalDatabase.newKey((byte)1, id), Utils.EMPTY_BYTES)) continue;
                    throw new DatabaseException("Unable to insert index id");
                }
                callback.run();
                if (primaryIndexId != 0L && localTxn.mRedo != null) {
                    localTxn.mContext.redoCommitFinalNotifySchema(localTxn.mRedo, localTxn.id(), primaryIndexId);
                }
                localTxn.commitAll();
            }
            catch (Throwable e) {
                try {
                    localTxn.reset();
                    for (int i = 0; i < pos; ++i) {
                        Utils.encodeLongBE(treeIdBytes, 0, ids[i]);
                        this.mRegistry.delete(Transaction.BOGUS, treeIdBytes);
                    }
                }
                catch (Throwable e2) {
                    Utils.suppress(e, e2);
                    throw Utils.closeOnFailure(this, e);
                }
                Utils.rethrowIfRecoverable(e);
                throw Utils.closeOnFailure(this, e);
            }
        }
        finally {
            shared.release();
        }
    }

    private boolean isAnonymousIndex(Transaction txn, byte[] name) throws IOException {
        return name.length == 0 && !this.mRegistryKeyMap.exists(txn, _LocalDatabase.newKey((byte)0, name));
    }

    @Override
    public boolean addRedoListener(RedoListener listener) {
        _RedoWriter _RedoWriter2 = this.mRedoWriter;
        if (_RedoWriter2 instanceof _ReplWriter) {
            _ReplWriter rw = (_ReplWriter)_RedoWriter2;
            return rw.mEngine.addRedoListener(listener);
        }
        return false;
    }

    @Override
    public boolean removeRedoListener(RedoListener listener) {
        _RedoWriter _RedoWriter2 = this.mRedoWriter;
        if (_RedoWriter2 instanceof _ReplWriter) {
            _ReplWriter rw = (_ReplWriter)_RedoWriter2;
            return rw.mEngine.removeRedoListener(listener);
        }
        return false;
    }

    @Override
    public void withRedoLock(Runnable callback) {
        _RedoWriter _RedoWriter2 = this.mRedoWriter;
        if (_RedoWriter2 instanceof _ReplWriter) {
            _ReplWriter rw = (_ReplWriter)_RedoWriter2;
            rw.mEngine.withRedoLock(callback);
        } else {
            callback.run();
        }
    }

    private static byte[] newKey(byte type, byte[] payload) {
        byte[] key = new byte[1 + payload.length];
        key[0] = type;
        System.arraycopy(payload, 0, key, 1, payload.length);
        return key;
    }

    private static byte[] newKey(byte type, int payload) {
        byte[] key = new byte[5];
        key[0] = type;
        Utils.encodeIntBE(key, 1, payload);
        return key;
    }

    private static byte[] newKey(byte type, long payload) {
        byte[] key = new byte[9];
        key[0] = type;
        Utils.encodeLongBE(key, 1, payload);
        return key;
    }

    int pageSize() {
        return this.mPageSize;
    }

    private int pageSize(long page) {
        return this.mPageSize;
    }

    @Override
    public CommitLock commitLock() {
        return this.mCommitLock;
    }

    _Node nodeMapGetShared(long nodeId) {
        int hash = Long.hashCode(nodeId);
        _Node node;
        while ((node = this.nodeMapGet(nodeId, hash)) != null) {
            node.acquireShared();
            if (nodeId == node.id()) {
                return node;
            }
            node.releaseShared();
        }
        return null;
    }

    _Node nodeMapGetExclusive(long nodeId) {
        int hash = Long.hashCode(nodeId);
        _Node node;
        while ((node = this.nodeMapGet(nodeId, hash)) != null) {
            node.acquireExclusive();
            if (nodeId == node.id()) {
                return node;
            }
            node.releaseExclusive();
        }
        return null;
    }

    _Node nodeMapGetExclusiveSpin(long nodeId) {
        int hash = Long.hashCode(nodeId);
        _Node node;
        while ((node = this.nodeMapGet(nodeId, hash)) != null) {
            if (node.tryAcquireExclusive()) {
                if (nodeId == node.id()) {
                    return node;
                }
                node.releaseExclusive();
            }
            Thread.onSpinWait();
        }
        return null;
    }

    _Node nodeMapGet(long nodeId) {
        return this.nodeMapGet(nodeId, Long.hashCode(nodeId));
    }

    _Node nodeMapGet(long nodeId, int hash) {
        _Node[] table = this.mNodeMapTable;
        int slot = hash & table.length - 1;
        _Node first = cNodeMapElementHandle.getVolatile(table, slot);
        if (first == null) {
            return null;
        }
        _Node node = first;
        do {
            if (node.id() != nodeId) continue;
            return node;
        } while ((node = node.mNodeMapNext) != null);
        if ((first = _LocalDatabase.nodeMapLock(table, slot, first)) == null) {
            return null;
        }
        node = first;
        while (node.id() != nodeId && (node = node.mNodeMapNext) != null) {
        }
        cNodeMapElementHandle.setVolatile(table, slot, first);
        return node;
    }

    private static _Node nodeMapLock(_Node[] table, int slot, _Node first) {
        while (first == NM_LOCK || !cNodeMapElementHandle.compareAndSet(table, slot, first, NM_LOCK)) {
            Thread.onSpinWait();
            first = cNodeMapElementHandle.getVolatile(table, slot);
            if (first != null) continue;
            return null;
        }
        return first;
    }

    void nodeMapPut(_Node node) {
        this.nodeMapPut(node, Long.hashCode(node.id()));
    }

    void nodeMapPut(_Node node, int hash) {
        _Node[] table = this.mNodeMapTable;
        int slot = hash & table.length - 1;
        _Node first = cNodeMapElementHandle.getVolatile(table, slot);
        while (first == null || (first = _LocalDatabase.nodeMapLock(table, slot, first)) == null) {
            first = cNodeMapElementHandle.compareAndExchange(table, slot, null, node);
            if (first != null) continue;
            return;
        }
        _Node e = first;
        do {
            if (e == node) {
                cNodeMapElementHandle.setVolatile(table, slot, first);
                return;
            }
            if (e.id() != node.id()) continue;
            cNodeMapElementHandle.setVolatile(table, slot, first);
            throw new AssertionError((Object)("Already in NodeMap: " + node + ", " + e + ", " + hash));
        } while ((e = e.mNodeMapNext) != null);
        node.mNodeMapNext = first;
        cNodeMapElementHandle.setVolatile(table, slot, node);
    }

    _Node nodeMapPutIfAbsent(_Node node) {
        int hash = Long.hashCode(node.id());
        _Node[] table = this.mNodeMapTable;
        int slot = hash & table.length - 1;
        _Node first = cNodeMapElementHandle.getVolatile(table, slot);
        while (first == null || (first = _LocalDatabase.nodeMapLock(table, slot, first)) == null) {
            first = cNodeMapElementHandle.compareAndExchange(table, slot, null, node);
            if (first != null) continue;
            return null;
        }
        _Node e = first;
        do {
            if (e.id() != node.id()) continue;
            cNodeMapElementHandle.setVolatile(table, slot, first);
            return e;
        } while ((e = e.mNodeMapNext) != null);
        node.mNodeMapNext = first;
        cNodeMapElementHandle.setVolatile(table, slot, node);
        return null;
    }

    void nodeMapReplace(_Node oldNode, _Node newNode) {
        _Node first;
        int slot;
        _Node[] table;
        block6: {
            table = this.mNodeMapTable;
            int hash = Long.hashCode(oldNode.id());
            slot = hash & table.length - 1;
            first = cNodeMapElementHandle.getVolatile(table, slot);
            if (first == null || (first = _LocalDatabase.nodeMapLock(table, slot, first)) == null) {
                if (!this.isClosed()) {
                    throw new AssertionError((Object)("Not found: " + oldNode + ", " + newNode));
                }
                return;
            }
            newNode.mNodeMapNext = oldNode.mNodeMapNext;
            if (first == oldNode) {
                first = newNode;
            } else {
                _Node next;
                _Node e = first;
                do {
                    if ((next = e.mNodeMapNext) != oldNode) continue;
                    e.mNodeMapNext = newNode;
                    break block6;
                } while ((e = next) != null);
                if (this.isClosed()) {
                    cNodeMapElementHandle.setVolatile(table, slot, first);
                    return;
                }
                throw new AssertionError((Object)("Not found: " + oldNode + ", " + newNode));
            }
        }
        oldNode.mNodeMapNext = null;
        cNodeMapElementHandle.setVolatile(table, slot, first);
    }

    boolean nodeMapRemove(_Node node) {
        return this.nodeMapRemove(node, Long.hashCode(node.id()));
    }

    boolean nodeMapRemove(_Node node, int hash) {
        boolean found;
        _Node[] table = this.mNodeMapTable;
        int slot = hash & table.length - 1;
        _Node first = cNodeMapElementHandle.getVolatile(table, slot);
        if (first == null || (first = _LocalDatabase.nodeMapLock(table, slot, first)) == null) {
            return false;
        }
        if (first == node) {
            found = true;
            first = first.mNodeMapNext;
        } else {
            _Node next;
            found = false;
            _Node e = first;
            do {
                if ((next = e.mNodeMapNext) != node) continue;
                found = true;
                e.mNodeMapNext = next.mNodeMapNext;
                break;
            } while ((e = next) != null);
        }
        node.mNodeMapNext = null;
        cNodeMapElementHandle.setVolatile(table, slot, first);
        return found;
    }

    _Node nodeMapLoadFragment(long nodeId) throws IOException {
        _Node existing;
        _Node node = this.nodeMapGetShared(nodeId);
        if (node != null) {
            node.used();
            return node;
        }
        node = this.allocLatchedNode();
        node.id(nodeId);
        while ((existing = this.nodeMapPutIfAbsent(node)) != null) {
            existing.acquireShared();
            if (nodeId == existing.id()) {
                node.id(0L);
                node.unused();
                return existing;
            }
            existing.releaseShared();
        }
        try {
            this.readNode(node, nodeId);
        }
        catch (Throwable t) {
            this.nodeMapRemove(node);
            node.id(0L);
            node.releaseExclusive();
            throw t;
        }
        node.downgrade();
        return node;
    }

    _Node nodeMapLoadFragmentExclusive(long nodeId, boolean read) throws IOException {
        _Node existing;
        _Node node = this.nodeMapGetExclusive(nodeId);
        if (node != null) {
            node.used();
            return node;
        }
        node = this.allocLatchedNode();
        node.id(nodeId);
        while ((existing = this.nodeMapPutIfAbsent(node)) != null) {
            existing.acquireExclusive();
            if (nodeId == existing.id()) {
                node.id(0L);
                node.unused();
                return existing;
            }
            existing.releaseExclusive();
        }
        try {
            if (read) {
                this.readNode(node, nodeId);
            }
        }
        catch (Throwable t) {
            this.nodeMapRemove(node);
            node.id(0L);
            node.releaseExclusive();
            throw t;
        }
        return node;
    }

    _Node nodeMapGetAndRemove(long nodeId) {
        _Node node = this.nodeMapGetExclusive(nodeId);
        if (node != null) {
            this.nodeMapRemove(node);
        }
        return node;
    }

    void nodeMapDeleteAll() {
        _Node[] table = this.mNodeMapTable;
        int slot = 0;
        block2: while (slot < table.length) {
            _Node node = cNodeMapElementHandle.getVolatile(table, slot);
            if (node != null && (node = _LocalDatabase.nodeMapLock(table, slot, node)) != null) {
                _Node next;
                do {
                    if (!node.tryAcquireExclusive()) {
                        cNodeMapElementHandle.setVolatile(table, slot, node);
                        Thread.yield();
                        continue block2;
                    }
                    try {
                        node.doDelete(this);
                        node.releaseExclusive();
                    }
                    catch (Throwable e) {
                        node.releaseExclusive();
                        cNodeMapElementHandle.setVolatile(table, slot, node);
                        throw e;
                    }
                    next = node.mNodeMapNext;
                    node.mNodeMapNext = null;
                } while ((node = next) != null);
                cNodeMapElementHandle.setVolatile(table, slot, null);
            }
            ++slot;
        }
        this.mNodeMapTable = new _Node[1];
    }

    final _Node latchToChild(_Node parent, int childPos) throws IOException {
        return this.latchChild(parent, childPos, 1);
    }

    final _Node latchChildRetainParent(_Node parent, int childPos) throws IOException {
        return this.latchChild(parent, childPos, 0);
    }

    final _Node latchChild(_Node parent, int childPos, int option) throws IOException {
        long childId;
        block5: {
            _Node childNode;
            block8: {
                block6: {
                    block7: {
                        childId = parent.retrieveChildRefId(childPos);
                        childNode = this.nodeMapGetShared(childId);
                        if (childNode == null) break block5;
                        if (childNode.mCachedState == 0 || parent.mCachedState != 0 || parent.id() <= 1L) break block6;
                        if (childNode.tryUpgrade()) break block7;
                        childNode.releaseShared();
                        childNode = this.nodeMapGetExclusive(childId);
                        if (childNode == null) break block5;
                        if (childNode.mCachedState != 0) break block7;
                        childNode.downgrade();
                        break block6;
                    }
                    if (option == 1) {
                        parent.releaseShared();
                    }
                    try {
                        childNode.write(this.mPageDb);
                    }
                    catch (Throwable e) {
                        childNode.releaseExclusive();
                        if (option == 0) {
                            parent.releaseShared();
                        }
                        throw e;
                    }
                    childNode.mCachedState = 0;
                    childNode.downgrade();
                    break block8;
                }
                if (option == 1) {
                    parent.releaseShared();
                }
            }
            childNode.used();
            return childNode;
        }
        return parent.loadChild(this, childId, option);
    }

    final _Node latchChildRetainParentEx(_Node parent, int childPos, boolean required) throws IOException {
        _Node childNode;
        block8: {
            long childId = parent.retrieveChildRefId(childPos);
            while ((childNode = this.nodeMapGet(childId)) != null) {
                if (required) {
                    childNode.acquireExclusive();
                } else if (!childNode.tryAcquireExclusive()) {
                    return null;
                }
                if (childId != childNode.id()) {
                    childNode.releaseExclusive();
                    continue;
                }
                break block8;
            }
            return parent.loadChild(this, childId, 4);
        }
        if (childNode.mCachedState != 0 && parent.mCachedState == 0 && parent.id() > 1L) {
            try {
                childNode.write(this.mPageDb);
            }
            catch (Throwable e) {
                childNode.releaseExclusive();
                parent.releaseExclusive();
                throw e;
            }
            childNode.mCachedState = 0;
        }
        childNode.used();
        return childNode;
    }

    _Node allocLatchedNode() throws IOException {
        return this.allocLatchedNode(0);
    }

    _Node allocLatchedNode(int mode) throws IOException {
        mode |= this.mPageDb.allocMode();
        _NodeGroup[] groups = this.mNodeGroups;
        int groupIx = ThreadLocalRandom.current().nextInt() & groups.length - 1;
        IOException fail = null;
        for (int trial = 1; trial <= 3; ++trial) {
            for (int i = 0; i < groups.length; ++i) {
                block8: {
                    try {
                        _Node node = groups[groupIx].tryAllocLatchedNode(trial, mode);
                        if (node != null) {
                            return node;
                        }
                    }
                    catch (IOException e) {
                        if (fail != null) break block8;
                        fail = e;
                    }
                }
                if (--groupIx >= 0) continue;
                groupIx = groups.length - 1;
            }
            this.checkClosed();
            this.cleanupUnreferencedTrees();
        }
        if (fail == null) {
            String stats = this.stats(false).toString();
            if (this.isCacheOnly()) {
                throw new DatabaseFullException(stats);
            }
            throw new CacheExhaustedException(stats);
        }
        if (fail instanceof DatabaseFullException) {
            throw fail;
        }
        throw new DatabaseFullException(fail);
    }

    _Node tryAllocRawDirtyNode(long id) throws IOException {
        if (this.mFullyMapped) {
            return null;
        }
        _NodeGroup[] groups = this.mNodeGroups;
        int groupIx = ThreadLocalRandom.current().nextInt(groups.length);
        _Node node = groups[groupIx].tryAllocLatchedNode(1, 2);
        if (node != null) {
            node.type((byte)0);
            node.id(id);
            node.mGroup.addDirty(node, this.mCommitState);
        }
        return node;
    }

    _Node allocDirtyNode() throws IOException {
        return this.allocDirtyNode(0);
    }

    _Node allocDirtyNode(int mode) throws IOException {
        _Node node = this.mPageDb.allocLatchedNode(this, mode);
        if (this.mFullyMapped) {
            node.mPage = this.mPageDb.dirtyPage(node.id());
        }
        node.mGroup.addDirty(node, this.mCommitState);
        return node;
    }

    _Node allocDirtyFragmentNode() throws IOException {
        _Node node = this.allocDirtyNode();
        this.nodeMapPut(node);
        return node;
    }

    boolean isMutable(_Node node) {
        return node.mCachedState == this.mCommitState && node.id() > 1L;
    }

    boolean shouldMarkDirty(_Node node) {
        return node.mCachedState != this.mCommitState && node.id() >= 0L;
    }

    boolean markDirty(_BTree tree, _Node node) throws IOException {
        if (node.mCachedState == this.mCommitState || node.id() < 0L) {
            return false;
        }
        this.doMarkDirty(tree, node);
        return true;
    }

    boolean markFragmentDirty(_Node node) throws IOException {
        if (node.mCachedState == this.mCommitState) {
            return false;
        }
        if (node.mCachedState != 0) {
            node.write(this.mPageDb);
        }
        long newId = this.mPageDb.allocPage();
        long oldId = node.id();
        if (oldId != 0L) {
            boolean removed = this.nodeMapRemove(node, Long.hashCode(oldId));
            try {
                this.mPageDb.deletePage(oldId, false);
            }
            catch (Throwable e) {
                if (removed) {
                    try {
                        this.nodeMapPut(node);
                    }
                    catch (Throwable e2) {
                        Utils.suppress(e, e2);
                    }
                }
                try {
                    this.mPageDb.recyclePage(newId);
                }
                catch (Throwable e2) {
                    Utils.suppress(e, e2);
                    this.close(e);
                }
                throw e;
            }
        }
        this.dirty(node, newId);
        this.nodeMapPut(node);
        return true;
    }

    void markUnmappedDirty(_Node node) throws IOException {
        if (node.mCachedState != this.mCommitState) {
            if (node.mCachedState != 0) {
                node.write(this.mPageDb);
            }
            long newId = this.mPageDb.allocPage();
            long oldId = node.id();
            try {
                this.mPageDb.deletePage(oldId, false);
            }
            catch (Throwable e) {
                try {
                    this.mPageDb.recyclePage(newId);
                }
                catch (Throwable e2) {
                    Utils.suppress(e, e2);
                    this.close(e);
                }
                throw e;
            }
            this.dirty(node, newId);
        }
    }

    void doMarkDirty(_BTree tree, _Node node) throws IOException {
        if (node.mCachedState != 0) {
            node.write(this.mPageDb);
        }
        long newId = this.mPageDb.allocPage();
        long oldId = node.id();
        try {
            if (node == tree.mRoot) {
                this.storeTreeRootId(tree, newId);
            }
        }
        catch (Throwable e) {
            try {
                this.mPageDb.recyclePage(newId);
            }
            catch (Throwable e2) {
                Utils.suppress(e, e2);
                this.close(e);
            }
            throw e;
        }
        if (oldId != 0L) {
            boolean removed = this.nodeMapRemove(node, Long.hashCode(oldId));
            try {
                this.mPageDb.deletePage(oldId, false);
            }
            catch (Throwable e) {
                if (removed) {
                    try {
                        this.nodeMapPut(node);
                    }
                    catch (Throwable e2) {
                        Utils.suppress(e, e2);
                    }
                }
                try {
                    if (node == tree.mRoot) {
                        this.storeTreeRootId(tree, oldId);
                    }
                    this.mPageDb.recyclePage(newId);
                }
                catch (Throwable e2) {
                    Utils.suppress(e, e2);
                    this.close(e);
                }
                throw e;
            }
        }
        this.dirty(node, newId);
        this.nodeMapPut(node);
    }

    private void storeTreeRootId(_BTree tree, long id) throws IOException {
        if (tree.mIdBytes != null) {
            byte[] encodedId = new byte[8];
            Utils.encodeLongLE(encodedId, 0, id);
            this.mRegistry.store(Transaction.BOGUS, tree.mIdBytes, encodedId);
        }
    }

    private void dirty(_Node node, long newId) throws IOException {
        if (this.mFullyMapped) {
            if (node.mPage == DirectPageOps.p_nonTreePage()) {
                node.mPage = this.mPageDb.dirtyPage(newId);
                node.asEmptyRoot();
            } else if (!DirectPageOps.isClosedOrDeleted(node.mPage)) {
                node.mPage = this.mPageDb.copyPage(node.id(), newId);
            }
        }
        node.id(newId);
        node.mGroup.addDirty(node, this.mCommitState);
    }

    void swapIfDirty(_Node oldNode, _Node newNode) {
        oldNode.mGroup.swapIfDirty(oldNode, newNode);
    }

    void deleteNode(_Node node) throws IOException {
        this.deleteNode(node, true);
    }

    void deleteNode(_Node node, boolean canRecycle) throws IOException {
        this.prepareToDelete(node);
        this.finishDeleteNode(node, canRecycle);
    }

    void prepareToDelete(_Node node) throws IOException {
        if (node.mCachedState == this.mCheckpointFlushState) {
            try {
                node.write(this.mPageDb);
            }
            catch (Throwable e) {
                node.releaseExclusive();
                throw e;
            }
        }
    }

    void finishDeleteNode(_Node node) throws IOException {
        this.finishDeleteNode(node, true);
    }

    void finishDeleteNode(_Node node, boolean canRecycle) throws IOException {
        try {
            long id = node.id();
            if (id != 0L) {
                boolean removed = this.nodeMapRemove(node, Long.hashCode(id));
                try {
                    if (canRecycle && node.mCachedState == this.mCommitState) {
                        this.mPageDb.recyclePage(id);
                    } else {
                        this.mPageDb.deletePage(id, true);
                    }
                }
                catch (Throwable e) {
                    if (removed) {
                        try {
                            this.nodeMapPut(node);
                        }
                        catch (Throwable e2) {
                            Utils.suppress(e, e2);
                        }
                    }
                    throw e;
                }
                node.id(-id);
            }
            node.mCachedState = 0;
        }
        catch (Throwable e) {
            node.releaseExclusive();
            this.close(e);
            throw e;
        }
        node.unused();
    }

    final byte[] fragmentKey(byte[] key) throws IOException {
        return this.fragment(key, key.length, this.mMaxKeySize);
    }

    final byte[] fragment(byte[] value, long vlength, int max) throws IOException {
        return this.fragment(value, vlength, max, 65535);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final byte[] fragment(byte[] value, long vlength, int max, int maxInline) throws IOException {
        byte[] newValue;
        block59: {
            int header;
            block57: {
                int offset;
                block60: {
                    long pointerSpace;
                    int remainder;
                    long pageCount;
                    int pageSize;
                    block58: {
                        int offset2;
                        int inline;
                        pageSize = this.mPageSize;
                        pageCount = vlength / (long)pageSize;
                        remainder = (int)(vlength % (long)pageSize);
                        if (vlength >= 65536L) {
                            max -= 11;
                        } else {
                            if (pageCount == 0L && remainder <= max - 5) {
                                byte[] newValue2 = new byte[5 + (int)vlength];
                                newValue2[0] = 2;
                                Utils.encodeShortLE(newValue2, 1, (int)vlength);
                                Utils.encodeShortLE(newValue2, 3, (int)vlength);
                                Utils.arrayCopyOrFill(value, 0, newValue2, 5, (int)vlength);
                                return newValue2;
                            }
                            max -= 9;
                        }
                        if (max < 0) {
                            return null;
                        }
                        pointerSpace = pageCount * 6L;
                        if (remainder > max || remainder > maxInline || pointerSpace > (long)(max + 6 - (inline = remainder == 0 ? 0 : 2) - remainder)) break block58;
                        byte header2 = (byte)inline;
                        if (vlength < 65536L) {
                            offset2 = 3;
                        } else if (vlength < 0x100000000L) {
                            header2 = (byte)(header2 | 4);
                            offset2 = 5;
                        } else if (vlength < 0x1000000000000L) {
                            header2 = (byte)(header2 | 8);
                            offset2 = 7;
                        } else {
                            header2 = (byte)(header2 | 0xC);
                            offset2 = 9;
                        }
                        int poffset = offset2 + inline + remainder;
                        newValue = new byte[poffset + (int)pointerSpace];
                        if (pageCount > 0L) {
                            if (value == null) {
                                Arrays.fill(newValue, poffset, poffset + (int)pageCount * 6, (byte)0);
                            } else {
                                try {
                                    int voffset = remainder;
                                    while (true) {
                                        block54: {
                                            _Node node = this.allocDirtyFragmentNode();
                                            try {
                                                Utils.encodeInt48LE(newValue, poffset, node.id());
                                                DirectPageOps.p_copyFromArray(value, voffset, node.mPage, 0, pageSize);
                                                if (pageCount != 1L) break block54;
                                                break;
                                            }
                                            finally {
                                                node.releaseExclusive();
                                            }
                                        }
                                        --pageCount;
                                        poffset += 6;
                                        voffset += pageSize;
                                    }
                                }
                                catch (DatabaseException e) {
                                    if (!e.isRecoverable()) {
                                        this.close(e);
                                        throw e;
                                    }
                                    try {
                                        while ((poffset -= 6) >= offset2 + inline + remainder) {
                                            this.deleteFragment(Utils.decodeUnsignedInt48LE(newValue, poffset));
                                        }
                                        throw e;
                                    }
                                    catch (Throwable e2) {
                                        Utils.suppress(e, e2);
                                        this.close(e);
                                    }
                                    throw e;
                                }
                            }
                        }
                        newValue[0] = header2;
                        if (remainder != 0) {
                            Utils.encodeShortLE(newValue, offset2, remainder);
                            Utils.arrayCopyOrFill(value, 0, newValue, offset2 + 2, remainder);
                        }
                        break block59;
                    }
                    ++pageCount;
                    pointerSpace += 6L;
                    if (vlength < 65536L) {
                        header = 0;
                        offset = 3;
                    } else if (vlength < 0x100000000L) {
                        header = 4;
                        offset = 5;
                    } else if (vlength < 0x1000000000000L) {
                        header = 8;
                        offset = 7;
                    } else {
                        header = 12;
                        offset = 9;
                    }
                    if (pointerSpace > (long)(max + 6)) break block60;
                    newValue = new byte[offset + (int)pointerSpace];
                    if (pageCount <= 0L) break block57;
                    if (value == null) {
                        Arrays.fill(newValue, offset, offset + (int)pageCount * 6, (byte)0);
                        break block57;
                    } else {
                        int poffset = offset;
                        try {
                            int voffset = 0;
                            while (true) {
                                block56: {
                                    _Node node = this.allocDirtyFragmentNode();
                                    try {
                                        Utils.encodeInt48LE(newValue, poffset, node.id());
                                        long page = node.mPage;
                                        if (pageCount > 1L) {
                                            DirectPageOps.p_copyFromArray(value, voffset, page, 0, pageSize);
                                            break block56;
                                        }
                                        DirectPageOps.p_copyFromArray(value, voffset, page, 0, remainder);
                                        DirectPageOps.p_clear(page, remainder, this.pageSize(page));
                                        break block57;
                                    }
                                    finally {
                                        node.releaseExclusive();
                                    }
                                }
                                --pageCount;
                                poffset += 6;
                                voffset += pageSize;
                            }
                        }
                        catch (DatabaseException e) {
                            if (!e.isRecoverable()) {
                                this.close(e);
                                throw e;
                            }
                            try {
                                while ((poffset -= 6) >= offset) {
                                    this.deleteFragment(Utils.decodeUnsignedInt48LE(newValue, poffset));
                                }
                                throw e;
                            }
                            catch (Throwable e2) {
                                Utils.suppress(e, e2);
                                this.close(e);
                            }
                            throw e;
                        }
                    }
                }
                header = (byte)(header | 1);
                newValue = new byte[offset + 6];
                if (value == null) {
                    Utils.encodeInt48LE(newValue, offset, 0L);
                } else {
                    int levels = this.calculateInodeLevels(vlength);
                    _Node inode = this.allocDirtyFragmentNode();
                    try {
                        Utils.encodeInt48LE(newValue, offset, inode.id());
                        this.writeMultilevelFragments(levels, inode, value, 0, vlength);
                        inode.releaseExclusive();
                    }
                    catch (DatabaseException e) {
                        if (!e.isRecoverable()) {
                            this.close(e);
                            throw e;
                        }
                        try {
                            this.deleteMultilevelFragments(levels, inode, vlength);
                            throw e;
                        }
                        catch (Throwable e2) {
                            Utils.suppress(e, e2);
                            this.close(e);
                        }
                        throw e;
                    }
                    catch (Throwable e) {
                        this.close(e);
                        throw e;
                    }
                }
            }
            newValue[0] = header;
        }
        if (vlength < 65536L) {
            Utils.encodeShortLE(newValue, 1, (int)vlength);
            return newValue;
        }
        if (vlength < 0x100000000L) {
            Utils.encodeIntLE(newValue, 1, (int)vlength);
            return newValue;
        }
        if (vlength < 0x1000000000000L) {
            Utils.encodeInt48LE(newValue, 1, vlength);
            return newValue;
        }
        Utils.encodeLongLE(newValue, 1, vlength);
        return newValue;
    }

    int calculateInodeLevels(long vlength) {
        int levels;
        long[] caps = this.mFragmentInodeLevelCaps;
        for (levels = 0; levels < caps.length && vlength > caps[levels]; ++levels) {
        }
        return levels;
    }

    static long decodeFullFragmentedValueLength(int header, long fragmented, int off) {
        return switch (header >> 2 & 3) {
            default -> DirectPageOps.p_ushortGetLE(fragmented, off);
            case 1 -> (long)DirectPageOps.p_intGetLE(fragmented, off) & 0xFFFFFFFFL;
            case 2 -> DirectPageOps.p_uint48GetLE(fragmented, off);
            case 3 -> DirectPageOps.p_longGetLE(fragmented, off);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMultilevelFragments(int level, _Node inode, byte[] value, int voffset, long vlength) throws IOException {
        long page = inode.mPage;
        long levelCap = this.levelCap(--level);
        int childNodeCount = _LocalDatabase.childNodeCount(vlength, levelCap);
        int poffset = 0;
        try {
            for (int i = 0; i < childNodeCount; ++i) {
                _Node childNode = this.allocDirtyFragmentNode();
                DirectPageOps.p_int48PutLE(page, poffset, childNode.id());
                poffset += 6;
                int len = (int)Math.min(levelCap, vlength);
                if (level <= 0) {
                    long childPage = childNode.mPage;
                    DirectPageOps.p_copyFromArray(value, voffset, childPage, 0, len);
                    DirectPageOps.p_clear(childPage, len, this.pageSize(childPage));
                    childNode.releaseExclusive();
                } else {
                    try {
                        this.writeMultilevelFragments(level, childNode, value, voffset, len);
                    }
                    finally {
                        childNode.releaseExclusive();
                    }
                }
                vlength -= (long)len;
                voffset += len;
            }
        }
        finally {
            DirectPageOps.p_clear(page, poffset, this.pageSize(page));
        }
    }

    private static int childNodeCount(long vlength, long levelCap) {
        int count = (int)((vlength + (levelCap - 1L)) / levelCap);
        if (count < 0) {
            count = _LocalDatabase.childNodeCountOverflow(vlength, levelCap);
        }
        return count;
    }

    private static int childNodeCountOverflow(long vlength, long levelCap) {
        return BigInteger.valueOf(vlength).add(BigInteger.valueOf(levelCap - 1L)).divide(BigInteger.valueOf(levelCap)).intValue();
    }

    byte[] reconstructKey(long fragmented, int off, int len) throws IOException {
        try {
            return this.reconstruct(fragmented, off, len);
        }
        catch (LargeValueException e) {
            throw new LargeKeyException(e.length(), e.getCause());
        }
    }

    byte[] reconstruct(long fragmented, int off, int len) throws IOException {
        return this.reconstruct(fragmented, off, len, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] reconstruct(long fragmented, int off, int len, long[] stats) throws IOException {
        byte[] value;
        long vLen;
        byte header = DirectPageOps.p_byteGet(fragmented, off++);
        --len;
        switch (header >> 2 & 3) {
            default: {
                vLen = DirectPageOps.p_ushortGetLE(fragmented, off);
                break;
            }
            case 1: {
                vLen = DirectPageOps.p_intGetLE(fragmented, off);
                if (vLen >= 0L) break;
                vLen &= 0xFFFFFFFFL;
                if (stats != null) break;
                throw new LargeValueException(vLen);
            }
            case 2: {
                vLen = DirectPageOps.p_uint48GetLE(fragmented, off);
                if (vLen <= Integer.MAX_VALUE || stats != null) break;
                throw new LargeValueException(vLen);
            }
            case 3: {
                vLen = DirectPageOps.p_longGetLE(fragmented, off);
                if (vLen >= 0L && (vLen <= Integer.MAX_VALUE || stats != null)) break;
                throw new LargeValueException(vLen);
            }
        }
        int vLenFieldSize = 2 + (header >> 1 & 6);
        off += vLenFieldSize;
        len -= vLenFieldSize;
        if (stats != null) {
            stats[0] = vLen;
            value = null;
        } else {
            try {
                value = new byte[(int)vLen];
            }
            catch (OutOfMemoryError e) {
                throw new LargeValueException(vLen, (Throwable)e);
            }
        }
        int vOff = 0;
        if ((header & 2) != 0) {
            int inLen = DirectPageOps.p_ushortGetLE(fragmented, off);
            off += 2;
            len -= 2;
            if (value != null) {
                DirectPageOps.p_copyToArray(fragmented, off, value, vOff, inLen);
            }
            off += inLen;
            len -= inLen;
            vOff += inLen;
            vLen -= (long)inLen;
        }
        long pagesRead = 0L;
        if ((header & 1) == 0) {
            while (len >= 6) {
                int pLen;
                long nodeId = DirectPageOps.p_uint48GetLE(fragmented, off);
                off += 6;
                len -= 6;
                if (nodeId == 0L) {
                    pLen = Math.min((int)vLen, this.mPageSize);
                } else {
                    _Node node = this.nodeMapLoadFragment(nodeId);
                    ++pagesRead;
                    try {
                        long page = node.mPage;
                        pLen = Math.min((int)vLen, this.pageSize(page));
                        if (value != null) {
                            DirectPageOps.p_copyToArray(page, 0, value, vOff, pLen);
                        }
                    }
                    finally {
                        node.releaseShared();
                    }
                }
                vOff += pLen;
                vLen -= (long)pLen;
            }
        } else {
            long inodeId = DirectPageOps.p_uint48GetLE(fragmented, off);
            if (inodeId != 0L) {
                _Node inode = this.nodeMapLoadFragment(inodeId);
                ++pagesRead;
                int levels = this.calculateInodeLevels(vLen);
                pagesRead += this.readMultilevelFragments(levels, inode, value, vOff, vLen);
            }
        }
        if (stats != null) {
            stats[1] = pagesRead;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readMultilevelFragments(int level, _Node inode, byte[] value, int voffset, long vlength) throws IOException {
        try {
            long pagesRead = 0L;
            long page = inode.mPage;
            long levelCap = this.levelCap(--level);
            int childNodeCount = _LocalDatabase.childNodeCount(vlength, levelCap);
            int poffset = 0;
            for (int i = 0; i < childNodeCount; ++i) {
                long childNodeId = DirectPageOps.p_uint48GetLE(page, poffset);
                int len = (int)Math.min(levelCap, vlength);
                if (childNodeId != 0L) {
                    _Node childNode = this.nodeMapLoadFragment(childNodeId);
                    ++pagesRead;
                    if (level <= 0) {
                        if (value != null) {
                            DirectPageOps.p_copyToArray(childNode.mPage, 0, value, voffset, len);
                        }
                        childNode.releaseShared();
                    } else {
                        pagesRead += this.readMultilevelFragments(level, childNode, value, voffset, len);
                    }
                }
                vlength -= (long)len;
                voffset += len;
                poffset += 6;
            }
            long l = pagesRead;
            return l;
        }
        finally {
            inode.releaseShared();
        }
    }

    void deleteFragments(long fragmented, int off, int len) throws IOException {
        long vLen;
        byte header = DirectPageOps.p_byteGet(fragmented, off++);
        --len;
        if ((header & 1) == 0) {
            vLen = 0L;
        } else {
            vLen = switch (header >> 2 & 3) {
                default -> DirectPageOps.p_ushortGetLE(fragmented, off);
                case 1 -> (long)DirectPageOps.p_intGetLE(fragmented, off) & 0xFFFFFFFFL;
                case 2 -> DirectPageOps.p_uint48GetLE(fragmented, off);
                case 3 -> DirectPageOps.p_longGetLE(fragmented, off);
            };
        }
        int vLenFieldSize = 2 + (header >> 1 & 6);
        off += vLenFieldSize;
        len -= vLenFieldSize;
        if ((header & 2) != 0) {
            int inLen = 2 + DirectPageOps.p_ushortGetLE(fragmented, off);
            off += inLen;
            len -= inLen;
        }
        if ((header & 1) == 0) {
            while (len >= 6) {
                long nodeId = DirectPageOps.p_uint48GetLE(fragmented, off);
                off += 6;
                len -= 6;
                this.deleteFragment(nodeId);
            }
        } else {
            long inodeId = DirectPageOps.p_uint48GetLE(fragmented, off);
            if (inodeId != 0L) {
                _Node inode = this.removeInode(inodeId);
                int levels = this.calculateInodeLevels(vLen);
                this.deleteMultilevelFragments(levels, inode, vLen);
            }
        }
    }

    private void deleteMultilevelFragments(int level, _Node inode, long vlength) throws IOException {
        long page = inode.mPage;
        long levelCap = this.levelCap(--level);
        int childNodeCount = _LocalDatabase.childNodeCount(vlength, levelCap);
        long[] childNodeIds = new long[childNodeCount];
        int poffset = 0;
        for (int i = 0; i < childNodeCount; ++i) {
            childNodeIds[i] = DirectPageOps.p_uint48GetLE(page, poffset);
            poffset += 6;
        }
        this.deleteNode(inode);
        if (level <= 0) {
            for (long childNodeId : childNodeIds) {
                this.deleteFragment(childNodeId);
            }
        } else {
            for (long childNodeId : childNodeIds) {
                long len = Math.min(levelCap, vlength);
                if (childNodeId != 0L) {
                    _Node childNode = this.removeInode(childNodeId);
                    this.deleteMultilevelFragments(level, childNode, len);
                }
                vlength -= len;
            }
        }
    }

    private _Node removeInode(long nodeId) throws IOException {
        _Node node = this.nodeMapGetAndRemove(nodeId);
        if (node == null) {
            node = this.allocLatchedNode(1);
            try {
                this.readNode(node, nodeId);
            }
            catch (Throwable e) {
                node.releaseExclusive();
                throw e;
            }
        }
        return node;
    }

    void deleteFragment(long nodeId) throws IOException {
        if (nodeId != 0L) {
            _Node node = this.nodeMapGetAndRemove(nodeId);
            if (node != null) {
                this.deleteNode(node);
            } else {
                try {
                    if (this.mInitialReadState != 0) {
                        this.mPageDb.recyclePage(nodeId);
                    } else {
                        this.mPageDb.deletePage(nodeId, true);
                    }
                }
                catch (Throwable e) {
                    this.close(e);
                    throw e;
                }
            }
        }
    }

    private static long[] calculateInodeLevelCaps(int pageSize) {
        long[] caps = new long[10];
        long cap = pageSize;
        long scalar = pageSize / 6;
        int i = 0;
        while (i < caps.length) {
            caps[i++] = cap;
            long next = cap * scalar;
            if (next / scalar != cap) {
                caps[i++] = Long.MAX_VALUE;
                break;
            }
            cap = next;
        }
        if (i < caps.length) {
            long[] newCaps = new long[i];
            System.arraycopy(caps, 0, newCaps, 0, i);
            caps = newCaps;
        }
        return caps;
    }

    long levelCap(int level) {
        return this.mFragmentInodeLevelCaps[level];
    }

    _BTree fragmentedTrash() throws IOException {
        _BTree trash = this.mFragmentedTrash;
        return trash != null ? trash : this.openFragmentedTrash(true);
    }

    _BTree tryFragmentedTrash() throws IOException {
        _BTree trash = this.mFragmentedTrash;
        return trash != null ? trash : this.openFragmentedTrash(false);
    }

    private _BTree openFragmentedTrash(boolean create) throws IOException {
        _BTree trash;
        this.mOpenTreesLatch.acquireExclusive();
        try {
            trash = this.mFragmentedTrash;
            if (trash == null) {
                trash = this.openInternalTree(3L, create);
                VarHandle.storeStoreFence();
                this.mFragmentedTrash = trash;
            }
        }
        finally {
            this.mOpenTreesLatch.releaseExclusive();
        }
        return trash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emptyLingeringTrash(LHashTable<?> activeTxns) throws IOException {
        this.mOpenTreesLatch.acquireExclusive();
        _BTree trash = this.mFragmentedTrash;
        if (trash != null) {
            this.mOpenTreesLatch.releaseExclusive();
            _FragmentedTrash.emptyLingeringTrash(trash, activeTxns);
            return;
        }
        try {
            trash = this.openInternalTree(3L, false);
            if (trash == null) {
                this.mOpenTreesLatch.releaseExclusive();
                return;
            }
        }
        catch (Throwable e) {
            this.mOpenTreesLatch.releaseExclusive();
            throw e;
        }
        this.mOpenTreesLatch.downgrade();
        try {
            _FragmentedTrash.emptyLingeringTrash(trash, activeTxns);
        }
        finally {
            this.mOpenTreesLatch.releaseShared();
            trash.forceClose();
        }
    }

    void readNode(_Node node, long id) throws IOException {
        if (this.mFullyMapped) {
            node.mPage = this.mPageDb.directPagePointer(id);
        } else {
            this.mPageDb.readPage(id, node.mPage);
        }
        node.id(id);
        node.mCachedState = this.mInitialReadState;
        if (node.mCachedState != 0) {
            node.mGroup.addDirty(node, node.mCachedState);
        }
    }

    @Override
    boolean isDirectPageAccess() {
        return true;
    }

    @Override
    boolean isCacheOnly() {
        return this.mPageDb.isCacheOnly();
    }

    @Override
    boolean isReadOnly() {
        return this.mReadOnly;
    }

    @Override
    Crypto dataCrypto() {
        return this.mPageDb.dataCrypto();
    }

    @Override
    Supplier<Checksum> checksumFactory() {
        return this.mPageDb.checksumFactory();
    }

    @Override
    Tree registry() {
        return this.mRegistry;
    }

    @Override
    public EventListener eventListener() {
        return this.mEventListener;
    }

    @Override
    void checkpoint(long sizeThreshold, long delayThresholdNanos) throws IOException {
        this.checkpoint(0, sizeThreshold, delayThresholdNanos);
    }

    private void forceCheckpoint() throws IOException {
        this.checkpoint(1, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpoint(int force, long sizeThreshold, long delayThresholdNanos) throws IOException {
        while (!this.isClosed() && !this.isCacheOnly()) {
            this.mCheckpointLock.lock();
            try {
                this.doCheckpoint(force, sizeThreshold, delayThresholdNanos);
                return;
            }
            catch (Throwable e) {
                if (!Utils.isRecoverable(e)) {
                    Utils.closeQuietly(this, e);
                    throw e;
                }
                try {
                    this.cleanupMasterUndoLog();
                }
                catch (Throwable e2) {
                    Utils.closeQuietly(this, e2);
                    Utils.suppress(e2, e);
                    throw e2;
                }
                if (!(e instanceof UnmodifiableReplicaException)) {
                    throw e;
                }
            }
            finally {
                this.mCheckpointLock.unlock();
            }
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupMasterUndoLog() throws IOException {
        LHashTable.Obj<Object> committed;
        if (this.mCommitMasterUndoLog == null) {
            return;
        }
        CommitLock.Shared shared = this.mCommitLock.acquireSharedUnchecked();
        try {
            if (this.isClosed()) {
                return;
            }
            committed = this.mCommitMasterUndoLog.findCommitted();
        }
        finally {
            shared.release();
        }
        if (committed == null || !this.waitForCommitted(committed)) {
            return;
        }
        LHashTable.Obj<Object> uncommitted = null;
        for (_TransactionContext txnContext : this.mTxnContexts) {
            uncommitted = txnContext.moveUncommitted(uncommitted);
        }
        if (uncommitted != null) {
            shared = this.mCommitLock.acquireSharedUnchecked();
            try {
                if (this.isClosed()) {
                    return;
                }
                this.mCommitMasterUndoLog.markUncommitted(uncommitted);
            }
            finally {
                shared.release();
            }
        }
    }

    private boolean waitForCommitted(LHashTable.Obj<Object> committed) {
        if (committed == null) {
            return true;
        }
        while (true) {
            block7: {
                for (_TransactionContext txnContext : this.mTxnContexts) {
                    if (!txnContext.anyActive(committed)) {
                        continue;
                    }
                    break block7;
                }
                return true;
            }
            if (this.isClosed()) {
                return false;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    boolean waitForCommitted() {
        this.mCommitLock.acquireExclusive();
        this.mCommitLock.releaseExclusive();
        LHashTable.Obj<Object> committed = null;
        for (_TransactionContext txnContext : this.mTxnContexts) {
            committed = txnContext.gatherCommitted(committed);
        }
        return this.waitForCommitted(committed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckpoint(int force, long sizeThreshold, long delayThresholdNanos) throws IOException {
        if (force >= 0 && this.isClosed()) {
            return;
        }
        this.cleanupUnreferencedTrees();
        _Node root = this.mRegistry.mRoot;
        long header = this.mCommitHeader;
        long nowNanos = System.nanoTime();
        if (force == 0 && header == DirectPageOps.p_null()) {
            boolean full;
            if (!(delayThresholdNanos == 0L || delayThresholdNanos > 0L && nowNanos - this.mLastCheckpointStartNanos >= delayThresholdNanos || this.mRedoWriter == null || this.mRedoWriter.shouldCheckpoint(sizeThreshold))) {
                this.flush(2);
                return;
            }
            root.acquireShared();
            try {
                full = root.mCachedState != 0;
            }
            finally {
                root.releaseShared();
            }
            if (!full) {
                for (_NodeGroup group : this.mNodeGroups) {
                    if (group.dirtyCount() <= 0L) continue;
                    full = true;
                    break;
                }
            }
            if (!full) {
                full = this.mPageDb.requiresCommit();
            }
            if (!full && this.mRedoWriter != null && this.mRedoWriter instanceof _ReplController) {
                full = this.mRedoWriter.shouldCheckpoint(1L);
            }
            if (!full) {
                this.flush(2);
                this.mLastCheckpointDurationNanos = 0L;
                return;
            }
        }
        this.mLastCheckpointStartNanos = nowNanos;
        if (this.mEventListener != null) {
            this.mEventListener.notify(EventType.CHECKPOINT_BEGIN, "Checkpoint begin", new Object[0]);
        }
        boolean resume = true;
        _UndoLog masterUndoLog = this.mCommitMasterUndoLog;
        if (header == DirectPageOps.p_null()) {
            header = DirectPageOps.p_callocPage(this.mPageDb.directPageSize());
            resume = false;
            if (masterUndoLog != null) {
                throw new AssertionError();
            }
        }
        _RedoWriter redo = this.mRedoWriter;
        try {
            long redoTxnId;
            long redoPos;
            long redoNum;
            int hoff = this.mPageDb.extraCommitDataOffset();
            DirectPageOps.p_intPutLE(header, hoff + 0, this.mEncodingVersion);
            if (redo != null) {
                redo.checkpointPrepare();
            }
            try {
                while (true) {
                    this.mCommitLock.acquireExclusive();
                    if (!root.tryAcquireShared()) {
                        this.mCommitLock.releaseExclusive();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                if (redo != null) {
                    redo.checkpointAborted();
                }
                throw e;
            }
            this.mCheckpointFlushState = -2;
            if (!resume) {
                DirectPageOps.p_longPutLE(header, hoff + 4, root.id());
            }
            if (redo == null) {
                redoNum = 0L;
                redoPos = 0L;
                redoTxnId = 0L;
            } else {
                redo.checkpointSwitch(this.mTxnContexts);
                redoNum = redo.checkpointNumber();
                redoPos = redo.checkpointPosition();
                redoTxnId = redo.checkpointTransactionId();
            }
            DirectPageOps.p_longPutLE(header, hoff + 28, redoNum);
            DirectPageOps.p_longPutLE(header, hoff + 36, redoTxnId);
            DirectPageOps.p_longPutLE(header, hoff + 44, redoPos);
            DirectPageOps.p_longPutLE(header, hoff + 52, redo == null ? 0L : redo.encoding());
            if (!resume) {
                long masterUndoLogId;
                long txnId = 0L;
                byte[] workspace = null;
                for (_TransactionContext txnContext : this.mTxnContexts) {
                    txnId = txnContext.higherTransactionId(txnId);
                    _TransactionContext _TransactionContext2 = txnContext;
                    synchronized (_TransactionContext2) {
                        if (txnContext.hasUndoLogs()) {
                            if (masterUndoLog == null) {
                                this.mCommitMasterUndoLog = masterUndoLog = new _UndoLog(this, 0L);
                            }
                            workspace = txnContext.writeToMaster(masterUndoLog, workspace);
                        }
                        txnContext.clearUncommitted();
                    }
                }
                if (masterUndoLog == null) {
                    masterUndoLogId = 0L;
                } else {
                    masterUndoLogId = masterUndoLog.persistReady();
                    if (masterUndoLogId == 0L) {
                        this.mCommitMasterUndoLog = null;
                        masterUndoLog = null;
                    }
                }
                DirectPageOps.p_longPutLE(header, hoff + 20, txnId);
                DirectPageOps.p_longPutLE(header, hoff + 12, masterUndoLogId);
            }
            this.mCommitHeader = header;
            this.mPageDb.commit(resume, header, this::checkpointFlush);
        }
        catch (Throwable e) {
            if (this.mCommitHeader != header) {
                DirectPageOps.p_delete(header);
            }
            if (this.mCheckpointFlushState == -2) {
                this.mCheckpointFlushState = -1;
                root.releaseShared();
                this.mCommitLock.releaseExclusive();
                if (redo != null) {
                    redo.checkpointAborted();
                }
                this.deleteCommitHeader();
                if (masterUndoLog != null) {
                    try {
                        masterUndoLog.truncateMaster();
                    }
                    catch (Throwable e2) {
                        Utils.suppress(e2, e);
                        this.close(e2);
                        throw e2;
                    }
                    finally {
                        this.mCommitMasterUndoLog = null;
                    }
                }
            }
            throw e;
        }
        this.deleteCommitHeader();
        if (masterUndoLog != null) {
            try {
                masterUndoLog.truncateMaster();
            }
            catch (Throwable e) {
                if (!this.isClosed()) {
                    throw e;
                }
            }
            finally {
                this.mCommitMasterUndoLog = null;
            }
        }
        if (this.mRedoWriter != null) {
            this.mRedoWriter.checkpointFinished();
        }
        this.mLastCheckpointDurationNanos = System.nanoTime() - this.mLastCheckpointStartNanos;
        if (this.mEventListener != null) {
            double duration = (double)this.mLastCheckpointDurationNanos / 1.0E9;
            this.mEventListener.notify(EventType.CHECKPOINT_COMPLETE, "Checkpoint completed in %1$1.3f seconds", new Object[]{duration, TimeUnit.SECONDS});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointFlush(boolean resume, long header) throws IOException {
        int stateToFlush = this.mCommitState;
        if (resume) {
            if (header != this.mCommitHeader) {
                throw new AssertionError();
            }
            stateToFlush ^= 1;
        } else {
            if (this.mInitialReadState != 0) {
                this.mInitialReadState = 0;
            }
            this.mCommitState = (byte)(stateToFlush ^ 1);
            this.mCommitHeader = header;
        }
        this.mCheckpointFlushState = stateToFlush;
        this.mRegistry.mRoot.releaseShared();
        this.mCommitLock.releaseExclusive();
        if (this.mRedoWriter != null) {
            this.mRedoWriter.checkpointStarted();
        }
        if (this.mEventListener != null) {
            this.mEventListener.notify(EventType.CHECKPOINT_FLUSH, "Flushing all dirty nodes", new Object[0]);
        }
        try {
            this.mCheckpointer.flushDirty(this.mNodeGroups, stateToFlush);
            if (this.mRedoWriter != null) {
                this.mRedoWriter.checkpointFlushed();
            }
        }
        finally {
            this.mCheckpointFlushState = -1;
        }
        if (this.mEventListener != null) {
            this.mEventListener.notify(EventType.CHECKPOINT_SYNC, "Forcibly persisting all changes", new Object[0]);
        }
    }

    static long readRedoPosition(long header, int offset) {
        return DirectPageOps.p_longGetLE(header, offset + 44);
    }

    static {
        NM_LOCK = new _Node();
        try {
            cClosedHandle = MethodHandles.lookup().findVarHandle(_LocalDatabase.class, "mClosed", Integer.TYPE);
            cCommitHeaderHandle = MethodHandles.lookup().findVarHandle(_LocalDatabase.class, "mCommitHeader", Long.TYPE);
            cNodeMapElementHandle = MethodHandles.arrayElementVarHandle(_Node[].class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    static class RedoClose
    extends ShutdownHook.Weak<_LocalDatabase> {
        RedoClose(_LocalDatabase db) {
            super(db);
        }

        @Override
        void doShutdown(_LocalDatabase db) {
            db.redoClose((byte)3, null);
        }
    }

    static class ShutdownPrimer
    extends ShutdownHook.Weak<_LocalDatabase> {
        private final int mMode;

        ShutdownPrimer(_LocalDatabase db, int mode) {
            super(db);
            this.mMode = mode;
        }

        @Override
        void doShutdown(_LocalDatabase db) {
            if (db.mReadOnly) {
                return;
            }
            if ((this.mMode & 1) != 0) {
                File primer = db.primerFile();
                try {
                    FileOutputStream fout = new FileOutputStream(primer);
                    try (BufferedOutputStream bout = new BufferedOutputStream(fout);){
                        db.createCachePrimer(bout);
                    }
                    catch (IOException e) {
                        fout.close();
                        primer.delete();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((this.mMode & 2) != 0) {
                if (db.mEventListener != null) {
                    db.mEventListener.notify(EventType.SHUTDOWN_CLEAN, "Database is cleanly shutting down", new Object[0]);
                }
                try {
                    db.shutdown();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private class Deletion
    implements Runnable {
        private _BTree mTrashed;
        private final boolean mResumed;
        private final EventListener mListener;

        Deletion(_BTree trashed, boolean resumed, EventListener listener) {
            this.mTrashed = trashed;
            this.mResumed = resumed;
            this.mListener = listener;
        }

        @Override
        public synchronized void run() {
            while (this.mTrashed != null) {
                this.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delete() {
            if (this.mListener != null) {
                this.mListener.notify(EventType.DELETION_BEGIN, "Index deletion " + (this.mResumed ? "resumed" : "begin") + ": %1$d, name: %2$s", this.mTrashed.id(), this.mTrashed.nameString());
            }
            byte[] idBytes = this.mTrashed.mIdBytes;
            try {
                long start = System.nanoTime();
                if (!this.mTrashed.deleteAll()) {
                    return;
                }
                _Node root = this.mTrashed.close(true, false);
                _LocalDatabase.this.removeFromTrash(this.mTrashed, root);
                if (this.mListener != null) {
                    double duration = (double)(System.nanoTime() - start) / 1.0E9;
                    this.mListener.notify(EventType.DELETION_COMPLETE, "Index deletion complete: %1$d, name: %2$s, duration: %3$1.3f seconds", this.mTrashed.id(), this.mTrashed.nameString(), duration);
                }
            }
            catch (IOException e) {
                if (!_LocalDatabase.this.isClosed() && this.mListener != null) {
                    this.mListener.notify(EventType.DELETION_FAILED, "Index deletion failed: %1$d, name: %2$s, exception: %3$s", this.mTrashed.id(), this.mTrashed.nameString(), Utils.rootCause(e));
                }
                Utils.closeQuietly(this.mTrashed);
                return;
            }
            finally {
                this.mTrashed = null;
            }
            if (this.mResumed) {
                try {
                    this.mTrashed = _LocalDatabase.this.openNextTrashedTree(idBytes);
                }
                catch (IOException e) {
                    if (!_LocalDatabase.this.isClosed() && this.mListener != null) {
                        this.mListener.notify(EventType.DELETION_FAILED, "Unable to resume deletion: %1$s", Utils.rootCause(e));
                    }
                    return;
                }
                if (this.mTrashed == null) {
                    try {
                        _LocalDatabase.this.forceCheckpoint();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class FreeListScan
    implements Runnable,
    LongConsumer {
        private Object mFinished;

        private FreeListScan() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object finished;
            _LocalDatabase.this.mCheckpointLock.lock();
            try {
                _LocalDatabase.this.mPageDb.scanFreeList(this);
                finished = this;
            }
            catch (Throwable e) {
                finished = e;
            }
            finally {
                _LocalDatabase.this.mCheckpointLock.unlock();
            }
            FreeListScan freeListScan = this;
            synchronized (freeListScan) {
                this.mFinished = finished;
                this.notifyAll();
            }
        }

        @Override
        public void accept(long id) {
        }

        synchronized void waitFor() throws IOException {
            try {
                while (this.mFinished == null) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                return;
            }
            Object object = this.mFinished;
            if (object instanceof Throwable) {
                Throwable t = (Throwable)object;
                Utils.rethrow(t);
            }
        }
    }
}

