/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import org.cojen.tupl.DeadlockException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._DeadlockDetector;
import org.cojen.tupl.core._GhostFrame;
import org.cojen.tupl.core._LocalDatabase;
import org.cojen.tupl.core._LockManager;
import org.cojen.tupl.core._Locker;
import org.cojen.tupl.util.LatchCondition;

class _Lock {
    long mIndexId;
    byte[] mKey;
    int mHashCode;
    _Lock mLockNext;
    int mLockCount;
    _Locker mOwner;
    private Object mSharedLockersObj;
    LatchCondition mQueueU;
    LatchCondition mQueueSX;
    static final VarHandle cLockCountHandle;

    _Lock() {
    }

    final boolean isAvailable(_Locker locker) {
        return this.mLockCount >= 0 || this.mOwner == locker;
    }

    final LockResult check(_Locker locker) {
        int count = this.mLockCount;
        return this.mOwner == locker ? (count == -1 ? LockResult.OWNED_EXCLUSIVE : LockResult.OWNED_UPGRADABLE) : (count != 0 && this.isSharedLocker(locker) ? LockResult.OWNED_SHARED : LockResult.UNOWNED);
    }

    final boolean isPrepareLock() {
        return this.mIndexId == 4L;
    }

    final LockResult tryLockShared(_LockManager.Bucket bucket, _Locker locker, long nanosTimeout) {
        if (this.mOwner == locker) {
            return this.mLockCount == -1 ? LockResult.OWNED_EXCLUSIVE : LockResult.OWNED_UPGRADABLE;
        }
        LatchCondition queueSX = this.mQueueSX;
        if (queueSX != null) {
            if (this.isSharedLocker(locker)) {
                return LockResult.OWNED_SHARED;
            }
            locker.mWaitingFor = this;
            if (nanosTimeout >= 0L) {
                if (nanosTimeout == 0L) {
                    return LockResult.TIMED_OUT_LOCK;
                }
                if (this.quickDeadlockCheck(locker)) {
                    return LockResult.DEADLOCK;
                }
            }
        } else {
            int count = this.mLockCount;
            if (count == -1) {
                locker.mWaitingFor = this;
                if (nanosTimeout >= 0L) {
                    if (nanosTimeout == 0L) {
                        return LockResult.TIMED_OUT_LOCK;
                    }
                    if (this.quickDeadlockCheck(locker)) {
                        return LockResult.DEADLOCK;
                    }
                }
                try {
                    this.mQueueSX = queueSX = new LatchCondition();
                }
                catch (Throwable e) {
                    locker.mWaitingFor = null;
                    throw e;
                }
            } else {
                if (count != 0 && this.isSharedLocker(locker)) {
                    return LockResult.OWNED_SHARED;
                }
                this.addSharedLocker(count, locker);
                return LockResult.ACQUIRED;
            }
        }
        int result = queueSX.awaitTagged(bucket, nanosTimeout);
        queueSX = this.mQueueSX;
        if (queueSX != null) {
            if (queueSX.isEmpty()) {
                this.mQueueSX = null;
            }
            if (result > 0) {
                locker.mWaitingFor = null;
                queueSX.signalTagged(bucket);
                this.addSharedLocker(this.mLockCount, locker);
                return LockResult.ACQUIRED;
            }
            if (result == 0) {
                return LockResult.TIMED_OUT_LOCK;
            }
        }
        locker.mWaitingFor = null;
        return LockResult.INTERRUPTED;
    }

    final LockResult tryLockUpgradable(_LockManager.Bucket bucket, _Locker locker, long nanosTimeout) {
        LatchCondition queueU;
        if (this.mOwner == locker) {
            return this.mLockCount == -1 ? LockResult.OWNED_EXCLUSIVE : LockResult.OWNED_UPGRADABLE;
        }
        int count = this.mLockCount;
        if (count != 0 && this.isSharedLocker(locker)) {
            if (!locker.canAttemptUpgrade(count)) {
                return LockResult.ILLEGAL;
            }
            if (count > 0) {
                this.mLockCount = count - 1 | Integer.MIN_VALUE;
                this.mOwner = locker;
                return LockResult.OWNED_UPGRADABLE;
            }
        }
        if ((queueU = this.mQueueU) != null) {
            locker.mWaitingFor = this;
            if (nanosTimeout >= 0L) {
                if (nanosTimeout == 0L) {
                    return LockResult.TIMED_OUT_LOCK;
                }
                if (this.quickDeadlockCheck(locker)) {
                    return LockResult.DEADLOCK;
                }
            }
        } else {
            if (count >= 0) {
                this.mLockCount = count | Integer.MIN_VALUE;
                this.mOwner = locker;
                return LockResult.ACQUIRED;
            }
            locker.mWaitingFor = this;
            if (nanosTimeout >= 0L) {
                if (nanosTimeout == 0L) {
                    return LockResult.TIMED_OUT_LOCK;
                }
                if (this.quickDeadlockCheck(locker)) {
                    return LockResult.DEADLOCK;
                }
            }
            try {
                this.mQueueU = queueU = new LatchCondition();
            }
            catch (Throwable e) {
                locker.mWaitingFor = null;
                throw e;
            }
        }
        int result = queueU.await(bucket, nanosTimeout);
        queueU = this.mQueueU;
        if (queueU != null) {
            if (queueU.isEmpty()) {
                this.mQueueU = null;
            }
            if (result > 0) {
                locker.mWaitingFor = null;
                this.mLockCount |= Integer.MIN_VALUE;
                this.mOwner = locker;
                return LockResult.ACQUIRED;
            }
            if (result == 0) {
                return LockResult.TIMED_OUT_LOCK;
            }
        }
        locker.mWaitingFor = null;
        return LockResult.INTERRUPTED;
    }

    /*
     * Unable to fully structure code
     */
    final LockResult tryLockExclusive(_LockManager.Bucket bucket, _Locker locker, long nanosTimeout) {
        block17: {
            block16: {
                ur = this.tryLockUpgradable(bucket, locker, nanosTimeout);
                if (!ur.isHeld() || ur == LockResult.OWNED_EXCLUSIVE) {
                    return ur;
                }
                queueSX = this.mQueueSX;
                if (queueSX == null) {
                    lockCount = this.mLockCount;
                    if (lockCount == -2147483648) {
                        this.mLockCount = -1;
                        return ur == LockResult.OWNED_UPGRADABLE ? LockResult.UPGRADED : LockResult.ACQUIRED;
                    }
                    if (nanosTimeout != 0L) {
                        locker.mWaitingFor = this;
                        if (nanosTimeout > 0L && lockCount == -2147483647 && this.quickDeadlockCheckExclusive()) {
                            return LockResult.DEADLOCK;
                        }
                        try {
                            this.mQueueSX = queueSX = new LatchCondition();
                        }
                        catch (Throwable e) {
                            locker.mWaitingFor = null;
                            throw e;
                        }
                    }
                } else if (nanosTimeout != 0L) {
                    locker.mWaitingFor = this;
                    if (nanosTimeout > 0L && this.mLockCount == -2147483647 && this.quickDeadlockCheckExclusive()) {
                        return LockResult.DEADLOCK;
                    } else {
                        ** GOTO lbl26
                    }
                }
                break block16;
lbl26:
                // 2 sources

                break block17;
            }
            if (ur == LockResult.ACQUIRED) {
                this.unlockUpgradable(bucket);
            }
            locker.mWaitingFor = this;
            return LockResult.TIMED_OUT_LOCK;
        }
        result = queueSX.await(bucket, nanosTimeout);
        queueSX = this.mQueueSX;
        if (queueSX != null) {
            if (queueSX.isEmpty()) {
                this.mQueueSX = null;
            }
            if (result > 0) {
                locker.mWaitingFor = null;
                this.mLockCount = -1;
                return ur == LockResult.OWNED_UPGRADABLE ? LockResult.UPGRADED : LockResult.ACQUIRED;
            }
            if (ur == LockResult.ACQUIRED) {
                this.unlockUpgradable(bucket);
            }
            if (result == 0) {
                return LockResult.TIMED_OUT_LOCK;
            }
        }
        locker.mWaitingFor = null;
        return LockResult.INTERRUPTED;
    }

    private boolean quickDeadlockCheck(_Locker locker) {
        _Lock waitingFor;
        return this.mOwner != null && (waitingFor = this.mOwner.mWaitingFor) != null && waitingFor.mOwner == locker;
    }

    private boolean quickDeadlockCheckExclusive() {
        _Locker locker;
        block3: {
            Object sharedObj = this.mSharedLockersObj;
            if (sharedObj instanceof _Locker) {
                locker = (_Locker)sharedObj;
            } else {
                for (LockerHTEntry e : (LockerHTEntry[])sharedObj) {
                    if (e == null) continue;
                    locker = e.mOwner;
                    break block3;
                }
                return false;
            }
        }
        _Lock waitingFor = locker.mWaitingFor;
        return waitingFor != null && waitingFor.isSharedLocker(this.mOwner);
    }

    private void unlockUpgradable(_LockManager.Bucket bucket) {
        this.mOwner = null;
        LatchCondition queueU = this.mQueueU;
        if (queueU != null) {
            queueU.signal(bucket);
        }
        this.mLockCount &= Integer.MAX_VALUE;
    }

    final void unlock(_Locker locker, _LockManager.Bucket bucket) {
        if (this.mOwner == locker) {
            this.doUnlockOwned(bucket);
        } else {
            this.doUnlockShared(locker, bucket);
        }
    }

    final void doUnlock(_Locker locker, _LockManager.Bucket bucket) {
        if (this.mOwner == locker) {
            this.doUnlockOwnedUnrestricted(bucket);
        } else {
            this.doUnlockShared(locker, bucket);
        }
    }

    private void doUnlockOwned(_LockManager.Bucket bucket) {
        int count = this.mLockCount;
        if (count != -1) {
            this.mOwner = null;
            LatchCondition queueU = this.mQueueU;
            this.mLockCount = count & Integer.MAX_VALUE;
            if (this.mLockCount == 0 && queueU == null && this.mQueueSX == null) {
                bucket.remove(this);
            } else if (queueU != null) {
                queueU.signal(bucket);
            }
        } else {
            throw this.unlockFail();
        }
        bucket.releaseExclusive();
    }

    /*
     * Unable to fully structure code
     */
    protected void doUnlockOwnedUnrestricted(_LockManager.Bucket bucket) {
        block6: {
            block7: {
                block5: {
                    count = this.mLockCount;
                    if (count == -1) break block5;
                    this.mOwner = null;
                    queueU = this.mQueueU;
                    this.mLockCount = count & 0x7FFFFFFF;
                    if (this.mLockCount == 0 && queueU == null && this.mQueueSX == null) {
                        bucket.remove(this);
                    } else if (queueU != null) {
                        queueU.signal(bucket);
                    }
                    break block6;
                }
                this.deleteGhost(bucket);
                this.mOwner = null;
                this.mLockCount = 0;
                queueU = this.mQueueU;
                queueSX = this.mQueueSX;
                if (queueU == null) break block7;
                queueU.signal(bucket);
                if (queueSX != null) ** GOTO lbl-1000
                break block6;
            }
            if (queueSX == null) {
                bucket.remove(this);
            } else lbl-1000:
            // 2 sources

            {
                queueSX.signal(bucket);
            }
        }
        bucket.releaseExclusive();
    }

    private void doUnlockShared(_Locker locker, _LockManager.Bucket bucket) {
        block9: {
            int count;
            block8: {
                block6: {
                    LockerHTEntry[] entries;
                    Object sharedObj;
                    block7: {
                        count = this.mLockCount;
                        if ((count & Integer.MAX_VALUE) == 0) break block6;
                        sharedObj = this.mSharedLockersObj;
                        if (sharedObj != locker) break block7;
                        this.mSharedLockersObj = null;
                        break block8;
                    }
                    if (!(sharedObj instanceof LockerHTEntry[]) || !_Lock.lockerHTremove(entries = (LockerHTEntry[])sharedObj, locker)) break block6;
                    if ((count & Integer.MAX_VALUE) == 1) {
                        this.mSharedLockersObj = null;
                    }
                    break block8;
                }
                if (!_Lock.isClosed(locker)) {
                    throw new IllegalStateException("Lock not held");
                }
                break block9;
            }
            this.mLockCount = --count;
            LatchCondition queueSX = this.mQueueSX;
            if (count == Integer.MIN_VALUE) {
                if (queueSX != null) {
                    queueSX.signal(bucket);
                }
            } else if (count == 0 && queueSX == null && this.mQueueU == null) {
                bucket.remove(this);
            }
        }
        bucket.releaseExclusive();
    }

    final void unlockToShared(_Locker locker, _LockManager.Bucket bucket) {
        if (this.mOwner == locker) {
            int count = this.mLockCount;
            if (count == -1) {
                throw this.unlockFail();
            }
            this.addSharedLocker(count & Integer.MAX_VALUE, locker);
            this.mOwner = null;
            LatchCondition queueU = this.mQueueU;
            if (queueU != null) {
                queueU.signal(bucket);
            }
        } else if (!(this.mLockCount != 0 && this.isSharedLocker(locker) || _Lock.isClosed(locker))) {
            throw new IllegalStateException("Lock not held");
        }
        bucket.releaseExclusive();
    }

    /*
     * Unable to fully structure code
     */
    final void doUnlockToShared(_Locker locker, _LockManager.Bucket bucket) {
        block7: {
            block5: {
                block6: {
                    if (this.mOwner != locker) break block5;
                    count = this.mLockCount;
                    if (count == -1) break block6;
                    this.addSharedLocker(count & 0x7FFFFFFF, locker);
                    this.mOwner = null;
                    queueU = this.mQueueU;
                    ** GOTO lbl-1000
                }
                this.deleteGhost(bucket);
                this.doAddSharedLocker(1, locker);
                this.mOwner = null;
                queueU = this.mQueueU;
                queueSX = this.mQueueSX;
                if (queueSX != null) {
                    if (queueU != null) {
                        queueU.signal(bucket);
                    }
                    queueSX.signal(bucket);
                } else if (queueU != null) {
                    queueU.signal(bucket);
                }
                break block7;
            }
            if (!(this.mLockCount != 0 && this.isSharedLocker(locker) || _Lock.isClosed(locker))) {
                throw new IllegalStateException("Lock not held");
            }
        }
        bucket.releaseExclusive();
    }

    final void doUnlockToUpgradable(_Locker locker, _LockManager.Bucket bucket) {
        if (this.mOwner != locker) {
            if (_Lock.isClosed(locker)) {
                bucket.releaseExclusive();
                return;
            }
            String message = "Exclusive or upgradable lock not held";
            if (this.mLockCount == 0 || !this.isSharedLocker(locker)) {
                message = "Lock not held";
            }
            throw new IllegalStateException(message);
        }
        if (this.mLockCount == -1) {
            this.deleteGhost(bucket);
            this.mLockCount = Integer.MIN_VALUE;
            LatchCondition queueSX = this.mQueueSX;
            if (queueSX != null) {
                queueSX.signalTagged(bucket);
            }
        }
        bucket.releaseExclusive();
    }

    private IllegalStateException unlockFail() {
        String message = this.isPrepareLock() ? "No locks held" : "Cannot unlock an exclusive lock";
        return new IllegalStateException(message);
    }

    private static boolean isClosed(_Locker locker) {
        _LocalDatabase db = locker.getDatabase();
        return db != null && db.isClosed();
    }

    private void deleteGhost(_LockManager.Bucket bucket) {
        Object obj = this.mSharedLockersObj;
        if (obj instanceof _GhostFrame) {
            _GhostFrame gf = (_GhostFrame)obj;
            this.mSharedLockersObj = null;
            gf.action(this.mOwner.getDatabase(), bucket, this);
        }
    }

    final boolean matches(long indexId, byte[] key, int hash) {
        return this.mHashCode == hash && this.mIndexId == indexId && Arrays.equals(this.mKey, key);
    }

    final void setGhostFrame(_GhostFrame frame) {
        this.mSharedLockersObj = frame;
    }

    final void setSharedLocker(_Locker owner) {
        this.mSharedLockersObj = owner;
    }

    final Object getSharedLocker() {
        return this.mSharedLockersObj;
    }

    final void detectDeadlock(_Locker locker, int lockType, long nanosTimeout) throws DeadlockException {
        _DeadlockDetector detector = new _DeadlockDetector(locker, true);
        if (detector.scan()) {
            Object att = this.findOwnerAttachment(locker, false, lockType);
            throw new DeadlockException(nanosTimeout, att, detector.mGuilty, detector.newDeadlockSet(lockType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object findOwnerAttachment(_Locker locker, boolean latched, int lockType) {
        Object att;
        _Locker owner = this.mOwner;
        if (owner != null && owner != locker && (att = owner.attachment()) != null) {
            return att;
        }
        if (lockType != -1) {
            return null;
        }
        Object sharedObj = this.mSharedLockersObj;
        if (sharedObj == null) {
            return null;
        }
        if (sharedObj instanceof _Locker) {
            _Locker held = (_Locker)sharedObj;
            return held.attachment();
        }
        if (sharedObj instanceof LockerHTEntry[]) {
            LockerHTEntry[] entries = (LockerHTEntry[])sharedObj;
            if (!latched) {
                _LockManager manager = locker.mManager;
                if (manager != null) {
                    _LockManager.Bucket bucket = manager.getBucket(this.mHashCode);
                    bucket.acquireShared();
                    try {
                        Object object = this.findOwnerAttachment(locker, true, lockType);
                        return object;
                    }
                    finally {
                        bucket.releaseShared();
                    }
                }
            } else {
                int i = entries.length;
                while (--i >= 0) {
                    LockerHTEntry e = entries[i];
                    while (e != null) {
                        Object att2;
                        owner = e.mOwner;
                        if (owner != null && (att2 = owner.attachment()) != null) {
                            return att2;
                        }
                        e = e.mNext;
                    }
                }
            }
        }
        return null;
    }

    final boolean isSharedLocker(_Locker locker) {
        Object sharedObj = this.mSharedLockersObj;
        if (sharedObj == locker) {
            return true;
        }
        if (sharedObj instanceof LockerHTEntry[]) {
            LockerHTEntry[] entries = (LockerHTEntry[])sharedObj;
            return _Lock.lockerHTcontains(entries, locker);
        }
        return false;
    }

    final int claimOwnership(_Locker locker) {
        Object sharedObj = this.mSharedLockersObj;
        if (sharedObj == locker) {
            return 1;
        }
        int count = this.mLockCount;
        if ((count & Integer.MAX_VALUE) == 0) {
            return 2;
        }
        if (sharedObj instanceof LockerHTEntry[]) {
            LockerHTEntry[] entries = (LockerHTEntry[])sharedObj;
            if ((count & Integer.MAX_VALUE) == 1) {
                if (_Lock.lockerHTcontains(entries, locker)) {
                    return 1;
                }
            } else if ((count & Integer.MAX_VALUE) > 1 && _Lock.lockerHTremove(entries, locker)) {
                this.mLockCount = count - 1;
                this.mOwner = locker;
                return 0;
            }
        }
        return -1;
    }

    final Object copyLockers() {
        _Locker[] lockers;
        int count = this.mLockCount;
        if (count == -1 || (count &= Integer.MAX_VALUE) == 0) {
            return this.mOwner;
        }
        Object object = this.mSharedLockersObj;
        if (!(object instanceof LockerHTEntry[])) {
            _Locker[] _LockerArray;
            if (this.mOwner == null) {
                _LockerArray = this.mSharedLockersObj;
            } else {
                _Locker[] _LockerArray2 = new _Locker[2];
                _LockerArray2[0] = (_Locker)this.mSharedLockersObj;
                _LockerArray = _LockerArray2;
                _LockerArray2[1] = this.mOwner;
            }
            return _LockerArray;
        }
        LockerHTEntry[] entries = (LockerHTEntry[])object;
        if (this.mOwner == null) {
            lockers = new _Locker[count];
        } else {
            lockers = new _Locker[count + 1];
            lockers[lockers.length - 1] = this.mOwner;
        }
        int i = 0;
        for (LockerHTEntry e : entries) {
            while (e != null) {
                lockers[i++] = e.mOwner;
                e = e.mNext;
            }
        }
        return lockers;
    }

    final void addSharedLocker(int count, _Locker locker) {
        if ((count & Integer.MAX_VALUE) >= 0x7FFFFFFE) {
            throw new IllegalStateException("Too many shared locks held");
        }
        this.doAddSharedLocker(count + 1, locker);
    }

    private void doAddSharedLocker(int newCount, _Locker locker) {
        Object sharedObj = this.mSharedLockersObj;
        if (sharedObj == null) {
            this.mSharedLockersObj = locker;
        } else if (sharedObj instanceof LockerHTEntry[]) {
            LockerHTEntry[] entries = (LockerHTEntry[])sharedObj;
            this.lockerHTadd(entries, newCount & Integer.MAX_VALUE, locker);
        } else {
            LockerHTEntry[] entries = new LockerHTEntry[4];
            _Lock.lockerHTadd(entries, (_Locker)sharedObj);
            _Lock.lockerHTadd(entries, locker);
            this.mSharedLockersObj = entries;
        }
        this.mLockCount = newCount;
    }

    private static boolean lockerHTcontains(LockerHTEntry[] entries, _Locker locker) {
        int hash = locker.hashCode();
        LockerHTEntry e = entries[hash & entries.length - 1];
        while (e != null) {
            if (e.mOwner == locker) {
                return true;
            }
            e = e.mNext;
        }
        return false;
    }

    private void lockerHTadd(LockerHTEntry[] entries, int newSize, _Locker locker) {
        if (newSize > entries.length >> 1) {
            int capacity = entries.length << 1;
            LockerHTEntry[] newEntries = new LockerHTEntry[capacity];
            int newMask = capacity - 1;
            int i = entries.length;
            while (--i >= 0) {
                LockerHTEntry e = entries[i];
                while (e != null) {
                    LockerHTEntry next = e.mNext;
                    int ix = e.mOwner.hashCode() & newMask;
                    e.mNext = newEntries[ix];
                    newEntries[ix] = e;
                    e = next;
                }
            }
            entries = newEntries;
            this.mSharedLockersObj = newEntries;
        }
        _Lock.lockerHTadd(entries, locker);
    }

    private static void lockerHTadd(LockerHTEntry[] entries, _Locker locker) {
        int index = locker.hashCode() & entries.length - 1;
        LockerHTEntry e = new LockerHTEntry();
        e.mOwner = locker;
        e.mNext = entries[index];
        entries[index] = e;
    }

    private static boolean lockerHTremove(LockerHTEntry[] entries, _Locker locker) {
        int index = locker.hashCode() & entries.length - 1;
        LockerHTEntry e = entries[index];
        LockerHTEntry prev = null;
        while (e != null) {
            if (e.mOwner == locker) {
                if (prev == null) {
                    entries[index] = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                }
                return true;
            }
            prev = e;
            e = e.mNext;
        }
        return false;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cLockCountHandle = lookup.findVarHandle(_Lock.class, "mLockCount", Integer.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    static final class LockerHTEntry {
        _Locker mOwner;
        LockerHTEntry mNext;

        LockerHTEntry() {
        }
    }
}

