/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.lang.invoke.VarHandle;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.LockUpgradeRule;
import org.cojen.tupl.core.Hasher;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._DetachedLockImpl;
import org.cojen.tupl.core._GhostFrame;
import org.cojen.tupl.core._LocalDatabase;
import org.cojen.tupl.core._LocalTransaction;
import org.cojen.tupl.core._Lock;
import org.cojen.tupl.core._Locker;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.LatchCondition;

public final class _LockManager {
    public static final int TYPE_SHARED = 1;
    public static final int TYPE_UPGRADABLE = Integer.MIN_VALUE;
    public static final int TYPE_EXCLUSIVE = -1;
    final WeakReference<_LocalDatabase> mDatabaseRef;
    final LockUpgradeRule mDefaultLockUpgradeRule;
    final long mDefaultTimeoutNanos;
    private final Bucket[] mBuckets;
    private final int mBucketShift;
    private final ThreadLocal<SoftReference<_Locker>> mLocalLockerRef;

    _LockManager(_LocalDatabase db, LockUpgradeRule lockUpgradeRule, long timeoutNanos) {
        this(db, lockUpgradeRule, timeoutNanos, Runtime.getRuntime().availableProcessors() * 16);
    }

    private _LockManager(_LocalDatabase db, LockUpgradeRule lockUpgradeRule, long timeoutNanos, int numBuckets) {
        WeakReference<_LocalDatabase> weakReference = this.mDatabaseRef = db == null ? null : new WeakReference<_LocalDatabase>(db);
        if (lockUpgradeRule == null) {
            lockUpgradeRule = LockUpgradeRule.STRICT;
        }
        this.mDefaultLockUpgradeRule = lockUpgradeRule;
        this.mDefaultTimeoutNanos = timeoutNanos;
        numBuckets = Utils.roundUpPower2(Math.max(2, numBuckets));
        this.mBuckets = new Bucket[numBuckets];
        for (int i = 0; i < numBuckets; ++i) {
            this.mBuckets[i] = new Bucket();
        }
        this.mBucketShift = Integer.numberOfLeadingZeros(numBuckets - 1);
        this.mLocalLockerRef = new ThreadLocal();
    }

    final Index indexById(long id) {
        _LocalDatabase db;
        if (this.mDatabaseRef != null && (db = (_LocalDatabase)this.mDatabaseRef.get()) != null) {
            try {
                return db.indexById(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public long numLocksHeld() {
        long count = 0L;
        for (Bucket bucket : this.mBuckets) {
            count += (long)bucket.size();
        }
        return count;
    }

    final boolean isAvailable(_Locker locker, long indexId, byte[] key, int hash) {
        return this.getBucket(hash).isAvailable(locker, indexId, key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LockResult check(_Locker locker, long indexId, byte[] key, int hash) {
        Bucket bucket = this.getBucket(hash);
        bucket.acquireShared();
        try {
            _Lock lock = bucket.lockFor(indexId, key, hash);
            LockResult lockResult = lock == null ? LockResult.UNOWNED : lock.check(locker);
            return lockResult;
        }
        finally {
            bucket.releaseShared();
        }
    }

    final void unlock(_Locker locker, _Lock lock) {
        Bucket bucket = this.getBucket(lock.mHashCode);
        bucket.acquireExclusive();
        try {
            lock.unlock(locker, bucket);
        }
        catch (Throwable e) {
            bucket.releaseExclusive();
            throw e;
        }
    }

    final void doUnlock(_Locker locker, _Lock lock) {
        Bucket bucket = this.getBucket(lock.mHashCode);
        bucket.acquireExclusive();
        try {
            lock.doUnlock(locker, bucket);
        }
        catch (Throwable e) {
            bucket.releaseExclusive();
            throw e;
        }
    }

    final void unlockToShared(_Locker locker, _Lock lock) {
        Bucket bucket = this.getBucket(lock.mHashCode);
        bucket.acquireExclusive();
        try {
            lock.unlockToShared(locker, bucket);
        }
        catch (Throwable e) {
            bucket.releaseExclusive();
            throw e;
        }
    }

    final void doUnlockToShared(_Locker locker, _Lock lock) {
        Bucket bucket = this.getBucket(lock.mHashCode);
        bucket.acquireExclusive();
        try {
            lock.doUnlockToShared(locker, bucket);
        }
        catch (Throwable e) {
            bucket.releaseExclusive();
            throw e;
        }
    }

    final void doUnlockToUpgradable(_Locker locker, _Lock lock) {
        Bucket bucket = this.getBucket(lock.mHashCode);
        bucket.acquireExclusive();
        try {
            lock.doUnlockToUpgradable(locker, bucket);
        }
        catch (Throwable e) {
            bucket.releaseExclusive();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void takeLockOwnership(_Lock lock, _Locker locker) {
        Bucket bucket = this.getBucket(lock.mHashCode);
        bucket.acquireExclusive();
        try {
            if (lock.mLockCount < 0) {
                lock.mOwner = locker;
            }
        }
        finally {
            bucket.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ghosted(long indexId, byte[] key, int hash, _GhostFrame frame) {
        Bucket bucket = this.getBucket(hash);
        bucket.acquireExclusive();
        try {
            bucket.lockFor(indexId, key, hash).setGhostFrame(frame);
        }
        finally {
            bucket.releaseExclusive();
        }
    }

    final _Locker lockSharedLocal(long indexId, byte[] key, int hash) throws LockFailureException {
        _Locker locker = this.localLocker();
        LockResult result = this.getBucket(hash).tryLock(1, locker, indexId, key, hash, this.mDefaultTimeoutNanos);
        if (result.isHeld()) {
            return locker;
        }
        throw locker.failed(1, result, this.mDefaultTimeoutNanos);
    }

    final _Locker lockExclusiveLocal(long indexId, byte[] key, int hash) throws LockFailureException {
        return this.lockExclusiveLocal(indexId, key, hash, this.mDefaultTimeoutNanos);
    }

    final _Locker lockExclusiveLocal(long indexId, byte[] key, int hash, long timeoutNanos) throws LockFailureException {
        _Locker locker = this.localLocker();
        LockResult result = this.getBucket(hash).tryLock(-1, locker, indexId, key, hash, timeoutNanos);
        if (result.isHeld()) {
            return locker;
        }
        throw locker.failed(-1, result, timeoutNanos);
    }

    final _Locker localLocker() {
        _Locker locker;
        SoftReference<_Locker> lockerRef = this.mLocalLockerRef.get();
        if (lockerRef == null || (locker = lockerRef.get()) == null) {
            locker = new _Locker(this);
            this.mLocalLockerRef.set(new SoftReference<_Locker>(locker));
        }
        return locker;
    }

    final _DetachedLockImpl newDetachedLock(_LocalTransaction owner) {
        _DetachedLockImpl lock = new _DetachedLockImpl();
        this.initDetachedLock(lock, owner);
        return lock;
    }

    final void initDetachedLock(_DetachedLockImpl lock, _LocalTransaction owner) {
        int hash = ThreadLocalRandom.current().nextInt();
        lock.init(hash, owner, this.getBucket(hash));
    }

    final void close() {
        _Locker locker = new _Locker(null);
        for (Bucket bucket : this.mBuckets) {
            bucket.close(locker);
        }
        if (this.mDatabaseRef != null) {
            this.mDatabaseRef.clear();
        }
    }

    static final int hash(long indexId, byte[] key) {
        return (int)Hasher.hash(indexId, key);
    }

    Bucket getBucket(int hash) {
        return this.mBuckets[hash >>> this.mBucketShift];
    }

    static final class Bucket
    extends Latch {
        private static final float LOAD_FACTOR = 0.75f;
        private _Lock[] mEntries = new _Lock[16];
        private int mSize;
        private int mGrowThreshold = (int)((float)this.mEntries.length * 0.75f);
        private volatile int mStamp;
        private long a0;
        private long a1;
        private long a2;

        Bucket() {
        }

        int size() {
            this.acquireShared();
            int size = this.mSize;
            this.releaseShared();
            return size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAvailable(_Locker locker, long indexId, byte[] key, int hash) {
            _Lock lock;
            int stamp = this.mStamp;
            if (stamp >= 0) {
                _Lock[] entries = this.mEntries;
                int index = hash & entries.length - 1;
                _Lock e = entries[index];
                while (e != null) {
                    VarHandle.loadLoadFence();
                    if (e.matches(indexId, key, hash)) {
                        return e.isAvailable(locker);
                    }
                    e = e.mLockNext;
                }
                if (stamp == this.mStamp) {
                    return true;
                }
            }
            this.acquireShared();
            try {
                lock = this.lockFor(indexId, key, hash);
            }
            finally {
                this.releaseShared();
            }
            return lock == null || lock.isAvailable(locker);
        }

        _Lock lockFor(long indexId, byte[] key, int hash) {
            _Lock[] entries = this.mEntries;
            int index = hash & entries.length - 1;
            _Lock e = entries[index];
            while (e != null) {
                if (e.matches(indexId, key, hash)) {
                    return e;
                }
                e = e.mLockNext;
            }
            return null;
        }

        _Lock lockAccess(long indexId, byte[] key, int hash) {
            _Lock[] entries = this.mEntries;
            int index = hash & entries.length - 1;
            _Lock lock = entries[index];
            while (lock != null) {
                if (lock.matches(indexId, key, hash)) {
                    return lock;
                }
                lock = lock.mLockNext;
            }
            if (this.mSize >= this.mGrowThreshold) {
                entries = this.rehash(entries);
                index = hash & entries.length - 1;
            }
            lock = new _Lock();
            lock.mIndexId = indexId;
            lock.mKey = key;
            lock.mHashCode = hash;
            lock.mLockNext = entries[index];
            VarHandle.storeStoreFence();
            entries[index] = lock;
            ++this.mSize;
            return lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LockResult tryLock(int type, _Locker locker, long indexId, byte[] key, int hash, long nanosTimeout) {
            LockResult result;
            _Lock lock;
            block18: {
                LockResult result2;
                block17: {
                    this.acquireExclusive();
                    try {
                        _Lock[] entries = this.mEntries;
                        int index = hash & entries.length - 1;
                        lock = entries[index];
                        while (lock != null) {
                            if (lock.matches(indexId, key, hash)) {
                                if (type == 1) {
                                    result2 = lock.tryLockShared(this, locker, nanosTimeout);
                                    break block17;
                                }
                                if (type == Integer.MIN_VALUE) {
                                    result2 = lock.tryLockUpgradable(this, locker, nanosTimeout);
                                    break block17;
                                }
                                result = lock.tryLockExclusive(this, locker, nanosTimeout);
                                break block18;
                            }
                            lock = lock.mLockNext;
                        }
                        if (this.mSize >= this.mGrowThreshold) {
                            entries = this.rehash(entries);
                            index = hash & entries.length - 1;
                        }
                        lock = new _Lock();
                        lock.mIndexId = indexId;
                        lock.mKey = key;
                        lock.mHashCode = hash;
                        lock.mLockNext = entries[index];
                        lock.mLockCount = type;
                        if (type == 1) {
                            lock.setSharedLocker(locker);
                        } else {
                            lock.mOwner = locker;
                        }
                        VarHandle.storeStoreFence();
                        entries[index] = lock;
                        ++this.mSize;
                    }
                    finally {
                        this.releaseExclusive();
                    }
                    locker.push(lock);
                    return LockResult.ACQUIRED;
                }
                if (result2 == LockResult.ACQUIRED) {
                    locker.push(lock);
                }
                return result2;
            }
            if (result == LockResult.ACQUIRED) {
                locker.push(lock);
            } else if (result == LockResult.UPGRADED) {
                locker.pushUpgrade(lock);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recoverLock(_Locker locker, _Lock lock) {
            int hash = lock.mHashCode;
            this.acquireExclusive();
            try {
                _Lock[] entries = this.mEntries;
                int index = hash & entries.length - 1;
                _Lock e = entries[index];
                while (e != null) {
                    if (e.matches(lock.mIndexId, lock.mKey, hash)) {
                        Object ghost;
                        if (lock.mLockCount == -1) {
                            e.mLockCount = -1;
                        }
                        if ((ghost = lock.getSharedLocker()) instanceof _GhostFrame) {
                            _GhostFrame gf = (_GhostFrame)ghost;
                            e.setGhostFrame(gf);
                        }
                        return;
                    }
                    e = e.mLockNext;
                }
                if (this.mSize >= this.mGrowThreshold) {
                    entries = this.rehash(entries);
                    index = hash & entries.length - 1;
                }
                lock.mLockNext = entries[index];
                lock.mOwner = locker;
                VarHandle.storeStoreFence();
                entries[index] = lock;
                ++this.mSize;
            }
            finally {
                this.releaseExclusive();
            }
            locker.push(lock);
        }

        void remove(_Lock lock) {
            _Lock[] entries = this.mEntries;
            int index = lock.mHashCode & entries.length - 1;
            _Lock e = entries[index];
            if (e == lock) {
                entries[index] = e.mLockNext;
            } else {
                while (true) {
                    _Lock next;
                    if ((next = e.mLockNext) == lock) {
                        e.mLockNext = next.mLockNext;
                        break;
                    }
                    e = next;
                }
            }
            --this.mSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(_Locker locker) {
            this.acquireExclusive();
            try {
                if (this.mSize > 0) {
                    this.mStamp |= Integer.MIN_VALUE;
                    _Lock[] entries = this.mEntries;
                    int i = entries.length;
                    while (--i >= 0) {
                        _Lock e = entries[i];
                        _Lock prev = null;
                        while (e != null) {
                            _Lock next = e.mLockNext;
                            if (e.mLockCount == -1) {
                                e.mOwner = locker;
                                prev = e;
                            } else {
                                e.mLockCount = 0;
                                e.mOwner = null;
                                if (prev == null) {
                                    entries[i] = next;
                                } else {
                                    prev.mLockNext = next;
                                }
                                e.mLockNext = null;
                                --this.mSize;
                            }
                            e.setSharedLocker(null);
                            LatchCondition q = e.mQueueU;
                            if (q != null) {
                                q.clear();
                                e.mQueueU = null;
                            }
                            if ((q = e.mQueueSX) != null) {
                                q.clear();
                                e.mQueueSX = null;
                            }
                            e = next;
                        }
                    }
                    this.mStamp = this.mStamp + 1 & Integer.MAX_VALUE;
                }
            }
            finally {
                this.releaseExclusive();
            }
        }

        private _Lock[] rehash(_Lock[] entries) {
            int capacity = entries.length << 1;
            _Lock[] newEntries = new _Lock[capacity];
            int newMask = capacity - 1;
            this.mStamp |= Integer.MIN_VALUE;
            int i = entries.length;
            while (--i >= 0) {
                _Lock e = entries[i];
                while (e != null) {
                    _Lock next = e.mLockNext;
                    int ix = e.mHashCode & newMask;
                    e.mLockNext = newEntries[ix];
                    newEntries[ix] = e;
                    e = next;
                }
            }
            entries = newEntries;
            this.mEntries = newEntries;
            this.mStamp = this.mStamp + 1 & Integer.MAX_VALUE;
            this.mGrowThreshold = (int)((float)capacity * 0.75f);
            return entries;
        }
    }
}

