/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.tupl.DeadlockException;
import org.cojen.tupl.IllegalUpgradeException;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockInterruptedException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.LockTimeoutException;
import org.cojen.tupl.LockUpgradeRule;
import org.cojen.tupl.core.RowPredicate;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._DatabaseAccess;
import org.cojen.tupl.core._LocalDatabase;
import org.cojen.tupl.core._Lock;
import org.cojen.tupl.core._LockManager;

class _Locker
implements _DatabaseAccess {
    final _LockManager mManager;
    final int mHash;
    _Lock mWaitingFor;
    ParentScope mParentScope;
    private Object mTailBlock;
    private static final VarHandle cTailBlockHandle;

    _Locker(_LockManager manager) {
        this(manager, ThreadLocalRandom.current().nextInt());
    }

    _Locker(_LockManager manager, int hash) {
        this.mManager = manager;
        this.mHash = hash;
    }

    public final int hashCode() {
        return this.mHash;
    }

    private _LockManager manager() {
        _LockManager manager = this.mManager;
        if (manager == null) {
            throw new IllegalStateException("Transaction is bogus");
        }
        return manager;
    }

    @Override
    public _LocalDatabase getDatabase() {
        WeakReference<_LocalDatabase> ref;
        _LockManager manager = this.mManager;
        if (manager != null && (ref = manager.mDatabaseRef) != null) {
            return (_LocalDatabase)ref.get();
        }
        return null;
    }

    public void attach(Object obj) {
        throw new UnsupportedOperationException();
    }

    public Object attachment() {
        return null;
    }

    public final boolean isNested() {
        return this.mParentScope != null;
    }

    public final int nestingLevel() {
        int count = 0;
        ParentScope parent = this.mParentScope;
        while (parent != null) {
            ++count;
            parent = parent.mParentScope;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LockResult doTryLock(int lockType, long indexId, byte[] key, int hash, long nanosTimeout) throws DeadlockException {
        LockResult result = this.manager().getBucket(hash).tryLock(lockType, this, indexId, key, hash, nanosTimeout);
        if (!result.isHeld()) {
            try {
                _Lock waitingFor;
                if (nanosTimeout != 0L && (waitingFor = this.mWaitingFor) != null) {
                    waitingFor.detectDeadlock(this, lockType, nanosTimeout);
                }
            }
            finally {
                this.mWaitingFor = null;
            }
        }
        return result;
    }

    final LockResult doLock(int lockType, long indexId, byte[] key, int hash, long nanosTimeout) throws LockFailureException {
        LockResult result = this.manager().getBucket(hash).tryLock(lockType, this, indexId, key, hash, nanosTimeout);
        if (result.isHeld()) {
            return result;
        }
        throw this.failed(lockType, result, nanosTimeout);
    }

    final LockResult doTryLockShared(long indexId, byte[] key, long nanosTimeout) throws DeadlockException {
        return this.doTryLock(1, indexId, key, _LockManager.hash(indexId, key), nanosTimeout);
    }

    final LockResult doTryLockShared(long indexId, byte[] key, int hash, long nanosTimeout) throws DeadlockException {
        return this.doTryLock(1, indexId, key, hash, nanosTimeout);
    }

    final LockResult doLockShared(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.doLock(1, indexId, key, _LockManager.hash(indexId, key), nanosTimeout);
    }

    final LockResult doLockShared(long indexId, byte[] key, int hash, long nanosTimeout) throws LockFailureException {
        return this.doLock(1, indexId, key, hash, nanosTimeout);
    }

    final LockResult doTryLockUpgradable(long indexId, byte[] key, long nanosTimeout) throws DeadlockException {
        return this.doTryLock(Integer.MIN_VALUE, indexId, key, _LockManager.hash(indexId, key), nanosTimeout);
    }

    final LockResult doTryLockUpgradable(long indexId, byte[] key, int hash, long nanosTimeout) throws DeadlockException {
        return this.doTryLock(Integer.MIN_VALUE, indexId, key, hash, nanosTimeout);
    }

    final LockResult doLockUpgradable(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.doLock(Integer.MIN_VALUE, indexId, key, _LockManager.hash(indexId, key), nanosTimeout);
    }

    final LockResult doLockUpgradable(long indexId, byte[] key, int hash, long nanosTimeout) throws LockFailureException {
        return this.doLock(Integer.MIN_VALUE, indexId, key, hash, nanosTimeout);
    }

    final LockResult doTryLockExclusive(long indexId, byte[] key, long nanosTimeout) throws DeadlockException {
        return this.doTryLock(-1, indexId, key, _LockManager.hash(indexId, key), nanosTimeout);
    }

    final LockResult doTryLockExclusive(long indexId, byte[] key, int hash, long nanosTimeout) throws DeadlockException {
        return this.doTryLock(-1, indexId, key, hash, nanosTimeout);
    }

    final LockResult doLockExclusive(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.doLock(-1, indexId, key, _LockManager.hash(indexId, key), nanosTimeout);
    }

    final LockResult doLockExclusive(long indexId, byte[] key, int hash, long nanosTimeout) throws LockFailureException {
        return this.doLock(-1, indexId, key, hash, nanosTimeout);
    }

    final void recoverLock(_Lock lock) {
        this.mManager.getBucket(lock.mHashCode).recoverLock(this, lock);
    }

    final boolean canAttemptUpgrade(int count) {
        LockUpgradeRule lockUpgradeRule = this.mManager.mDefaultLockUpgradeRule;
        return lockUpgradeRule == LockUpgradeRule.UNCHECKED | lockUpgradeRule == LockUpgradeRule.LENIENT & count == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final _Lock doLockSharedNoPush(long indexId, byte[] key) throws LockFailureException {
        LockResult result;
        _Lock lock;
        int hash = _LockManager.hash(indexId, key);
        _LockManager.Bucket bucket = this.mManager.getBucket(hash);
        bucket.acquireExclusive();
        try {
            lock = bucket.lockAccess(indexId, key, hash);
            result = lock.tryLockShared(bucket, this, -1L);
        }
        finally {
            bucket.releaseExclusive();
        }
        if (!result.isHeld()) {
            throw this.failed(1, result, -1L);
        }
        return result == LockResult.ACQUIRED ? lock : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final _Lock doLockUpgradableNoPush(long indexId, byte[] key) throws LockFailureException {
        LockResult result;
        _Lock lock;
        int hash = _LockManager.hash(indexId, key);
        _LockManager.Bucket bucket = this.mManager.getBucket(hash);
        bucket.acquireExclusive();
        try {
            lock = bucket.lockAccess(indexId, key, hash);
            result = lock.tryLockUpgradable(bucket, this, -1L);
        }
        finally {
            bucket.releaseExclusive();
        }
        if (!result.isHeld()) {
            throw this.failed(Integer.MIN_VALUE, result, -1L);
        }
        return result == LockResult.ACQUIRED ? lock : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LockFailureException failed(int lockType, LockResult result, long nanosTimeout) throws DeadlockException {
        _Lock waitingFor;
        switch (result) {
            case DEADLOCK: {
                nanosTimeout = 0L;
            }
            case TIMED_OUT_LOCK: {
                waitingFor = this.mWaitingFor;
                if (waitingFor == null) break;
                try {
                    waitingFor.detectDeadlock(this, lockType, nanosTimeout);
                    break;
                }
                finally {
                    this.mWaitingFor = null;
                }
            }
            case ILLEGAL: {
                return new IllegalUpgradeException();
            }
            case INTERRUPTED: {
                return new LockInterruptedException();
            }
            default: {
                waitingFor = this.mWaitingFor;
                this.mWaitingFor = null;
            }
        }
        if (result.isTimedOut() || result == LockResult.DEADLOCK) {
            Object att;
            Object object = att = waitingFor == null ? null : waitingFor.findOwnerAttachment(this, false, lockType);
            if (result.isTimedOut()) {
                return new LockTimeoutException(nanosTimeout, att);
            }
            return new DeadlockException(nanosTimeout, att, true);
        }
        return new LockFailureException();
    }

    public final LockResult lockCheck(long indexId, byte[] key) {
        return this.manager().check(this, indexId, key, _LockManager.hash(indexId, key));
    }

    public final long lastLockedIndex() {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            return 0L;
        }
        return _Locker.peek((Object)tailObj).mIndexId;
    }

    public final byte[] lastLockedKey() {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            return null;
        }
        return _Locker.peek((Object)tailObj).mKey;
    }

    private static _Lock peek(Object tailObj) {
        _Lock lock;
        return tailObj instanceof _Lock ? (lock = (_Lock)tailObj) : ((Block)tailObj).last();
    }

    public final void unlock() {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            throw new IllegalStateException("No locks held");
        }
        if (tailObj instanceof _Lock) {
            _Lock lock = (_Lock)tailObj;
            ParentScope parent = this.mParentScope;
            if (parent != null && parent.mTailBlock == tailObj) {
                throw new IllegalStateException("Cannot cross a scope boundary");
            }
            this.mManager.unlock(this, lock);
            this.mTailBlock = null;
        } else {
            Block.unlockLast((Block)tailObj, this);
        }
    }

    final void doUnlock() {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            throw new IllegalStateException("No locks held");
        }
        if (tailObj instanceof _Lock) {
            _Lock lock = (_Lock)tailObj;
            ParentScope parent = this.mParentScope;
            if (parent != null && parent.mTailBlock == tailObj) {
                throw new IllegalStateException("Cannot cross a scope boundary");
            }
            this.mManager.doUnlock(this, lock);
            this.mTailBlock = null;
        } else {
            Block.doUnlockLast((Block)tailObj, this);
        }
    }

    public final void unlockToShared() {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            throw new IllegalStateException("No locks held");
        }
        if (tailObj instanceof _Lock) {
            _Lock lock = (_Lock)tailObj;
            ParentScope parent = this.mParentScope;
            if (parent != null && parent.mTailBlock == tailObj) {
                throw new IllegalStateException("Cannot cross a scope boundary");
            }
            this.mManager.unlockToShared(this, lock);
        } else {
            Block.unlockLastToShared((Block)tailObj, this);
        }
    }

    final void doUnlockToShared() {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            throw new IllegalStateException("No locks held");
        }
        if (tailObj instanceof _Lock) {
            _Lock lock = (_Lock)tailObj;
            ParentScope parent = this.mParentScope;
            if (parent != null && parent.mTailBlock == tailObj) {
                throw new IllegalStateException("Cannot cross a scope boundary");
            }
            this.mManager.doUnlockToShared(this, lock);
        } else {
            Block.doUnlockLastToShared((Block)tailObj, this);
        }
    }

    final void doUnlockToUpgradable() {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            throw new IllegalStateException("No locks held");
        }
        if (tailObj instanceof _Lock) {
            _Lock lock = (_Lock)tailObj;
            ParentScope parent = this.mParentScope;
            if (parent != null && parent.mTailBlock == tailObj) {
                throw new IllegalStateException("Cannot cross a scope boundary");
            }
            this.mManager.doUnlockToUpgradable(this, lock);
        } else {
            Block.doUnlockLastToUpgradable((Block)tailObj, this);
        }
    }

    public final void unlockCombine() {
        Object object = this.mTailBlock;
        if (object instanceof Block) {
            Block block = (Block)object;
            Block.unlockCombine(block);
        }
    }

    final ParentScope scopeEnter() {
        Object tailObj;
        ParentScope parent = new ParentScope();
        parent.mParentScope = this.mParentScope;
        parent.mTailBlock = tailObj = this.mTailBlock;
        if (tailObj instanceof Block) {
            Block block = (Block)tailObj;
            parent.mTailBlockSize = block.mSize;
        }
        this.mParentScope = parent;
        return parent;
    }

    final void promote() {
        Object tailObj = this.mTailBlock;
        if (tailObj != null) {
            ParentScope parent = this.mParentScope;
            parent.mTailBlock = tailObj;
            if (tailObj instanceof Block) {
                Block block = (Block)tailObj;
                parent.mTailBlockSize = block.mSize;
            }
        }
    }

    final void scopeUnlockAll() {
        Object parentTailObj;
        ParentScope parent = this.mParentScope;
        if (parent == null || (parentTailObj = parent.mTailBlock) == null) {
            Object tailObj = this.mTailBlock;
            if (tailObj instanceof _Lock) {
                _Lock lock = (_Lock)tailObj;
                this.mManager.doUnlock(this, lock);
                this.mTailBlock = null;
            } else {
                Block tail = (Block)tailObj;
                if (tail != null) {
                    do {
                        tail.unlockToSavepoint(this, 0);
                    } while ((tail = tail.prev()) != null);
                    this.mTailBlock = null;
                }
            }
        } else if (parentTailObj instanceof _Lock) {
            Object tailObj = this.mTailBlock;
            if (tailObj instanceof Block) {
                Block tail = (Block)tailObj;
                while (true) {
                    Block prev;
                    if ((prev = tail.prev()) == null) break;
                    tail.unlockToSavepoint(this, 0);
                    tail = prev;
                }
                tail.unlockToSavepoint(this, 1);
                this.mTailBlock = tail;
            }
        } else {
            Block tail;
            for (tail = (Block)this.mTailBlock; tail != parentTailObj; tail = tail.prev()) {
                tail.unlockToSavepoint(this, 0);
            }
            tail.unlockToSavepoint(this, parent.mTailBlockSize);
            this.mTailBlock = tail;
        }
    }

    final void unlockToPrepare() {
        if (this.mParentScope != null) {
            throw new IllegalStateException();
        }
        while (true) {
            Object tailObj;
            if ((tailObj = this.mTailBlock) instanceof _Lock) {
                _Lock lock = (_Lock)tailObj;
                if (!lock.isPrepareLock()) {
                    this.mManager.doUnlock(this, lock);
                    this.mTailBlock = null;
                }
                return;
            }
            Block tail = (Block)tailObj;
            if (tail == null || tail.last().isPrepareLock()) {
                return;
            }
            Block.doUnlockLast(tail, this);
        }
    }

    final void unlockAllExceptPrepare() {
        if (this.mParentScope != null) {
            throw new IllegalStateException();
        }
        Object tailObj = this.mTailBlock;
        if (tailObj instanceof _Lock) {
            _Lock lock = (_Lock)tailObj;
            if (lock.isPrepareLock()) {
                return;
            }
        } else if (tailObj != null) {
            _Lock lock = ((Block)tailObj).removeLastIfPrepare(this);
            this.scopeUnlockAll();
            this.mTailBlock = lock;
            return;
        }
        throw new IllegalStateException(String.valueOf(tailObj));
    }

    final void unlockNonExclusive() {
        this.transferExclusive(this);
    }

    final void transferExclusive(_Locker newOwner) {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            return;
        }
        if (tailObj instanceof _Lock) {
            _Lock lock = (_Lock)tailObj;
            if (lock.mLockCount != -1) {
                this.mManager.doUnlock(this, lock);
            } else {
                if (newOwner == this) {
                    return;
                }
                this.mManager.takeLockOwnership(lock, newOwner);
                cTailBlockHandle.setRelease(newOwner, lock);
            }
            this.mTailBlock = null;
            return;
        }
        Block tail = (Block)tailObj;
        Block last = null;
        do {
            int size;
            if ((size = tail.transferExclusive(this, newOwner)) <= 0) {
                tail = tail.prev();
                continue;
            }
            if (last == null) {
                cTailBlockHandle.setRelease(newOwner, tail);
            } else {
                last.mPrev = tail;
            }
            last = tail;
            tail = tail.prev();
        } while (tail != null);
        if (newOwner != this) {
            this.mTailBlock = null;
        }
    }

    final ParentScope scopeExit() {
        this.scopeUnlockAll();
        return this.popScope();
    }

    final void scopeExitAll() {
        this.mParentScope = null;
        this.scopeUnlockAll();
    }

    final void discardAllLocks() {
        this.mParentScope = null;
        this.mTailBlock = null;
    }

    final void push(_Lock lock) {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            cTailBlockHandle.setRelease(this, lock);
        } else if (tailObj instanceof _Lock) {
            _Lock tailLock = (_Lock)tailObj;
            cTailBlockHandle.setRelease(this, new Block(tailLock, lock));
        } else {
            ((Block)tailObj).pushLock(this, lock, 0L);
        }
    }

    final void pushUpgrade(_Lock lock) {
        Object tailObj = this.mTailBlock;
        if (tailObj instanceof _Lock) {
            _Lock tailLock = (_Lock)tailObj;
            if (tailObj != lock || this.mParentScope != null) {
                Block block = new Block(tailLock, lock);
                block.secondUpgrade();
                cTailBlockHandle.setRelease(this, block);
            }
        } else {
            ((Block)tailObj).pushLock(this, lock, Long.MIN_VALUE);
        }
    }

    final _Lock findAnyConflict(long indexId, RowPredicate predicate) {
        Object tailObj = cTailBlockHandle.getAcquire(this);
        if (tailObj != null) {
            if (tailObj instanceof _Lock) {
                _Lock lock = (_Lock)tailObj;
                if (lock.mIndexId == indexId && predicate.test(lock.mKey) && _Lock.cLockCountHandle.getAcquire(lock) < 0) {
                    return lock;
                }
            } else {
                Block block = (Block)tailObj;
                do {
                    _Lock lock;
                    if ((lock = block.findAnyConflict(indexId, predicate)) == null) continue;
                    return lock;
                } while ((block = block.prevAcquire()) != null);
            }
        }
        return null;
    }

    private ParentScope popScope() {
        ParentScope parent = this.mParentScope;
        if (parent == null) {
            this.mTailBlock = null;
        } else {
            this.mTailBlock = parent.mTailBlock;
            this.mParentScope = parent.mParentScope;
        }
        return parent;
    }

    static {
        try {
            cTailBlockHandle = MethodHandles.lookup().findVarHandle(_Locker.class, "mTailBlock", Object.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    static final class ParentScope {
        ParentScope mParentScope;
        Object mTailBlock;
        int mTailBlockSize;
        LockMode mLockMode;
        long mLockTimeoutNanos;
        int mHasState;
        long mSavepoint;

        ParentScope() {
        }
    }

    static final class Block {
        private static final int FIRST_BLOCK_CAPACITY = 8;
        private static final int HIGHEST_BLOCK_CAPACITY = 64;
        private final _Lock[] mLocks;
        private long mUpgrades;
        private int mSize;
        private long mUnlockGroup;
        private Block mPrev;
        private static final VarHandle cPrevHandle;
        private static final VarHandle cSizeHandle;

        Block(_Lock first, _Lock second) {
            _Lock[] locks = new _Lock[8];
            locks[0] = first;
            locks[1] = second;
            this.mLocks = locks;
            cSizeHandle.setRelease(this, 2);
        }

        void secondUpgrade() {
            this.mUpgrades = 0x4000000000000000L;
        }

        private Block(Block prev, _Lock first, long upgrade) {
            int capacity = prev.mLocks.length;
            if (capacity < 64) {
                capacity <<= 1;
            }
            _Lock[] _LockArray = new _Lock[capacity];
            this.mLocks = _LockArray;
            _LockArray[0] = first;
            this.mUpgrades = upgrade;
            cSizeHandle.setRelease(this, 1);
            cPrevHandle.setRelease(this, prev);
        }

        void pushLock(_Locker locker, _Lock lock, long upgrade) {
            ParentScope parent;
            _Lock[] locks = this.mLocks;
            int size = this.mSize;
            if (upgrade != 0L && ((parent = locker.mParentScope) == null || parent.mTailBlockSize != size) && locks[size - 1] == lock) {
                return;
            }
            if (size < locks.length) {
                locks[size] = lock;
                this.mUpgrades |= upgrade >>> size;
                cSizeHandle.setRelease(this, size + 1);
            } else {
                cTailBlockHandle.setRelease(locker, new Block(this, lock, upgrade));
            }
        }

        _Lock last() {
            return this.mLocks[this.mSize - 1];
        }

        _Lock removeLastIfPrepare(_Locker locker) {
            int size = this.mSize - 1;
            _Lock lock = this.mLocks[size];
            if (!lock.isPrepareLock()) {
                throw new IllegalStateException();
            }
            this.mLocks[size] = null;
            if (size == 0) {
                locker.mTailBlock = this.mPrev;
            } else {
                this.mSize = size;
            }
            return lock;
        }

        static void unlockLast(Block block, _Locker locker) {
            int size = block.mSize;
            while (true) {
                long mask;
                long upgrades;
                if (((upgrades = block.mUpgrades) & (mask = Long.MIN_VALUE >>> --size)) != 0L) {
                    throw new IllegalStateException("Cannot unlock non-immediate upgrade");
                }
                _Lock[] locks = block.mLocks;
                _Lock lock = locks[size];
                block.parentCheck(locker, lock);
                locker.mManager.unlock(locker, lock);
                locks[size] = null;
                if (size == 0) {
                    Block prev = block.mPrev;
                    locker.mTailBlock = prev;
                    if ((block.mUnlockGroup & mask) == 0L) {
                        return;
                    }
                    block = prev;
                    size = block.mSize;
                    continue;
                }
                block.mUpgrades = upgrades & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                block.mSize = size;
                long unlockGroup = block.mUnlockGroup;
                if ((unlockGroup & mask) == 0L) {
                    return;
                }
                block.mUnlockGroup = unlockGroup & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }

        static void doUnlockLast(Block block, _Locker locker) {
            int size = block.mSize;
            while (true) {
                long mask;
                long upgrades;
                if (((upgrades = block.mUpgrades) & (mask = Long.MIN_VALUE >>> --size)) != 0L) {
                    throw new IllegalStateException("Cannot unlock non-immediate upgrade");
                }
                _Lock[] locks = block.mLocks;
                _Lock lock = locks[size];
                block.parentCheck(locker, lock);
                locker.mManager.doUnlock(locker, lock);
                locks[size] = null;
                if (size == 0) {
                    Block prev = block.mPrev;
                    locker.mTailBlock = prev;
                    if ((block.mUnlockGroup & mask) == 0L) {
                        return;
                    }
                    block = prev;
                    size = block.mSize;
                    continue;
                }
                block.mUpgrades = upgrades & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                block.mSize = size;
                long unlockGroup = block.mUnlockGroup;
                if ((unlockGroup & mask) == 0L) {
                    return;
                }
                block.mUnlockGroup = unlockGroup & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }

        static void unlockLastToShared(Block block, _Locker locker) {
            int size = block.mSize;
            while (true) {
                long mask;
                if ((block.mUpgrades & (mask = Long.MIN_VALUE >>> --size)) != 0L) {
                    throw new IllegalStateException("Cannot unlock non-immediate upgrade");
                }
                _Lock lock = block.mLocks[size];
                block.parentCheck(locker, lock);
                locker.mManager.unlockToShared(locker, lock);
                if ((block.mUnlockGroup & mask) == 0L) {
                    return;
                }
                if (size != 0) continue;
                block = block.mPrev;
                size = block.mSize;
            }
        }

        static void doUnlockLastToShared(Block block, _Locker locker) {
            int size = block.mSize;
            while (true) {
                long mask;
                if ((block.mUpgrades & (mask = Long.MIN_VALUE >>> --size)) != 0L) {
                    throw new IllegalStateException("Cannot unlock non-immediate upgrade");
                }
                _Lock lock = block.mLocks[size];
                block.parentCheck(locker, lock);
                locker.mManager.doUnlockToShared(locker, lock);
                if ((block.mUnlockGroup & mask) == 0L) {
                    return;
                }
                if (size != 0) continue;
                block = block.mPrev;
                size = block.mSize;
            }
        }

        static void doUnlockLastToUpgradable(Block block, _Locker locker) {
            int size = block.mSize;
            while (true) {
                _Lock[] locks = block.mLocks;
                _Lock lock = locks[--size];
                block.parentCheck(locker, lock);
                locker.mManager.doUnlockToUpgradable(locker, lock);
                long upgrades = block.mUpgrades;
                long mask = Long.MIN_VALUE >>> size;
                if ((upgrades & mask) == 0L) {
                    if ((block.mUnlockGroup & mask) == 0L) {
                        return;
                    }
                    if (size != 0) continue;
                    block = block.mPrev;
                    size = block.mSize;
                    continue;
                }
                locks[size] = null;
                if (size == 0) {
                    Block prev = block.mPrev;
                    locker.mTailBlock = prev;
                    if ((block.mUnlockGroup & mask) == 0L) {
                        return;
                    }
                    block = prev;
                    size = block.mSize;
                    continue;
                }
                block.mUpgrades = upgrades & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                block.mSize = size;
                long unlockGroup = block.mUnlockGroup;
                if ((unlockGroup & mask) == 0L) {
                    return;
                }
                block.mUnlockGroup = unlockGroup & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }

        static void unlockCombine(Block block) {
            long prevMask;
            long mask;
            int size;
            while (true) {
                size = block.mSize - 1;
                mask = block.mUnlockGroup | Long.MAX_VALUE >>> size;
                if ((mask = (mask ^ 0xFFFFFFFFFFFFFFFFL) & mask + 1L) != 0L) break;
                block = block.mPrev;
            }
            long upgrades = block.mUpgrades;
            if (size != 0) {
                prevMask = upgrades >> 1;
            } else {
                Block prev = block.mPrev;
                if (prev == null) {
                    return;
                }
                prevMask = prev.mUpgrades << prev.mSize - 1;
            }
            if (((upgrades ^ prevMask) & mask) != 0L) {
                throw new IllegalStateException("Cannot combine an acquire with an upgrade");
            }
            if (mask < 0L && block.mPrev == null) {
                return;
            }
            block.mUnlockGroup |= mask;
        }

        private void parentCheck(_Locker locker, _Lock lock) throws IllegalStateException {
            Object parentTail;
            ParentScope parent = locker.mParentScope;
            if (parent != null && ((parentTail = parent.mTailBlock) == lock || parentTail == this && parent.mTailBlockSize == this.mSize)) {
                throw new IllegalStateException("Cannot cross a scope boundary");
            }
        }

        void unlockToSavepoint(_Locker locker, int targetSize) {
            int size = this.mSize;
            if (size > targetSize) {
                _Lock[] locks = this.mLocks;
                _LockManager manager = locker.mManager;
                long mask = Long.MIN_VALUE >>> --size;
                long upgrades = this.mUpgrades;
                while (true) {
                    _Lock lock = locks[size];
                    if ((upgrades & mask) != 0L) {
                        manager.doUnlockToUpgradable(locker, lock);
                    } else {
                        manager.doUnlock(locker, lock);
                    }
                    locks[size] = null;
                    if (size == targetSize) break;
                    --size;
                    mask <<= 1;
                }
                this.mUpgrades = upgrades & (-1L >>> size ^ 0xFFFFFFFFFFFFFFFFL);
                this.mSize = size;
            }
        }

        int transferExclusive(_Locker locker, _Locker newOwner) {
            int i;
            _Lock[] locks = this.mLocks;
            _LockManager manager = locker.mManager;
            int size = this.mSize;
            long upgrades = this.mUpgrades;
            int newSize = 0;
            for (i = 0; i < size; ++i) {
                _Lock lock = locks[i];
                if (lock.mLockCount != -1) {
                    manager.doUnlock(locker, lock);
                } else if (upgrades >= 0L) {
                    if (newSize != i) {
                        locks[newSize] = lock;
                    }
                    if (newOwner != locker) {
                        manager.takeLockOwnership(lock, newOwner);
                    }
                    ++newSize;
                }
                upgrades <<= 1;
            }
            if (newSize != size) {
                for (i = newSize; i < size; ++i) {
                    locks[i] = null;
                }
                this.mUpgrades = 0L;
                this.mSize = newSize;
                this.mUnlockGroup = 0L;
            }
            return newSize;
        }

        _Lock findAnyConflict(long indexId, RowPredicate predicate) {
            _Lock[] locks = this.mLocks;
            int i = cSizeHandle.getAcquire(this);
            while (--i >= 0) {
                _Lock lock = locks[i];
                if (lock == null || lock.mIndexId != indexId || !predicate.test(lock.mKey) || _Lock.cLockCountHandle.getAcquire(lock) >= 0) continue;
                return lock;
            }
            return null;
        }

        Block prev() {
            return this.mPrev;
        }

        Block prevAcquire() {
            return cPrevHandle.getAcquire(this);
        }

        static {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                cPrevHandle = lookup.findVarHandle(Block.class, "mPrev", Block.class);
                cSizeHandle = lookup.findVarHandle(Block.class, "mSize", Integer.TYPE);
            }
            catch (Throwable e) {
                throw Utils.rethrow(e);
            }
        }
    }
}

