/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import java.util.zip.Checksum;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DatabaseFullException;
import org.cojen.tupl.core._LocalDatabase;
import org.cojen.tupl.core._Node;
import org.cojen.tupl.core._PageDb;
import org.cojen.tupl.ext.Crypto;

final class _NonPageDb
extends _PageDb {
    private final int mPageSize;
    private final AtomicLong mAllocId;
    private final LongAdder mFreePageCount;
    private final long mDatabaseId;

    _NonPageDb(int pageSize) {
        this.mPageSize = pageSize;
        this.mAllocId = new AtomicLong(1L);
        this.mFreePageCount = new LongAdder();
        this.mDatabaseId = _NonPageDb.generateDatabaseId(new Random());
    }

    @Override
    long databaseId() {
        return this.mDatabaseId;
    }

    @Override
    void pageCache(_LocalDatabase db) {
    }

    @Override
    Crypto dataCrypto() {
        return null;
    }

    @Override
    Supplier<Checksum> checksumFactory() {
        return null;
    }

    @Override
    void delete() {
    }

    @Override
    boolean isCacheOnly() {
        return true;
    }

    @Override
    public int directPageSize() {
        return this.pageSize();
    }

    @Override
    public int allocMode() {
        return 2;
    }

    @Override
    public _Node allocLatchedNode(_LocalDatabase db, int mode) throws IOException {
        _Node node = db.allocLatchedNode(mode);
        long nodeId = node.id();
        if (nodeId < 0L) {
            nodeId = -nodeId;
            this.mFreePageCount.decrement();
        } else {
            nodeId = this.allocPage();
        }
        node.id(nodeId);
        return node;
    }

    @Override
    public int pageSize() {
        return this.mPageSize;
    }

    @Override
    public long pageCount() {
        return 0L;
    }

    @Override
    public void pageLimit(long limit) {
    }

    @Override
    public long pageLimit() {
        return -1L;
    }

    @Override
    public void pageLimitOverride(long limit) {
    }

    @Override
    public _PageDb.Stats stats() {
        _PageDb.Stats stats = new _PageDb.Stats();
        stats.freePages = Math.max(0L, this.mFreePageCount.sum());
        stats.totalPages = Math.max(stats.freePages, this.mAllocId.get());
        return stats;
    }

    @Override
    public boolean requiresCommit() {
        return false;
    }

    @Override
    public void readPage(long id, long page) throws IOException {
        _NonPageDb.fail(false);
    }

    @Override
    public long allocPage() throws IOException {
        long id = this.mAllocId.incrementAndGet();
        if (id > 0xFFFFFFFFFFFFL) {
            this.mAllocId.decrementAndGet();
            throw new DatabaseFullException();
        }
        return id;
    }

    @Override
    public void writePage(long id, long page) throws IOException {
        _NonPageDb.fail(true);
    }

    @Override
    public long evictPage(long id, long page) throws IOException {
        this.writePage(id, page);
        return page;
    }

    @Override
    public void deletePage(long id, boolean force) throws IOException {
        this.mFreePageCount.increment();
    }

    @Override
    public void recyclePage(long id) throws IOException {
        this.deletePage(id, true);
    }

    @Override
    public long allocatePages(long pageCount) throws IOException {
        return 0L;
    }

    @Override
    public void scanFreeList(LongConsumer dst) throws IOException {
    }

    @Override
    public boolean compactionStart(long targetPageCount) throws IOException {
        return false;
    }

    @Override
    public boolean compactionScanFreeList() throws IOException {
        return false;
    }

    @Override
    public boolean compactionVerify() throws IOException {
        return false;
    }

    @Override
    public boolean compactionEnd() throws IOException {
        return false;
    }

    @Override
    public void compactionReclaim() throws IOException {
    }

    @Override
    public boolean truncatePages() throws IOException {
        return false;
    }

    @Override
    public int extraCommitDataOffset() {
        return 0;
    }

    @Override
    public void commit(boolean resume, long header, _PageDb.CommitCallback callback) throws IOException {
        throw new DatabaseException("Cannot commit to a non-stored database");
    }

    @Override
    public void readExtraCommitData(byte[] extra) throws IOException {
        Arrays.fill(extra, (byte)0);
    }

    @Override
    public void close() {
    }

    @Override
    public void close(Throwable cause) {
        this.close();
    }

    private static void fail(boolean forWrite) throws DatabaseException {
        if (forWrite) {
            throw new DatabaseFullException();
        }
        throw new DatabaseException("Cannot read from a non-stored database");
    }
}

