/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.WriteFailureException;
import org.cojen.tupl.core.DirectPageOps;
import org.cojen.tupl.core.IntegerRef;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._IdHeap;
import org.cojen.tupl.core._LocalDatabase;
import org.cojen.tupl.core._Node;
import org.cojen.tupl.core._PageDb;
import org.cojen.tupl.core._PageManager;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;

final class _PageQueue
implements IntegerRef {
    static final int I_REMOVE_PAGE_COUNT = 0;
    static final int I_REMOVE_NODE_COUNT = 8;
    static final int I_REMOVE_HEAD_ID = 16;
    static final int I_REMOVE_HEAD_OFFSET = 24;
    static final int I_REMOVE_HEAD_FIRST_PAGE_ID = 28;
    static final int I_APPEND_HEAD_ID = 36;
    static final int HEADER_SIZE = 44;
    static final int I_NEXT_NODE_ID = 0;
    static final int I_FIRST_PAGE_ID = 8;
    static final int I_NODE_START = 16;
    private final _PageManager mManager;
    private final int mPageSize;
    private final boolean mIsReserve;
    private final boolean mAggressive;
    private long mRemovePageCount;
    private long mRemoveNodeCount;
    private long mRemoveHead;
    private long mRemoveHeadId;
    private int mRemoveHeadOffset;
    private long mRemoveHeadFirstPageId;
    private long mRemoveStoppedId;
    private long mRemovedNodeCounter;
    private long mReserveReclaimUpperBound;
    private volatile long mAppendHeadId;
    private final ReentrantLock mAppendLock;
    private final _IdHeap mAppendHeap;
    private final long mAppendTail;
    private volatile long mAppendTailId;
    private long mAppendPageCount;
    private long mAppendNodeCount;
    private boolean mDrainInProgress;

    static boolean exists(long header, int offset) {
        return DirectPageOps.p_longGetLE(header, offset + 16) != 0L;
    }

    static _PageQueue newRegularFreeList(_PageManager manager) {
        return new _PageQueue(manager, false, false, null);
    }

    static _PageQueue newRecycleFreeList(_PageManager manager) {
        return new _PageQueue(manager, false, true, null);
    }

    private _PageQueue(_PageManager manager, boolean isReserve, boolean aggressive, ReentrantLock appendLock) {
        this.mManager = manager;
        this.mPageSize = manager.pageSize();
        this.mIsReserve = isReserve;
        this.mAggressive = aggressive;
        this.mRemoveHead = DirectPageOps.p_callocPage(manager.directPageSize());
        this.mAppendLock = appendLock == null ? new ReentrantLock(false) : appendLock;
        this.mAppendHeap = new _IdHeap(this.mPageSize - 16);
        this.mAppendTail = DirectPageOps.p_callocPage(manager.directPageSize());
    }

    void delete() {
        DirectPageOps.p_delete(this.mRemoveHead);
        DirectPageOps.p_delete(this.mAppendTail);
    }

    _PageQueue newReserveFreeList() {
        if (this.mAggressive) {
            throw new IllegalStateException();
        }
        _PageQueue queue = new _PageQueue(this.mManager, true, false, this.mAppendLock);
        queue.mReserveReclaimUpperBound = Long.MAX_VALUE;
        return queue;
    }

    void init(long headNodeId) {
        this.mAppendLock.lock();
        try {
            this.mAppendHeadId = this.mAppendTailId = headNodeId;
            this.mRemoveStoppedId = this.mAppendTailId;
        }
        finally {
            this.mAppendLock.unlock();
        }
    }

    void init(EventListener debugListener, long header, int offset) throws IOException {
        this.mRemovePageCount = DirectPageOps.p_longGetLE(header, offset + 0);
        this.mRemoveNodeCount = DirectPageOps.p_longGetLE(header, offset + 8);
        this.mRemoveHeadId = DirectPageOps.p_longGetLE(header, offset + 16);
        this.mRemoveHeadOffset = DirectPageOps.p_intGetLE(header, offset + 24);
        this.mRemoveHeadFirstPageId = DirectPageOps.p_longGetLE(header, offset + 28);
        this.mAppendHeadId = this.mAppendTailId = DirectPageOps.p_longGetLE(header, offset + 36);
        if (debugListener != null) {
            String type = this.mIsReserve ? "Reserve" : (this.mAggressive ? "Recycle" : "Regular");
            debugListener.notify(EventType.DEBUG, "%1$s free list REMOVE_PAGE_COUNT: %2$d", type, this.mRemovePageCount);
            debugListener.notify(EventType.DEBUG, "%1$s free list REMOVE_NODE_COUNT: %2$d", type, this.mRemoveNodeCount);
            debugListener.notify(EventType.DEBUG, "%1$s free list REMOVE_HEAD_ID: %2$d", type, this.mRemoveHeadId);
            debugListener.notify(EventType.DEBUG, "%1$s free list REMOVE_HEAD_OFFSET: %2$d", type, this.mRemoveHeadOffset);
            debugListener.notify(EventType.DEBUG, "%1$s free list REMOVE_HEAD_FIRST_PAGE_ID: %2$d", type, this.mRemoveHeadFirstPageId);
        }
        if (this.mRemoveHeadId == 0L) {
            this.mRemoveStoppedId = this.mAppendHeadId;
        } else {
            long head = this.readRemoveNode(this.mRemoveHeadId);
            if (this.mRemoveHeadFirstPageId == 0L) {
                this.mRemoveHeadFirstPageId = DirectPageOps.p_longGetBE(head, 8);
            }
        }
    }

    void reclaim(ReentrantLock removeLock, long upperBound) throws IOException {
        long pageId;
        if (!this.mIsReserve) {
            throw new IllegalStateException();
        }
        removeLock.lock();
        this.mReserveReclaimUpperBound = upperBound;
        while (true) {
            if ((pageId = this.tryRemove(removeLock)) == 0L) break;
            if (pageId <= upperBound) {
                this.mManager.deletePage(pageId, true);
            }
            removeLock.lock();
        }
        removeLock.unlock();
        pageId = this.mRemoveStoppedId;
        if (pageId != 0L && pageId <= upperBound) {
            this.mManager.deletePage(pageId, true);
        }
    }

    long getRemoveScanTarget() {
        return this.mRemovedNodeCounter + this.mRemoveNodeCount;
    }

    boolean isRemoveScanComplete(long target) {
        return this.mRemovedNodeCounter - target >= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long tryRemove(ReentrantLock lock) throws IOException {
        long oldHeadId;
        long pageId;
        if (this.mRemoveHeadId == 0L) {
            if (!this.mAggressive || this.mRemoveStoppedId == this.mAppendTailId) {
                return 0L;
            }
            this.loadRemoveNode(this.mRemoveStoppedId);
            this.mRemoveStoppedId = 0L;
        }
        try {
            long nextId;
            long delta;
            pageId = this.mRemoveHeadFirstPageId;
            if (this.mManager.isPageOutOfBounds(pageId) && !this.mIsReserve) {
                throw new CorruptDatabaseException("Invalid page id in free list: " + pageId + "; list node: " + this.mRemoveHeadId);
            }
            --this.mRemovePageCount;
            long head = this.mRemoveHead;
            if (this.mRemoveHeadOffset < this.pageSize(head) && (delta = DirectPageOps.p_ulongGetVar(head, this)) > 0L) {
                this.mRemoveHeadFirstPageId = pageId + delta;
                long l = pageId;
                return l;
            }
            oldHeadId = this.mRemoveHeadId;
            if (this.mIsReserve && oldHeadId > this.mReserveReclaimUpperBound) {
                oldHeadId = 0L;
            }
            if ((nextId = DirectPageOps.p_longGetBE(head, 0)) == (this.mAggressive ? this.mAppendTailId : this.mAppendHeadId)) {
                this.mRemoveHeadId = 0L;
                this.mRemoveHeadOffset = 0;
                this.mRemoveHeadFirstPageId = 0L;
                this.mRemoveStoppedId = nextId;
            } else {
                this.loadRemoveNode(nextId);
            }
            --this.mRemoveNodeCount;
            ++this.mRemovedNodeCounter;
        }
        finally {
            lock.unlock();
        }
        if (oldHeadId != 0L) {
            this.mManager.deletePage(oldHeadId, true);
        }
        return pageId;
    }

    private void loadRemoveNode(long id) throws IOException {
        if (this.mManager.isPageOutOfBounds(id)) {
            throw new CorruptDatabaseException("Invalid node id in free list: " + id);
        }
        long head = this.readRemoveNode(id);
        this.mRemoveHeadId = id;
        this.mRemoveHeadOffset = 16;
        this.mRemoveHeadFirstPageId = DirectPageOps.p_longGetBE(head, 8);
    }

    private long readRemoveNode(long id) throws IOException {
        _Node node;
        long head = this.mRemoveHead;
        _LocalDatabase cache = this.mManager.mPageCache;
        if (cache == null || this.mIsReserve || (node = cache.nodeMapGetExclusiveSpin(id)) == null) {
            this.mManager.mPageArray.readPage(id, head);
        } else {
            cache.nodeMapRemove(node);
            if (node.mCachedState != 0) {
                this.mManager.mPageArray.writePage(id, node.mPage);
                node.mCachedState = 0;
            }
            if (cache.mFullyMapped) {
                DirectPageOps.p_copy(node.mPage, 0, head, 0, this.mPageSize);
            } else {
                this.mRemoveHead = node.mPage;
                node.mPage = head;
                head = this.mRemoveHead;
            }
            node.unused();
        }
        return head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(long id, boolean force) throws IOException {
        block7: {
            if (id <= 1L) {
                throw new IllegalArgumentException("Page id: " + id);
            }
            _IdHeap appendHeap = this.mAppendHeap;
            this.mAppendLock.lock();
            try {
                appendHeap.add(id);
                ++this.mAppendPageCount;
                if (this.mDrainInProgress || !appendHeap.shouldDrain()) break block7;
                try {
                    this.drainAppendHeap(appendHeap);
                }
                catch (IOException e) {
                    if (!force) {
                        appendHeap.remove(id);
                        --this.mAppendPageCount;
                        throw e;
                    }
                }
            }
            finally {
                this.mAppendLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long tryUnappend() {
        this.mAppendLock.lock();
        try {
            _IdHeap appendHeap = this.mAppendHeap;
            if (this.mDrainInProgress && appendHeap.size() <= 1) {
                long l = 0L;
                return l;
            }
            long id = appendHeap.tryRemove();
            if (id != 0L) {
                --this.mAppendPageCount;
            }
            long l = id;
            return l;
        }
        finally {
            this.mAppendLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainAppendHeap(_IdHeap appendHeap) throws IOException {
        if (this.mDrainInProgress) {
            throw new AssertionError();
        }
        this.mDrainInProgress = true;
        try {
            _Node node;
            long tailBuf;
            long newTailId = this.mManager.allocPage();
            _LocalDatabase cache = this.mManager.mPageCache;
            if (cache == null || this.mIsReserve) {
                tailBuf = this.mAppendTail;
                node = null;
            } else {
                node = cache.tryAllocRawDirtyNode(this.mAppendTailId);
                tailBuf = node == null ? this.mAppendTail : node.mPage;
            }
            long firstPageId = appendHeap.remove();
            DirectPageOps.p_longPutBE(tailBuf, 0, newTailId);
            DirectPageOps.p_longPutBE(tailBuf, 8, firstPageId);
            int end = appendHeap.drain(firstPageId, tailBuf, 16, this.pageSize(tailBuf) - 16);
            DirectPageOps.p_clear(tailBuf, end, this.pageSize(tailBuf));
            if (node != null) {
                cache.nodeMapPut(node);
                node.releaseExclusive();
            } else {
                try {
                    this.mManager.mPageArray.writePage(this.mAppendTailId, tailBuf);
                }
                catch (IOException e) {
                    appendHeap.undrain(firstPageId, tailBuf, 16, end);
                    this.mManager.recyclePage(newTailId);
                    throw WriteFailureException.from(e);
                }
            }
            ++this.mAppendNodeCount;
            this.mAppendTailId = newTailId;
        }
        finally {
            this.mDrainInProgress = false;
        }
    }

    ReentrantLock appendLock() {
        return this.mAppendLock;
    }

    void preCommit() throws IOException {
        _IdHeap appendHeap = this.mAppendHeap;
        while (appendHeap.size() > 0) {
            this.drainAppendHeap(appendHeap);
        }
    }

    void commitStart(long header, int offset) {
        DirectPageOps.p_longPutLE(header, offset + 0, this.mRemovePageCount + this.mAppendPageCount);
        DirectPageOps.p_longPutLE(header, offset + 8, this.mRemoveNodeCount + this.mAppendNodeCount);
        if (this.mRemoveHeadId == 0L && this.mAppendPageCount > 0L) {
            long headId = this.mAppendHeadId;
            if (headId != this.mRemoveStoppedId) {
                headId = this.mRemoveStoppedId == this.mAppendTailId ? 0L : this.mRemoveStoppedId;
            }
            DirectPageOps.p_longPutLE(header, offset + 16, headId);
            DirectPageOps.p_intPutLE(header, offset + 24, 16);
            DirectPageOps.p_longPutLE(header, offset + 28, 0L);
        } else {
            DirectPageOps.p_longPutLE(header, offset + 16, this.mRemoveHeadId);
            DirectPageOps.p_intPutLE(header, offset + 24, this.mRemoveHeadOffset);
            DirectPageOps.p_longPutLE(header, offset + 28, this.mRemoveHeadFirstPageId);
        }
        DirectPageOps.p_longPutLE(header, offset + 36, this.mAppendTailId);
        this.mRemovePageCount += this.mAppendPageCount;
        this.mRemoveNodeCount += this.mAppendNodeCount;
        this.mAppendPageCount = 0L;
        this.mAppendNodeCount = 0L;
    }

    void commitEnd(long header, int offset) throws IOException {
        long newAppendHeadId = DirectPageOps.p_longGetLE(header, offset + 36);
        if (this.mRemoveHeadId == 0L && this.mRemoveStoppedId != newAppendHeadId && this.mRemoveStoppedId != this.mAppendTailId) {
            this.loadRemoveNode(this.mRemoveStoppedId);
            this.mRemoveStoppedId = 0L;
        }
        this.mAppendHeadId = newAppendHeadId;
    }

    void addTo(_PageDb.Stats stats) {
        stats.freePages += this.mRemovePageCount + this.mAppendPageCount + this.mRemoveNodeCount + this.mAppendNodeCount;
    }

    boolean hasAppendedPages() {
        this.mAppendLock.lock();
        try {
            boolean bl = this.mAppendPageCount + this.mAppendNodeCount > 0L;
            return bl;
        }
        finally {
            this.mAppendLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean verifyPageRange(long startId, long endId) throws IOException {
        if (!this.mIsReserve) {
            throw new AssertionError();
        }
        long expectedHash = 0L;
        for (long i = startId; i < endId; ++i) {
            expectedHash += Utils.scramble(i);
        }
        long hash = 0L;
        long count = 0L;
        long nodeId = this.mRemoveHeadId;
        if (nodeId != 0L) {
            long node = DirectPageOps.p_clonePage(this.mRemoveHead, this.mManager.directPageSize());
            try {
                long pageId = this.mRemoveHeadFirstPageId;
                IntegerRef.Value nodeOffsetRef = new IntegerRef.Value();
                nodeOffsetRef.value = this.mRemoveHeadOffset;
                while (true) {
                    long delta;
                    if (pageId < startId || pageId >= endId) {
                        boolean bl = false;
                        return bl;
                    }
                    hash += Utils.scramble(pageId);
                    ++count;
                    if (nodeOffsetRef.value < this.pageSize(node) && (delta = DirectPageOps.p_ulongGetVar(node, nodeOffsetRef)) > 0L) {
                        pageId += delta;
                        continue;
                    }
                    if (nodeId >= startId && nodeId < endId) {
                        hash += Utils.scramble(nodeId);
                        ++count;
                    }
                    if ((nodeId = DirectPageOps.p_longGetBE(node, 0)) == this.mAppendTailId) {
                        break;
                    }
                    this.mManager.mPageArray.readPage(nodeId, node);
                    pageId = DirectPageOps.p_longGetBE(node, 8);
                    nodeOffsetRef.value = 16;
                }
            }
            finally {
                DirectPageOps.p_delete(node);
            }
        }
        return hash == expectedHash && count == endId - startId;
    }

    private int pageSize(long page) {
        return this.mPageSize;
    }

    @Override
    public int get() {
        return this.mRemoveHeadOffset;
    }

    @Override
    public void set(int offset) {
        this.mRemoveHeadOffset = offset;
    }
}

