/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.LongAdder;
import org.cojen.tupl.Entry;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Sorter;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.CommitLock;
import org.cojen.tupl.core.DirectPageOps;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._BTree;
import org.cojen.tupl.core._BTreeCursor;
import org.cojen.tupl.core._BTreeMerger;
import org.cojen.tupl.core._LocalDatabase;
import org.cojen.tupl.core._Node;
import org.cojen.tupl.core._SortReverseScanner;
import org.cojen.tupl.core._SortScanner;

final class _ParallelSorter
implements Sorter,
_Node.Supplier {
    private static final int MIN_SORT_TREES = 8;
    private static final int MAX_SORT_TREES = 64;
    private static final int LEVEL_MIN_SIZE = 8;
    private static final int L0_MAX_SIZE = 256;
    private static final int L1_MAX_SIZE = 1024;
    private static final int MERGE_THREAD_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int S_READY = 0;
    private static final int S_FINISHING = 1;
    private static final int S_EXCEPTION = 2;
    private static final int S_RESET = 3;
    private final _LocalDatabase mDatabase;
    private final Executor mExecutor;
    private _BTree[] mSortTrees;
    private int mSortTreesSize;
    private _BTree[] mSortTreePool;
    private int mSortTreePoolSize;
    private Merger mLastMerger;
    private int mMergerCount;
    private volatile List<Level> mSortTreeLevels;
    private LongAdder mFinishCounter;
    private long mFinishCount;
    private int mState;
    private Throwable mException;

    _ParallelSorter(_LocalDatabase db, Executor executor) {
        this.mDatabase = db;
        this.mExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void add(byte[] key, byte[] value) throws IOException {
        CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
        try {
            _Node node;
            if (this.mSortTreesSize == 0) {
                _BTree sortTree = this.allocSortTree();
                _BTree[] _BTreeArray = new _BTree[8];
                this.mSortTrees = _BTreeArray;
                _BTreeArray[0] = sortTree;
                this.mSortTreesSize = 1;
                node = sortTree.mRoot;
            } else {
                _BTree sortTree = this.mSortTrees[this.mSortTreesSize - 1];
                node = this.latchRootDirty(sortTree);
            }
            try {
                node = _Node.appendToSortLeaf(node, this.mDatabase, key, value, this);
            }
            finally {
                node.releaseExclusive();
            }
        }
        catch (Throwable e) {
            this.exception(e);
            throw e;
        }
        finally {
            shared.release();
        }
        if (this.mSortTreesSize >= 64) {
            this.mergeSortTrees();
        }
    }

    @Override
    public synchronized void addBatch(byte[][] kvPairs, int offset, int size) throws IOException {
        _Node node;
        if (size <= 0) {
            return;
        }
        _LocalDatabase db = this.mDatabase;
        CommitLock commitLock = db.commitLock();
        CommitLock.Shared shared = commitLock.acquireShared();
        block4: while (true) {
            try {
                if (this.mSortTreesSize == 0) {
                    sortTree = this.allocSortTree();
                    _BTree[] _BTreeArray = new _BTree[8];
                    this.mSortTrees = _BTreeArray;
                    _BTreeArray[0] = sortTree;
                    this.mSortTreesSize = 1;
                    node = sortTree.mRoot;
                } else {
                    sortTree = this.mSortTrees[this.mSortTreesSize - 1];
                    node = this.latchRootDirty(sortTree);
                }
            }
            catch (Throwable e) {
                shared.release();
                this.exception(e);
                throw e;
            }
            do {
                try {
                    byte[] key = kvPairs[offset++];
                    byte[] value = kvPairs[offset++];
                    node = _Node.appendToSortLeaf(node, db, key, value, this);
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    shared.release();
                    this.exception(e);
                    throw e;
                }
                --size;
                if (this.mSortTreesSize < 64 && !commitLock.hasQueuedThreads()) continue;
                node.releaseExclusive();
                shared.release();
                if (this.mSortTreesSize >= 64) {
                    this.mergeSortTrees();
                }
                if (size <= 0) {
                    return;
                }
                commitLock.acquireShared(shared);
                continue block4;
            } while (size > 0);
            break;
        }
        node.releaseExclusive();
        shared.release();
    }

    @Override
    public _BTree finish() throws IOException {
        try {
            _BTree tree = this.doFinish(null);
            this.finishComplete(true, true);
            return tree;
        }
        catch (Throwable e) {
            this.resetAsync(e);
            throw e;
        }
    }

    @Override
    public Scanner<Entry> finishScan() throws IOException {
        return this.finishScan(new _SortScanner(this.mDatabase));
    }

    @Override
    public Scanner<Entry> finishScan(Scanner<Entry> src) throws IOException {
        return this.finishScan(new _SortScanner(this.mDatabase), src);
    }

    @Override
    public Scanner<Entry> finishScanReverse() throws IOException {
        return this.finishScan(new _SortReverseScanner(this.mDatabase));
    }

    @Override
    public Scanner<Entry> finishScanReverse(Scanner<Entry> src) throws IOException {
        return this.finishScan(new _SortReverseScanner(this.mDatabase), src);
    }

    private Scanner<Entry> finishScan(_SortScanner dst) throws IOException {
        try {
            _BTree tree = this.doFinish(dst);
            if (tree != null) {
                this.finishComplete(true, true);
                dst.ready(tree);
            }
            return dst;
        }
        catch (Throwable e) {
            this.resetAsync(e);
            throw e;
        }
    }

    private Scanner<Entry> finishScan(_SortScanner dst, final Scanner<Entry> src) throws IOException {
        if (src == null) {
            return this.finishScan(dst);
        }
        Runnable addTask = new Runnable(){
            private Object mState = this;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: {
                    Throwable state;
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.mState == null) {
                            break block9;
                        }
                        this.mState = Thread.currentThread();
                    }
                    try {
                        _ParallelSorter.this.addAll(src);
                        state = null;
                    }
                    catch (Throwable e) {
                        state = e;
                    }
                    1 var2_4 = this;
                    synchronized (var2_4) {
                        this.mState = state;
                        this.notifyAll();
                    }
                }
                Utils.closeQuietly(src);
            }

            synchronized void waitUntilFinished() throws InterruptedIOException {
                Object state;
                while ((state = this.mState) != null) {
                    if (state instanceof Throwable) {
                        Throwable t = (Throwable)state;
                        throw Utils.rethrow(t);
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        state = this.mState;
                        this.mState = null;
                        if (state instanceof Thread) {
                            Thread t = (Thread)state;
                            t.interrupt();
                        }
                        InterruptedIOException ex = new InterruptedIOException();
                        if (state instanceof Throwable) {
                            Throwable t = (Throwable)state;
                            ex.addSuppressed(t);
                        }
                        throw ex;
                    }
                }
                return;
            }
        };
        this.mExecutor.execute(addTask);
        dst.notReady(new _SortScanner.Supplier(){
            final /* synthetic */ 1 val$addTask;
            {
                this.val$addTask = var2_2;
            }

            @Override
            public _BTree get() throws IOException {
                try {
                    this.val$addTask.waitUntilFinished();
                    _BTree tree = _ParallelSorter.this.doFinish(null);
                    _ParallelSorter.this.finishComplete(true, true);
                    return tree;
                }
                catch (Throwable e) {
                    _ParallelSorter.this.resetAsync(e);
                    throw e;
                }
            }

            @Override
            public void close() throws IOException {
                _ParallelSorter.this.reset();
            }
        });
        return dst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private _BTree doFinish(_SortScanner dst) throws IOException {
        Level finishLevel;
        _ParallelSorter _ParallelSorter2 = this;
        synchronized (_ParallelSorter2) {
            _BTreeMerger merger;
            _BTree[] allTrees;
            this.checkState();
            this.setState(1);
            this.mFinishCount = 0L;
            try {
                while (this.mMergerCount != 0) {
                    this.wait();
                }
                if (this.mLastMerger != null) {
                    throw new AssertionError();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            Level[] levels = this.stopTreeMergers();
            int numLevelTrees = 0;
            if (levels != null) {
                Level[] levelArray = levels;
                int n = levelArray.length;
                for (int i = 0; i < n; ++i) {
                    Level level;
                    Level level2 = level = levelArray[i];
                    synchronized (level2) {
                        numLevelTrees += level.mSize;
                        continue;
                    }
                }
            }
            _BTree[] sortTrees = this.mSortTrees;
            int size = this.mSortTreesSize;
            this.mSortTrees = null;
            this.mSortTreesSize = 0;
            if (size == 0) {
                if (numLevelTrees == 0) {
                    return this.mDatabase.newTemporaryIndex();
                }
                if (numLevelTrees == 1) {
                    return levels[0].mTrees[0];
                }
                allTrees = new _BTree[numLevelTrees];
            } else {
                _BTree tree;
                if (size == 1) {
                    _Node node;
                    tree = sortTrees[0];
                    CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
                    try {
                        node = this.latchRootDirty(tree);
                    }
                    finally {
                        shared.release();
                    }
                    node.sortLeaf();
                    node.releaseExclusive();
                } else {
                    tree = this.mDatabase.newTemporaryIndex();
                    this.doMergeSortTrees(null, sortTrees, size, tree);
                }
                if (numLevelTrees == 0) {
                    return tree;
                }
                allTrees = new _BTree[numLevelTrees + 1];
                allTrees[numLevelTrees] = tree;
            }
            int i = levels.length;
            int pos = 0;
            while (--i >= 0) {
                Level level = levels[i];
                System.arraycopy(level.mTrees, 0, allTrees, pos, level.mSize);
                pos += level.mSize;
            }
            i = this.mSortTreeLevels.size();
            while (--i >= 1) {
                this.mSortTreeLevels.remove(i);
            }
            finishLevel = levels[0];
            levels = null;
            finishLevel.mSize = 0;
            finishLevel.mMerger = merger = this.newTreeMerger(allTrees, finishLevel, finishLevel);
            merger.start();
            this.mFinishCounter = merger;
        }
        if (dst == null) {
            return finishLevel.waitForFirstTree();
        }
        dst.notReady(new _SortScanner.Supplier(){

            @Override
            public _BTree get() throws IOException {
                try {
                    _BTree tree = finishLevel.waitForFirstTree();
                    _ParallelSorter.this.finishComplete(true, true);
                    return tree;
                }
                catch (Throwable e) {
                    _ParallelSorter.this.resetAsync(e);
                    throw e;
                }
            }

            @Override
            public void close() throws IOException {
                _ParallelSorter.this.reset();
            }
        });
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Level[] stopTreeMergers() throws InterruptedIOException {
        Level[] list = this.mSortTreeLevels;
        if (list == null) {
            return null;
        }
        while (true) {
            Level[] levelArray = list;
            // MONITORENTER : list
            Level[] levels = list.toArray(new Level[list.size()]);
            // MONITOREXIT : levelArray
            for (Level level : levels) {
                level.stop();
            }
            levelArray = levels;
            int n = levelArray.length;
            for (int i = 0; i < n; ++i) {
                Level level;
                Level level2 = level = levelArray[i];
                // MONITORENTER : level2
                level.waitUntilFinished();
                // MONITOREXIT : level2
            }
            levelArray = list;
            // MONITORENTER : list
            if (list.size() <= levels.length) {
                // MONITOREXIT : levelArray
                return levels;
            }
            // MONITOREXIT : levelArray
        }
    }

    private synchronized void finishComplete(boolean checkException, boolean clearException) throws IOException {
        this.mSortTreeLevels = null;
        if (this.mFinishCounter != null) {
            this.mFinishCount = this.mFinishCounter.sum();
            this.mFinishCounter = null;
        }
        if (this.mSortTreePoolSize > 0) {
            do {
                _BTree tree = this.mSortTreePool[--this.mSortTreePoolSize];
                this.mSortTreePool[this.mSortTreePoolSize] = null;
                this.mDatabase.quickDeleteTemporaryTree(tree);
            } while (this.mSortTreePoolSize > 0);
        }
        if (this.mState == 2) {
            if (checkException) {
                this.checkState();
            }
            if (!clearException) {
                return;
            }
        }
        this.setState(0);
        this.mException = null;
    }

    @Override
    public synchronized long progress() {
        return this.mFinishCounter != null ? this.mFinishCounter.sum() : this.mFinishCount;
    }

    @Override
    public void reset() throws IOException {
        this.reset(false);
    }

    private void resetAsync(Throwable cause) {
        try {
            this.mExecutor.execute(() -> {
                try {
                    this.reset(true);
                }
                catch (Throwable e) {
                    Utils.uncaught(e);
                }
            });
        }
        catch (Throwable e) {
            cause.addSuppressed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(boolean isAsync) throws IOException {
        ArrayList<_BTree> toDrop = null;
        _ParallelSorter _ParallelSorter2 = this;
        synchronized (_ParallelSorter2) {
            while (this.mState == 3) {
                if (isAsync) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
            this.setState(3);
            this.mFinishCounter = null;
            this.mFinishCount = 0L;
            try {
                try {
                    while (this.mMergerCount != 0) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                Level[] levels = this.stopTreeMergers();
                if (levels != null) {
                    Level[] levelArray = levels;
                    int n = levelArray.length;
                    for (int i = 0; i < n; ++i) {
                        int size;
                        _BTree[] trees;
                        Level level;
                        Level level2 = level = levelArray[i];
                        synchronized (level2) {
                            trees = level.mTrees;
                            size = level.mSize;
                            level.mSize = 0;
                        }
                        if (size == 0) continue;
                        if (toDrop == null) {
                            toDrop = new ArrayList();
                        }
                        for (int i2 = 0; i2 < size; ++i2) {
                            toDrop.add(trees[i2]);
                        }
                    }
                    this.mSortTreeLevels = null;
                }
                _BTree[] sortTrees = this.mSortTrees;
                int size = this.mSortTreesSize;
                this.mSortTrees = null;
                this.mSortTreesSize = 0;
                if (size != 0) {
                    if (toDrop == null) {
                        toDrop = new ArrayList<_BTree>();
                    }
                    for (int i = 0; i < size; ++i) {
                        toDrop.add(sortTrees[i]);
                    }
                }
            }
            catch (Throwable e) {
                this.exception(e);
                throw e;
            }
        }
        try {
            if (toDrop != null) {
                if (toDrop.size() == 1) {
                    ((_BTree)toDrop.get(0)).drop(false).run();
                } else {
                    this.runDropTasks(toDrop);
                }
            }
            this.finishComplete(false, !isAsync);
        }
        catch (Throwable e) {
            this.exception(e);
            throw e;
        }
    }

    private void runDropTasks(final List<_BTree> toDrop) throws IOException {
        final int numThreads = Math.min(toDrop.size(), MERGE_THREAD_COUNT);
        var controller = new Runnable(){
            private int mPos;
            private int mActive;
            {
                this.mActive = numThreads;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    _BTree tree;
                    4 var2_2 = this;
                    synchronized (var2_2) {
                        int pos = this.mPos;
                        if (pos >= toDrop.size()) {
                            this.inactive();
                            return;
                        }
                        tree = (_BTree)toDrop.get(pos);
                        this.mPos = pos + 1;
                    }
                    try {
                        tree.drop(false).run();
                        continue;
                    }
                    catch (Throwable e) {
                        this.inactive();
                        if (_ParallelSorter.this.mDatabase.isClosed()) continue;
                        Utils.rethrow(e);
                        continue;
                    }
                    break;
                }
            }

            synchronized void waitUntilFinished() throws InterruptedIOException {
                while (this.mActive > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
            }

            private synchronized void inactive() {
                if (--this.mActive <= 0) {
                    this.notifyAll();
                }
            }
        };
        for (int i = 1; i < numThreads; ++i) {
            this.mExecutor.execute(controller);
        }
        controller.run();
        controller.waitUntilFinished();
    }

    @Override
    public _Node newNode() throws IOException {
        if (this.mSortTreesSize >= this.mSortTrees.length) {
            this.mSortTrees = Arrays.copyOf(this.mSortTrees, 64);
        }
        _BTree sortTree = this.allocSortTree();
        this.mSortTrees[this.mSortTreesSize++] = sortTree;
        return sortTree.mRoot;
    }

    private _BTree allocSortTree() throws IOException {
        _Node root;
        _BTree tree;
        this.checkState();
        int size = this.mSortTreePoolSize;
        if (size > 0) {
            tree = this.mSortTreePool[--size];
            this.mSortTreePoolSize = size;
            root = this.latchRootDirty(tree);
        } else {
            tree = this.mDatabase.newTemporaryTree(true);
            root = tree.mRoot;
        }
        root.asSortLeaf();
        return tree;
    }

    private _Node latchRootDirty(_BTree tree) throws IOException {
        _Node root = tree.mRoot;
        root.acquireExclusive();
        try {
            this.mDatabase.markDirty(tree, root);
            return root;
        }
        catch (Throwable e) {
            root.releaseExclusive();
            throw e;
        }
    }

    private void mergeSortTrees() throws IOException {
        Merger merger;
        _BTree dest = this.mDatabase.newTemporaryIndex();
        _BTree[] sortTrees = this.mSortTrees;
        int size = this.mSortTreesSize;
        this.mSortTrees = new _BTree[64];
        this.mSortTreesSize = 0;
        if (this.mSortTreeLevels == null) {
            this.mSortTreeLevels = new ArrayList<Level>();
        }
        this.mLastMerger = merger = new Merger(this.mLastMerger, sortTrees, size, dest);
        try {
            while (this.mMergerCount >= MERGE_THREAD_COUNT) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        ++this.mMergerCount;
        this.mExecutor.execute(merger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMergeSortTrees(Merger merger, _BTree[] sortTrees, int size, _BTree dest) throws IOException {
        Throwable ex = null;
        _BTreeCursor appender = dest.newCursor(Transaction.BOGUS);
        try {
            appender.firstLeaf();
            CommitLock commitLock = this.mDatabase.commitLock();
            CommitLock.Shared shared = commitLock.acquireShared();
            try {
                _BTree sortTree;
                int i;
                this.mDatabase.checkClosed();
                for (i = 0; i < size; ++i) {
                    _Node node = this.latchRootDirty(sortTrees[i]);
                    node.sortLeaf();
                    node.garbage(i << 1);
                }
                i = size >>> 1;
                while (--i >= 0) {
                    _ParallelSorter.siftDown(sortTrees, size, i, sortTrees[i]);
                }
                if (commitLock.hasQueuedThreads()) {
                    shared.release();
                    shared = commitLock.acquireShared();
                    for (i = 0; i < size; ++i) {
                        sortTree = sortTrees[i];
                        this.mDatabase.markDirty(sortTree, sortTree.mRoot);
                    }
                }
                int len = size;
                while (true) {
                    sortTree = sortTrees[0];
                    _Node node = sortTree.mRoot;
                    int order = node.garbage();
                    if ((order & 1) == 0) {
                        appender.appendTransfer(node);
                    } else {
                        node.deleteFirstSortLeafEntry();
                        node.garbage(order & 0xFFFFFFFE);
                    }
                    if (!node.hasKeys()) {
                        if (--len == 0) {
                            break;
                        }
                        _BTree last = sortTrees[len];
                        sortTrees[len] = sortTree;
                        sortTree = last;
                    }
                    _ParallelSorter.siftDown(sortTrees, len, 0, sortTree);
                }
            }
            finally {
                shared.release();
            }
        }
        catch (Throwable e) {
            ex = e;
        }
        finally {
            appender.reset();
        }
        for (int i = 0; i < size; ++i) {
            sortTrees[i].mRoot.releaseExclusive();
        }
        _ParallelSorter _ParallelSorter2 = this;
        synchronized (_ParallelSorter2) {
            if (this.mSortTreePool == null || this.mSortTreePoolSize == 0) {
                this.mSortTreePool = sortTrees;
                this.mSortTreePoolSize = size;
            } else {
                int totalSize = this.mSortTreePoolSize + size;
                if (totalSize > this.mSortTreePool.length) {
                    this.mSortTreePool = Arrays.copyOf(this.mSortTreePool, totalSize);
                }
                System.arraycopy(sortTrees, 0, this.mSortTreePool, this.mSortTreePoolSize, size);
                this.mSortTreePoolSize = totalSize;
            }
            if (merger != null) {
                merger.mSortTrees = null;
                merger.mSize = 0;
                Merger prev = merger.mPrev;
                if (prev != null && prev.mDest != null) {
                    prev.mNext = merger;
                    return;
                }
                while (true) {
                    this.addToLevel(this.selectLevel(0), 256, merger.mDest);
                    merger.mDest = null;
                    merger.mPrev = null;
                    --this.mMergerCount;
                    Merger next = merger.mNext;
                    if (next == null) {
                        if (this.mLastMerger != merger) break;
                        if (this.mMergerCount != 0) {
                            throw new AssertionError();
                        }
                        this.mLastMerger = null;
                        break;
                    }
                    merger = next;
                }
                this.notifyAll();
            }
        }
        if (ex != null) {
            Utils.rethrow(ex);
        }
    }

    private static void siftDown(_BTree[] sortTrees, int size, int pos, _BTree element) throws IOException {
        int half = size >>> 1;
        while (pos < half) {
            int childPos = (pos << 1) + 1;
            _BTree child = sortTrees[childPos];
            int rightPos = childPos + 1;
            if (rightPos < size && _ParallelSorter.compareSortTrees(child, sortTrees[rightPos]) > 0) {
                childPos = rightPos;
                child = sortTrees[childPos];
            }
            if (_ParallelSorter.compareSortTrees(element, child) <= 0) break;
            sortTrees[pos] = child;
            pos = childPos;
        }
        sortTrees[pos] = element;
    }

    private static int compareSortTrees(_BTree leftTree, _BTree rightTree) throws IOException {
        _Node left = leftTree.mRoot;
        _Node right = rightTree.mRoot;
        int compare = _Node.compareKeys(left, DirectPageOps.p_ushortGetLE(left.mPage, left.searchVecStart()), right, DirectPageOps.p_ushortGetLE(right.mPage, right.searchVecStart()));
        if (compare == 0) {
            int rightOrder;
            int leftOrder = left.garbage();
            if (leftOrder < (rightOrder = right.garbage())) {
                left.garbage(leftOrder | 1);
                compare = -1;
            } else {
                right.garbage(rightOrder | 1);
                compare = 1;
            }
        }
        return compare;
    }

    private Level selectLevel(int levelNum) {
        return _ParallelSorter.selectLevel(levelNum, this.mSortTreeLevels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Level selectLevel(int levelNum, List<Level> levels) {
        List<Level> list = levels;
        synchronized (list) {
            if (levelNum < levels.size()) {
                return levels.get(levelNum);
            }
            Level level = new Level(levelNum);
            levels.add(level);
            return level;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLevel(Level level, int maxSize, _BTree tree) {
        _BTreeMerger merger;
        try {
            Level level2 = level;
            synchronized (level2) {
                _BTree[] trees = level.mTrees;
                int size = level.mSize;
                if (size >= trees.length) {
                    trees = Arrays.copyOfRange(trees, 0, trees.length << 1);
                    level.mTrees = trees;
                }
                trees[size++] = tree;
                if (size < maxSize || level.mStopped) {
                    level.mSize = size;
                    return;
                }
                Level nextLevel = this.selectLevel(level.mLevelNum + 1);
                level.mSize = 0;
                trees = (_BTree[])trees.clone();
                merger = this.newTreeMerger(trees, level, nextLevel);
                level.waitUntilFinished();
                level.mMerger = merger;
            }
        }
        catch (Throwable e) {
            this.exception(e);
            return;
        }
        try {
            merger.start();
        }
        catch (Throwable e) {
            level.finished(merger);
            throw e;
        }
    }

    private _BTreeMerger newTreeMerger(_BTree[] trees, final Level level, final Level nextLevel) {
        return new _BTreeMerger(this.mDatabase, trees, this.mExecutor, MERGE_THREAD_COUNT){

            @Override
            protected void merged(_BTree tree) {
                _ParallelSorter.this.addToLevel(nextLevel, 1024, tree);
            }

            @Override
            protected void remainder(_BTree tree) {
                if (tree != null) {
                    _ParallelSorter.this.addToLevel(nextLevel, 1024, tree);
                } else {
                    Throwable ex = this.exceptionCheck();
                    if (ex != null) {
                        _ParallelSorter.this.exception(ex);
                    }
                    level.finished(this);
                }
            }
        };
    }

    private void checkState() throws InterruptedIOException {
        if (this.mState != 0) {
            switch (this.mState) {
                case 1: {
                    throw new IllegalStateException("Finish in progress");
                }
                case 2: {
                    Throwable e = this.mException;
                    if (e == null) break;
                    Utils.addLocalTrace(e);
                    throw Utils.rethrow(e);
                }
            }
            throw new InterruptedIOException("Sorter is reset");
        }
    }

    private synchronized void exception(Throwable e) {
        if (this.mException == null) {
            this.mException = e;
        }
        this.setState(2);
    }

    private void setState(int state) {
        this.mState = state;
        this.notifyAll();
    }

    private final class Merger
    implements Runnable {
        private _BTree[] mSortTrees;
        private int mSize;
        private _BTree mDest;
        Merger mPrev;
        Merger mNext;

        Merger(Merger prev, _BTree[] sortTrees, int size, _BTree dest) {
            this.mPrev = prev;
            this.mSortTrees = sortTrees;
            this.mSize = size;
            this.mDest = dest;
        }

        @Override
        public void run() {
            try {
                _ParallelSorter.this.doMergeSortTrees(this, this.mSortTrees, this.mSize, this.mDest);
            }
            catch (Throwable e) {
                _ParallelSorter.this.exception(e);
            }
        }
    }

    private static final class Level {
        final int mLevelNum;
        _BTree[] mTrees;
        int mSize;
        _BTreeMerger mMerger;
        boolean mStopped;

        Level(int levelNum) {
            this.mLevelNum = levelNum;
            this.mTrees = new _BTree[8];
        }

        synchronized void stop() {
            this.mStopped = true;
            if (this.mMerger != null) {
                this.mMerger.stop();
            }
        }

        void waitUntilFinished() throws InterruptedIOException {
            try {
                while (this.mMerger != null) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }

        synchronized _BTree waitForFirstTree() throws InterruptedIOException {
            this.waitUntilFinished();
            return this.mTrees[0];
        }

        synchronized void finished(_BTreeMerger merger) {
            if (merger == this.mMerger) {
                this.mMerger = null;
                this.notifyAll();
            }
        }
    }
}

