/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import org.cojen.tupl.core._PendingTxn;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.LatchCondition;
import org.cojen.tupl.util.Runner;

final class _PendingTxnFinisher
extends Latch
implements Runnable {
    private final int mMaxThreads;
    private final LatchCondition mIdleCondition;
    private _PendingTxn mFirst;
    private _PendingTxn mLast;
    private int mTotalThreads;

    _PendingTxnFinisher(int maxThreads) {
        this.mMaxThreads = maxThreads;
        this.mIdleCondition = new LatchCondition();
    }

    void enqueue(_PendingTxn first, _PendingTxn last) {
        this.acquireExclusive();
        try {
            if (this.mLast == null) {
                this.mFirst = first;
            } else {
                this.mLast.setNextPlain(first);
            }
            this.mLast = last;
            if (this.mIdleCondition.isEmpty() && this.mTotalThreads < this.mMaxThreads) {
                Runner.start("PendingTxnFinisher", this);
                ++this.mTotalThreads;
            } else {
                this.mIdleCondition.signal(this);
            }
        }
        finally {
            this.releaseExclusive();
        }
    }

    void interrupt() {
        this.acquireExclusive();
        try {
            this.mIdleCondition.signalAll(this);
        }
        finally {
            this.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            _PendingTxn pending;
            boolean waited = false;
            this.acquireExclusive();
            try {
                while (true) {
                    if ((pending = this.mFirst) != null) {
                        if (pending == this.mLast) {
                            this.mFirst = null;
                            this.mLast = null;
                        } else {
                            this.mFirst = pending.getNextPlain();
                        }
                        break;
                    }
                    if (waited) {
                        --this.mTotalThreads;
                        return;
                    }
                    long nanosTimeout = 10000000000L;
                    long nanosEnd = System.nanoTime() + nanosTimeout;
                    this.mIdleCondition.priorityAwait(this, nanosTimeout, nanosEnd);
                    waited = true;
                }
            }
            finally {
                this.releaseExclusive();
            }
            pending.run();
        }
    }
}

