/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.tupl.DeadlockException;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.CoreTransaction;
import org.cojen.tupl.core.DeadlockInfoSet;
import org.cojen.tupl.core.DetachedDeadlockInfo;
import org.cojen.tupl.core.DetachedLock;
import org.cojen.tupl.core.RowPredicate;
import org.cojen.tupl.core.RowPredicateLock;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._CursorFrame;
import org.cojen.tupl.core._DeadlockDetector;
import org.cojen.tupl.core._DetachedLockImpl;
import org.cojen.tupl.core._LocalTransaction;
import org.cojen.tupl.core._Lock;
import org.cojen.tupl.core._LockManager;
import org.cojen.tupl.core._Locker;
import org.cojen.tupl.diag.DeadlockInfo;
import org.cojen.tupl.util.LatchCondition;

final class _RowPredicateLockImpl<R>
implements RowPredicateLock<R> {
    private final _LockManager mManager;
    private final long mIndexId;
    private final ThreadLocal<Integer> mVersionStripe;
    private static final int cNumStripes = Runtime.getRuntime().availableProcessors();
    private volatile StripedVersionLock mNewestVersion;
    private static final VarHandle cNewestVersionHandle;
    private static final VarHandle cLockNextHandle;
    private volatile Evaluator<R> mLastEvaluator;
    private static final VarHandle cLastEvaluatorHandle;
    private static final VarHandle cNextHandle;

    _RowPredicateLockImpl(_LockManager manager, long indexId) {
        this.mManager = manager;
        this.mIndexId = indexId;
        this.mVersionStripe = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return ThreadLocalRandom.current().nextInt(cNumStripes);
            }
        };
        this.mNewestVersion = this.newVersion();
    }

    private StripedVersionLock newVersion() {
        StripedVersionLock version = new StripedVersionLock();
        this.mManager.initDetachedLock(version, null);
        return version;
    }

    @Override
    public RowPredicateLock.Closer openAcquire(Transaction txn, R row) throws IOException {
        if (txn.lockMode() == LockMode.UNSAFE) {
            return RowPredicateLock.NonCloser.THE;
        }
        _LocalTransaction local = (_LocalTransaction)txn;
        VersionLock version = this.mNewestVersion.select(this);
        if (version.acquireNoPush(local)) {
            local.push(version);
        }
        try {
            Evaluator<R> e = this.mLastEvaluator;
            while (e != null) {
                if (e.test(row)) {
                    e.matchAcquire(local);
                }
                e = e.mPrev;
            }
            return version;
        }
        catch (Throwable e) {
            version.close();
            throw e;
        }
    }

    @Override
    public RowPredicateLock.Closer openAcquireP(Transaction txn, R row, byte[] key, byte[] value) throws IOException {
        if (txn.lockMode() == LockMode.UNSAFE) {
            return RowPredicateLock.NonCloser.THE;
        }
        _LocalTransaction local = (_LocalTransaction)txn;
        VersionLock version = this.mNewestVersion.select(this);
        if (version.acquireNoPush(local)) {
            local.push(version);
        }
        try {
            Evaluator<R> e = this.mLastEvaluator;
            while (e != null) {
                if (e.testP(row, key, value)) {
                    e.matchAcquire(local);
                }
                e = e.mPrev;
            }
            return version;
        }
        catch (Throwable e) {
            version.close();
            throw e;
        }
    }

    @Override
    public RowPredicateLock.Closer tryOpenAcquire(Transaction txn, R row, byte[] key, byte[] value) throws IOException {
        RowPredicateLock.Closer closer;
        if (txn.lockMode() == LockMode.UNSAFE) {
            return RowPredicateLock.NonCloser.THE;
        }
        _LocalTransaction local = (_LocalTransaction)txn;
        VersionLock version = this.mNewestVersion.select(this);
        if (version.acquireNoPush(local)) {
            local.push(version);
            closer = version;
        } else {
            closer = RowPredicateLock.NonCloser.THE;
        }
        try {
            Evaluator<R> e = this.mLastEvaluator;
            while (e != null) {
                if (!(row == null ? !e.test(key, value) : !e.test(row))) {
                    LockResult result = e.tryMatchAcquire(local);
                    if (result == LockResult.ACQUIRED) {
                        txn.unlockCombine();
                        closer = version;
                    } else if (!result.isHeld()) {
                        if (closer == version) {
                            txn.unlock();
                        }
                        return null;
                    }
                }
                e = e.mPrev;
            }
            return closer;
        }
        catch (Throwable e) {
            version.close();
            throw e;
        }
    }

    @Override
    public Object acquireLocksNoPush(Transaction txn, byte[] key, byte[] value) throws LockFailureException {
        _LocalTransaction local = (_LocalTransaction)txn;
        _Lock[] locks = null;
        int numLocks = 0;
        VersionLock version = this.mNewestVersion.select(this);
        if (version.acquireNoPush(local)) {
            locks = version;
            numLocks = 1;
        }
        try {
            _Lock e = this.mLastEvaluator;
            while (true) {
                block22: {
                    _Lock lock;
                    block21: {
                        block20: {
                            if (e != null) break block20;
                            lock = local.doLockUpgradableNoPush(this.mIndexId, key);
                            break block21;
                        }
                        if (!e.test(key, value)) break block22;
                        lock = e.matchAcquireNoPush(local);
                    }
                    if (lock != null) {
                        if (locks == null) {
                            locks = lock;
                        } else if (locks instanceof _Lock) {
                            _Lock first = (_Lock)locks;
                            array = new _Lock[4];
                            array[0] = first;
                            array[1] = lock;
                            locks = array;
                        } else {
                            array = locks;
                            if (numLocks >= array.length) {
                                _Lock[] newArray = new _Lock[array.length << 1];
                                System.arraycopy(array, 0, newArray, 0, array.length);
                                array = newArray;
                            }
                            array[numLocks] = lock;
                        }
                        ++numLocks;
                    }
                    if (e == null) break;
                }
                e = e.mPrev;
            }
            e = locks;
            return e;
        }
        catch (Exception e) {
            if (locks != null) {
                if (locks instanceof _Lock) {
                    _Lock lock = (_Lock)locks;
                    this.unlockUnowned(lock);
                } else {
                    for (_Lock lock : (_Lock[])locks) {
                        this.unlockUnowned(lock);
                    }
                }
            }
            throw e;
        }
        finally {
            version.close();
        }
    }

    private void unlockUnowned(_Lock lock) {
        _LockManager.Bucket bucket = this.mManager.getBucket(lock.mHashCode);
        bucket.acquireExclusive();
        try {
            if (lock instanceof DetachedLock) {
                lock.doUnlock(null, bucket);
            } else {
                lock.doUnlockOwnedUnrestricted(bucket);
            }
        }
        finally {
            bucket.releaseExclusive();
        }
    }

    @Override
    public void redoPredicateMode(Transaction txn) throws IOException {
        ((CoreTransaction)txn).redoPredicateMode();
    }

    @Override
    public RowPredicateLock.Closer addPredicate(Transaction txn, RowPredicate<R> predicate) throws LockFailureException {
        if (predicate instanceof Evaluator) {
            Evaluator evaluator = (Evaluator)predicate;
            this.addEvaluator(txn, evaluator);
            return evaluator;
        }
        return this.addNonEvaluator(txn, predicate);
    }

    private Evaluator addNonEvaluator(Transaction txn, final RowPredicate<R> predicate) throws LockFailureException {
        if (predicate instanceof RowPredicate.None) {
            return null;
        }
        Evaluator evaluator = new Evaluator<R>(){

            @Override
            public boolean test(R row) {
                return predicate.test(row);
            }

            @Override
            public boolean test(byte[] key, byte[] value) {
                return predicate.test(key, value);
            }

            @Override
            public boolean test(byte[] key) {
                return predicate.test(key);
            }

            public String toString() {
                return predicate.toString();
            }
        };
        this.addEvaluator(txn, evaluator);
        return evaluator;
    }

    @Override
    public RowPredicateLock.Closer addGuard(Transaction txn) throws LockFailureException {
        Guard guard = new Guard();
        this.addEvaluator(txn, guard);
        return guard;
    }

    private void addEvaluator(Transaction txn, Evaluator<R> evaluator) throws LockFailureException {
        _LocalTransaction local = (_LocalTransaction)txn;
        evaluator.mLock = this;
        this.mManager.initDetachedLock(evaluator, local);
        evaluator.mNext = evaluator;
        int trials = _CursorFrame.SPIN_LIMIT;
        while (true) {
            Evaluator<R> last = this.mLastEvaluator;
            evaluator.mPrev = last;
            if (last == null) {
                if (cLastEvaluatorHandle.compareAndSet(this, null, evaluator)) {
                    break;
                }
            } else if (last.mNext == last && cNextHandle.compareAndSet(last, last, evaluator)) {
                while (this.mLastEvaluator != last) {
                    Thread.onSpinWait();
                }
                this.mLastEvaluator = evaluator;
                break;
            }
            if (--trials < 0) {
                Thread.yield();
                trials = _CursorFrame.SPIN_LIMIT << 1;
                continue;
            }
            Thread.onSpinWait();
        }
        try {
            StripedVersionLock version;
            StripedVersionLock newVersion = this.newVersion();
            while (true) {
                version = this.mNewestVersion;
                newVersion.mLockNext = version;
                if (cNewestVersionHandle.compareAndSet(this, version, newVersion)) break;
                Thread.onSpinWait();
            }
            StripedVersionLock newerVersion = null;
            while (true) {
                boolean discard = version.await(this.mIndexId, evaluator, local);
                _Lock olderVersion = version.mLockNext;
                if (discard && newerVersion != null) {
                    cLockNextHandle.weakCompareAndSet(newerVersion, version, olderVersion);
                }
                if (olderVersion == null) break;
                newerVersion = version;
                version = (StripedVersionLock)olderVersion;
            }
            evaluator.acquireExclusive();
        }
        catch (Throwable e) {
            this.remove(evaluator);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withExclusiveNoRedo(Transaction txn, Runnable mustWait, Runnable callback) throws IOException {
        _LocalTransaction local = (_LocalTransaction)txn;
        local.enter();
        try {
            Evaluator all = this.addNonEvaluator(local, RowPredicate.all());
            VersionLock version = this.mNewestVersion.select(this);
            if (version.acquireNoPush(local)) {
                local.push(version);
            }
            try {
                Evaluator<R> e = this.mLastEvaluator;
                while (e != null) {
                    if (e != all) {
                        if (mustWait != null) {
                            mustWait.run();
                            mustWait = null;
                        }
                        e.acquireShared(local);
                    }
                    e = e.mPrev;
                }
                callback.run();
            }
            finally {
                version.close();
            }
        }
        finally {
            txn.exit();
        }
    }

    @Override
    public int countPredicates() {
        int count = 0;
        Evaluator<R> e = this.mLastEvaluator;
        while (e != null) {
            ++count;
            e = e.mPrev;
        }
        return count;
    }

    @Override
    public Class<? extends RowPredicate<R>> evaluatorClass() {
        return Evaluator.class;
    }

    private void remove(Evaluator<R> lock) {
        int trials = _CursorFrame.SPIN_LIMIT;
        Evaluator n;
        while ((n = lock.mNext) != null) {
            if (n == lock) {
                if (cNextHandle.compareAndSet(lock, n, null)) {
                    Evaluator p;
                    while (!((p = lock.mPrev) == null || p.mNext == lock && cNextHandle.compareAndSet(p, lock, p))) {
                    }
                    while (this.mLastEvaluator != lock) {
                        Thread.onSpinWait();
                    }
                    this.mLastEvaluator = p;
                    return;
                }
            } else if (n.mPrev == lock && cNextHandle.compareAndSet(lock, n, null)) {
                Evaluator p;
                while (!((p = lock.mPrev) == null || p.mNext == lock && cNextHandle.compareAndSet(p, lock, n))) {
                }
                n.mPrev = p;
                return;
            }
            if (--trials < 0) {
                Thread.yield();
                trials = _CursorFrame.SPIN_LIMIT << 1;
                continue;
            }
            Thread.onSpinWait();
        }
        return;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cNewestVersionHandle = lookup.findVarHandle(_RowPredicateLockImpl.class, "mNewestVersion", StripedVersionLock.class);
            cLockNextHandle = lookup.findVarHandle(_Lock.class, "mLockNext", _Lock.class);
            cLastEvaluatorHandle = lookup.findVarHandle(_RowPredicateLockImpl.class, "mLastEvaluator", Evaluator.class);
            cNextHandle = lookup.findVarHandle(Evaluator.class, "mNext", Evaluator.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static final class StripedVersionLock
    extends VersionLock {
        private VersionLock[] mStripes;
        private static final VarHandle cStripesHandle;
        private static final VarHandle cStripesElementHandle;

        private StripedVersionLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        VersionLock select(_RowPredicateLockImpl<?> parent) {
            VersionLock[] stripes;
            VersionLock lock;
            int which;
            VersionLock[] stripes2 = cStripesHandle.getOpaque(this);
            if (stripes2 == null) {
                if (this.mBucket.tryAcquireExclusive()) {
                    return this;
                }
                which = parent.mVersionStripe.get();
            } else {
                which = parent.mVersionStripe.get();
                lock = cStripesElementHandle.getAcquire(stripes2, which);
                if (lock != null && lock.mBucket.tryAcquireExclusive()) {
                    return lock;
                }
                which = ThreadLocalRandom.current().nextInt(cNumStripes);
                parent.mVersionStripe.set(which);
                lock = cStripesElementHandle.getAcquire(stripes2, which);
                if (lock != null) {
                    lock.mBucket.acquireExclusive();
                    return lock;
                }
            }
            do {
                block14: {
                    _LockManager.Bucket bucket = this.mBucket;
                    bucket.acquireExclusive();
                    stripes = this.mStripes;
                    try {
                        if (stripes == null) {
                            stripes = new VersionLock[cNumStripes];
                            cStripesHandle.setOpaque(this, stripes);
                        } else {
                            lock = stripes[which];
                            if (lock != null) break block14;
                        }
                        lock = new VersionLock();
                        parent.mManager.initDetachedLock(lock, null);
                        cStripesElementHandle.setRelease(stripes, which, lock);
                    }
                    finally {
                        bucket.releaseExclusive();
                    }
                }
                if (lock.mBucket.tryAcquireExclusive()) {
                    return lock;
                }
                which = ThreadLocalRandom.current().nextInt(cNumStripes);
                parent.mVersionStripe.set(which);
            } while ((lock = cStripesElementHandle.getAcquire(stripes, which)) == null);
            lock.mBucket.acquireExclusive();
            return lock;
        }

        boolean await(long indexId, Evaluator<?> evaluator, _LocalTransaction txn) throws LockFailureException {
            boolean result = true;
            VersionLock[] stripes = cStripesHandle.getOpaque(this);
            if (stripes != null) {
                for (int i = 0; i < stripes.length; ++i) {
                    VersionLock lock = cStripesElementHandle.getAcquire(stripes, i);
                    if (lock == null) continue;
                    result &= lock.doAwait(indexId, evaluator, txn);
                }
            }
            return result & this.doAwait(indexId, evaluator, txn);
        }

        static {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                cStripesHandle = lookup.findVarHandle(StripedVersionLock.class, "mStripes", VersionLock[].class);
                cStripesElementHandle = MethodHandles.arrayElementVarHandle(VersionLock[].class);
            }
            catch (Throwable e) {
                throw Utils.rethrow(e);
            }
        }
    }

    private static class VersionLock
    extends _DetachedLockImpl
    implements RowPredicateLock.Closer {
        private static final VarHandle cIndexIdHandle;
        private static final VarHandle cQueueUHandle;

        private VersionLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean acquireNoPush(_Locker locker) {
            try {
                int count = this.mLockCount;
                if (count == -1) {
                    throw new IllegalStateException();
                }
                cIndexIdHandle.getAndAdd(this, 1L);
                if (count != 0 && this.isSharedLocker(locker)) {
                    boolean bl = false;
                    return bl;
                }
                this.addSharedLocker(count, locker);
            }
            finally {
                this.mBucket.releaseExclusive();
            }
            return true;
        }

        @Override
        public final void close() {
            if (cIndexIdHandle.getAndAdd(this, -1L) == 1L) {
                this.signalQueueU();
            }
        }

        private void signalQueueU() {
            LatchCondition queue = cQueueUHandle.getAcquire(this);
            if (queue != null) {
                _LockManager.Bucket bucket = this.mBucket;
                bucket.acquireExclusive();
                try {
                    queue.signalAll(bucket);
                }
                finally {
                    bucket.releaseExclusive();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean doAwait(long indexId, Evaluator<?> evaluator, _LocalTransaction txn) throws LockFailureException {
            DetachedDeadlockInfo deadlock;
            int w;
            _Lock conflict;
            block43: {
                _LockManager.Bucket bucket;
                block42: {
                    block45: {
                        Object lockers;
                        block46: {
                            LatchCondition queue;
                            if (cLockCountHandle.getAcquire(this) == Integer.MIN_VALUE) {
                                return true;
                            }
                            bucket = this.mBucket;
                            bucket.acquireExclusive();
                            try {
                                if (this.mLockCount == Integer.MIN_VALUE) {
                                    bucket.releaseExclusive();
                                    return true;
                                }
                                queue = this.mQueueSX;
                                if (queue == null) {
                                    this.mQueueSX = queue = new LatchCondition();
                                }
                            }
                            catch (Throwable e) {
                                bucket.releaseExclusive();
                                throw e;
                            }
                            if (cIndexIdHandle.getVolatile(this) != 0L) {
                                queue = this.mQueueU;
                                if (queue == null) {
                                    try {
                                        queue = new LatchCondition();
                                        cQueueUHandle.setRelease(this, queue);
                                    }
                                    catch (Throwable e) {
                                        bucket.releaseExclusive();
                                        throw e;
                                    }
                                }
                                if (cIndexIdHandle.getVolatile(this) != 0L) {
                                    int w2 = queue.await(bucket, txn.mLockTimeoutNanos);
                                    if (this.mLockCount == Integer.MIN_VALUE) {
                                        bucket.releaseExclusive();
                                        return true;
                                    }
                                    if (w2 <= 0 && cIndexIdHandle.getVolatile(this) != 0L) {
                                        bucket.releaseExclusive();
                                        throw VersionLock.failed(txn, w2);
                                    }
                                }
                            }
                            bucket.downgrade();
                            try {
                                lockers = this.copyLockers();
                            }
                            finally {
                                bucket.releaseShared();
                            }
                            if (lockers == null) break block45;
                            if (!(lockers instanceof _Locker)) break block46;
                            _Locker locker = (_Locker)lockers;
                            if (locker == txn || (conflict = VersionLock.findAnyConflict(locker, indexId, evaluator)) == null) break block45;
                            break block42;
                        }
                        for (_Locker locker : (_Locker[])lockers) {
                            if (locker == txn) continue;
                            conflict = VersionLock.findAnyConflict(locker, indexId, evaluator);
                            if (conflict == null) {
                                if (cLockCountHandle.getAcquire(this) != Integer.MIN_VALUE) continue;
                                return true;
                            }
                            break block42;
                        }
                    }
                    return false;
                }
                if (cLockCountHandle.getAcquire(this) == Integer.MIN_VALUE) {
                    return true;
                }
                bucket.acquireExclusive();
                try {
                    LatchCondition queueSX = this.mQueueSX;
                    if (queueSX == null) {
                        w = -1;
                        deadlock = null;
                        break block43;
                    }
                    if (this.mOwner == null) {
                        if (this.claimOwnership(txn) > 0) {
                            var12_16 = 1;
                            return var12_16 != 0;
                        }
                    } else {
                        if (this.mLockCount == Integer.MIN_VALUE) {
                            var12_16 = 1;
                            return var12_16 != 0;
                        }
                        if (this.isSharedLocker(txn)) {
                            String desc = String.valueOf(this.mOwner.mWaitingFor);
                            deadlock = new DetachedDeadlockInfo(desc, this.mOwner.attachment());
                            w = 0;
                            break block43;
                        }
                    }
                    try {
                        txn.mWaitingFor = evaluator;
                        w = queueSX.await(bucket, txn.mLockTimeoutNanos);
                    }
                    finally {
                        if (this.mOwner == txn) {
                            this.addSharedLocker(this.mLockCount, txn);
                            this.mOwner = null;
                        }
                    }
                    queueSX = this.mQueueSX;
                    if (queueSX == null) {
                        txn.mWaitingFor = null;
                        w = -1;
                        deadlock = null;
                    } else {
                        if (w > 0) {
                            txn.mWaitingFor = null;
                            queueSX.signalAll(bucket);
                            boolean desc = true;
                            return desc;
                        }
                        deadlock = null;
                    }
                }
                finally {
                    bucket.releaseExclusive();
                }
            }
            if (deadlock != null) {
                DeadlockInfo[] infos = new DeadlockInfo[2];
                infos[0] = deadlock;
                Object attachment = conflict.findOwnerAttachment(txn, false, -1);
                infos[1] = _DeadlockDetector.newDeadlockInfo(txn.mManager, conflict, attachment);
                throw new DeadlockException(0L, deadlock.ownerAttachment(), true, new DeadlockInfoSet(infos));
            }
            throw VersionLock.failed(txn, w);
        }

        private static _Lock findAnyConflict(_Locker locker, long indexId, Evaluator<?> evaluator) {
            return evaluator.hasMatched() ? evaluator : locker.findAnyConflict(indexId, evaluator);
        }

        private static LockFailureException failed(_LocalTransaction txn, int w) throws DeadlockException {
            LockResult result = w < 0 ? LockResult.INTERRUPTED : LockResult.TIMED_OUT_LOCK;
            return txn.failed(-1, result, txn.mLockTimeoutNanos);
        }

        static {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                cIndexIdHandle = lookup.findVarHandle(VersionLock.class, "mIndexId", Long.TYPE);
                cQueueUHandle = lookup.findVarHandle(VersionLock.class, "mQueueU", LatchCondition.class);
            }
            catch (Throwable e) {
                throw Utils.rethrow(e);
            }
        }
    }

    public static abstract class Evaluator<R>
    extends _DetachedLockImpl
    implements RowPredicate<R>,
    RowPredicateLock.Closer {
        private _RowPredicateLockImpl<R> mLock;
        private volatile Evaluator<R> mNext;
        private volatile Evaluator<R> mPrev;
        private boolean mMatched;
        private static final VarHandle cMatchedHandle;

        @Override
        protected final void doUnlockOwnedUnrestricted(_LockManager.Bucket bucket) {
            super.doUnlockOwnedUnrestricted(bucket);
            this.mLock.remove(this);
        }

        final void matchAcquire(_LocalTransaction txn) throws LockFailureException {
            cMatchedHandle.weakCompareAndSetPlain(this, false, true);
            this.acquireShared(txn);
        }

        final LockResult tryMatchAcquire(_LocalTransaction txn) throws LockFailureException {
            cMatchedHandle.weakCompareAndSetPlain(this, false, true);
            return this.tryAcquireShared(txn, 0L);
        }

        final _Lock matchAcquireNoPush(_LocalTransaction txn) throws LockFailureException {
            cMatchedHandle.weakCompareAndSetPlain(this, false, true);
            return this.acquireSharedNoPush(txn);
        }

        final boolean hasMatched() {
            return cMatchedHandle.getOpaque(this);
        }

        @Override
        public void close() {
            _LockManager.Bucket bucket = this.mBucket;
            bucket.acquireExclusive();
            this.doUnlockOwnedUnrestricted(bucket);
        }

        static {
            try {
                cMatchedHandle = MethodHandles.lookup().findVarHandle(Evaluator.class, "mMatched", Boolean.TYPE);
            }
            catch (Throwable e) {
                throw Utils.rethrow(e);
            }
        }
    }

    private static final class Guard<R>
    extends Evaluator<R> {
        private Guard() {
        }

        @Override
        public boolean test(R row) {
            return false;
        }

        @Override
        public boolean test(byte[] key, byte[] value) {
            return false;
        }

        @Override
        public boolean test(byte[] key) {
            return false;
        }
    }
}

