/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.Comparator;
import java.util.Objects;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.Entry;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.UnpositionedCursorException;
import org.cojen.tupl.core.EntryPopulator;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._BTree;
import org.cojen.tupl.core._BTreeCursor;
import org.cojen.tupl.core._LocalDatabase;

class _SortScanner
implements Scanner<Entry> {
    private static final MethodHandle POPULATOR = EntryPopulator.THE;
    private final _LocalDatabase mDatabase;
    private _BTreeCursor mCursor;
    private Supplier mSupplier;
    private Entry mEntry;
    private Comparator<Entry> mComparator;

    _SortScanner(_LocalDatabase db) {
        this.mDatabase = db;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 277;
    }

    @Override
    public Comparator<Entry> getComparator() {
        Comparator comparator = this.mComparator;
        if (comparator == null) {
            this.mComparator = comparator = (a, b) -> Utils.KEY_COMPARATOR.compare(a.key(), b.key());
        }
        return comparator;
    }

    @Override
    public Entry row() {
        Entry e = this.mEntry;
        if (e == null) {
            if (this.mCursor == null && this.tryOpenCursor() == null) {
                return null;
            }
            e = this.mEntry;
        }
        return e;
    }

    @Override
    public Entry step() throws IOException {
        return this.doStep((Entry)null);
    }

    @Override
    public Entry step(Entry row) throws IOException {
        Objects.requireNonNull(row);
        return this.doStep(row);
    }

    private Entry doStep(Entry row) throws IOException {
        _BTreeCursor c = this.mCursor;
        if (c == null && (c = this.tryOpenCursor()) == null) {
            return null;
        }
        try {
            this.doStep(c);
            byte[] key = c.key();
            if (key != null) {
                this.mEntry = row = POPULATOR.invokeExact(row, key, c.value());
                return row;
            }
            this.mCursor = null;
            this.mEntry = null;
            this.mDatabase.quickDeleteTemporaryTree(c.mTree);
            return null;
        }
        catch (UnpositionedCursorException e) {
            this.mEntry = null;
            return null;
        }
        catch (Throwable e) {
            throw Utils.fail(this, e);
        }
    }

    protected void doStep(_BTreeCursor c) throws IOException {
        c.deleteNext();
    }

    @Override
    public void close() throws IOException {
        block6: {
            try {
                _BTreeCursor c = this.mCursor;
                if (c != null) {
                    this.mCursor = null;
                    this.mEntry = null;
                    this.mDatabase.deleteIndex(c.mTree).run();
                } else if (this.mSupplier != null) {
                    this.mSupplier.close();
                    this.mSupplier = null;
                }
            }
            catch (ClosedIndexException c) {
            }
            catch (IOException e) {
                if (this.mDatabase.isClosed()) break block6;
                throw e;
            }
        }
    }

    void ready(_BTree tree) throws IOException {
        _BTreeCursor c = new _BTreeCursor(tree, Transaction.BOGUS);
        this.initPosition(c);
        this.mCursor = c;
        byte[] key = c.key();
        if (key != null) {
            try {
                this.mEntry = POPULATOR.invokeExact(null, key, c.value());
            }
            catch (Throwable e) {
                throw Utils.fail(this, e);
            }
        }
    }

    protected void initPosition(_BTreeCursor c) throws IOException {
        c.first();
    }

    void notReady(Supplier supplier) {
        this.mSupplier = supplier;
    }

    private _BTreeCursor tryOpenCursor() {
        try {
            if (this.mSupplier == null) {
                return null;
            }
            _BTree tree = this.mSupplier.get();
            this.mSupplier = null;
            this.ready(tree);
            return this.mCursor;
        }
        catch (IOException e) {
            throw Utils.rethrow(e);
        }
    }

    static interface Supplier {
        public _BTree get() throws IOException;

        public void close() throws IOException;
    }
}

