/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.util.Arrays;
import org.cojen.tupl.core._BTree;
import org.cojen.tupl.core._CursorFrame;
import org.cojen.tupl.core._LocalDatabase;
import org.cojen.tupl.core._Node;

final class _Split {
    final boolean mSplitRight;
    private final _Node mSibling;
    private byte[] mFullKey;
    private byte[] mActualKey;

    _Split(boolean splitRight, _Node sibling) {
        this.mSplitRight = splitRight;
        this.mSibling = sibling;
    }

    final void setKey(_Split split) {
        this.mFullKey = split.mFullKey;
        this.mActualKey = split.mActualKey;
    }

    final void setKey(_BTree tree, byte[] fullKey) throws IOException {
        this.setKey(tree.mDatabase, fullKey);
    }

    final void setKey(_LocalDatabase db, byte[] fullKey) throws IOException {
        byte[] actualKey = fullKey;
        if (_Node.calculateAllowedKeyLength(db, fullKey) < 0) {
            actualKey = db.fragmentKey(fullKey);
        }
        this.mFullKey = fullKey;
        this.mActualKey = actualKey;
    }

    final void setKey(byte[] fullKey, byte[] actualKey) {
        this.mFullKey = fullKey;
        this.mActualKey = actualKey;
    }

    final byte[] fragmentedKey() {
        return this.mFullKey == this.mActualKey ? null : this.mActualKey;
    }

    final int compare(byte[] key) {
        return Arrays.compareUnsigned(key, this.mFullKey);
    }

    final _Node selectNode(_Node node, byte[] key) {
        _Node right;
        _Node left;
        _Node sibling = this.mSibling;
        sibling.acquireShared();
        if (this.mSplitRight) {
            left = node;
            right = sibling;
        } else {
            left = sibling;
            right = node;
        }
        if (this.compare(key) < 0) {
            right.releaseShared();
            return left;
        }
        left.releaseShared();
        return right;
    }

    final int adjustBindPosition(int pos) {
        if (!this.mSplitRight) {
            _Node sibling = this.latchSibling();
            pos += sibling.highestPos() + 2;
            sibling.releaseShared();
        }
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final byte[] retrieveLeafValue(_Node node, int pos) throws IOException {
        if (this.mSplitRight) {
            int highestPos = node.highestPos();
            if (pos > highestPos) {
                _Node sibling = this.latchSibling();
                try {
                    byte[] byArray = sibling.retrieveLeafValue(pos - highestPos - 2);
                    return byArray;
                }
                finally {
                    sibling.releaseShared();
                }
            }
        } else {
            _Node sibling = this.latchSibling();
            try {
                int highestPos = sibling.highestPos();
                if (pos <= highestPos) {
                    byte[] byArray = sibling.retrieveLeafValue(pos);
                    return byArray;
                }
                pos = pos - highestPos - 2;
            }
            finally {
                sibling.releaseShared();
            }
        }
        return node.retrieveLeafValue(pos);
    }

    final int binarySearchLeaf(_Node node, byte[] key) throws IOException {
        int searchPos;
        _Node right;
        _Node left;
        _Node sibling = this.latchSibling();
        if (this.mSplitRight) {
            left = node;
            right = sibling;
        } else {
            left = sibling;
            right = node;
        }
        if (this.compare(key) < 0) {
            searchPos = left.binarySearch(key);
        } else {
            int highestPos = left.highestLeafPos();
            searchPos = right.binarySearch(key);
            searchPos = searchPos < 0 ? searchPos - highestPos - 2 : highestPos + 2 + searchPos;
        }
        sibling.releaseShared();
        return searchPos;
    }

    final int highestPos(_Node node) {
        _Node sibling = this.latchSibling();
        int pos = node.isLeaf() ? node.highestLeafPos() + 2 + sibling.highestLeafPos() : node.highestInternalPos() + 2 + sibling.highestInternalPos();
        sibling.releaseShared();
        return pos;
    }

    final _Node latchSibling() {
        _Node sibling = this.mSibling;
        sibling.acquireShared();
        return sibling;
    }

    final _Node latchSiblingEx() {
        _Node sibling = this.mSibling;
        sibling.acquireExclusive();
        return sibling;
    }

    final void rebindFrame(_CursorFrame frame, _Node sibling) {
        int pos = frame.mNodePos;
        if (this.mSplitRight) {
            byte[] key;
            _Node frameNode = frame.mNode;
            if (frameNode == null) {
                return;
            }
            int highestPos = frameNode.highestPos();
            if (pos >= 0) {
                if (pos > highestPos) {
                    frame.rebind(sibling, pos - highestPos - 2);
                }
                return;
            }
            if ((pos ^= 0xFFFFFFFF) <= highestPos) {
                return;
            }
            if (pos == highestPos + 2 && ((key = frame.mNotFoundKey) == null || this.compare(key) < 0)) {
                return;
            }
            frame.rebind(sibling, ~(pos - highestPos - 2));
        } else {
            int highestPos = sibling.highestPos();
            if (pos >= 0) {
                if (pos <= highestPos) {
                    frame.rebind(sibling, pos);
                } else {
                    frame.mNodePos = pos - highestPos - 2;
                }
                return;
            }
            if ((pos ^= 0xFFFFFFFF) <= highestPos) {
                frame.rebind(sibling, ~pos);
                return;
            }
            if (pos == highestPos + 2) {
                byte[] key = frame.mNotFoundKey;
                if (key == null) {
                    return;
                }
                if (this.compare(key) < 0) {
                    frame.rebind(sibling, ~pos);
                    return;
                }
            }
            frame.mNodePos = ~(pos - highestPos - 2);
        }
    }

    final void unrebindOriginalFrame(_CursorFrame frame) {
        if (!this.mSplitRight) {
            int pos = frame.mNodePos;
            int adjust = this.mSibling.highestPos() + 2;
            pos = pos >= 0 ? (pos += adjust) : (pos -= adjust);
            frame.mNodePos = pos;
        }
    }

    final void unrebindSiblingFrame(_CursorFrame frame, _Node original) {
        int pos = frame.mNodePos;
        if (this.mSplitRight) {
            int adjust = original.highestPos() + 2;
            pos = pos >= 0 ? (pos += adjust) : (pos -= adjust);
        }
        frame.rebind(original, pos);
    }

    final int splitKeyEncodedLength() {
        byte[] actualKey = this.mActualKey;
        if (actualKey == this.mFullKey) {
            return _Node.calculateKeyLength(actualKey);
        }
        return 2 + actualKey.length;
    }

    final int copySplitKeyToParent(long dest, int destLoc) {
        byte[] actualKey = this.mActualKey;
        if (actualKey == this.mFullKey) {
            return _Node.encodeNormalKey(actualKey, dest, destLoc);
        }
        return _Node.encodeFragmentedKey(actualKey, dest, destLoc);
    }
}

