/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import java.util.zip.Checksum;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.IncompleteRestoreException;
import org.cojen.tupl.Snapshot;
import org.cojen.tupl.core.ChecksumPageArray;
import org.cojen.tupl.core.CommitLock;
import org.cojen.tupl.core.CompressedPageArray;
import org.cojen.tupl.core.CryptoPageArray;
import org.cojen.tupl.core.DirectPageOps;
import org.cojen.tupl.core.PageQueueScanner;
import org.cojen.tupl.core.TransformedPageArray;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core.WrongPageSize;
import org.cojen.tupl.core._LocalDatabase;
import org.cojen.tupl.core._Node;
import org.cojen.tupl.core._PageDb;
import org.cojen.tupl.core._PageManager;
import org.cojen.tupl.core._SnapshotPageArray;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.ext.Crypto;
import org.cojen.tupl.io.FilePageArray;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.StripedPageArray;
import org.cojen.tupl.util.Latch;

final class _StoredPageDb
extends _PageDb {
    private static final long MAGIC_NUMBER = 6529720411368701212L;
    private static final long INCOMPLETE_RESTORE = 1295383629602457917L;
    private static final int I_MAGIC_NUMBER = 0;
    private static final int I_PAGE_SIZE = 8;
    private static final int I_COMMIT_NUMBER = 12;
    private static final int I_CHECKSUM = 16;
    private static final int I_MANAGER_HEADER = 20;
    private static final int I_EXTRA_DATA = 256;
    private static final int I_DATABASE_ID = 248;
    private static final int MINIMUM_PAGE_SIZE = 512;
    private final Crypto mCrypto;
    private final _SnapshotPageArray mPageArray;
    private final _PageManager mPageManager;
    private final Latch mHeaderLatch;
    private int mCommitNumber;
    private final long mDatabaseId;

    static _StoredPageDb open(EventListener debugListener, boolean explicitPageSize, int pageSize, File[] files, EnumSet<OpenOption> options, Supplier<Checksum> checksumFactory, Crypto crypto, boolean destroy) throws IOException {
        while (true) {
            try {
                PageArray pa = _StoredPageDb.openPageArray(pageSize, files, options);
                pa = _StoredPageDb.decorate(pa, checksumFactory, crypto);
                return new _StoredPageDb(debugListener, pa, crypto, destroy);
            }
            catch (WrongPageSize e) {
                if (explicitPageSize) {
                    throw e.rethrow();
                }
                pageSize = e.mActual;
                explicitPageSize = true;
                continue;
            }
            break;
        }
    }

    static _StoredPageDb open(EventListener debugListener, PageArray rawArray, Supplier<Checksum> checksumFactory, Crypto crypto, boolean destroy) throws IOException {
        try {
            PageArray pa = _StoredPageDb.decorate(rawArray, checksumFactory, crypto);
            return new _StoredPageDb(debugListener, pa, crypto, destroy);
        }
        catch (WrongPageSize e) {
            throw e.rethrow();
        }
    }

    private static PageArray openPageArray(int pageSize, File[] files, EnumSet<OpenOption> options) throws IOException {
        _StoredPageDb.checkPageSize(pageSize);
        if (!options.contains((Object)OpenOption.CREATE)) {
            for (File file : files) {
                if (file.exists()) continue;
                throw new DatabaseException("File does not exist: " + file);
            }
        }
        if (files.length == 0) {
            throw new IllegalArgumentException("No files provided");
        }
        if (files.length == 1) {
            return new FilePageArray(pageSize, files[0], options);
        }
        PageArray[] arrays = new PageArray[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                arrays[i] = new FilePageArray(pageSize, files[i], options);
            }
            return new StripedPageArray(arrays);
        }
        catch (Throwable e) {
            for (PageArray pa : arrays) {
                Utils.closeQuietly(pa);
            }
            throw e;
        }
    }

    private static void checkPageSize(int pageSize) {
        if (pageSize < 512) {
            throw new IllegalArgumentException("Page size is too small: " + pageSize + " < 512");
        }
    }

    private static PageArray decorate(PageArray pa, Supplier<Checksum> checksumFactory, Crypto crypto) {
        if (checksumFactory != null) {
            pa = ChecksumPageArray.open(pa, checksumFactory);
        }
        if (crypto != null) {
            pa = new CryptoPageArray(pa, crypto);
        }
        return pa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private _StoredPageDb(EventListener debugListener, PageArray pa, Crypto crypto, boolean destroy) throws IOException, WrongPageSize {
        block32: {
            this.mCrypto = crypto;
            this.mPageArray = new _SnapshotPageArray(pa);
            this.mHeaderLatch = new Latch();
            try {
                int pageSize = this.mPageArray.pageSize();
                _StoredPageDb.checkPageSize(pageSize);
                if (destroy || this.mPageArray.isEmpty()) {
                    this.mPageManager = new _PageManager(this.mPageArray);
                    this.mCommitNumber = -1;
                    this.mDatabaseId = _StoredPageDb.generateDatabaseId(new SecureRandom());
                    long header = DirectPageOps.p_callocPage(this.mPageArray.directPageSize());
                    try {
                        this.mCommitLock.acquireExclusive();
                        try {
                            this.commit(false, header, null);
                            this.commit(false, header, null);
                        }
                        finally {
                            this.mCommitLock.releaseExclusive();
                        }
                    }
                    finally {
                        DirectPageOps.p_delete(header);
                    }
                    this.mPageArray.truncatePageCount(2L);
                    break block32;
                }
                this.mPageArray.sync(false);
                long header0 = DirectPageOps.p_null();
                long header1 = DirectPageOps.p_null();
                try {
                    int commitNumber;
                    long header;
                    boolean issues;
                    block33: {
                        int commitNumber1;
                        CorruptDatabaseException ex0;
                        int pageSize0;
                        int commitNumber0;
                        issues = false;
                        try {
                            header0 = this.readHeader(0);
                            commitNumber0 = DirectPageOps.p_intGetLE(header0, 12);
                            pageSize0 = DirectPageOps.p_intGetLE(header0, 8);
                            ex0 = null;
                        }
                        catch (IncompleteRestoreException e) {
                            throw e;
                        }
                        catch (CorruptDatabaseException e) {
                            if (debugListener != null) {
                                debugListener.notify(EventType.DEBUG, e.toString(), new Object[0]);
                            }
                            issues = true;
                            header0 = DirectPageOps.p_null();
                            commitNumber0 = -1;
                            pageSize0 = pageSize;
                            ex0 = e;
                        }
                        if (pageSize0 != pageSize) {
                            throw new WrongPageSize(pageSize, pageSize0);
                        }
                        try {
                            header1 = this.readHeader(1);
                            commitNumber1 = DirectPageOps.p_intGetLE(header1, 12);
                        }
                        catch (IncompleteRestoreException e) {
                            throw e;
                        }
                        catch (CorruptDatabaseException e) {
                            if (ex0 != null) {
                                throw ex0;
                            }
                            if (debugListener != null) {
                                debugListener.notify(EventType.DEBUG, e.toString(), new Object[0]);
                            }
                            issues = true;
                            header = header0;
                            commitNumber = commitNumber0;
                            break block33;
                        }
                        int pageSize1 = DirectPageOps.p_intGetLE(header1, 8);
                        if (pageSize0 != pageSize1) {
                            throw new CorruptDatabaseException("Mismatched page sizes: " + pageSize0 + " != " + pageSize1);
                        }
                        if (header0 == DirectPageOps.p_null()) {
                            header = header1;
                            commitNumber = commitNumber1;
                        } else {
                            int diff = commitNumber1 - commitNumber0;
                            if (diff > 0) {
                                header = header1;
                                commitNumber = commitNumber1;
                            } else if (diff < 0) {
                                header = header0;
                                commitNumber = commitNumber0;
                            } else {
                                throw new CorruptDatabaseException("Both headers have same commit number: " + commitNumber0);
                            }
                        }
                    }
                    this.mHeaderLatch.acquireExclusive();
                    this.mCommitNumber = commitNumber;
                    this.mHeaderLatch.releaseExclusive();
                    if (debugListener != null) {
                        debugListener.notify(EventType.DEBUG, "PAGE_SIZE: %1$d", pageSize);
                        debugListener.notify(EventType.DEBUG, "COMMIT_NUMBER: %1$d", commitNumber);
                    }
                    this.mPageManager = new _PageManager(debugListener, issues, this.mPageArray, header, 20);
                    this.mDatabaseId = DirectPageOps.p_longGetLE(header, 248);
                }
                finally {
                    DirectPageOps.p_delete(header0);
                    DirectPageOps.p_delete(header1);
                }
            }
            catch (WrongPageSize e) {
                this.delete();
                Utils.closeQuietly(this);
                throw e;
            }
            catch (Throwable e) {
                this.delete();
                throw this.closeOnFailure(e);
            }
        }
    }

    @Override
    long databaseId() {
        return this.mDatabaseId;
    }

    @Override
    void pageCache(_LocalDatabase db) {
        this.mPageManager.pageCache(db);
    }

    @Override
    Crypto dataCrypto() {
        return this.mCrypto;
    }

    @Override
    Supplier<Checksum> checksumFactory() {
        return TransformedPageArray.checksumFactory(this.mPageArray.mSource);
    }

    @Override
    void delete() {
        if (this.mPageManager != null) {
            this.mPageManager.delete();
        }
    }

    @Override
    boolean isCacheOnly() {
        PageArray pageArray = this.mPageArray.mSource;
        if (pageArray instanceof CompressedPageArray) {
            CompressedPageArray cpa = (CompressedPageArray)pageArray;
            return cpa.isCacheOnly();
        }
        return false;
    }

    @Override
    public int directPageSize() {
        return this.mPageArray.directPageSize();
    }

    @Override
    public int allocMode() {
        return 0;
    }

    @Override
    public _Node allocLatchedNode(_LocalDatabase db, int mode) throws IOException {
        long nodeId = this.allocPage();
        try {
            _Node node = db.allocLatchedNode(mode);
            node.id(nodeId);
            return node;
        }
        catch (Throwable e) {
            try {
                this.recyclePage(nodeId);
            }
            catch (Throwable e2) {
                Utils.suppress(e, e2);
            }
            throw e;
        }
    }

    @Override
    public int pageSize() {
        return this.mPageArray.pageSize();
    }

    @Override
    public long pageCount() throws IOException {
        return this.mPageArray.pageCount();
    }

    @Override
    public void pageLimit(long limit) {
        this.mPageManager.pageLimit(limit);
    }

    @Override
    public long pageLimit() {
        return this.mPageManager.pageLimit();
    }

    @Override
    public void pageLimitOverride(long bytes) {
        this.mPageManager.pageLimitOverride(bytes);
    }

    @Override
    public _PageDb.Stats stats() {
        _PageDb.Stats stats = new _PageDb.Stats();
        this.mPageManager.addTo(stats);
        return stats;
    }

    @Override
    public boolean requiresCommit() {
        return this.mPageManager.hasDeletedOrRecycledPages();
    }

    @Override
    public void readPage(long id, long page) throws IOException {
        try {
            this.mPageArray.readPage(id, page, 0, this.pageSize());
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
    }

    @Override
    public long allocPage() throws IOException {
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            long l = this.mPageManager.allocPage();
            return l;
        }
        catch (DatabaseException e) {
            if (e.isRecoverable()) {
                throw e;
            }
            throw this.closeOnFailure(e);
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
        finally {
            shared.release();
        }
    }

    @Override
    public void writePage(long id, long page) throws IOException {
        _StoredPageDb.checkId(id);
        this.mPageArray.writePage(id, page, 0);
    }

    @Override
    public long evictPage(long id, long page) throws IOException {
        _StoredPageDb.checkId(id);
        return this.mPageArray.evictPage(id, page);
    }

    @Override
    public void deletePage(long id, boolean force) throws IOException {
        _StoredPageDb.checkId(id);
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            this.mPageManager.deletePage(id, force);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
        finally {
            shared.release();
        }
    }

    @Override
    public void recyclePage(long id) throws IOException {
        _StoredPageDb.checkId(id);
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            try {
                this.mPageManager.recyclePage(id);
            }
            catch (IOException e) {
                this.mPageManager.deletePage(id, true);
            }
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
        finally {
            shared.release();
        }
    }

    @Override
    public long allocatePages(long pageCount) throws IOException {
        if (pageCount <= 0L) {
            return 0L;
        }
        _PageDb.Stats stats = new _PageDb.Stats();
        this.mPageManager.addTo(stats);
        if ((pageCount -= stats.freePages) < 0L) {
            return 0L;
        }
        this.mPageArray.expandPageCount(this.mPageArray.pageCount() + pageCount);
        int i = 0;
        while ((long)i < pageCount) {
            CommitLock.Shared shared = this.mCommitLock.acquireShared();
            try {
                this.mPageManager.allocAndRecyclePage();
            }
            catch (Throwable e) {
                throw this.closeOnFailure(e);
            }
            finally {
                shared.release();
            }
            ++i;
        }
        return pageCount;
    }

    @Override
    public long directPagePointer(long id) throws IOException {
        return this.mPageArray.directPagePointer(id);
    }

    @Override
    public long dirtyPage(long id) throws IOException {
        return this.mPageArray.dirtyPage(id);
    }

    @Override
    public long copyPage(long srcId, long dstId) throws IOException {
        return this.mPageArray.copyPage(srcId, dstId);
    }

    @Override
    public void scanFreeList(LongConsumer dst) throws IOException {
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            this.scanFreeList(28, dst);
            this.scanFreeList(72, dst);
        }
        finally {
            shared.release();
        }
    }

    private void scanFreeList(int headerOffset, LongConsumer dst) throws IOException {
        PageQueueScanner.scan(this.mPageArray, this.mCommitNumber & 1, headerOffset, dst);
    }

    @Override
    public boolean compactionStart(long targetPageCount) throws IOException {
        this.mCommitLock.acquireExclusive();
        try {
            boolean bl = this.mPageManager.compactionStart(targetPageCount);
            return bl;
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
        finally {
            this.mCommitLock.releaseExclusive();
        }
    }

    @Override
    public boolean compactionScanFreeList() throws IOException {
        try {
            return this.mPageManager.compactionScanFreeList(this.mCommitLock);
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
    }

    @Override
    public boolean compactionVerify() throws IOException {
        return this.mPageManager.compactionVerify();
    }

    @Override
    public boolean compactionEnd() throws IOException {
        try {
            return this.mPageManager.compactionEnd(this.mCommitLock);
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
    }

    @Override
    public void compactionReclaim() throws IOException {
        try {
            this.mPageManager.compactionReclaim();
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
    }

    @Override
    public boolean truncatePages() throws IOException {
        return this.mPageManager.truncatePages();
    }

    @Override
    public int extraCommitDataOffset() {
        return 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(boolean resume, long header, _PageDb.CommitCallback callback) throws IOException {
        CommitLock.Shared shared = this.mCommitLock.acquireShared();
        try {
            this.mHeaderLatch.acquireShared();
            int commitNumber = this.mCommitNumber + 1;
            this.mHeaderLatch.releaseShared();
            try {
                if (!resume) {
                    this.mPageManager.commitStart(header, 20);
                }
                if (callback != null) {
                    callback.prepare(resume, header);
                }
            }
            catch (DatabaseException e) {
                if (e.isRecoverable()) {
                    throw e;
                }
                throw this.closeOnFailure(e);
            }
            try {
                this.commitHeader(header, commitNumber);
                this.mPageManager.commitEnd(header, 20);
            }
            catch (Throwable e) {
                throw this.closeOnFailure(e);
            }
        }
        finally {
            shared.release();
        }
    }

    @Override
    public void readExtraCommitData(byte[] extra) throws IOException {
        try {
            this.mHeaderLatch.acquireShared();
            try {
                this.readPartial(this.mCommitNumber & 1, 256, extra, 0, extra.length);
            }
            finally {
                this.mHeaderLatch.releaseShared();
            }
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    @Override
    public void close(Throwable cause) throws IOException {
        if (this.mPageArray != null) {
            this.mPageArray.close(cause);
        }
    }

    OutputStream encrypt(OutputStream out) throws IOException {
        if (this.mCrypto != null) {
            try {
                out = new BufferedOutputStream(this.mCrypto.newEncryptingStream(out));
            }
            catch (GeneralSecurityException e) {
                throw new DatabaseException(e);
            }
        }
        return out;
    }

    InputStream decrypt(InputStream in) throws IOException {
        if (this.mCrypto != null) {
            try {
                in = this.mCrypto.newDecryptingStream(in);
            }
            catch (GeneralSecurityException e) {
                throw new DatabaseException(e);
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot beginSnapshot(_LocalDatabase db) throws IOException {
        PageArray pageArray = this.mPageArray.mSource;
        if (pageArray instanceof CompressedPageArray) {
            CompressedPageArray cpa = (CompressedPageArray)pageArray;
            return cpa.beginSnapshot();
        }
        this.mHeaderLatch.acquireShared();
        try {
            long redoPos;
            long pageCount;
            long header = DirectPageOps.p_allocPage(this.directPageSize());
            try {
                this.mPageArray.readPage((long)(this.mCommitNumber & 1), header, 0, 512);
                pageCount = _PageManager.readTotalPageCount(header, 20);
                redoPos = _LocalDatabase.readRedoPosition(header, 256);
            }
            finally {
                DirectPageOps.p_delete(header);
            }
            Snapshot snapshot = this.mPageArray.beginSnapshot(db, pageCount, redoPos);
            return snapshot;
        }
        finally {
            this.mHeaderLatch.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long snapshotRedoPos() throws IOException {
        long header = DirectPageOps.p_allocPage(this.directPageSize());
        try {
            this.mPageArray.readPage((long)(this.mCommitNumber & 1), header, 0, 512);
            long l = _LocalDatabase.readRedoPosition(header, 256);
            return l;
        }
        finally {
            DirectPageOps.p_delete(header);
        }
    }

    static _PageDb restoreFromSnapshot(int pageSize, File[] files, EnumSet<OpenOption> options, Supplier<Checksum> checksumFactory, Crypto crypto, InputStream in) throws IOException {
        try (InputStream inputStream = in;){
            Object newBuffer;
            byte[] buffer;
            if (options.contains((Object)OpenOption.READ_ONLY)) {
                throw new DatabaseException("Cannot restore into a read-only file");
            }
            if (crypto != null) {
                buffer = new byte[pageSize];
                Utils.readFully(in, buffer, 0, buffer.length);
                if (checksumFactory != null) {
                    pageSize -= 4;
                }
                try {
                    crypto.decryptPage(0L, pageSize, buffer, 0);
                }
                catch (GeneralSecurityException e) {
                    throw new DatabaseException(e);
                }
            } else {
                buffer = new byte[512];
                Utils.readFully(in, buffer, 0, buffer.length);
            }
            _StoredPageDb.checkMagicNumber(Utils.decodeLongLE(buffer, 0));
            pageSize = Utils.decodeIntLE(buffer, 8);
            if (checksumFactory != null) {
                pageSize += 4;
            }
            PageArray pa = _StoredPageDb.openPageArray(pageSize, files, options);
            if (pageSize != buffer.length) {
                if (crypto != null) {
                    Utils.closeQuietly(pa);
                    throw new CorruptDatabaseException("Mismatched page size: " + pageSize + " != " + buffer.length);
                }
                newBuffer = new byte[pageSize];
                System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                Utils.readFully(in, newBuffer, buffer.length, pageSize - buffer.length);
                buffer = newBuffer;
            }
            try {
                newBuffer = _StoredPageDb.restoreFromSnapshot(checksumFactory, crypto, in, buffer, pa);
                return newBuffer;
            }
            catch (Throwable e) {
                Utils.closeQuietly(pa);
                throw e;
            }
        }
    }

    static _PageDb restoreFromSnapshot(PageArray pa, Supplier<Checksum> checksumFactory, Crypto crypto, InputStream in) throws IOException {
        try (InputStream inputStream = in;){
            int pageSize;
            byte[] buffer = new byte[pa.pageSize()];
            Utils.readFully(in, buffer, 0, buffer.length);
            if (crypto != null) {
                pageSize = buffer.length;
                if (checksumFactory != null) {
                    pageSize -= 4;
                }
                try {
                    crypto.decryptPage(0L, pageSize, buffer, 0);
                }
                catch (GeneralSecurityException e) {
                    throw new DatabaseException(e);
                }
            }
            _StoredPageDb.checkMagicNumber(Utils.decodeLongLE(buffer, 0));
            pageSize = Utils.decodeIntLE(buffer, 8);
            if (checksumFactory != null) {
                pageSize += 4;
            }
            if (pageSize != buffer.length) {
                Utils.closeQuietly(pa);
                throw new CorruptDatabaseException("Mismatched page size: " + pageSize + " != " + buffer.length);
            }
            _PageDb _PageDb2 = _StoredPageDb.restoreFromSnapshot(checksumFactory, crypto, in, buffer, pa);
            return _PageDb2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static _PageDb restoreFromSnapshot(Supplier<Checksum> checksumFactory, Crypto crypto, InputStream in, byte[] buffer, PageArray rawArray) throws IOException {
        PageArray logicalArray = _StoredPageDb.decorate(rawArray, checksumFactory, crypto);
        Utils.encodeLongLE(buffer, 0, 1295383629602457917L);
        int commitNumber = Utils.decodeIntLE(buffer, 12);
        long pageCount = Utils.decodeLongLE(buffer, 20);
        long bufferPage = DirectPageOps.p_transferPage(buffer, rawArray.directPageSize());
        try {
            int amt;
            _StoredPageDb.writeLogicalHeader(logicalArray, buffer, bufferPage);
            logicalArray.sync(false);
            Utils.readFully(in, buffer, 0, buffer.length);
            rawArray.writePage(1L, DirectPageOps.p_transferArrayToPage(buffer, bufferPage));
            if (crypto != null) {
                try {
                    crypto.decryptPage(0L, logicalArray.pageSize(), buffer, 0);
                }
                catch (GeneralSecurityException e) {
                    throw new DatabaseException(e);
                }
            }
            if (Utils.decodeIntLE(buffer, 12) > commitNumber) {
                pageCount = Utils.decodeLongLE(buffer, 20);
            }
            rawArray.expandPageCount(pageCount);
            long index = 2L;
            while ((amt = in.read(buffer)) >= 0) {
                Utils.readFully(in, buffer, amt, buffer.length - amt);
                rawArray.writePage(index, DirectPageOps.p_transferArrayToPage(buffer, bufferPage));
                ++index;
            }
            rawArray.sync(false);
            rawArray.readPage(0L, bufferPage);
            DirectPageOps.p_transferPageToArray(bufferPage, buffer);
            if (crypto != null) {
                try {
                    crypto.decryptPage(0L, logicalArray.pageSize(), buffer, 0);
                }
                catch (GeneralSecurityException e) {
                    throw new DatabaseException(e);
                }
            }
            Utils.encodeLongLE(buffer, 0, 6529720411368701212L);
            _StoredPageDb.writeLogicalHeader(logicalArray, buffer, bufferPage);
        }
        finally {
            DirectPageOps.p_delete(bufferPage);
        }
        logicalArray.sync(true);
        try {
            return new _StoredPageDb(null, logicalArray, crypto, false);
        }
        catch (WrongPageSize e) {
            throw e.rethrow();
        }
    }

    private static void writeLogicalHeader(PageArray pa, byte[] buffer, long bufferPage) throws IOException {
        if (buffer.length != pa.pageSize()) {
            buffer = Arrays.copyOfRange(buffer, 0, pa.pageSize());
        }
        pa.writePage(0L, DirectPageOps.p_transferArrayToPage(buffer, bufferPage));
    }

    private IOException closeOnFailure(Throwable e) throws IOException {
        throw Utils.closeOnFailure(this, e);
    }

    private static void checkId(long id) {
        if (id <= 1L) {
            throw new IllegalArgumentException("Illegal page id: " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitHeader(long header, int commitNumber) throws IOException {
        _SnapshotPageArray array = this.mPageArray;
        DirectPageOps.p_longPutLE(header, 0, 6529720411368701212L);
        DirectPageOps.p_intPutLE(header, 8, array.pageSize());
        DirectPageOps.p_intPutLE(header, 12, commitNumber);
        DirectPageOps.p_longPutLE(header, 248, this.mDatabaseId);
        _StoredPageDb.setHeaderChecksum(header);
        int dupCount = this.pageSize() / 512;
        for (int i = 1; i < dupCount; ++i) {
            DirectPageOps.p_copy(header, 0, header, i * 512, 512);
        }
        ((PageArray)array).sync(true);
        this.mHeaderLatch.acquireExclusive();
        try {
            array.writePage((long)(commitNumber & 1), header);
            this.mCommitNumber = commitNumber;
        }
        finally {
            this.mHeaderLatch.releaseExclusive();
        }
        ((PageArray)array).syncPage(commitNumber & 1);
    }

    private static int setHeaderChecksum(long header) {
        DirectPageOps.p_intPutLE(header, 16, 0);
        int checksum = DirectPageOps.p_crc32(header, 0, 512);
        DirectPageOps.p_intPutLE(header, 16, checksum);
        return checksum;
    }

    private long readHeader(int id) throws IOException {
        long header = DirectPageOps.p_allocPage(this.directPageSize());
        try {
            try {
                this.mPageArray.readPage((long)id, header, 0, 512);
            }
            catch (EOFException e) {
                throw new CorruptDatabaseException("File is smaller than expected");
            }
            _StoredPageDb.checkMagicNumber(DirectPageOps.p_longGetLE(header, 0));
            int checksum = DirectPageOps.p_intGetLE(header, 16);
            int newChecksum = _StoredPageDb.setHeaderChecksum(header);
            if (newChecksum != checksum) {
                throw new CorruptDatabaseException("Header checksum mismatch: " + newChecksum + " != " + checksum);
            }
            return header;
        }
        catch (Throwable e) {
            DirectPageOps.p_delete(header);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPartial(long index, int start, byte[] buf, int offset, int length) throws IOException {
        long page;
        int readLen;
        int directPageSize = this.directPageSize();
        if (directPageSize < 0) {
            readLen = this.pageSize();
            page = DirectPageOps.p_allocPage(directPageSize);
        } else {
            readLen = start + length;
            page = DirectPageOps.p_alloc(readLen);
        }
        try {
            this.mPageArray.readPage(index, page, 0, readLen);
            DirectPageOps.p_copyToArray(page, start, buf, offset, length);
        }
        finally {
            DirectPageOps.p_delete(page);
        }
    }

    private static void checkMagicNumber(long magic) throws CorruptDatabaseException {
        if (magic != 6529720411368701212L) {
            if (magic == 1295383629602457917L) {
                throw new IncompleteRestoreException();
            }
            throw new CorruptDatabaseException("Wrong magic number: " + magic);
        }
    }
}

