/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.Flushable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.UnmodifiableReplicaException;
import org.cojen.tupl.core.LHashTable;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._LocalTransaction;
import org.cojen.tupl.core._PendingTxn;
import org.cojen.tupl.core._RedoWriter;
import org.cojen.tupl.core._UndoLog;
import org.cojen.tupl.diag.DatabaseStats;
import org.cojen.tupl.util.Latch;

final class _TransactionContext
extends Latch
implements Flushable {
    private static final VarHandle cHighTxnIdHandle;
    private final long mTxnStride;
    private long mInitialTxnId;
    private volatile long mHighTxnId;
    private _UndoLog mTopUndoLog;
    private int mUndoLogCount;
    private LHashTable.Obj<Object> mUncommitted;
    private final byte[] mRedoBuffer;
    private int mRedoPos;
    private int mRedoTerminatePos;
    private long mRedoFirstTxnId;
    private long mRedoLastTxnId;
    private _RedoWriter mRedoWriter;
    private boolean mRedoWriterLatched;
    private long mRedoWriterPos;

    _TransactionContext(int txnStride, int redoBufferSize) {
        if (txnStride <= 0) {
            throw new IllegalArgumentException();
        }
        this.mTxnStride = txnStride;
        this.mRedoBuffer = new byte[redoBufferSize];
    }

    synchronized void addStats(DatabaseStats stats) {
        stats.transactionCount += (long)this.mUndoLogCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetTransactionId(long txnId) {
        if (txnId < 0L) {
            throw new IllegalArgumentException();
        }
        _TransactionContext _TransactionContext2 = this;
        synchronized (_TransactionContext2) {
            this.mInitialTxnId = txnId;
            this.mHighTxnId = txnId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long nextTransactionId() {
        long txnId = cHighTxnIdHandle.getAndAdd(this, this.mTxnStride) + this.mTxnStride;
        if (txnId <= 0L) {
            _TransactionContext _TransactionContext2 = this;
            synchronized (_TransactionContext2) {
                if (this.mHighTxnId <= 0L && (txnId = this.mHighTxnId + this.mTxnStride) <= 0L) {
                    txnId = this.mInitialTxnId % this.mTxnStride;
                }
                this.mHighTxnId = txnId;
            }
        }
        return txnId;
    }

    void acquireRedoLatch() {
        this.acquireExclusive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseRedoLatch() throws IOException {
        block8: {
            try {
                if (!this.mRedoWriterLatched) break block8;
                try {
                    int length;
                    if (this.mRedoFirstTxnId != 0L || (length = this.mRedoPos) == 0) break block8;
                    try {
                        this.mRedoWriterPos = this.mRedoWriter.write(false, this.mRedoBuffer, 0, length, this.mRedoTerminatePos, null);
                    }
                    catch (IOException e) {
                        throw Utils.rethrow(e, this.mRedoWriter.mCloseCause);
                    }
                    this.mRedoPos = 0;
                    this.mRedoTerminatePos = 0;
                }
                finally {
                    this.mRedoWriter.releaseExclusive();
                    this.mRedoWriterLatched = false;
                }
            }
            finally {
                this.releaseExclusive();
            }
        }
    }

    void fullAcquireRedoLatch(_RedoWriter redo) throws IOException {
        this.acquireExclusive();
        try {
            if (redo != this.mRedoWriter) {
                this.switchRedo(redo);
            }
            redo.acquireExclusive();
        }
        catch (Throwable e) {
            this.releaseRedoLatch();
            throw e;
        }
        this.mRedoWriterLatched = true;
    }

    void discardRedoWriter(_RedoWriter expect) {
        this.acquireExclusive();
        if (this.mRedoWriter == expect) {
            this.mRedoPos = 0;
            this.mRedoTerminatePos = 0;
            this.mRedoFirstTxnId = 0L;
            this.mRedoWriter = null;
        }
        this.releaseExclusive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long redoStoreAutoCommit(_RedoWriter redo, long indexId, byte[] key, byte[] value, DurabilityMode mode) throws IOException {
        Utils.keyCheck(key);
        mode = redo.opWriteCheck(mode);
        this.acquireRedoLatch();
        try {
            if (value == null) {
                this.redoWriteOp(redo, (byte)18, indexId);
                this.redoWriteUnsignedVarInt(key.length);
                this.redoWriteBytes(key, true);
            } else {
                this.redoWriteOp(redo, (byte)16, indexId);
                this.redoWriteUnsignedVarInt(key.length);
                this.redoWriteBytes(key, false);
                this.redoWriteUnsignedVarInt(value.length);
                this.redoWriteBytes(value, true);
            }
            long l = this.redoNonTxnTerminateCommit(redo, mode);
            return l;
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long redoStoreNoLockAutoCommit(_RedoWriter redo, long indexId, byte[] key, byte[] value, DurabilityMode mode) throws IOException {
        Utils.keyCheck(key);
        mode = redo.opWriteCheck(mode);
        this.acquireRedoLatch();
        try {
            if (value == null) {
                this.redoWriteOp(redo, (byte)19, indexId);
                this.redoWriteUnsignedVarInt(key.length);
                this.redoWriteBytes(key, true);
            } else {
                this.redoWriteOp(redo, (byte)17, indexId);
                this.redoWriteUnsignedVarInt(key.length);
                this.redoWriteBytes(key, false);
                this.redoWriteUnsignedVarInt(value.length);
                this.redoWriteBytes(value, true);
            }
            long l = this.redoNonTxnTerminateCommit(redo, mode);
            return l;
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long redoRenameIndexCommitFinal(_RedoWriter redo, long txnId, long indexId, byte[] newName, DurabilityMode mode) throws IOException {
        mode = redo.opWriteCheck(mode);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)21, txnId);
            this.redoWriteLongLE(indexId);
            this.redoWriteUnsignedVarInt(newName.length);
            this.redoWriteBytes(newName, true);
            this.redoWriteTerminator(redo);
            long l = this.redoFlushCommit(mode);
            return l;
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long redoDeleteIndexCommitFinal(_RedoWriter redo, long txnId, long indexId, DurabilityMode mode) throws IOException {
        mode = redo.opWriteCheck(mode);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)22, txnId);
            this.redoWriteLongLE(indexId);
            this.redoWriteTerminator(redo);
            long l = this.redoFlushCommit(mode);
            return l;
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoEnter(_RedoWriter redo, long txnId) throws IOException {
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)24, txnId);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoRollback(_RedoWriter redo, long txnId) throws IOException {
        DurabilityMode mode = redo.opWriteCheck(DurabilityMode.NO_FLUSH);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)25, txnId);
            this.redoWriteTerminator(redo);
            this.redoFlushCommit(mode);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoRollbackFinal(_RedoWriter redo, long txnId) throws IOException {
        DurabilityMode mode = redo.opWriteCheck(DurabilityMode.NO_FLUSH);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)26, txnId);
            this.redoWriteTerminator(redo);
            this.redoFlushCommit(mode);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoCommit(_RedoWriter redo, long txnId) throws IOException {
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)27, txnId);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long redoCommitFinal(_LocalTransaction txn) throws IOException {
        _RedoWriter redo = txn.mRedo;
        DurabilityMode mode = redo.opWriteCheck(txn.mDurabilityMode);
        if (mode == DurabilityMode.SYNC && txn.mDurabilityMode != DurabilityMode.SYNC) {
            _PendingTxn pending = txn.preparePending();
            try {
                this.acquireRedoLatch();
                try {
                    this.redoWriteTxnOp(redo, (byte)28, pending.mTxnId);
                    this.redoWriteTerminator(redo);
                    this.redoFlush(true, pending);
                }
                finally {
                    this.releaseRedoLatch();
                }
                return -1L;
            }
            catch (Throwable e) {
                throw pending.rollback(e);
            }
        }
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)28, txn.mTxnId);
            this.redoWriteTerminator(redo);
            long l = this.redoFlushCommit(mode);
            return l;
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoLock(_RedoWriter redo, byte op, long txnId, long indexId, byte[] key) throws IOException {
        Utils.keyCheck(key);
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, op, txnId);
            this.redoWriteLongLE(indexId);
            this.redoWriteUnsignedVarInt(key.length);
            this.redoWriteBytes(key, true);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoStore(_RedoWriter redo, byte op, long txnId, long indexId, byte[] key, byte[] value) throws IOException {
        Utils.keyCheck(key);
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.doRedoStore(redo, op, txnId, indexId, key, value);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long redoStoreCommitFinal(_LocalTransaction txn, long indexId, byte[] key, byte[] value) throws IOException {
        Utils.keyCheck(key);
        _RedoWriter redo = txn.mRedo;
        DurabilityMode mode = redo.opWriteCheck(txn.mDurabilityMode);
        if (mode == DurabilityMode.SYNC && txn.mDurabilityMode != DurabilityMode.SYNC) {
            _PendingTxn pending = txn.preparePending();
            try {
                this.acquireRedoLatch();
                try {
                    this.doRedoStore(redo, (byte)35, pending.mTxnId, indexId, key, value);
                    this.redoFlush(true, pending);
                }
                finally {
                    this.releaseRedoLatch();
                }
                return -1L;
            }
            catch (Throwable e) {
                throw pending.rollback(e);
            }
        }
        this.acquireRedoLatch();
        try {
            this.doRedoStore(redo, (byte)35, txn.mTxnId, indexId, key, value);
            long l = this.redoFlushCommit(mode);
            return l;
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    private void doRedoStore(_RedoWriter redo, byte op, long txnId, long indexId, byte[] key, byte[] value) throws IOException {
        this.redoWriteTxnOp(redo, op, txnId);
        this.redoWriteLongLE(indexId);
        this.redoWriteUnsignedVarInt(key.length);
        this.redoWriteBytes(key, false);
        this.redoWriteUnsignedVarInt(value.length);
        this.redoWriteBytes(value, true);
        this.redoWriteTerminator(redo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoDelete(_RedoWriter redo, byte op, long txnId, long indexId, byte[] key) throws IOException {
        Utils.keyCheck(key);
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.doRedoDelete(redo, op, txnId, indexId, key);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long redoDeleteCommitFinal(_LocalTransaction txn, long indexId, byte[] key) throws IOException {
        Utils.keyCheck(key);
        _RedoWriter redo = txn.mRedo;
        DurabilityMode mode = redo.opWriteCheck(txn.mDurabilityMode);
        if (mode == DurabilityMode.SYNC && txn.mDurabilityMode != DurabilityMode.SYNC) {
            _PendingTxn pending = txn.preparePending();
            try {
                this.acquireRedoLatch();
                try {
                    this.doRedoDelete(redo, (byte)39, pending.mTxnId, indexId, key);
                    this.redoFlush(true, pending);
                }
                finally {
                    this.releaseRedoLatch();
                }
                return -1L;
            }
            catch (Throwable e) {
                throw pending.rollback(e);
            }
        }
        this.acquireRedoLatch();
        try {
            this.doRedoDelete(redo, (byte)39, txn.mTxnId, indexId, key);
            long l = this.redoFlushCommit(mode);
            return l;
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    private void doRedoDelete(_RedoWriter redo, byte op, long txnId, long indexId, byte[] key) throws IOException {
        this.redoWriteTxnOp(redo, op, txnId);
        this.redoWriteLongLE(indexId);
        this.redoWriteUnsignedVarInt(key.length);
        this.redoWriteBytes(key, true);
        this.redoWriteTerminator(redo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoCursorRegister(_RedoWriter redo, long cursorId, long indexId) throws IOException {
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)40, cursorId);
            this.redoWriteLongLE(indexId);
            this.redoWriteTerminator(redo);
            this.redoFlush(false);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoCursorUnregister(_RedoWriter redo, long cursorId) throws IOException {
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)41, cursorId);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoCursorStore(_RedoWriter redo, long cursorId, long txnId, byte[] key, byte[] value) throws IOException {
        Utils.keyCheck(key);
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteCursorOp(redo, (byte)42, cursorId, txnId);
            this.redoWriteUnsignedVarInt(key.length);
            this.redoWriteBytes(key, false);
            this.redoWriteUnsignedVarInt(value.length);
            this.redoWriteBytes(value, true);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoCursorDelete(_RedoWriter redo, long cursorId, long txnId, byte[] key) throws IOException {
        Utils.keyCheck(key);
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteCursorOp(redo, (byte)43, cursorId, txnId);
            this.redoWriteUnsignedVarInt(key.length);
            this.redoWriteBytes(key, true);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoCursorFind(_RedoWriter redo, long cursorId, long txnId, byte[] key) throws IOException {
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteCursorOp(redo, (byte)44, cursorId, txnId);
            this.redoWriteUnsignedVarInt(key.length);
            this.redoWriteBytes(key, true);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoCursorValueSetLength(_RedoWriter redo, long cursorId, long txnId, long length) throws IOException {
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteCursorOp(redo, (byte)45, cursorId, txnId);
            this.redoWriteUnsignedVarLong(length);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoCursorValueWrite(_RedoWriter redo, long cursorId, long txnId, long pos, byte[] buf, int off, int len) throws IOException {
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteCursorOp(redo, (byte)46, cursorId, txnId);
            this.redoWriteUnsignedVarLong(pos);
            this.redoWriteUnsignedVarInt(len);
            this.redoWriteBytes(buf, off, len, true);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoCursorValueClear(_RedoWriter redo, long cursorId, long txnId, long pos, long length) throws IOException {
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteCursorOp(redo, (byte)47, cursorId, txnId);
            this.redoWriteUnsignedVarLong(pos);
            this.redoWriteUnsignedVarLong(length);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoPrepare(_RedoWriter redo, long txnId, long prepareTxnId, int handlerId, byte[] message, boolean commit) throws IOException {
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            if (message == null) {
                byte op = commit ? (byte)50 : 48;
                this.redoWriteTxnOp(redo, op, txnId);
                this.redoWriteLongLE(prepareTxnId);
                this.redoWriteUnsignedVarInt(handlerId);
            } else {
                byte op = commit ? (byte)51 : 49;
                this.redoWriteTxnOp(redo, op, txnId);
                this.redoWriteLongLE(prepareTxnId);
                this.redoWriteUnsignedVarInt(handlerId);
                this.redoWriteUnsignedVarInt(message.length);
                this.redoWriteBytes(message, true);
            }
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoPrepareRollback(_RedoWriter redo, long txnId, long prepareTxnId) throws IOException {
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)52, txnId);
            this.redoWriteLongLE(prepareTxnId);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoCommitFinalNotifySchema(_RedoWriter redo, long txnId, long indexId) throws IOException {
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)54, txnId);
            this.redoWriteLongLE(indexId);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoPredicateMode(_RedoWriter redo, long txnId) throws IOException {
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)55, txnId);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoCustom(_RedoWriter redo, long txnId, int handlerId, byte[] message) throws IOException {
        if (message == null) {
            throw new NullPointerException("Message is null");
        }
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)56, txnId);
            this.redoWriteUnsignedVarInt(handlerId);
            this.redoWriteUnsignedVarInt(message.length);
            this.redoWriteBytes(message, true);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoCustomLock(_RedoWriter redo, long txnId, int handlerId, byte[] message, long indexId, byte[] key) throws IOException {
        Utils.keyCheck(key);
        if (message == null) {
            throw new NullPointerException("Message is null");
        }
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteTxnOp(redo, (byte)57, txnId);
            this.redoWriteUnsignedVarInt(handlerId);
            this.redoWriteLongLE(indexId);
            this.redoWriteUnsignedVarInt(key.length);
            this.redoWriteBytes(key, false);
            this.redoWriteUnsignedVarInt(message.length);
            this.redoWriteBytes(message, true);
            this.redoWriteTerminator(redo);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    void doRedoReset(_RedoWriter redo) throws IOException {
        redo.opWriteCheck(null);
        this.redoWriteOp(redo, (byte)1);
        this.redoNonTxnTerminateCommit(redo, DurabilityMode.NO_FLUSH);
        assert (this.mRedoWriterLatched);
        redo.mLastTxnId = 0L;
    }

    void redoTimestamp(_RedoWriter redo, byte op) throws IOException {
        this.acquireRedoLatch();
        try {
            this.doRedoTimestamp(redo, op, DurabilityMode.NO_FLUSH);
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    void doRedoTimestamp(_RedoWriter redo, byte op, DurabilityMode mode) throws IOException {
        this.doRedoOp(redo, op, System.currentTimeMillis(), mode);
    }

    void doRedoNopRandom(_RedoWriter redo, DurabilityMode mode) throws IOException {
        this.doRedoOp(redo, (byte)6, ThreadLocalRandom.current().nextLong(), mode);
    }

    private void doRedoOp(_RedoWriter redo, byte op, long operand, DurabilityMode mode) throws IOException {
        redo.opWriteCheck(null);
        this.redoWriteOp(redo, op, operand);
        this.redoNonTxnTerminateCommit(redo, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long redoControl(_RedoWriter redo, byte[] message) throws IOException {
        if (message == null) {
            throw new NullPointerException("Message is null");
        }
        redo.opWriteCheck(null);
        this.acquireRedoLatch();
        try {
            this.redoWriteOp(redo, (byte)8);
            this.redoWriteUnsignedVarInt(message.length);
            this.redoWriteBytes(message, true);
            long l = this.redoNonTxnTerminateCommit(redo, DurabilityMode.SYNC);
            return l;
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    private long redoNonTxnTerminateCommit(_RedoWriter redo, DurabilityMode mode) throws IOException {
        this.mRedoTerminatePos = this.mRedoPos;
        if (!redo.shouldWriteTerminators()) {
            return this.redoFlushCommit(mode);
        }
        if (this.mRedoFirstTxnId != 0L) {
            this.redoWriteIntLE(Utils.nzHash(this.mRedoLastTxnId));
            return this.redoFlushCommit(mode);
        }
        int length = this.mRedoPos;
        int commitLen = this.mRedoTerminatePos;
        byte[] buffer = this.mRedoBuffer;
        redo = this.latchWriter();
        if (length > buffer.length - 4) {
            try {
                this.mRedoWriterPos = redo.write(false, buffer, 0, length, commitLen, null);
            }
            catch (IOException e) {
                throw Utils.rethrow(e, redo.mCloseCause);
            }
            this.mRedoPos = 0;
            this.mRedoTerminatePos = 0;
            length = 0;
            commitLen = 0;
        }
        Utils.encodeIntLE(buffer, length, Utils.nzHash(redo.mLastTxnId));
        length += 4;
        boolean flush = mode == DurabilityMode.SYNC || mode == DurabilityMode.NO_SYNC;
        try {
            this.mRedoWriterPos = redo.write(flush, buffer, 0, length, commitLen, null);
        }
        catch (IOException e) {
            throw Utils.rethrow(e, redo.mCloseCause);
        }
        this.mRedoPos = 0;
        this.mRedoTerminatePos = 0;
        return mode == DurabilityMode.SYNC ? this.mRedoWriterPos : 0L;
    }

    private void redoWriteTerminator(_RedoWriter redo) throws IOException {
        this.mRedoTerminatePos = this.mRedoPos;
        if (redo.shouldWriteTerminators()) {
            this.redoWriteIntLE(Utils.nzHash(this.mRedoLastTxnId));
        }
    }

    private void redoWriteIntLE(int v) throws IOException {
        int pos = this.mRedoPos;
        byte[] buffer = this.mRedoBuffer;
        if (pos > buffer.length - 4) {
            this.redoFlush(false);
            pos = 0;
        }
        Utils.encodeIntLE(buffer, pos, v);
        this.mRedoPos = pos + 4;
    }

    private void redoWriteLongLE(long v) throws IOException {
        int pos = this.mRedoPos;
        byte[] buffer = this.mRedoBuffer;
        if (pos > buffer.length - 8) {
            this.redoFlush(false);
            pos = 0;
        }
        Utils.encodeLongLE(buffer, pos, v);
        this.mRedoPos = pos + 8;
    }

    private void redoWriteUnsignedVarInt(int v) throws IOException {
        int pos = this.mRedoPos;
        byte[] buffer = this.mRedoBuffer;
        if (pos > buffer.length - 5) {
            this.redoFlush(false);
            pos = 0;
        }
        this.mRedoPos = Utils.encodeUnsignedVarInt(buffer, pos, v);
    }

    private void redoWriteUnsignedVarLong(long v) throws IOException {
        int pos = this.mRedoPos;
        byte[] buffer = this.mRedoBuffer;
        if (pos > buffer.length - 9) {
            this.redoFlush(false);
            pos = 0;
        }
        this.mRedoPos = Utils.encodeUnsignedVarLong(buffer, pos, v);
    }

    private void redoWriteBytes(byte[] bytes, boolean term) throws IOException {
        this.redoWriteBytes(bytes, 0, bytes.length, term);
    }

    private void redoWriteBytes(byte[] bytes, int offset, int length, boolean term) throws IOException {
        if (length == 0) {
            return;
        }
        byte[] buffer = this.mRedoBuffer;
        int avail = buffer.length - this.mRedoPos;
        if (avail >= length) {
            if (this.mRedoPos == 0 && avail == length) {
                _RedoWriter redo = this.latchWriter();
                this.mRedoWriterPos = _TransactionContext.write(redo, bytes, offset, length, term);
            } else {
                System.arraycopy(bytes, offset, buffer, this.mRedoPos, length);
                this.mRedoPos += length;
            }
        } else {
            System.arraycopy(bytes, offset, buffer, this.mRedoPos, avail);
            this.mRedoPos = buffer.length;
            this.redoFlush(false);
            offset += avail;
            if ((length -= avail) >= buffer.length) {
                this.mRedoWriterPos = _TransactionContext.write(this.mRedoWriter, bytes, offset, length, term);
            } else {
                System.arraycopy(bytes, offset, buffer, 0, length);
                this.mRedoPos = length;
            }
        }
    }

    private static long write(_RedoWriter redo, byte[] bytes, int offset, int length, boolean term) throws IOException {
        try {
            return redo.write(false, bytes, offset, length, term ? length : 0, null);
        }
        catch (IOException e) {
            throw Utils.rethrow(e, redo.mCloseCause);
        }
    }

    private void redoWriteOp(_RedoWriter redo, byte op) throws IOException {
        this.mRedoPos = this.doRedoWriteOp(redo, op, 1);
    }

    private void redoWriteOp(_RedoWriter redo, byte op, long operand) throws IOException {
        int pos = this.doRedoWriteOp(redo, op, 9);
        Utils.encodeLongLE(this.mRedoBuffer, pos, operand);
        this.mRedoPos = pos + 8;
    }

    private int doRedoWriteOp(_RedoWriter redo, byte op, int len) throws IOException {
        byte[] buffer;
        int pos;
        if (redo != this.mRedoWriter) {
            this.switchRedo(redo);
        }
        if ((pos = this.mRedoPos) > (buffer = this.mRedoBuffer).length - len) {
            this.redoFlush(false);
            pos = 0;
        }
        buffer[pos] = op;
        return pos + 1;
    }

    /*
     * Unable to fully structure code
     */
    private void redoWriteTxnOp(_RedoWriter redo, byte op, long txnId) throws IOException {
        block3: {
            if (redo != this.mRedoWriter) {
                this.switchRedo(redo);
            }
            if ((pos = this.mRedoPos) <= (buffer = this.mRedoBuffer).length - 10) break block3;
            this.redoFlush(false);
            pos = 0;
            ** GOTO lbl-1000
        }
        if (pos != 0) {
            this.mRedoPos = Utils.encodeSignedVarLong(buffer, pos + 1, txnId - this.mRedoLastTxnId);
        } else lbl-1000:
        // 2 sources

        {
            this.mRedoFirstTxnId = txnId;
            this.mRedoPos = 10;
        }
        buffer[pos] = op;
        this.mRedoLastTxnId = txnId;
    }

    /*
     * Unable to fully structure code
     */
    private void redoWriteCursorOp(_RedoWriter redo, byte op, long cursorId, long txnId) throws IOException {
        block3: {
            if (redo != this.mRedoWriter) {
                this.switchRedo(redo);
            }
            if ((pos = this.mRedoPos) <= (buffer = this.mRedoBuffer).length - 20) break block3;
            this.redoFlush(false);
            ** GOTO lbl-1000
        }
        if (pos != 0) {
            buffer[pos] = op;
            pos = Utils.encodeSignedVarLong(buffer, pos + 1, cursorId - this.mRedoLastTxnId);
        } else lbl-1000:
        // 2 sources

        {
            buffer[0] = op;
            pos = 10;
            this.mRedoFirstTxnId = cursorId;
        }
        this.mRedoPos = Utils.encodeSignedVarLong(buffer, pos, txnId - cursorId);
        this.mRedoLastTxnId = txnId;
    }

    @Override
    public void flush() throws IOException {
        this.acquireRedoLatch();
        try {
            this.doFlush();
        }
        finally {
            this.releaseRedoLatch();
        }
    }

    void doFlush() throws IOException {
        this.redoFlush(false);
    }

    private void switchRedo(_RedoWriter redo) throws IOException {
        try {
            this.redoFlush(false);
        }
        catch (UnmodifiableReplicaException e) {
            this.mRedoPos = 0;
            this.mRedoTerminatePos = 0;
            this.mRedoFirstTxnId = 0L;
        }
        finally {
            if (this.mRedoWriterLatched) {
                this.mRedoWriter.releaseExclusive();
                this.mRedoWriterLatched = false;
            }
        }
        this.mRedoWriter = redo;
    }

    private long redoFlushCommit(DurabilityMode mode) throws IOException {
        if (mode == DurabilityMode.SYNC) {
            this.redoFlush(true);
            return this.mRedoWriterPos;
        }
        this.redoFlush(mode == DurabilityMode.NO_SYNC);
        return 0L;
    }

    private void redoFlush(boolean full) throws IOException {
        this.redoFlush(full, null);
    }

    private void redoFlush(boolean full, _PendingTxn pending) throws IOException {
        int length = this.mRedoPos;
        if (length == 0) {
            return;
        }
        int commitLen = this.mRedoTerminatePos;
        byte[] buffer = this.mRedoBuffer;
        int offset = 0;
        _RedoWriter redo = this.latchWriter();
        long redoWriterLastTxnId = redo.mLastTxnId;
        if (this.mRedoFirstTxnId != 0L) {
            long delta = Utils.convertSignedVarLong(this.mRedoFirstTxnId - redoWriterLastTxnId);
            int varLen = Utils.calcUnsignedVarLongLength(delta);
            offset = 10 - varLen;
            Utils.encodeUnsignedVarLong(buffer, offset, delta);
            buffer[--offset] = buffer[0];
            length -= offset;
            commitLen -= offset;
            redo.mLastTxnId = this.mRedoLastTxnId;
        }
        try {
            try {
                this.mRedoWriterPos = redo.write(full, buffer, offset, length, commitLen, pending);
            }
            catch (IOException e) {
                throw Utils.rethrow(e, redo.mCloseCause);
            }
        }
        catch (Throwable e) {
            redo.mLastTxnId = redoWriterLastTxnId;
            throw e;
        }
        this.mRedoPos = 0;
        this.mRedoTerminatePos = 0;
        this.mRedoFirstTxnId = 0L;
    }

    private _RedoWriter latchWriter() {
        _RedoWriter redo = this.mRedoWriter;
        if (!this.mRedoWriterLatched) {
            redo.acquireExclusive();
            this.mRedoWriterLatched = true;
        }
        return redo;
    }

    synchronized void register(_UndoLog log) {
        _UndoLog top = this.mTopUndoLog;
        if (top != null) {
            log.mPrev = top;
            top.mNext = log;
        }
        this.mTopUndoLog = log;
        ++this.mUndoLogCount;
    }

    synchronized void unregister(_UndoLog log) {
        _UndoLog prev = log.mPrev;
        _UndoLog next = log.mNext;
        if (prev != null) {
            prev.mNext = next;
            log.mPrev = null;
        }
        if (next != null) {
            next.mPrev = prev;
            log.mNext = null;
        } else if (log == this.mTopUndoLog) {
            this.mTopUndoLog = prev;
        }
        --this.mUndoLogCount;
    }

    synchronized void uncommitted(long txnId) {
        if (this.mUncommitted == null) {
            this.mUncommitted = new LHashTable.Obj(4);
        }
        this.mUncommitted.insert(txnId);
    }

    synchronized boolean anyActive(LHashTable.Obj<Object> committed) {
        _UndoLog log = this.mTopUndoLog;
        while (log != null) {
            if (committed.get(log.mTxnId) != null && log.isCommitted()) {
                return true;
            }
            log = log.mPrev;
        }
        return false;
    }

    synchronized LHashTable.Obj<Object> moveUncommitted(LHashTable.Obj<Object> dest) {
        LHashTable.Obj<Object> uncommitted = this.mUncommitted;
        if (uncommitted != null) {
            this.mUncommitted = null;
            if (dest == null) {
                return uncommitted;
            }
            uncommitted.traverse(e -> {
                dest.insert(e.key);
                return false;
            });
        }
        return dest;
    }

    void clearUncommitted() {
        this.mUncommitted = null;
    }

    synchronized LHashTable.Obj<Object> gatherCommitted(LHashTable.Obj<Object> dest) {
        _UndoLog log = this.mTopUndoLog;
        while (log != null) {
            if (log.isCommitted()) {
                if (dest == null) {
                    dest = new LHashTable.Obj(4);
                }
                dest.insert(log.mTxnId);
            }
            log = log.mPrev;
        }
        return dest;
    }

    long higherTransactionId(long txnId) {
        return Math.max(this.mHighTxnId, txnId);
    }

    boolean hasUndoLogs() {
        return this.mTopUndoLog != null;
    }

    byte[] writeToMaster(_UndoLog master, byte[] workspace) throws IOException {
        _UndoLog log = this.mTopUndoLog;
        while (log != null) {
            workspace = log.writeToMaster(master, workspace);
            log = log.mPrev;
        }
        return workspace;
    }

    synchronized void deleteUndoLogs() {
        _UndoLog log = this.mTopUndoLog;
        while (log != null) {
            log.delete();
            log = log.mPrev;
        }
        this.mTopUndoLog = null;
    }

    static {
        try {
            cHighTxnIdHandle = MethodHandles.lookup().findVarHandle(_TransactionContext.class, "mHighTxnId", Long.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }
}

