/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.diag;

import java.io.Serializable;
import org.cojen.tupl.core.Utils;

public class DatabaseStats
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public int pageSize;
    public long freePages;
    public long totalPages;
    public long cachePages;
    public long dirtyPages;
    public int openIndexes;
    public long lockCount;
    public long cursorCount;
    public long transactionCount;
    public long checkpointDuration;
    public long replicationBacklog;

    public DatabaseStats clone() {
        try {
            return (DatabaseStats)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Utils.rethrow(e);
        }
    }

    public int hashCode() {
        long hash = this.freePages;
        hash = hash * 31L + this.totalPages;
        hash = hash * 31L + this.dirtyPages;
        return (int)Utils.scramble(hash);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == DatabaseStats.class) {
            DatabaseStats other = (DatabaseStats)obj;
            return this.pageSize == other.pageSize && this.freePages == other.freePages && this.totalPages == other.totalPages && this.cachePages == other.cachePages && this.dirtyPages == other.dirtyPages && this.openIndexes == other.openIndexes && this.lockCount == other.lockCount && this.cursorCount == other.cursorCount && this.transactionCount == other.transactionCount && this.checkpointDuration == other.checkpointDuration && this.replicationBacklog == other.replicationBacklog;
        }
        return false;
    }

    public String toString() {
        return "DatabaseStats{pageSize=" + this.pageSize + ", freePages=" + this.freePages + ", totalPages=" + this.totalPages + ", cachePages=" + this.cachePages + ", dirtyPages=" + this.dirtyPages + ", openIndexes=" + this.openIndexes + ", lockCount=" + this.lockCount + ", cursorCount=" + this.cursorCount + ", transactionCount=" + this.transactionCount + ", checkpointDuration=" + this.checkpointDuration + ", replicationBacklog=" + this.replicationBacklog + "}";
    }
}

