/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.diag;

import java.io.PrintStream;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.ev.AllowEventListener;
import org.cojen.tupl.ev.DisallowEventListener;
import org.cojen.tupl.ev.EventLogger;
import org.cojen.tupl.ev.EventPrinter;
import org.cojen.tupl.ev.Slf4jLogger;
import org.slf4j.Logger;

public interface EventListener {
    public static EventListener printTo(PrintStream out) {
        return new EventPrinter(out);
    }

    public static EventListener logTo(java.util.logging.Logger logger) {
        return new EventLogger(logger);
    }

    public static EventListener logTo(System.Logger logger) {
        return new EventLogger(logger);
    }

    public static EventListener logTo(Logger logger) {
        return new Slf4jLogger(logger);
    }

    public void notify(EventType var1, String var2, Object ... var3);

    default public boolean isObserved(EventType type) {
        return this.isObserved(type.category) && this.isObserved(type.level);
    }

    default public boolean isObserved(EventType.Category category) {
        return true;
    }

    default public boolean isObserved(System.Logger.Level level) {
        return true;
    }

    default public EventListener observe(EventType.Category ... categories) {
        return AllowEventListener.make(this, categories);
    }

    default public EventListener observe(System.Logger.Level ... levels) {
        return AllowEventListener.make(this, levels);
    }

    default public EventListener ignore(EventType.Category ... categories) {
        return DisallowEventListener.make(this, categories);
    }

    default public EventListener ignore(System.Logger.Level ... levels) {
        return DisallowEventListener.make(this, levels);
    }
}

