/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.diag;

import java.io.Serializable;
import org.cojen.tupl.core.Utils;

public class IndexStats
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public double entryCount;
    public double keyBytes;
    public double valueBytes;
    public double freeBytes;
    public double totalBytes;

    public IndexStats() {
    }

    public IndexStats(double entryCount, double keyBytes, double valueBytes, double freeBytes, double totalBytes) {
        this.entryCount = entryCount;
        this.keyBytes = keyBytes;
        this.valueBytes = valueBytes;
        this.freeBytes = freeBytes;
        this.totalBytes = totalBytes;
    }

    public IndexStats add(IndexStats augend) {
        return new IndexStats(this.entryCount + augend.entryCount, this.keyBytes + augend.keyBytes, this.valueBytes + augend.valueBytes, this.freeBytes + augend.freeBytes, this.totalBytes + augend.totalBytes);
    }

    public IndexStats subtract(IndexStats subtrahend) {
        return new IndexStats(this.entryCount - subtrahend.entryCount, this.keyBytes - subtrahend.keyBytes, this.valueBytes - subtrahend.valueBytes, this.freeBytes - subtrahend.freeBytes, this.totalBytes - subtrahend.totalBytes);
    }

    public IndexStats divide(double scalar) {
        return new IndexStats(this.entryCount / scalar, this.keyBytes / scalar, this.valueBytes / scalar, this.freeBytes / scalar, this.totalBytes / scalar);
    }

    public IndexStats round() {
        return new IndexStats(Math.round(this.entryCount), Math.round(this.keyBytes), Math.round(this.valueBytes), Math.round(this.freeBytes), Math.round(this.totalBytes));
    }

    public IndexStats divideAndRound(double scalar) {
        return new IndexStats(Math.round(this.entryCount / scalar), Math.round(this.keyBytes / scalar), Math.round(this.valueBytes / scalar), Math.round(this.freeBytes / scalar), Math.round(this.totalBytes / scalar));
    }

    public IndexStats clone() {
        try {
            return (IndexStats)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Utils.rethrow(e);
        }
    }

    public int hashCode() {
        long hash = Double.doubleToLongBits(this.entryCount);
        hash = hash * 31L + Double.doubleToLongBits(this.keyBytes);
        hash = hash * 31L + Double.doubleToLongBits(this.valueBytes);
        hash = hash * 31L + Double.doubleToLongBits(this.freeBytes);
        hash = hash * 31L + Double.doubleToLongBits(this.totalBytes);
        return (int)Utils.scramble(hash);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == IndexStats.class) {
            IndexStats other = (IndexStats)obj;
            return this.entryCount == other.entryCount && this.keyBytes == other.keyBytes && this.valueBytes == other.valueBytes && this.freeBytes == other.freeBytes && this.totalBytes == other.totalBytes;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("IndexStats{");
        boolean any = false;
        any = IndexStats.append(b, any, "entryCount", this.entryCount);
        any = IndexStats.append(b, any, "keyBytes", this.keyBytes);
        any = IndexStats.append(b, any, "valueBytes", this.valueBytes);
        any = IndexStats.append(b, any, "freeBytes", this.freeBytes);
        any = IndexStats.append(b, any, "totalBytes", this.totalBytes);
        b.append('}');
        return b.toString();
    }

    private static boolean append(StringBuilder b, boolean any, String name, double value) {
        if (!Double.isNaN(value)) {
            if (any) {
                b.append(", ");
            }
            b.append(name).append('=');
            long v = (long)value;
            if ((double)v == value) {
                b.append(v);
            } else {
                b.append(value);
            }
            any = true;
        }
        return any;
    }
}

