/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.diag;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class QueryPlan
implements Serializable {
    QueryPlan() {
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        this.appendTo(b);
        return b.toString();
    }

    public void printTo(PrintStream out) {
        try {
            this.appendTo(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void appendTo(StringBuilder b) {
        try {
            this.appendTo((Appendable)b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void appendTo(Appendable a) throws IOException {
        this.appendTo(a, "", "");
    }

    abstract void appendTo(Appendable var1, String var2, String var3) throws IOException;

    private static Appendable appendItem(Appendable a, String indent, String title) throws IOException {
        return a.append(indent).append("...").append(title).append(": ");
    }

    private static Appendable appendArray(Appendable a, String[] array) throws IOException {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    a.append(", ");
                }
                a.append(array[i]);
            }
        }
        return a;
    }

    private static Appendable appendSub(Appendable a, String indent, String title, QueryPlan sub) throws IOException {
        if (sub != null) {
            String in1 = indent + "- ";
            if (title != null) {
                in1 = in1 + title + ": ";
            }
            String in2 = indent + "  ";
            sub.appendTo(a, in1, in2);
        }
        return a;
    }

    public static final class RangeUnion
    extends Union {
        private static final long serialVersionUID = 1L;

        public RangeUnion(QueryPlan ... sources) {
            super(sources);
        }

        @Override
        void appendTo(Appendable a, String in1, String in2) throws IOException {
            this.appendTo(a, in1, in2, "range union");
        }

        public boolean equals(Object obj) {
            RangeUnion union;
            return obj instanceof RangeUnion && this.matches(union = (RangeUnion)obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ 0x9E6BB5D1;
        }
    }

    public static final class DisjointUnion
    extends Union {
        private static final long serialVersionUID = 1L;

        public DisjointUnion(QueryPlan ... sources) {
            super(sources);
        }

        @Override
        void appendTo(Appendable a, String in1, String in2) throws IOException {
            this.appendTo(a, in1, in2, "disjoint union");
        }

        public boolean equals(Object obj) {
            DisjointUnion union;
            return obj instanceof DisjointUnion && this.matches(union = (DisjointUnion)obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ 0x280FC4CB;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Union
    extends Set {
        Union(QueryPlan ... sources) {
            super(sources);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ 0x59B5A696;
        }
    }

    public static final class Empty
    extends Set {
        public Empty() {
            super(new QueryPlan[0]);
        }

        @Override
        void appendTo(Appendable a, String in1, String in2) throws IOException {
            this.appendTo(a, in1, in2, "empty");
        }

        public boolean equals(Object obj) {
            return obj instanceof Empty;
        }

        @Override
        public int hashCode() {
            return 791511942;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Set
    extends QueryPlan {
        public final QueryPlan[] sources;

        Set(QueryPlan ... sources) {
            this.sources = sources;
        }

        void appendTo(Appendable a, String in1, String in2, String title) throws IOException {
            a.append(in1).append(title).append('\n');
            if (this.sources != null) {
                for (int i = 0; i < this.sources.length; ++i) {
                    QueryPlan.appendSub(a, in2, null, this.sources[i]);
                }
            }
        }

        boolean matches(Set other) {
            return Arrays.equals(this.sources, other.sources);
        }

        public int hashCode() {
            return Arrays.hashCode(this.sources) ^ 0x329CDC26;
        }
    }

    public static final class PrimaryJoin
    extends NaturalJoin {
        private static final long serialVersionUID = 1L;
        public final String table;

        public PrimaryJoin(String table, String[] keyColumns, QueryPlan source) {
            super(keyColumns, new LoadOne(table, "primary key", keyColumns), source);
            this.table = table;
        }

        @Override
        void appendTo(Appendable a, String in1, String in2) throws IOException {
            a.append(in1).append("primary join").append('\n');
            QueryPlan.appendItem(a, in2, "table").append(this.table).append('\n');
            QueryPlan.appendItem(a, in2, "key columns");
            QueryPlan.appendArray(a, this.columns).append('\n');
            QueryPlan.appendSub(a, in2, null, this.source);
        }

        @Override
        public boolean equals(Object obj) {
            PrimaryJoin join;
            return obj instanceof PrimaryJoin && this.matches(join = (PrimaryJoin)obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ 0x7A089E4D;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static class NaturalJoin
    extends QueryPlan {
        private static final long serialVersionUID = 1L;
        public final String[] columns;
        public final QueryPlan target;
        public final QueryPlan source;

        public NaturalJoin(String[] columns, QueryPlan target, QueryPlan source) {
            this.columns = columns;
            this.target = target;
            this.source = source;
        }

        @Override
        void appendTo(Appendable a, String in1, String in2) throws IOException {
            a.append(in1).append("natural join").append('\n');
            QueryPlan.appendItem(a, in2, "columns");
            QueryPlan.appendArray(a, this.columns).append('\n');
            QueryPlan.appendSub(a, in2, "target", this.target);
            QueryPlan.appendSub(a, in2, "source", this.source);
        }

        public boolean equals(Object obj) {
            NaturalJoin join;
            return obj instanceof NaturalJoin && this.matches(join = (NaturalJoin)obj);
        }

        boolean matches(NaturalJoin other) {
            return Arrays.equals(this.columns, other.columns) && Objects.equals(this.target, other.target) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int hash = Objects.hashCode(this.source);
            hash = hash * 31 + Objects.hashCode(this.target);
            hash = hash * 31 + Arrays.hashCode(this.columns);
            return hash ^ 0x7834B42C;
        }
    }

    public static final class GroupSort
    extends Sort {
        private static final long serialVersionUID = 1L;
        public final String[] groupColumns;

        public GroupSort(String[] groupColumns, String[] sortColumns, QueryPlan source) {
            super(sortColumns, source);
            this.groupColumns = groupColumns;
        }

        @Override
        void appendTo(Appendable a, String in1, String in2) throws IOException {
            a.append(in1).append("group sort").append(": [");
            QueryPlan.appendArray(a, this.groupColumns).append("], ");
            QueryPlan.appendArray(a, this.sortColumns).append('\n');
            QueryPlan.appendSub(a, in2, null, this.source);
        }

        @Override
        public boolean equals(Object obj) {
            GroupSort sort;
            return obj instanceof GroupSort && this.matches(sort = (GroupSort)obj);
        }

        boolean matches(GroupSort other) {
            return super.equals(other) && Arrays.equals(this.groupColumns, other.groupColumns);
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = hash * 31 + Arrays.hashCode(this.groupColumns);
            return hash ^ 0x5E90FC12;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static class Sort
    extends QueryPlan {
        private static final long serialVersionUID = 1L;
        public final String[] sortColumns;
        public final QueryPlan source;

        public Sort(String[] sortColumns, QueryPlan source) {
            this.sortColumns = sortColumns;
            this.source = source;
        }

        @Override
        void appendTo(Appendable a, String in1, String in2) throws IOException {
            a.append(in1).append("sort").append(": ");
            QueryPlan.appendArray(a, this.sortColumns).append('\n');
            QueryPlan.appendSub(a, in2, null, this.source);
        }

        public boolean equals(Object obj) {
            Sort sort;
            return obj instanceof Sort && this.matches(sort = (Sort)obj);
        }

        boolean matches(Sort other) {
            return Arrays.equals(this.sortColumns, other.sortColumns) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int hash = Arrays.hashCode(this.sortColumns);
            hash = hash * 31 + Objects.hashCode(this.source);
            return hash ^ 0xE7048E8F;
        }
    }

    public static final class Filter
    extends QueryPlan {
        private static final long serialVersionUID = 1L;
        public final String expression;
        public final QueryPlan source;

        public Filter(String expression, QueryPlan source) {
            this.expression = expression;
            this.source = source;
        }

        @Override
        void appendTo(Appendable a, String in1, String in2) throws IOException {
            a.append(in1).append("filter").append(": ").append(this.expression).append('\n');
            QueryPlan.appendSub(a, in2, null, this.source);
        }

        public boolean equals(Object obj) {
            Filter filter;
            return obj instanceof Filter && this.matches(filter = (Filter)obj);
        }

        boolean matches(Filter other) {
            return Objects.equals(this.expression, other.expression) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int hash = Objects.hashCode(this.expression);
            hash = hash * 31 + Objects.hashCode(this.source);
            return hash ^ 0xEF9DD36C;
        }
    }

    public static final class LoadOne
    extends Table {
        private static final long serialVersionUID = 1L;

        public LoadOne(String table, String which, String[] keyColumns) {
            super(table, which, keyColumns);
        }

        @Override
        void appendTo(Appendable a, String in1, String in2) throws IOException {
            a.append(in1).append("load one using ").append(this.which).append('\n');
            QueryPlan.appendItem(a, in2, "table").append(this.table).append('\n');
            this.appendKeyColumns(a, in2).append('\n');
        }

        public boolean equals(Object obj) {
            LoadOne load;
            return obj instanceof LoadOne && this.matches(load = (LoadOne)obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ 0xB5FF368E;
        }
    }

    public static final class RangeScan
    extends Scan {
        private static final long serialVersionUID = 1L;
        public final String low;
        public final String high;

        public RangeScan(String table, String which, String[] keyColumns, boolean reverse, String low, String high) {
            super(table, which, keyColumns, reverse);
            this.low = low;
            this.high = high;
        }

        @Override
        void appendTo(Appendable a, String in1, String in2) throws IOException {
            this.appendTo(a, in1, in2, "range");
            QueryPlan.appendItem(a, in2, "range");
            if (this.low != null) {
                a.append(this.low).append(' ');
            }
            a.append("..");
            if (this.high != null) {
                a.append(' ').append(this.high);
            }
            a.append('\n');
        }

        public boolean equals(Object obj) {
            RangeScan scan;
            return obj instanceof RangeScan && this.matches(scan = (RangeScan)obj);
        }

        boolean matches(RangeScan other) {
            return super.matches(other) && Objects.equals(this.low, other.low) && Objects.equals(this.high, other.high);
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = hash * 31 + Objects.hashCode(this.low);
            hash = hash * 31 + Objects.hashCode(this.high);
            return hash ^ 0xA1E1050;
        }
    }

    public static final class FullScan
    extends Scan {
        private static final long serialVersionUID = 1L;

        public FullScan(String table, String which, String[] keyColumns, boolean reverse) {
            super(table, which, keyColumns, reverse);
        }

        @Override
        void appendTo(Appendable a, String in1, String in2) throws IOException {
            this.appendTo(a, in1, in2, "full");
        }

        public boolean equals(Object obj) {
            FullScan scan;
            return obj instanceof FullScan && this.matches(scan = (FullScan)obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ 0x66F7C99E;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Scan
    extends Table {
        public final boolean reverse;

        Scan(String table, String which, String[] keyColumns, boolean reverse) {
            super(table, which, keyColumns);
            this.reverse = reverse;
        }

        void appendTo(Appendable a, String in1, String in2, String title) throws IOException {
            a.append(in1);
            if (this.reverse) {
                a.append("reverse ");
            }
            a.append(title).append(" scan over ").append(this.which).append('\n');
            QueryPlan.appendItem(a, in2, "table").append(this.table).append('\n');
            this.appendKeyColumns(a, in2).append('\n');
        }

        boolean matches(Scan other) {
            return super.matches(other) && this.reverse == other.reverse;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ (this.reverse ? 754613080 : 1644587376);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Table
    extends QueryPlan {
        public final String table;
        public final String which;
        public final String[] keyColumns;

        Table(String table, String which, String[] keyColumns) {
            this.table = table;
            this.which = which;
            this.keyColumns = keyColumns;
        }

        Appendable appendKeyColumns(Appendable a, String indent) throws IOException {
            QueryPlan.appendItem(a, indent, "key columns");
            return QueryPlan.appendArray(a, this.keyColumns);
        }

        boolean matches(Table other) {
            return Objects.equals(this.table, other.table) && Objects.equals(this.which, other.which) && Arrays.equals(this.keyColumns, other.keyColumns);
        }

        public int hashCode() {
            int hash = Objects.hashCode(this.table);
            hash = hash * 31 + Objects.hashCode(this.which);
            hash = hash * 31 + Arrays.hashCode(this.keyColumns);
            return hash;
        }
    }
}

