/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.diag;

import org.cojen.tupl.Index;

public class VerificationObserver {
    protected Index index;
    protected int height;
    public boolean failed;

    public boolean indexBegin(Index index, int height) {
        this.index = index;
        this.height = height;
        return true;
    }

    public boolean indexComplete(Index index, boolean passed, String message) {
        this.index = null;
        this.height = 0;
        return true;
    }

    public boolean indexNodePassed(long id, int level, int entryCount, int freeBytes, int largeValueCount) {
        return true;
    }

    public boolean indexNodeFailed(long id, int level, String message) {
        StringBuilder b = new StringBuilder("Verification failure: ");
        this.appendFailedMessage(b, id, level, message);
        this.reportFailure(b.toString());
        return true;
    }

    protected void appendFailedMessage(StringBuilder b, long id, int level, String message) {
        b.append("index=");
        Index index = this.index;
        if (index == null) {
            b.append("null");
        } else {
            b.append(index.id());
            String name = index.nameString();
            if (name != null) {
                b.append(" (").append(name).append(')');
            }
        }
        b.append(", node=").append(id).append(", level=").append(level).append(": ").append(message);
    }

    protected void reportFailure(String message) {
        System.out.println(message);
    }
}

