/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.ev;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.ev.FilteredEventListener;

public final class AllowEventListener
extends FilteredEventListener {
    public static EventListener make(EventListener listener, EventType.Category ... categories) {
        Set levelSet;
        EventListener original = listener;
        Set<EventType.Category> categorySet = categories.length == 0 ? Collections.emptySet() : new HashSet<EventType.Category>(Arrays.asList(categories));
        if (listener instanceof AllowEventListener) {
            AllowEventListener allowed = (AllowEventListener)listener;
            listener = allowed.mListener;
            categorySet.retainAll(allowed.mCategories);
            levelSet = allowed.mLevels;
        } else {
            levelSet = null;
        }
        return AllowEventListener.make(original, listener, categorySet, levelSet);
    }

    public static EventListener make(EventListener listener, System.Logger.Level ... levels) {
        Set categorySet;
        EventListener original = listener;
        Set<System.Logger.Level> levelSet = levels.length == 0 ? Collections.emptySet() : new HashSet<System.Logger.Level>(Arrays.asList(levels));
        if (listener instanceof AllowEventListener) {
            AllowEventListener allowed = (AllowEventListener)listener;
            listener = allowed.mListener;
            levelSet.retainAll(allowed.mLevels);
            categorySet = allowed.mCategories;
        } else {
            categorySet = null;
        }
        return AllowEventListener.make(original, listener, categorySet, levelSet);
    }

    private static EventListener make(EventListener original, EventListener listener, Set<EventType.Category> categories, Set<System.Logger.Level> levels) {
        AllowEventListener newListener = new AllowEventListener(listener, categories, levels);
        return newListener.equals(original) ? original : newListener;
    }

    AllowEventListener(EventListener listener, Set<EventType.Category> categories, Set<System.Logger.Level> levels) {
        super(listener, categories, levels);
    }

    @Override
    public boolean isObserved(EventType.Category category) {
        return this.mCategories == null || this.mCategories.contains((Object)category);
    }

    @Override
    public boolean isObserved(System.Logger.Level level) {
        return this.mLevels == null || this.mLevels.contains((Object)level);
    }

    @Override
    protected boolean sameClass(Object obj) {
        return obj.getClass() == AllowEventListener.class;
    }
}

