/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.ev;

import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.ev.SafeEventListener;

public class ChainedEventListener
extends SafeEventListener {
    private final EventListener[] mRest;

    public static EventListener make(EventListener ... listeners) {
        if (listeners == null || listeners.length == 0) {
            return null;
        }
        int count = 0;
        EventListener first = null;
        for (EventListener listener : listeners) {
            if (listener == null) continue;
            ++count;
            if (first != null) continue;
            first = listener;
        }
        if (count <= 1) {
            return first;
        }
        EventListener[] rest = new EventListener[count - 1];
        int j = 0;
        for (int i = 0; i < listeners.length; ++i) {
            EventListener listener;
            listener = listeners[i];
            if (listener == null || listener == first) continue;
            rest[j++] = listener;
        }
        return new ChainedEventListener(first, rest);
    }

    ChainedEventListener(EventListener first, EventListener ... rest) {
        super(first);
        this.mRest = rest;
    }

    @Override
    public void notify(EventType type, String message, Object ... args) {
        try {
            if (this.shouldNotify(type)) {
                this.mListener.notify(type, message, args);
                for (EventListener listener : this.mRest) {
                    try {
                        listener.notify(type, message, args);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

