/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.ev;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.ev.FilteredEventListener;

public final class DisallowEventListener
extends FilteredEventListener {
    public static EventListener make(EventListener listener, EventType.Category ... categories) {
        Set levelSet;
        if (categories.length == 0) {
            return listener;
        }
        EventListener original = listener;
        HashSet<EventType.Category> categorySet = new HashSet<EventType.Category>(Arrays.asList(categories));
        if (listener instanceof DisallowEventListener) {
            DisallowEventListener disallowed = (DisallowEventListener)listener;
            listener = disallowed.mListener;
            categorySet.addAll(disallowed.mCategories);
            levelSet = disallowed.mLevels;
        } else {
            levelSet = null;
        }
        return DisallowEventListener.make(original, listener, categorySet, levelSet);
    }

    public static EventListener make(EventListener listener, System.Logger.Level ... levels) {
        Set categorySet;
        if (levels.length == 0) {
            return listener;
        }
        EventListener original = listener;
        HashSet<System.Logger.Level> levelSet = new HashSet<System.Logger.Level>(Arrays.asList(levels));
        if (listener instanceof DisallowEventListener) {
            DisallowEventListener disallowed = (DisallowEventListener)listener;
            listener = disallowed.mListener;
            levelSet.addAll(disallowed.mLevels);
            categorySet = disallowed.mCategories;
        } else {
            categorySet = null;
        }
        return DisallowEventListener.make(original, listener, categorySet, levelSet);
    }

    private static EventListener make(EventListener original, EventListener listener, Set<EventType.Category> categories, Set<System.Logger.Level> levels) {
        DisallowEventListener newListener = new DisallowEventListener(listener, categories, levels);
        return newListener.equals(original) ? original : newListener;
    }

    DisallowEventListener(EventListener listener, Set<EventType.Category> categories, Set<System.Logger.Level> levels) {
        super(listener, categories, levels);
    }

    @Override
    public boolean isObserved(EventType.Category category) {
        return this.mCategories == null || !this.mCategories.contains((Object)category);
    }

    @Override
    public boolean isObserved(System.Logger.Level level) {
        return this.mLevels == null || !this.mLevels.contains((Object)level);
    }

    @Override
    protected boolean sameClass(Object obj) {
        return obj.getClass() == DisallowEventListener.class;
    }
}

