/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.ev;

import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.io.Utils;

public final class EventLogger
implements EventListener {
    private final Object mLogger;

    public EventLogger(Logger logger) {
        this.mLogger = Objects.requireNonNull(logger);
    }

    public EventLogger(System.Logger logger) {
        this.mLogger = Objects.requireNonNull(logger);
    }

    @Override
    public void notify(EventType type, String message, Object ... args) {
        try {
            Object object = this.mLogger;
            if (object instanceof System.Logger) {
                System.Logger logger = (System.Logger)object;
                if (logger.isLoggable(type.level)) {
                    logger.log(type.level, (ResourceBundle)null, EventLogger.makeMessage(type, message, args), EventLogger.makeThrown(args));
                }
            } else {
                EventLogger.notify((Logger)this.mLogger, type, message, args);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void notify(Logger logger, EventType type, String message, Object ... args) {
        Level level;
        switch (type.level) {
            case ALL: {
                Level level2 = Level.ALL;
                break;
            }
            case TRACE: {
                Level level2 = Level.FINER;
                break;
            }
            case DEBUG: {
                Level level2 = Level.FINE;
                break;
            }
            case INFO: {
                Level level2 = Level.INFO;
                break;
            }
            case WARNING: {
                Level level2 = Level.WARNING;
                break;
            }
            default: {
                Level level2 = Level.SEVERE;
                break;
            }
            case OFF: {
                Level level2 = level = Level.OFF;
            }
        }
        if (logger.isLoggable(level)) {
            LogRecord record = new LogRecord(level, EventLogger.makeMessage(type, message, args));
            record.setSourceClassName(null);
            record.setSourceMethodName(null);
            record.setThrown(EventLogger.makeThrown(args));
            logger.log(record);
        }
    }

    private static String makeMessage(EventType type, String message, Object ... args) {
        return type.category + ": " + String.format(message, args);
    }

    private static Throwable makeThrown(Object ... args) {
        Throwable thrown = null;
        for (Object obj : args) {
            if (!(obj instanceof Throwable)) continue;
            Throwable t = (Throwable)obj;
            if (thrown != null) {
                Utils.suppress(thrown, t);
                continue;
            }
            thrown = t;
        }
        return thrown;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof EventLogger)) return false;
        EventLogger el = (EventLogger)obj;
        if (!this.mLogger.equals(el.mLogger)) return false;
        return true;
    }

    public int hashCode() {
        return this.mLogger.hashCode();
    }
}

