/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.ev;

import java.io.PrintStream;
import java.util.Objects;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;

public final class EventPrinter
implements EventListener {
    private final PrintStream mOut;

    public EventPrinter(PrintStream out) {
        this.mOut = Objects.requireNonNull(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(EventType type, String message, Object ... args) {
        try {
            String fullMessage = type.category + ": " + String.format(message, args);
            PrintStream printStream = this.mOut;
            synchronized (printStream) {
                this.mOut.println(fullMessage);
                for (Object obj : args) {
                    if (!(obj instanceof Throwable)) continue;
                    Throwable t = (Throwable)obj;
                    t.printStackTrace(this.mOut);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof EventPrinter)) return false;
        EventPrinter ep = (EventPrinter)obj;
        if (!this.mOut.equals(ep.mOut)) return false;
        return true;
    }

    public int hashCode() {
        return this.mOut.hashCode();
    }
}

