/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.ev;

import java.util.Objects;
import java.util.Set;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.ev.SafeEventListener;

abstract class FilteredEventListener
extends SafeEventListener {
    protected final Set<EventType.Category> mCategories;
    protected final Set<System.Logger.Level> mLevels;

    FilteredEventListener(EventListener listener, Set<EventType.Category> categories, Set<System.Logger.Level> levels) {
        super(listener);
        this.mCategories = categories;
        this.mLevels = levels;
    }

    @Override
    final boolean shouldNotify(EventType type) {
        return this.isObserved(type.category) && this.isObserved(type.level);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.sameClass(obj)) {
            FilteredEventListener other = (FilteredEventListener)obj;
            return this.mListener.equals(other.mListener) && Objects.equals(this.mCategories, other.mCategories) && Objects.equals(this.mLevels, other.mLevels);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + Objects.hashCode(this.mCategories);
        hash = hash * 31 + Objects.hashCode(this.mLevels);
        return hash;
    }

    protected abstract boolean sameClass(Object var1);
}

