/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.ev;

import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.ev.EventLogger;
import org.cojen.tupl.ev.EventPrinter;

public class SafeEventListener
implements EventListener {
    final EventListener mListener;

    public static EventListener makeSafe(EventListener listener) {
        return listener == null || listener instanceof SafeEventListener || listener.getClass() == EventLogger.class || listener.getClass() == EventPrinter.class ? listener : new SafeEventListener(listener);
    }

    SafeEventListener(EventListener listener) {
        this.mListener = listener;
    }

    @Override
    public void notify(EventType type, String message, Object ... args) {
        try {
            if (this.shouldNotify(type)) {
                this.mListener.notify(type, message, args);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isObserved(EventType type) {
        return this.mListener.isObserved(type);
    }

    @Override
    public boolean isObserved(EventType.Category category) {
        return this.mListener.isObserved(category);
    }

    @Override
    public boolean isObserved(System.Logger.Level level) {
        return this.mListener.isObserved(level);
    }

    boolean shouldNotify(EventType type) {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == SafeEventListener.class) {
            return this.mListener.equals(((SafeEventListener)obj).mListener);
        }
        return false;
    }

    public int hashCode() {
        return this.mListener.hashCode() + this.getClass().hashCode();
    }
}

