/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.ev;

import java.util.Objects;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.io.Utils;
import org.slf4j.Logger;

public final class Slf4jLogger
implements EventListener {
    private final Logger mLogger;

    public Slf4jLogger(Logger logger) {
        this.mLogger = Objects.requireNonNull(logger);
    }

    @Override
    public void notify(EventType type, String message, Object ... args) {
        try {
            Logger logger = this.mLogger;
            switch (type.level) {
                case ALL: 
                case TRACE: {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace(Slf4jLogger.makeMessage(type, message, args), Slf4jLogger.makeThrown(args));
                    break;
                }
                case DEBUG: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(Slf4jLogger.makeMessage(type, message, args), Slf4jLogger.makeThrown(args));
                    break;
                }
                case INFO: {
                    if (!logger.isInfoEnabled()) break;
                    logger.info(Slf4jLogger.makeMessage(type, message, args), Slf4jLogger.makeThrown(args));
                    break;
                }
                case WARNING: {
                    if (!logger.isWarnEnabled()) break;
                    logger.warn(Slf4jLogger.makeMessage(type, message, args), Slf4jLogger.makeThrown(args));
                    break;
                }
                default: {
                    if (!logger.isErrorEnabled()) break;
                    logger.error(Slf4jLogger.makeMessage(type, message, args), Slf4jLogger.makeThrown(args));
                }
                case OFF: 
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String makeMessage(EventType type, String message, Object ... args) {
        return type.category + ": " + String.format(message, args);
    }

    private static Throwable makeThrown(Object ... args) {
        Throwable thrown = null;
        for (Object obj : args) {
            if (!(obj instanceof Throwable)) continue;
            Throwable t = (Throwable)obj;
            if (thrown != null) {
                Utils.suppress(thrown, t);
                continue;
            }
            thrown = t;
        }
        return thrown;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Slf4jLogger)) return false;
        Slf4jLogger sl = (Slf4jLogger)obj;
        if (!this.mLogger.equals(sl.mLogger)) return false;
        return true;
    }

    public int hashCode() {
        return this.mLogger.hashCode();
    }
}

