/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.filter;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import org.cojen.tupl.filter.ColumnFilter;
import org.cojen.tupl.filter.ColumnToArgFilter;
import org.cojen.tupl.filter.FalseFilter;
import org.cojen.tupl.filter.GroupFilter;
import org.cojen.tupl.filter.OrFilter;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.filter.TrueFilter;
import org.cojen.tupl.filter.Visitor;
import org.cojen.tupl.rows.ColumnInfo;

public class AndFilter
extends GroupFilter {
    static RowFilter flatten(RowFilter[] subFilters, int off, int len) {
        if (len == 1) {
            return subFilters[off];
        }
        if (len == 0) {
            return TrueFilter.THE;
        }
        int count = 0;
        for (int i = off; i < off + len; ++i) {
            RowFilter sub = subFilters[i];
            if (sub instanceof AndFilter) {
                AndFilter af = (AndFilter)sub;
                count += af.mSubFilters.length;
                continue;
            }
            ++count;
        }
        if (count == 0) {
            return TrueFilter.THE;
        }
        RowFilter[] newSubFilters = new RowFilter[count];
        int i = off;
        int j = 0;
        while (j < newSubFilters.length) {
            RowFilter sub;
            if ((sub = subFilters[i++]) instanceof AndFilter) {
                AndFilter af = (AndFilter)sub;
                for (RowFilter andSubFilter : af.mSubFilters) {
                    newSubFilters[j++] = andSubFilter;
                }
                continue;
            }
            newSubFilters[j++] = sub;
        }
        if (newSubFilters.length == 1) {
            return newSubFilters[0];
        }
        return new AndFilter(newSubFilters);
    }

    AndFilter(RowFilter ... subFilters) {
        super(Arrays.hashCode(subFilters), subFilters);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    void appendTo(StringBuilder b) {
        if (this.mSubFilters.length == 0) {
            b.append('T');
        } else {
            super.appendTo(b);
        }
    }

    @Override
    public boolean isDnf() {
        if ((this.mFlags & 1) != 0) {
            return (this.mFlags & 2) != 0;
        }
        for (RowFilter sub : this.mSubFilters) {
            if (!(sub instanceof OrFilter) && sub.isDnf()) continue;
            this.mFlags |= 1;
            return false;
        }
        this.mFlags |= 3;
        this.mDnf = this;
        return true;
    }

    @Override
    public boolean isCnf() {
        if ((this.mFlags & 4) != 0) {
            return (this.mFlags & 8) != 0;
        }
        for (RowFilter sub : this.mSubFilters) {
            if (sub.isCnf()) continue;
            this.mFlags |= 4;
            return false;
        }
        this.mFlags |= 0xC;
        this.mCnf = this;
        return true;
    }

    @Override
    public int isMatch(RowFilter filter) {
        if (this.equals(filter)) {
            return 1;
        }
        if (filter instanceof AndFilter) {
            AndFilter af = (AndFilter)filter;
            return this.matchSet().equalMatches(af.matchSet());
        }
        if (filter instanceof OrFilter) {
            OrFilter of = (OrFilter)filter;
            return this.matchSet().inverseMatches(of.matchSet());
        }
        return 0;
    }

    @Override
    public OrFilter not() {
        return new OrFilter(this.subNot());
    }

    @Override
    public RowFilter retain(Map<String, ColumnInfo> columns, boolean strict, RowFilter undecided) {
        RowFilter[] subFilters = this.mSubFilters;
        if (subFilters.length == 0) {
            return this;
        }
        subFilters = (RowFilter[])this.mSubFilters.clone();
        int len = 0;
        for (int i = 0; i < subFilters.length; ++i) {
            RowFilter sub = subFilters[i].retain(columns, strict, undecided);
            if (sub == FalseFilter.THE) {
                return sub;
            }
            if (sub == TrueFilter.THE) continue;
            subFilters[len++] = sub;
        }
        return this.newInstance(subFilters, 0, len);
    }

    @Override
    public RowFilter[] split(Map<String, ColumnInfo> columns) {
        RowFilter[] result = new RowFilter[]{TrueFilter.THE, TrueFilter.THE};
        this.splitCombine(columns, result);
        return result;
    }

    @Override
    protected void splitCombine(Map<String, ColumnInfo> columns, RowFilter[] result) {
        for (RowFilter sub : this.mSubFilters) {
            sub.splitCombine(columns, result);
        }
    }

    @Override
    public RowFilter[] rangeExtract(ColumnInfo ... keyColumns) {
        if (this.mReduced == null) {
            return this.reduce().rangeExtract(keyColumns);
        }
        RowFilter[] subFilters = this.mSubFilters;
        ColumnToArgFilter[] lowTerms = new ColumnToArgFilter[keyColumns.length];
        ColumnToArgFilter[] highTerms = new ColumnToArgFilter[keyColumns.length];
        boolean fuzzy = false;
        block0: for (int k = 0; k < keyColumns.length; ++k) {
            ColumnInfo keyColumn = keyColumns[k];
            String keyName = keyColumn.name;
            for (int match = 0; match <= 1; ++match) {
                int s;
                block10: {
                    for (s = 0; s < subFilters.length; ++s) {
                        RowFilter sub = subFilters[s];
                        if (!(sub instanceof ColumnToArgFilter)) continue;
                        ColumnToArgFilter term = (ColumnToArgFilter)sub;
                        if (!keyName.equals(term.mColumn.name)) continue;
                        int op = term.mOperator;
                        if (match == 0) {
                            if (op != 0) continue;
                            lowTerms[k] = term;
                            highTerms[k] = term;
                            if (term.mColumn.type == BigDecimal.class) {
                                fuzzy = true;
                                continue;
                            }
                            break block10;
                        }
                        if (!keyColumn.isDescending()) {
                            if (op == 5 || op == 2) {
                                if (lowTerms[k] != null) continue;
                                lowTerms[k] = term;
                                subFilters = this.removeSub(subFilters, s);
                                continue;
                            }
                            if (op != 3 && op != 4 || highTerms[k] != null) continue;
                            highTerms[k] = term;
                            subFilters = this.removeSub(subFilters, s);
                            continue;
                        }
                        if (op == 5 || op == 2) {
                            if (highTerms[k] != null) continue;
                            highTerms[k] = ColumnToArgFilter.descending(term);
                            subFilters = this.removeSub(subFilters, s);
                            continue;
                        }
                        if (op != 3 && op != 4 || lowTerms[k] != null) continue;
                        lowTerms[k] = ColumnToArgFilter.descending(term);
                        subFilters = this.removeSub(subFilters, s);
                    }
                    continue;
                }
                subFilters = this.removeSub(subFilters, s);
                continue block0;
            }
        }
        RowFilter lowRange = AndFilter.combineRange(lowTerms, fuzzy, 2);
        RowFilter highRange = AndFilter.combineRange(highTerms, fuzzy, 4);
        RowFilter remaining = this;
        if (subFilters != this.mSubFilters && (remaining = AndFilter.flatten(subFilters, 0, subFilters.length)) == TrueFilter.THE) {
            remaining = null;
        }
        return new RowFilter[]{lowRange, highRange, remaining, null};
    }

    private RowFilter[] removeSub(RowFilter[] subFilters, int s) {
        if (subFilters == this.mSubFilters) {
            subFilters = (RowFilter[])this.mSubFilters.clone();
        }
        subFilters[s] = TrueFilter.THE;
        return subFilters;
    }

    private static RowFilter combineRange(ColumnToArgFilter[] terms, boolean fuzzy, int lastOp) {
        int len;
        for (len = 0; len < terms.length && terms[len] != null; ++len) {
        }
        if (len == 0) {
            return null;
        }
        if (!fuzzy && terms[len - 1].operator() == 0) {
            terms[len - 1] = terms[len - 1].withOperator(lastOp);
        }
        return AndFilter.flatten(terms, 0, len);
    }

    @Override
    public boolean matchesOne(RowFilter high, ColumnInfo ... keyColumns) {
        AndFilter highCol;
        block9: {
            block8: {
                if (!(high instanceof AndFilter)) break block8;
                highCol = (AndFilter)high;
                if (this.mSubFilters.length == keyColumns.length && this.mSubFilters.length == highCol.mSubFilters.length) break block9;
            }
            return false;
        }
        for (int i = 0; i < this.mSubFilters.length; ++i) {
            RowFilter lowSub = this.mSubFilters[i];
            if (!(lowSub instanceof ColumnToArgFilter)) {
                return false;
            }
            ColumnToArgFilter lowSubCol = (ColumnToArgFilter)lowSub;
            RowFilter highSub = highCol.mSubFilters[i];
            if (!(highSub instanceof ColumnToArgFilter)) {
                return false;
            }
            ColumnToArgFilter highSubCol = (ColumnToArgFilter)highSub;
            if (lowSubCol.mArgNum != highSubCol.mArgNum || !lowSubCol.mColumn.name.equals(highSubCol.mColumn.name)) {
                return false;
            }
            int lowOp = 0;
            int highOp = 0;
            if (i == this.mSubFilters.length - 1) {
                lowOp = 2;
                highOp = 4;
            }
            if (lowSubCol.mOperator == lowOp && highSubCol.mOperator == highOp) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchesOne(String columnName) {
        for (RowFilter sub : this.mSubFilters) {
            if (!sub.matchesOne(columnName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final char opChar() {
        return '&';
    }

    @Override
    final RowFilter newInstance(RowFilter[] subFilters, int off, int len) {
        return AndFilter.flatten(subFilters, off, len);
    }

    @Override
    final RowFilter newFlippedInstance(RowFilter ... subFilters) {
        return OrFilter.flatten(subFilters, 0, subFilters.length);
    }

    @Override
    final RowFilter emptyInstance() {
        return TrueFilter.THE;
    }

    @Override
    final RowFilter emptyFlippedInstance() {
        return FalseFilter.THE;
    }

    @Override
    final int reduceOperator(ColumnFilter a, ColumnFilter b) {
        return a.reduceOperatorForAnd(b);
    }
}

