/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.filter;

import java.util.Map;
import org.cojen.tupl.filter.OrFilter;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.rows.ColumnInfo;

public abstract class ColumnFilter
extends RowFilter {
    public static final int OP_EQ = 0;
    public static final int OP_NE = 1;
    public static final int OP_GE = 2;
    public static final int OP_LT = 3;
    public static final int OP_LE = 4;
    public static final int OP_GT = 5;
    public static final int OP_IN = 6;
    public static final int OP_NOT_IN = 7;
    final ColumnInfo mColumn;
    final int mOperator;
    int mMatchHashCode;
    private static final int[] REDUCE_AND = new int[]{0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, 1, -6, 3, -4, 5, 0, -6, 2, Integer.MAX_VALUE, -1, 5, Integer.MAX_VALUE, 3, Integer.MAX_VALUE, 3, 3, Integer.MAX_VALUE, 0, -4, -1, 3, 4, Integer.MAX_VALUE, Integer.MAX_VALUE, 5, 5, Integer.MAX_VALUE, Integer.MAX_VALUE, 5};
    private static final int[] REDUCE_OR = new int[]{0, Integer.MAX_VALUE, 2, -5, 4, -3, Integer.MAX_VALUE, 1, Integer.MAX_VALUE, 1, Integer.MAX_VALUE, 1, 2, Integer.MAX_VALUE, 2, Integer.MAX_VALUE, Integer.MAX_VALUE, 2, -5, 1, Integer.MAX_VALUE, 3, 4, -2, 4, Integer.MAX_VALUE, Integer.MAX_VALUE, 4, 4, Integer.MAX_VALUE, -3, 1, 2, -2, Integer.MAX_VALUE, 5};

    public static int flipOperator(int op) {
        return op ^ 1;
    }

    public static int descendingOperator(int op) {
        return switch (op) {
            case 2 -> 4;
            case 3 -> 5;
            case 4 -> 2;
            case 5 -> 3;
            default -> op;
        };
    }

    public static boolean hasEqualComponent(int op) {
        return (op & 1) == 0;
    }

    public static int removeEqualComponent(int op) {
        return switch (op) {
            case 0 -> 1;
            case 2 -> 5;
            case 4 -> 3;
            default -> op;
        };
    }

    ColumnFilter(int hash, ColumnInfo column, int op) {
        super(hash);
        this.mColumn = column;
        this.mOperator = op;
    }

    @Override
    public int numTerms() {
        return 1;
    }

    @Override
    public RowFilter reduce() {
        return this;
    }

    @Override
    RowFilter reduce(long limit, boolean merge) {
        return this;
    }

    @Override
    RowFilter expandOperators(boolean force) {
        int op1;
        if (!force) {
            return this;
        }
        switch (this.mOperator) {
            default: {
                return this;
            }
            case 2: {
                op1 = 5;
                break;
            }
            case 4: {
                op1 = 3;
            }
        }
        return new OrFilter(this.withOperator(op1), this.withOperator(0));
    }

    @Override
    public boolean isDnf() {
        return true;
    }

    @Override
    public ColumnFilter dnf() {
        return this;
    }

    @Override
    ColumnFilter dnf(long limit, boolean merge) {
        return this;
    }

    @Override
    public boolean isCnf() {
        return true;
    }

    @Override
    public ColumnFilter cnf() {
        return this;
    }

    @Override
    ColumnFilter cnf(long limit, boolean merge) {
        return this;
    }

    @Override
    public int isSubMatch(RowFilter filter) {
        return this.isMatch(filter);
    }

    @Override
    public ColumnFilter not() {
        return this.withOperator(ColumnFilter.flipOperator(this.mOperator));
    }

    @Override
    public ColumnFilter sort() {
        return this;
    }

    @Override
    public RowFilter prioritize(Map<String, ColumnInfo> columns) {
        return this;
    }

    public ColumnInfo column() {
        return this.mColumn;
    }

    public int operator() {
        return this.mOperator;
    }

    public String operatorString() {
        return switch (this.mOperator) {
            case 0 -> "==";
            case 1 -> "!=";
            case 2 -> ">=";
            case 3 -> "<";
            case 4 -> "<=";
            case 5 -> ">";
            case 6 -> "in";
            case 7 -> "!in";
            default -> "?";
        };
    }

    public boolean isExact() {
        return ColumnFilter.isExact(this.mOperator);
    }

    public static boolean isExact(int op) {
        return op <= 1;
    }

    public boolean isIn() {
        return ColumnFilter.isIn(this.mOperator);
    }

    public static boolean isIn(int op) {
        return op >= 6;
    }

    int reduceOperatorForAnd(ColumnFilter other) {
        if (!this.isReducible(other)) {
            return Integer.MIN_VALUE;
        }
        return ColumnFilter.reduceOperatorForAnd(this.mOperator, other.mOperator);
    }

    static int reduceOperatorForAnd(int op1, int op2) {
        if (op1 < 6 && op2 < 6) {
            return REDUCE_AND[op1 * 6 + op2];
        }
        return Integer.MIN_VALUE;
    }

    int reduceOperatorForOr(ColumnFilter other) {
        if (!this.isReducible(other)) {
            return Integer.MIN_VALUE;
        }
        return ColumnFilter.reduceOperatorForOr(this.mOperator, other.mOperator);
    }

    static int reduceOperatorForOr(int op1, int op2) {
        if (op1 < 6 && op2 < 6) {
            return REDUCE_OR[op1 * 6 + op2];
        }
        return Integer.MIN_VALUE;
    }

    private boolean isReducible(ColumnFilter other) {
        return this.mColumn.equals(other.mColumn) && this.equalRhs(other);
    }

    abstract boolean equalRhs(ColumnFilter var1);

    abstract ColumnFilter withOperator(int var1);

    @Override
    void appendTo(StringBuilder b) {
        b.append(this.mColumn.name).append(' ').append(this.operatorString()).append(' ');
    }
}

