/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.filter;

import java.math.BigDecimal;
import java.util.Map;
import org.cojen.tupl.filter.ColumnFilter;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.filter.Visitor;
import org.cojen.tupl.rows.ColumnInfo;

public class ColumnToArgFilter
extends ColumnFilter {
    final int mArgNum;

    ColumnToArgFilter(ColumnInfo column, int op, int arg) {
        super(ColumnToArgFilter.hash(column, op, arg), column, op);
        this.mArgNum = arg;
    }

    private static int hash(ColumnInfo column, int op, int arg) {
        int hash = column.hashCode();
        hash = hash * 31 + op;
        hash = hash * 31 + arg;
        return hash;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int isMatch(RowFilter filter) {
        if (filter == this) {
            return 1;
        }
        if (filter instanceof ColumnToArgFilter) {
            ColumnToArgFilter other = (ColumnToArgFilter)filter;
            if (this.mArgNum == other.mArgNum && this.mColumn.equals(other.mColumn)) {
                if (this.mOperator == other.mOperator) {
                    return 1;
                }
                if (this.mOperator == ColumnToArgFilter.flipOperator(other.mOperator)) {
                    return -1;
                }
            }
        }
        return 0;
    }

    @Override
    public int matchHashCode() {
        int hash = this.mMatchHashCode;
        if (hash == 0) {
            hash = this.mColumn.hashCode();
            hash = hash * 31 + (this.mOperator & 0xFFFFFFFE);
            this.mMatchHashCode = hash = hash * 31 + this.mArgNum;
        }
        return hash;
    }

    @Override
    public boolean isSufficient(Map<String, ColumnInfo> columns) {
        return columns.containsKey(this.mColumn.name);
    }

    @Override
    public RowFilter retain(Map<String, ColumnInfo> columns, boolean strict, RowFilter undecided) {
        return columns.containsKey(this.mColumn.name) ? this : undecided;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public RowFilter[] rangeExtract(ColumnInfo ... keyColumns) {
        if (!keyColumns[0].name.equals(this.mColumn.name)) ** GOTO lbl-1000
        remaining = null;
        switch (this.mOperator) {
            case 0: {
                if (this.mColumn.type != BigDecimal.class) {
                    low = this.withOperator(2);
                    high = this.withOperator(4);
                    break;
                }
                remaining = this;
                low = this;
                high = this;
                break;
            }
            case 2: 
            case 5: {
                low = this;
                high = null;
                break;
            }
            case 3: 
            case 4: {
                low = null;
                high = this;
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                remaining = this;
                low = null;
                high = null;
            }
        }
        if (keyColumns[0].isDescending()) {
            newLow = ColumnToArgFilter.descending(high);
            high = ColumnToArgFilter.descending(low);
            low = newLow;
        }
        return new RowFilter[]{low, high, remaining, null};
    }

    static ColumnToArgFilter descending(ColumnToArgFilter filter) {
        if (filter != null) {
            int op;
            switch (filter.mOperator) {
                case 2: {
                    op = 4;
                    break;
                }
                case 3: {
                    op = 5;
                    break;
                }
                case 4: {
                    op = 2;
                    break;
                }
                case 5: {
                    op = 3;
                    break;
                }
                default: {
                    return filter;
                }
            }
            filter = filter.withOperator(op);
        }
        return filter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matchesOne(RowFilter high, ColumnInfo ... keyColumns) {
        if (!(high instanceof ColumnToArgFilter)) return false;
        ColumnToArgFilter highCol = (ColumnToArgFilter)high;
        if (this.mOperator != 2) return false;
        if (highCol.mOperator != 4) return false;
        if (this.mArgNum != highCol.mArgNum) return false;
        if (!this.mColumn.name.equals(highCol.mColumn.name)) return false;
        if (keyColumns.length != 1) return false;
        if (!keyColumns[0].name.equals(this.mColumn.name)) return false;
        return true;
    }

    @Override
    public boolean matchesOne(String columnName) {
        return this.mOperator == 0 && this.mColumn.type != BigDecimal.class && this.mColumn.name.equals(columnName);
    }

    public int argument() {
        return this.mArgNum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof ColumnToArgFilter)) return false;
        ColumnToArgFilter other = (ColumnToArgFilter)obj;
        if (!this.mColumn.equals(other.mColumn)) return false;
        if (this.mOperator != other.mOperator) return false;
        if (this.mArgNum != other.mArgNum) return false;
        return true;
    }

    @Override
    public int compareTo(RowFilter filter) {
        if (!(filter instanceof ColumnToArgFilter)) {
            return super.compareTo(filter);
        }
        ColumnToArgFilter other = (ColumnToArgFilter)filter;
        int cmp = this.mColumn.name.compareTo(other.mColumn.name);
        if (cmp == 0 && (cmp = Integer.compare(this.mOperator, other.mOperator)) == 0) {
            cmp = Integer.compare(this.mArgNum, other.mArgNum);
        }
        return cmp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean equalRhs(ColumnFilter other) {
        if (!(other instanceof ColumnToArgFilter)) return false;
        ColumnToArgFilter ctaf = (ColumnToArgFilter)other;
        if (this.mArgNum != ctaf.mArgNum) return false;
        return true;
    }

    @Override
    public ColumnToArgFilter withOperator(int op) {
        return new ColumnToArgFilter(this.mColumn, op, this.mArgNum);
    }

    @Override
    void appendTo(StringBuilder b) {
        super.appendTo(b);
        b.append('?').append(this.mArgNum);
    }
}

