/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.filter;

import java.util.Map;
import org.cojen.tupl.filter.ColumnFilter;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.filter.Visitor;
import org.cojen.tupl.rows.ColumnInfo;

public final class ColumnToColumnFilter
extends ColumnFilter {
    private final ColumnInfo mOtherColumn;
    private final ColumnInfo mCommon;

    ColumnToColumnFilter(ColumnInfo column, int op, ColumnInfo other, ColumnInfo common) {
        super(ColumnToColumnFilter.hash(column, op, other), column, op);
        this.mOtherColumn = other;
        this.mCommon = common;
    }

    private static int hash(ColumnInfo column, int op, ColumnInfo other) {
        int hash = column.hashCode();
        hash = hash * 31 + op;
        hash = hash * 31 + other.hashCode();
        return hash;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int isMatch(RowFilter filter) {
        if (filter == this) {
            return 1;
        }
        if (filter instanceof ColumnToColumnFilter) {
            ColumnToColumnFilter other = (ColumnToColumnFilter)filter;
            if (this.mColumn.equals(other.mColumn) && this.mOtherColumn.equals(other.mOtherColumn)) {
                if (this.mOperator == other.mOperator) {
                    return 1;
                }
                if (this.mOperator == ColumnToColumnFilter.flipOperator(other.mOperator)) {
                    return -1;
                }
            }
        }
        return 0;
    }

    @Override
    public int matchHashCode() {
        int hash = this.mMatchHashCode;
        if (hash == 0) {
            hash = this.mColumn.hashCode();
            hash = hash * 31 + (this.mOperator & 0xFFFFFFFE);
            this.mMatchHashCode = hash = hash * 31 + this.mOtherColumn.hashCode();
        }
        return hash;
    }

    @Override
    public boolean isSufficient(Map<String, ColumnInfo> columns) {
        return columns.containsKey(this.mColumn.name) && columns.containsKey(this.mOtherColumn.name);
    }

    @Override
    public RowFilter retain(Map<String, ColumnInfo> columns, boolean strict, RowFilter undecided) {
        if (columns.containsKey(this.mColumn.name) ? strict && !columns.containsKey(this.mOtherColumn.name) : strict || !columns.containsKey(this.mOtherColumn.name)) {
            return undecided;
        }
        return this;
    }

    @Override
    public boolean matchesOne(String columnName) {
        return false;
    }

    public ColumnInfo otherColumn() {
        return this.mOtherColumn;
    }

    public ColumnInfo common() {
        return this.mCommon;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof ColumnToColumnFilter)) return false;
        ColumnToColumnFilter other = (ColumnToColumnFilter)obj;
        if (!this.mColumn.equals(other.mColumn)) return false;
        if (this.mOperator != other.mOperator) return false;
        if (!this.mOtherColumn.equals(other.mOtherColumn)) return false;
        return true;
    }

    @Override
    public int compareTo(RowFilter filter) {
        if (!(filter instanceof ColumnToColumnFilter)) {
            return super.compareTo(filter);
        }
        ColumnToColumnFilter other = (ColumnToColumnFilter)filter;
        int cmp = this.mColumn.name.compareTo(other.mColumn.name);
        if (cmp == 0 && (cmp = Integer.compare(this.mOperator, other.mOperator)) == 0) {
            cmp = this.mOtherColumn.name.compareTo(other.mOtherColumn.name);
        }
        return cmp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean equalRhs(ColumnFilter other) {
        if (!(other instanceof ColumnToColumnFilter)) return false;
        ColumnToColumnFilter ctcf = (ColumnToColumnFilter)other;
        if (!this.mOtherColumn.equals(ctcf.mOtherColumn)) return false;
        return true;
    }

    @Override
    ColumnToColumnFilter withOperator(int op) {
        return new ColumnToColumnFilter(this.mColumn, op, this.mOtherColumn, this.mCommon);
    }

    @Override
    void appendTo(StringBuilder b) {
        super.appendTo(b);
        b.append(this.mOtherColumn.name);
    }
}

