/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.filter;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import org.cojen.tupl.filter.ColumnFilter;
import org.cojen.tupl.filter.ColumnToArgFilter;
import org.cojen.tupl.filter.ColumnToColumnFilter;
import org.cojen.tupl.filter.ComplexFilterException;
import org.cojen.tupl.filter.MatchSet;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.rows.ColumnInfo;

public abstract class GroupFilter
extends RowFilter {
    private static final long REDUCE_LIMIT;
    private static final long REDUCE_LIMIT_SQRT;
    private static final int SPLIT_LIMIT;
    final RowFilter[] mSubFilters;
    int mMatchHashCode;
    private MatchSet mMatchSet;
    static final int FLAG_DNF_SET = 1;
    static final int FLAG_IS_DNF = 2;
    static final int FLAG_CNF_SET = 4;
    static final int FLAG_IS_CNF = 8;
    int mFlags;
    RowFilter mReduced;
    RowFilter mReducedNoMerge;
    RowFilter mDnf;
    RowFilter mCnf;

    GroupFilter(int hash, RowFilter ... subFilters) {
        super(hash);
        this.mSubFilters = subFilters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof GroupFilter)) return false;
        GroupFilter other = (GroupFilter)obj;
        if (this.opChar() != other.opChar()) return false;
        if (!Arrays.equals(this.mSubFilters, other.mSubFilters)) return false;
        return true;
    }

    @Override
    public int compareTo(RowFilter filter) {
        if (filter instanceof GroupFilter) {
            GroupFilter other = (GroupFilter)filter;
            if (this.opChar() == other.opChar()) {
                return Arrays.compare((Comparable[])this.mSubFilters, (Comparable[])other.mSubFilters);
            }
        }
        return super.compareTo(filter);
    }

    @Override
    public RowFilter sort() {
        Object[] subFilters = this.mSubFilters;
        if (subFilters.length == 0) {
            return this;
        }
        subFilters = (RowFilter[])subFilters.clone();
        for (int i = 0; i < subFilters.length; ++i) {
            subFilters[i] = ((RowFilter)subFilters[i]).sort();
        }
        Arrays.sort(subFilters);
        return this.newInstance((RowFilter[])subFilters);
    }

    @Override
    public RowFilter prioritize(Map<String, ColumnInfo> columns) {
        RowFilter[] subFilters = this.mSubFilters;
        if (subFilters.length == 0) {
            return this;
        }
        subFilters = (RowFilter[])subFilters.clone();
        for (int i = 0; i < subFilters.length; ++i) {
            subFilters[i] = subFilters[i].prioritize(columns);
        }
        Arrays.sort(subFilters, (a, b) -> Double.compare(GroupFilter.matchStrength(b, columns), GroupFilter.matchStrength(a, columns)));
        return this.newInstance(subFilters);
    }

    @Override
    public boolean isSufficient(Map<String, ColumnInfo> columns) {
        for (RowFilter sub : this.mSubFilters) {
            if (sub.isSufficient(columns)) continue;
            return false;
        }
        return true;
    }

    private static double matchStrength(RowFilter filter, Map<String, ColumnInfo> columns) {
        if (filter instanceof ColumnToArgFilter) {
            ColumnToArgFilter cf = (ColumnToArgFilter)filter;
            return columns.containsKey(cf.column().name) ? 1.0 : 0.0;
        }
        if (filter instanceof GroupFilter) {
            RowFilter sub;
            double strength;
            GroupFilter gf = (GroupFilter)filter;
            double sum = 0.0;
            RowFilter[] rowFilterArray = gf.mSubFilters;
            int n = rowFilterArray.length;
            for (int i = 0; i < n && (strength = GroupFilter.matchStrength(sub = rowFilterArray[i], columns)) != 0.0; ++i) {
                sum += strength;
            }
            return sum / (double)gf.mSubFilters.length;
        }
        if (filter instanceof ColumnToColumnFilter) {
            double strength;
            ColumnToColumnFilter cf = (ColumnToColumnFilter)filter;
            double d = strength = columns.containsKey(cf.column().name) ? 0.5 : 0.0;
            if (columns.containsKey(cf.otherColumn().name)) {
                strength += 0.5;
            }
            return strength;
        }
        return 0.0;
    }

    @Override
    void appendTo(StringBuilder b) {
        char opChar = this.opChar();
        for (int i = 0; i < this.mSubFilters.length; ++i) {
            RowFilter sub;
            if (i != 0) {
                b.append(' ').append(opChar).append(opChar).append(' ');
            }
            if ((sub = this.mSubFilters[i]) instanceof GroupFilter) {
                b.append('(');
                sub.appendTo(b);
                b.append(')');
                continue;
            }
            sub.appendTo(b);
        }
    }

    @Override
    public final int numTerms() {
        int num = 0;
        for (RowFilter sub : this.mSubFilters) {
            num += sub.numTerms();
        }
        return num;
    }

    public final RowFilter[] subFilters() {
        return this.mSubFilters;
    }

    public abstract char opChar();

    RowFilter newInstance(RowFilter ... subFilters) {
        return this.newInstance(subFilters, 0, subFilters.length);
    }

    abstract RowFilter newInstance(RowFilter[] var1, int var2, int var3);

    abstract RowFilter newFlippedInstance(RowFilter ... var1);

    abstract RowFilter emptyInstance();

    abstract RowFilter emptyFlippedInstance();

    abstract int reduceOperator(ColumnFilter var1, ColumnFilter var2);

    final RowFilter[] subNot() {
        RowFilter[] subFilters = (RowFilter[])this.mSubFilters.clone();
        for (int i = 0; i < subFilters.length; ++i) {
            subFilters[i] = subFilters[i].not();
        }
        return subFilters;
    }

    final MatchSet matchSet() {
        MatchSet set = this.mMatchSet;
        if (set == null) {
            this.mMatchSet = set = new MatchSet(this);
        }
        return set;
    }

    @Override
    public final int isSubMatch(RowFilter filter) {
        MatchSet set;
        int result = this.isMatch(filter);
        if (result == 0 && (result = (set = this.matchSet()).hasMatch(filter)) == 0 && filter instanceof GroupFilter) {
            GroupFilter group = (GroupFilter)filter;
            for (RowFilter sub : group.mSubFilters) {
                int subResult = set.hasMatch(sub);
                if (subResult == 0) {
                    return 0;
                }
                if (result == 0) {
                    result = subResult;
                    continue;
                }
                if (result == subResult) continue;
                return 0;
            }
        }
        return result;
    }

    @Override
    public final int matchHashCode() {
        int hash = this.mMatchHashCode;
        if (hash == 0) {
            for (RowFilter sub : this.mSubFilters) {
                hash += sub.matchHashCode();
            }
            this.mMatchHashCode = hash;
        }
        return hash;
    }

    @Override
    public final RowFilter reduce() {
        if (this.mReduced == null) {
            this.mReduced = this.doReduce(0L, true);
        }
        return this.mReduced;
    }

    @Override
    final RowFilter reduce(long limit, boolean merge) {
        if (merge) {
            if (this.mReduced == null) {
                this.mReduced = this.doReduce(limit, true);
            }
            return this.mReduced;
        }
        if (this.mReducedNoMerge == null) {
            this.mReducedNoMerge = this.doReduce(limit, false);
        }
        return this.mReducedNoMerge;
    }

    private RowFilter doReduce(long limit, boolean merge) {
        int j;
        boolean repeat;
        RowFilter[] subFilters = this.mSubFilters;
        if ((limit += (long)subFilters.length * (long)subFilters.length) > REDUCE_LIMIT) {
            throw new ComplexFilterException(null, limit);
        }
        int numRemoved = 0;
        do {
            repeat = false;
            block1: for (int i = 0; i < subFilters.length; ++i) {
                Object sub = subFilters[i];
                if (sub == null) continue;
                RowFilter subReduced = ((RowFilter)sub).reduce(limit, merge);
                if (sub != subReduced) {
                    if (subReduced == this.emptyFlippedInstance()) {
                        return subReduced;
                    }
                    sub = subReduced;
                    if (sub.getClass() != this.getClass()) {
                        if (subFilters == this.mSubFilters) {
                            subFilters = (RowFilter[])subFilters.clone();
                        }
                        subFilters[i] = sub;
                    } else {
                        RowFilter[] subSubFilters = ((GroupFilter)sub).mSubFilters;
                        RowFilter[] rowFilterArray = new RowFilter[subFilters.length - 1 + subSubFilters.length];
                        System.arraycopy(subFilters, 0, rowFilterArray, 0, i);
                        System.arraycopy(subSubFilters, 0, rowFilterArray, i, subSubFilters.length);
                        System.arraycopy(subFilters, i + 1, rowFilterArray, i + subSubFilters.length, subFilters.length - i - 1);
                        subFilters = rowFilterArray;
                        repeat = true;
                        sub = subFilters[i];
                    }
                }
                block2: for (j = 0; j < subFilters.length; ++j) {
                    GroupFilter groupSub;
                    RowFilter rowFilter;
                    if (i == j || (rowFilter = subFilters[j]) == null) continue;
                    int result = ((RowFilter)sub).isSubMatch(rowFilter);
                    if (result == 0) {
                        ColumnFilter columnSub;
                        int op;
                        RowFilter resultSub;
                        if (sub.getClass() == rowFilter.getClass() && sub instanceof GroupFilter && (resultSub = (groupSub = (GroupFilter)sub).eliminate((GroupFilter)rowFilter)) != sub) {
                            if (resultSub == this.emptyFlippedInstance()) {
                                return resultSub;
                            }
                            repeat = true;
                            if (subFilters == this.mSubFilters) {
                                subFilters = (RowFilter[])subFilters.clone();
                            }
                            subFilters[i] = resultSub;
                            continue;
                        }
                        if (!merge || j <= i || sub.getClass() != rowFilter.getClass() || !(sub instanceof ColumnFilter) || (op = this.reduceOperator(columnSub = (ColumnFilter)sub, (ColumnFilter)rowFilter)) == Integer.MIN_VALUE) continue;
                        if (op == Integer.MAX_VALUE) {
                            return this.emptyFlippedInstance();
                        }
                        if (subFilters == this.mSubFilters) {
                            subFilters = (RowFilter[])subFilters.clone();
                        }
                        if (op < 0) {
                            repeat = true;
                            op ^= 0xFFFFFFFF;
                        }
                        if (op != columnSub.operator()) {
                            columnSub = columnSub.withOperator(op);
                        }
                        ++numRemoved;
                        subFilters[i] = null;
                        subFilters[j] = columnSub;
                        continue block1;
                    }
                    if (result > 0) {
                        ++numRemoved;
                        if (subFilters == this.mSubFilters) {
                            subFilters = (RowFilter[])subFilters.clone();
                        }
                        subFilters[i] = null;
                        continue block1;
                    }
                    if (!(sub instanceof GroupFilter)) {
                        return this.emptyFlippedInstance();
                    }
                    groupSub = (GroupFilter)sub;
                    RowFilter[] subSubFilters = groupSub.mSubFilters;
                    RowFilter[] newSubSubFilters = new RowFilter[subSubFilters.length - 1];
                    int k = 0;
                    for (RowFilter subSub : subSubFilters) {
                        if (subSub.isMatch(rowFilter) < 0) continue;
                        if (k >= newSubSubFilters.length) continue block2;
                        newSubSubFilters[k++] = subSub;
                    }
                    sub = groupSub.newInstance(newSubSubFilters, 0, k);
                    if (subFilters == this.mSubFilters) {
                        subFilters = (RowFilter[])subFilters.clone();
                    }
                    subFilters[i] = sub;
                }
            }
        } while (repeat);
        if (numRemoved > 0) {
            int newLength = subFilters.length - numRemoved;
            if (newLength <= 1) {
                if (newLength == 0) {
                    return this.emptyInstance();
                }
                for (RowFilter rowFilter : subFilters) {
                    if (rowFilter == null) continue;
                    return rowFilter;
                }
            }
            RowFilter[] newSubFilters = new RowFilter[newLength];
            j = 0;
            for (int i = 0; i < subFilters.length; ++i) {
                RowFilter rowFilter = subFilters[i];
                if (rowFilter == null) continue;
                newSubFilters[j++] = rowFilter;
            }
            subFilters = newSubFilters;
        } else if (subFilters == this.mSubFilters) {
            return this;
        }
        RowFilter reduced = this.newInstance(subFilters);
        if (reduced instanceof GroupFilter) {
            GroupFilter group = (GroupFilter)reduced;
            group.mReduced = group;
        }
        return reduced;
    }

    @Override
    RowFilter expandOperators(boolean force) {
        block5: {
            if (!force) {
                for (RowFilter sub : this.mSubFilters) {
                    if (sub instanceof ColumnFilter) {
                        continue;
                    }
                    break block5;
                }
                return this;
            }
        }
        RowFilter[] subFilters = this.mSubFilters;
        for (int i = 0; i < subFilters.length; ++i) {
            RowFilter sub = subFilters[i];
            RowFilter expanded = sub.expandOperators(true);
            if (expanded == sub) continue;
            if (subFilters == this.mSubFilters) {
                subFilters = (RowFilter[])subFilters.clone();
            }
            subFilters[i] = expanded;
        }
        return subFilters == this.mSubFilters ? this : this.newInstance(subFilters);
    }

    @Override
    public final RowFilter dnf() {
        RowFilter dnf = this.mDnf;
        if (dnf == null) {
            dnf = this.dnf(0L, true);
            try {
                RowFilter reduced;
                RowFilter expanded = dnf.expandOperators(false);
                if (expanded != dnf && !(reduced = expanded.dnf(0L, false).reduce()).equals(dnf) && reduced.numTerms() <= dnf.numTerms()) {
                    if (!reduced.isDnf()) {
                        throw new AssertionError();
                    }
                    dnf = reduced;
                }
            }
            catch (ComplexFilterException complexFilterException) {
                // empty catch block
            }
            this.mDnf = dnf;
        }
        return dnf;
    }

    @Override
    public final RowFilter dnf(long limit, boolean merge) {
        RowFilter filter = this;
        while (!(filter = filter.reduce(limit, merge)).isDnf()) {
            if (!(filter instanceof GroupFilter)) {
                return filter.dnf(limit, merge);
            }
            GroupFilter group = (GroupFilter)filter;
            filter = group.distribute(limit, merge, true);
        }
        return filter;
    }

    @Override
    public final RowFilter cnf() {
        RowFilter cnf = this.mCnf;
        if (cnf == null) {
            cnf = this.cnf(0L, true);
            try {
                RowFilter reduced;
                RowFilter expanded = cnf.expandOperators(false);
                if (expanded != cnf && !(reduced = expanded.cnf(0L, false).reduce()).equals(cnf) && reduced.numTerms() <= cnf.numTerms()) {
                    if (!reduced.isCnf()) {
                        throw new AssertionError();
                    }
                    cnf = reduced;
                }
            }
            catch (ComplexFilterException complexFilterException) {
                // empty catch block
            }
            this.mCnf = cnf;
        }
        return cnf;
    }

    @Override
    public final RowFilter cnf(long limit, boolean merge) {
        RowFilter filter = this;
        while (!(filter = filter.reduce(limit, merge)).isCnf()) {
            if (!(filter instanceof GroupFilter)) {
                return filter.cnf(limit, merge);
            }
            GroupFilter group = (GroupFilter)filter;
            filter = group.distribute(limit, merge, false);
        }
        return filter;
    }

    private RowFilter distribute(long limit, boolean merge, boolean dnf) {
        RowFilter[] subFilters = this.mSubFilters;
        long count = 1L;
        for (RowFilter sub : subFilters) {
            RowFilter filter;
            if (!(sub instanceof GroupFilter)) continue;
            GroupFilter group = (GroupFilter)sub;
            if ((count *= (long)group.mSubFilters.length) > (long)SPLIT_LIMIT && subFilters.length > 2 && (filter = this.trySplitDistribute(limit, merge, dnf)) != null) {
                return filter;
            }
            if (count <= REDUCE_LIMIT_SQRT) continue;
            throw this.complex();
        }
        RowFilter[] newSubFilters = new RowFilter[(int)count];
        for (int i = 0; i < newSubFilters.length; ++i) {
            RowFilter newSub;
            RowFilter[] newGroupSubFilters = new RowFilter[subFilters.length];
            int select = i;
            for (int j = 0; j < newGroupSubFilters.length; ++j) {
                RowFilter sub = subFilters[j];
                if (sub instanceof GroupFilter) {
                    GroupFilter group = (GroupFilter)sub;
                    int num = group.mSubFilters.length;
                    int subSelect = select / num;
                    newGroupSubFilters[j] = group.mSubFilters[select - subSelect * num];
                    select = subSelect;
                    continue;
                }
                newGroupSubFilters[j] = sub;
            }
            newSubFilters[i] = newSub = this.newInstance(newGroupSubFilters).reduce(limit, merge);
        }
        return this.newFlippedInstance(newSubFilters);
    }

    private RowFilter trySplitDistribute(long limit, boolean merge, boolean dnf) {
        int mid = this.mSubFilters.length >> 1;
        RowFilter filter = this.splitDistribute(limit, merge, dnf, mid);
        if (!this.equals(filter)) {
            return filter;
        }
        for (int pos = 1; pos < this.mSubFilters.length; ++pos) {
            if (pos == mid || this.equals(filter = this.splitDistribute(limit, merge, dnf, pos))) continue;
            return filter;
        }
        return null;
    }

    private RowFilter splitDistribute(long limit, boolean merge, boolean dnf, int pos) {
        RowFilter left = this.newInstance(this.mSubFilters, 0, pos);
        RowFilter right = this.newInstance(this.mSubFilters, pos, this.mSubFilters.length - pos);
        if (dnf) {
            left = left.dnf(limit, merge);
            right = right.dnf(limit, merge);
        } else {
            left = left.cnf(limit, merge);
            right = right.cnf(limit, merge);
        }
        return this.newInstance(left, right);
    }

    private ComplexFilterException complex() {
        BigInteger numTerms = BigInteger.ONE;
        for (RowFilter sub : this.mSubFilters) {
            if (!(sub instanceof GroupFilter)) continue;
            GroupFilter group = (GroupFilter)sub;
            numTerms = numTerms.multiply(BigInteger.valueOf(group.mSubFilters.length));
        }
        return new ComplexFilterException(numTerms, 0L);
    }

    private RowFilter eliminate(GroupFilter other) {
        RowFilter[] newSubFilters = null;
        int newSubFiltersSize = 0;
        for (int i = 0; i < this.mSubFilters.length; ++i) {
            RowFilter sub = this.mSubFilters[i];
            if (other.isSubMatch(sub) < 0 && this.matchSet().equalMatches(other.matchSet(), sub) != 0) {
                if (newSubFilters != null) continue;
                newSubFilters = new RowFilter[this.mSubFilters.length];
                System.arraycopy(this.mSubFilters, 0, newSubFilters, 0, i);
                newSubFiltersSize = i;
                continue;
            }
            if (newSubFilters == null) continue;
            newSubFilters[newSubFiltersSize++] = sub;
        }
        return newSubFilters == null ? this : this.newInstance(newSubFilters, 0, newSubFiltersSize);
    }

    static {
        double limit = 1.0E7;
        String prop = System.getProperty("org.cojen.tupl.filter.ReduceLimit");
        if (prop != null) {
            try {
                limit = Double.parseDouble(prop);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        REDUCE_LIMIT = (long)limit;
        REDUCE_LIMIT_SQRT = (long)Math.sqrt(limit);
        SPLIT_LIMIT = (int)Math.min(1000L, REDUCE_LIMIT_SQRT);
    }
}

