/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.filter;

import org.cojen.tupl.core.Utils;
import org.cojen.tupl.filter.GroupFilter;
import org.cojen.tupl.filter.RowFilter;

final class MatchSet {
    private final Entry[] mEntries;
    private final int mSize;

    MatchSet(GroupFilter group) {
        this(group.mSubFilters);
    }

    MatchSet(RowFilter ... filters) {
        Entry[] entries = new Entry[Utils.roundUpPower2(filters.length + 1)];
        int size = 0;
        block0: for (RowFilter filter : filters) {
            int hash = filter.matchHashCode();
            int index = hash & entries.length - 1;
            Entry e = entries[index];
            while (e != null) {
                if (hash == e.mMatchHash && e.mFilter.equals(filter)) continue block0;
                e = e.mNext;
            }
            entries[index] = new Entry(filter, hash, entries[index]);
            ++size;
        }
        this.mEntries = entries;
        this.mSize = size;
    }

    int hasMatch(RowFilter filter) {
        int hash = filter.matchHashCode();
        Entry[] entries = this.mEntries;
        Entry e = entries[hash & entries.length - 1];
        while (e != null) {
            int result;
            if (hash == e.mMatchHash && (result = e.mFilter.isMatch(filter)) != 0) {
                return result;
            }
            e = e.mNext;
        }
        return 0;
    }

    int inverseMatches(MatchSet other) {
        if (this.mSize != other.mSize) {
            return 0;
        }
        Entry[] entries = this.mEntries;
        for (int i = 0; i < entries.length; ++i) {
            Entry e = entries[i];
            while (e != null) {
                if (other.hasMatch(e.mFilter) >= 0) {
                    return 0;
                }
                e = e.mNext;
            }
        }
        return -1;
    }

    int hasEqualMatch(RowFilter filter) {
        int hash = filter.matchHashCode();
        Entry[] entries = this.mEntries;
        Entry e = entries[hash & entries.length - 1];
        while (e != null) {
            if (hash == e.mMatchHash && e.mFilter.equals(filter)) {
                return 1;
            }
            e = e.mNext;
        }
        return 0;
    }

    int equalMatches(MatchSet other) {
        if (this.mSize != other.mSize) {
            return 0;
        }
        Entry[] entries = this.mEntries;
        for (int i = 0; i < entries.length; ++i) {
            Entry e = entries[i];
            while (e != null) {
                if (other.hasEqualMatch(e.mFilter) == 0) {
                    return 0;
                }
                e = e.mNext;
            }
        }
        return 1;
    }

    int equalMatches(MatchSet other, RowFilter exclude) {
        if (this.mSize != other.mSize) {
            return 0;
        }
        Entry[] entries = this.mEntries;
        for (int i = 0; i < entries.length; ++i) {
            Entry e = entries[i];
            while (e != null) {
                if (!e.mFilter.equals(exclude) && other.hasEqualMatch(e.mFilter) == 0) {
                    return 0;
                }
                e = e.mNext;
            }
        }
        return other.hasMatch(exclude) < 0 ? 1 : 0;
    }

    private static class Entry {
        final RowFilter mFilter;
        final int mMatchHash;
        final Entry mNext;

        Entry(RowFilter filter, int hash, Entry next) {
            this.mFilter = filter;
            this.mMatchHash = hash;
            this.mNext = next;
        }
    }
}

