/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.filter;

import java.util.Arrays;
import java.util.Map;
import org.cojen.tupl.filter.AndFilter;
import org.cojen.tupl.filter.ColumnFilter;
import org.cojen.tupl.filter.FalseFilter;
import org.cojen.tupl.filter.GroupFilter;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.filter.TrueFilter;
import org.cojen.tupl.filter.Visitor;
import org.cojen.tupl.rows.ColumnInfo;

public class OrFilter
extends GroupFilter {
    static RowFilter flatten(RowFilter[] subFilters, int off, int len) {
        if (len == 1) {
            return subFilters[off];
        }
        if (len == 0) {
            return FalseFilter.THE;
        }
        int count = 0;
        for (int i = off; i < off + len; ++i) {
            RowFilter sub = subFilters[i];
            if (sub instanceof OrFilter) {
                OrFilter of = (OrFilter)sub;
                count += of.mSubFilters.length;
                continue;
            }
            ++count;
        }
        if (count == 0) {
            return FalseFilter.THE;
        }
        RowFilter[] newSubFilters = new RowFilter[count];
        int i = off;
        int j = 0;
        while (j < newSubFilters.length) {
            RowFilter sub;
            if ((sub = subFilters[i++]) instanceof OrFilter) {
                OrFilter of = (OrFilter)sub;
                RowFilter[] orSubFilters = of.mSubFilters;
                for (int k = 0; k < orSubFilters.length; ++k) {
                    newSubFilters[j++] = orSubFilters[k];
                }
                continue;
            }
            newSubFilters[j++] = sub;
        }
        if (newSubFilters.length == 1) {
            return newSubFilters[0];
        }
        return new OrFilter(newSubFilters);
    }

    OrFilter(RowFilter ... subFilters) {
        super(~Arrays.hashCode(subFilters), subFilters);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    void appendTo(StringBuilder b) {
        if (this.mSubFilters.length == 0) {
            b.append('F');
        } else {
            super.appendTo(b);
        }
    }

    @Override
    RowFilter expandOperators(boolean force) {
        RowFilter expanded = super.expandOperators(force);
        if (expanded == this) {
            return this;
        }
        RowFilter[] subFilters = ((OrFilter)expanded).mSubFilters;
        return OrFilter.flatten(subFilters, 0, subFilters.length);
    }

    @Override
    public boolean isDnf() {
        if ((this.mFlags & 1) != 0) {
            return (this.mFlags & 2) != 0;
        }
        for (RowFilter sub : this.mSubFilters) {
            if (sub.isDnf()) continue;
            this.mFlags |= 1;
            return false;
        }
        this.mFlags |= 3;
        this.mDnf = this;
        return true;
    }

    @Override
    public boolean isCnf() {
        if ((this.mFlags & 4) != 0) {
            return (this.mFlags & 8) != 0;
        }
        for (RowFilter sub : this.mSubFilters) {
            if (!(sub instanceof AndFilter) && sub.isCnf()) continue;
            this.mFlags |= 4;
            return false;
        }
        this.mFlags |= 0xC;
        this.mCnf = this;
        return true;
    }

    @Override
    public int isMatch(RowFilter filter) {
        if (this.equals(filter)) {
            return 1;
        }
        if (filter instanceof OrFilter) {
            OrFilter of = (OrFilter)filter;
            return this.matchSet().equalMatches(of.matchSet());
        }
        if (filter instanceof AndFilter) {
            AndFilter af = (AndFilter)filter;
            return this.matchSet().inverseMatches(af.matchSet());
        }
        return 0;
    }

    @Override
    public AndFilter not() {
        return new AndFilter(this.subNot());
    }

    @Override
    public RowFilter retain(Map<String, ColumnInfo> columns, boolean strict, RowFilter undecided) {
        RowFilter[] subFilters = this.mSubFilters;
        if (subFilters.length == 0) {
            return this;
        }
        subFilters = (RowFilter[])this.mSubFilters.clone();
        int len = 0;
        for (int i = 0; i < subFilters.length; ++i) {
            RowFilter sub = subFilters[i].retain(columns, strict, undecided);
            if (sub == TrueFilter.THE) {
                return sub;
            }
            if (sub == FalseFilter.THE) continue;
            subFilters[len++] = sub;
        }
        return this.newInstance(subFilters, 0, len);
    }

    @Override
    public RowFilter[][] multiRangeExtract(boolean disjoint, boolean reverse, ColumnInfo ... keyColumns) {
        if (this.mSubFilters.length <= 1) {
            return super.multiRangeExtract(disjoint, reverse, keyColumns);
        }
        return this.doMultiRangeExtract(disjoint, reverse, keyColumns);
    }

    private RowFilter[][] doMultiRangeExtract(boolean disjoint, boolean reverse, ColumnInfo ... keyColumns) {
        int i;
        RowFilter[] subFilters = this.mSubFilters;
        RowFilter[] rangeFilters = null;
        RowFilter[][] ranges = null;
        int numRanges = 0;
        block0: for (i = 0; i < subFilters.length; ++i) {
            RowFilter sub = subFilters[i];
            RowFilter[] range = sub.rangeExtract(keyColumns);
            if (range[0] == null && range[1] == null && sub.equals(range[2])) {
                return super.multiRangeExtract(disjoint, reverse, keyColumns);
            }
            if (numRanges == 0) {
                rangeFilters = new RowFilter[subFilters.length];
                ranges = new RowFilter[subFilters.length][];
                rangeFilters[0] = sub;
                ranges[0] = range;
                ++numRanges;
                continue;
            }
            for (int j = 0; j < numRanges; ++j) {
                int which = reverse ? 1 : 0;
                RowFilter check = ranges[j][which];
                if (check == null || range[which] == null || check.isSubMatch(range[which]) <= 0 && range[which].isSubMatch(check) <= 0) continue;
                RowFilter mergedFilter = sub.or(rangeFilters[j]).cnf();
                RowFilter[] mergedRange = mergedFilter.rangeExtract(keyColumns);
                rangeFilters[j] = mergedFilter;
                ranges[j] = mergedRange;
                continue block0;
            }
            rangeFilters[numRanges] = sub;
            ranges[numRanges] = range;
            ++numRanges;
        }
        if (disjoint) {
            for (i = 1; i < numRanges; ++i) {
                rangeFilters[i] = rangeFilters[i].and(rangeFilters[i - 1].not()).reduce();
                ranges[i] = rangeFilters[i].rangeExtract(keyColumns);
            }
        }
        if (numRanges < ranges.length) {
            ranges = (RowFilter[][])Arrays.copyOfRange(ranges, 0, numRanges);
        }
        return ranges;
    }

    @Override
    public boolean matchesOne(String columnName) {
        RowFilter prev = null;
        for (RowFilter sub : this.mSubFilters) {
            if (!sub.matchesOne(columnName)) {
                return false;
            }
            if (prev != null && !prev.equals(sub)) {
                return false;
            }
            prev = sub;
        }
        return true;
    }

    @Override
    public final char opChar() {
        return '|';
    }

    @Override
    final RowFilter newInstance(RowFilter[] subFilters, int off, int len) {
        return OrFilter.flatten(subFilters, off, len);
    }

    @Override
    final RowFilter newFlippedInstance(RowFilter ... subFilters) {
        return AndFilter.flatten(subFilters, 0, subFilters.length);
    }

    @Override
    final RowFilter emptyInstance() {
        return FalseFilter.THE;
    }

    @Override
    final RowFilter emptyFlippedInstance() {
        return TrueFilter.THE;
    }

    @Override
    final int reduceOperator(ColumnFilter a, ColumnFilter b) {
        return a.reduceOperatorForOr(b);
    }
}

