/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cojen.tupl.filter.AndFilter;
import org.cojen.tupl.filter.ColumnToArgFilter;
import org.cojen.tupl.filter.ColumnToColumnFilter;
import org.cojen.tupl.filter.InFilter;
import org.cojen.tupl.filter.OrFilter;
import org.cojen.tupl.filter.Query;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.filter.TrueFilter;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.ConvertUtils;
import org.cojen.tupl.rows.OrderBy;

public class Parser {
    private final Map<String, ColumnInfo> mAllColumns;
    private final String mFilter;
    private int mPos;
    private int mNextArg;
    private Map<Integer, Boolean> mInArgs;
    private boolean mNoFilter;
    private LinkedHashMap<String, ColumnInfo> mProjection;
    private OrderBy mOrderBy;

    public Parser(Map<String, ColumnInfo> allColumns, String filter) {
        this.mAllColumns = allColumns;
        this.mFilter = filter;
    }

    public Query parseQuery(Map<String, ColumnInfo> availableColumns) {
        this.parseProjection(availableColumns);
        return new Query(this.mProjection, this.mOrderBy, this.parseFilter());
    }

    /*
     * Unable to fully structure code
     */
    private void parseProjection(Map<String, ColumnInfo> availableColumns) {
        block22: {
            if (availableColumns == null) {
                availableColumns = this.mAllColumns;
            }
            start = this.mPos--;
            c = this.nextCharIgnoreWhitespace();
            if (c != 123) {
                this.mPos = start;
                return;
            }
            projection = new LinkedHashMap<String, ColumnInfo>();
            orderBy = null;
            excluded = null;
            wildcard = false;
            c = this.nextCharIgnoreWhitespace();
            if (c == 125) break block22;
            while (true) {
                block24: {
                    block30: {
                        block29: {
                            block28: {
                                block26: {
                                    block27: {
                                        block25: {
                                            block23: {
                                                if (c != 42) break block23;
                                                wildcard = true;
                                                ++this.mPos;
                                                break block24;
                                            }
                                            colStart = this.mPos;
                                            if (c != 126) break block25;
                                            prefix = -1;
                                            this.skipCharIgnoreWhitespace();
                                            break block26;
                                        }
                                        if (c != 43) break block27;
                                        prefix = 2;
                                        ** GOTO lbl35
                                    }
                                    if (c != 45) {
                                        prefix = 0;
                                    } else {
                                        prefix = 3;
lbl35:
                                        // 2 sources

                                        if (this.skipCharIgnoreWhitespace() == 33) {
                                            prefix |= 4;
                                            this.skipCharIgnoreWhitespace();
                                        }
                                    }
                                }
                                column = this.parseColumn(prefix < 0 ? null : availableColumns);
                                name = column.name;
                                if (prefix >= 0) break block28;
                                if (excluded == null) {
                                    excluded = new HashSet<String>();
                                }
                                if (projection.containsKey(name)) {
                                    this.mPos = colStart;
                                    throw this.error("Cannot exclude a column which is explicitly selected");
                                }
                                excluded.add(name);
                                break block24;
                            }
                            if (excluded != null && excluded.contains(name)) {
                                this.mPos = colStart;
                                throw this.error("Cannot select a column which is also excluded");
                            }
                            projection.put(name, column);
                            if (prefix == 0) break block24;
                            if (orderBy != null) break block29;
                            orderBy = new OrderBy();
                            break block30;
                        }
                        if (orderBy.containsKey(name)) break block24;
                    }
                    type = column.typeCode;
                    if ((prefix & 3) == 3) {
                        type |= 128;
                    }
                    if ((prefix & 4) == 4) {
                        type |= 256;
                    }
                    orderBy.put(name, new OrderBy.Rule(column, type));
                }
                c = this.nextCharIgnoreWhitespace();
                if (c == 125) break;
                if (c != 44) {
                    --this.mPos;
                    throw this.error("Comma expected");
                }
                c = this.nextCharIgnoreWhitespace();
                --this.mPos;
            }
        }
        if (this.nextCharIgnoreWhitespace() < 0) {
            this.mNoFilter = true;
        } else {
            --this.mPos;
        }
        if (wildcard) {
            for (Map.Entry<String, ColumnInfo> e : availableColumns.entrySet()) {
                projection.putIfAbsent(e.getKey(), e.getValue());
            }
        }
        if (excluded != null) {
            if (!wildcard) {
                this.mPos = start;
                throw this.error("Must include wildcard if any columns are excluded");
            }
            projection.keySet().removeAll(excluded);
        }
        this.mProjection = projection.size() == availableColumns.size() ? null : projection;
        this.mOrderBy = orderBy;
    }

    public void skipProjection() {
        int start = this.mPos;
        int c = this.nextCharIgnoreWhitespace();
        if (c == 123) {
            this.mPos = this.mFilter.indexOf(125, this.mPos);
            if (this.mPos < 0) {
                this.mPos = this.mFilter.length();
                this.mNoFilter = true;
            } else {
                ++this.mPos;
            }
        } else {
            this.mPos = start;
        }
    }

    public RowFilter parseFilter() {
        if (this.mNoFilter) {
            return TrueFilter.THE;
        }
        this.mInArgs = new HashMap<Integer, Boolean>();
        RowFilter filter = this.doParseFilter();
        int c = this.nextCharIgnoreWhitespace();
        if (c >= 0) {
            --this.mPos;
            throw this.error("Unexpected trailing characters");
        }
        return filter;
    }

    private RowFilter doParseFilter() {
        return this.parseOrFilter();
    }

    private RowFilter parseOrFilter() {
        ArrayList<RowFilter> list = null;
        RowFilter filter = this.parseAndFilter();
        while (true) {
            int c;
            if ((c = this.nextCharIgnoreWhitespace()) != 124) {
                --this.mPos;
                break;
            }
            c = this.nextChar();
            if (c != 124) {
                this.mPos -= 2;
                throw this.error("Or operator must be specified as '||'");
            }
            this.operatorCheck();
            if (list == null) {
                list = new ArrayList<RowFilter>();
                Parser.addToOrFilter(list, filter);
            }
            Parser.addToOrFilter(list, this.parseAndFilter());
        }
        if (list == null) {
            return filter;
        }
        return new OrFilter(list.toArray(new RowFilter[list.size()]));
    }

    private static void addToOrFilter(ArrayList<RowFilter> list, RowFilter filter) {
        if (filter instanceof OrFilter) {
            OrFilter of = (OrFilter)filter;
            Collections.addAll(list, of.mSubFilters);
        } else {
            list.add(filter);
        }
    }

    private RowFilter parseAndFilter() {
        ArrayList<RowFilter> list = null;
        RowFilter filter = this.parseEntityFilter();
        while (true) {
            int c;
            if ((c = this.nextCharIgnoreWhitespace()) != 38) {
                --this.mPos;
                break;
            }
            c = this.nextChar();
            if (c != 38) {
                this.mPos -= 2;
                throw this.error("And operator must be specified as '&&'");
            }
            this.operatorCheck();
            if (list == null) {
                list = new ArrayList<RowFilter>();
                Parser.addToAndFilter(list, filter);
            }
            Parser.addToAndFilter(list, this.parseEntityFilter());
        }
        if (list == null) {
            return filter;
        }
        return new AndFilter(list.toArray(new RowFilter[list.size()]));
    }

    private static void addToAndFilter(ArrayList<RowFilter> list, RowFilter filter) {
        if (filter instanceof AndFilter) {
            AndFilter af = (AndFilter)filter;
            Collections.addAll(list, af.mSubFilters);
        } else {
            list.add(filter);
        }
    }

    private RowFilter parseEntityFilter() {
        Boolean in;
        ColumnToArgFilter filter;
        int arg;
        int op;
        int c = this.nextCharIgnoreWhitespace();
        if (c == 33) {
            c = this.nextCharIgnoreWhitespace();
            if (c != 40) {
                --this.mPos;
                throw this.error("Left paren expected");
            }
            return this.parseParenFilter().not();
        }
        if (c == 40) {
            return this.parseParenFilter();
        }
        --this.mPos;
        int startPos = this.mPos--;
        ColumnInfo column = this.parseColumn(null);
        c = this.nextCharIgnoreWhitespace();
        switch (c) {
            case 61: {
                c = this.nextChar();
                if (c != 61) {
                    this.mPos -= 2;
                    throw this.error("Equality operator must be specified as '=='");
                }
                op = 0;
                this.operatorCheck();
                break;
            }
            case 33: {
                c = this.nextChar();
                if (c != 61) {
                    this.mPos -= 2;
                    throw this.error("Inequality operator must be specified as '!='");
                }
                op = 1;
                this.operatorCheck();
                break;
            }
            case 60: {
                c = this.nextChar();
                op = c == 61 ? 4 : 3;
                this.operatorCheck();
                break;
            }
            case 62: {
                c = this.nextChar();
                if (c == 61) {
                    op = 2;
                } else {
                    --this.mPos;
                    op = 5;
                }
                this.operatorCheck();
                break;
            }
            case 105: {
                c = this.nextChar();
                if (c != 110) {
                    this.mPos -= 2;
                    throw this.error("Unknown operator");
                }
                op = 6;
                this.operatorCheck(true);
                break;
            }
            case 63: {
                --this.mPos;
                throw this.error("Relational operator missing");
            }
            case -1: {
                throw this.error("Relational operator expected");
            }
            default: {
                --this.mPos;
                throw this.error("Unknown operator");
            }
        }
        c = this.nextCharIgnoreWhitespace();
        if (c == 63) {
            arg = this.tryParseArgNumber();
            if (arg < 0) {
                arg = ++this.mNextArg;
            }
        } else {
            --this.mPos;
            if (op >= 6) {
                throw this.error("Argument number or '?' expected");
            }
            ColumnInfo match = this.parseColumn(null);
            ColumnInfo common = ConvertUtils.commonType(column, match, op);
            if (common == null) {
                throw this.error("Cannot compare '" + column.name + "' to '" + match.name + "' due to type mismatch", startPos);
            }
            return new ColumnToColumnFilter(column, op, match, common);
        }
        if (op < 6) {
            filter = new ColumnToArgFilter(column, op, arg);
            in = Boolean.FALSE;
        } else {
            filter = new InFilter(column, arg);
            in = Boolean.TRUE;
        }
        Boolean existing = this.mInArgs.putIfAbsent(arg, in);
        if (existing != null && existing != in) {
            throw this.error("Mismatched argument usage with 'in' operator", startPos);
        }
        return filter;
    }

    private RowFilter parseParenFilter() {
        RowFilter filter = this.doParseFilter();
        if (this.nextCharIgnoreWhitespace() != 41) {
            --this.mPos;
            throw this.error("Right paren expected");
        }
        return filter;
    }

    private void operatorCheck() {
        this.operatorCheck(false);
    }

    private void operatorCheck(boolean text) {
        int c = this.nextChar();
        --this.mPos;
        switch (c) {
            case -1: 
            case 0: 
            case 9: 
            case 10: 
            case 13: 
            case 32: 
            case 33: 
            case 40: 
            case 41: 
            case 63: {
                return;
            }
        }
        if (Character.isWhitespace(c)) {
            return;
        }
        if (Character.isJavaIdentifierStart(c) == text) {
            throw this.error("Unknown operator");
        }
    }

    private ColumnInfo parseColumn(Map<String, ColumnInfo> availableColumns) {
        ColumnInfo column;
        int start = this.mPos--;
        int c = this.nextChar();
        if (c < 0) {
            throw this.error("Column name expected");
        }
        if (!Character.isJavaIdentifierStart(c)) {
            throw this.error("Not a valid character for start of column name: '" + (char)c + "'");
        }
        while (Character.isJavaIdentifierPart(c = this.nextChar())) {
        }
        String name = this.mFilter.substring(start, --this.mPos);
        if (availableColumns == null) {
            availableColumns = this.mAllColumns;
        }
        if ((column = availableColumns.get(name)) == null) {
            this.mPos = start;
            String prefix = availableColumns == this.mAllColumns || !this.mAllColumns.containsKey(name) ? "Unknown column" : "Column is unavailable for selection";
            throw this.error(prefix + ": " + name);
        }
        return column;
    }

    private int tryParseArgNumber() {
        long arg;
        int start = this.mPos;
        int c = this.nextChar();
        if (48 <= c && c <= 57) {
            arg = c - 48;
        } else {
            if (c < 0) {
                return -1;
            }
            if (c == 41 || c == 124 || c == 38 || Character.isWhitespace(c)) {
                --this.mPos;
                return -1;
            }
            this.mPos = start;
            throw this.error("Malformed argument number");
        }
        while (48 <= (c = this.nextChar()) && c <= 57) {
            if ((arg = arg * 10L + (long)(c - 48)) <= Integer.MAX_VALUE) continue;
            this.mPos = start;
            throw this.error("Argument number is too large");
        }
        --this.mPos;
        if (arg <= 0L) {
            this.mPos = start;
            throw this.error("Argument number must be at least one");
        }
        return (int)arg;
    }

    private int nextChar() {
        int pos = this.mPos;
        String filter = this.mFilter;
        int c = pos >= filter.length() ? -1 : (int)filter.charAt(pos);
        this.mPos = pos + 1;
        return c;
    }

    private int nextCharIgnoreWhitespace() {
        int c;
        block3: while ((c = this.nextChar()) >= 0) {
            switch (c) {
                case 0: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
            if (Character.isWhitespace(c)) continue;
            return c;
        }
        return c;
    }

    private int skipCharIgnoreWhitespace() {
        ++this.mPos;
        int c = this.nextCharIgnoreWhitespace();
        --this.mPos;
        return c;
    }

    private IllegalArgumentException error(String message) {
        return this.error(message, this.mPos);
    }

    private IllegalArgumentException error(String message, int pos) {
        int remaining;
        message = pos <= 0 || this.mFilter.length() == 0 ? (String)message + " (at start of filter expression)" : (pos >= this.mFilter.length() ? (String)message + " (at end of filter expression)" : ((remaining = this.mFilter.length() - pos) <= 20 ? (String)message + " (at \"" + this.mFilter.substring(pos) + "\")" : (String)message + " (at \"" + this.mFilter.substring(pos, pos + 17) + "...\")"));
        return new IllegalArgumentException((String)message);
    }
}

