/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.filter;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.filter.TrueFilter;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.OrderBy;

public record Query(Map<String, ColumnInfo> projection, OrderBy orderBy, RowFilter filter) {
    public Query withOrderBy(OrderBy ob) {
        return Objects.equals(this.orderBy, ob) ? this : new Query(this.projection, ob, this.filter);
    }

    public Query withFilter(RowFilter rf) {
        return rf.equals(this.filter) ? this : new Query(this.projection, this.orderBy, rf);
    }

    public Query reduce() {
        return this.withFilter(this.filter.reduce());
    }

    @Override
    public String toString() {
        Set<String> names;
        if (this.projection != null) {
            names = this.projection.keySet();
        } else if (this.orderBy != null) {
            names = this.orderBy.keySet();
        } else {
            return this.filter.toString();
        }
        StringBuilder b = new StringBuilder().append('{');
        for (String name : names) {
            OrderBy.Rule rule;
            if (b.length() != 1) {
                b.append(',').append(' ');
            }
            if (this.orderBy != null && (rule = (OrderBy.Rule)this.orderBy.get(name)) != null) {
                rule.appendTo(b);
                continue;
            }
            b.append(name);
        }
        if (this.projection == null) {
            b.append(", *");
        }
        b.append('}');
        if (this.filter != TrueFilter.THE) {
            b.append(' ');
            this.filter.appendTo(b);
        }
        return b.toString();
    }
}

