/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.filter;

import java.util.Map;
import java.util.Objects;
import org.cojen.tupl.filter.AndFilter;
import org.cojen.tupl.filter.ComplexFilterException;
import org.cojen.tupl.filter.OrFilter;
import org.cojen.tupl.filter.TrueFilter;
import org.cojen.tupl.filter.Visitor;
import org.cojen.tupl.rows.ColumnInfo;

public abstract class RowFilter
implements Comparable<RowFilter> {
    private final int mHash;

    RowFilter(int hash) {
        this.mHash = hash;
    }

    public abstract void accept(Visitor var1);

    public abstract int numTerms();

    public abstract RowFilter reduce();

    public RowFilter reduceMore() {
        RowFilter filter = this.reduce();
        int numTerms = -1;
        try {
            RowFilter dnf = filter.dnf();
            numTerms = filter.numTerms();
            if (dnf.numTerms() < numTerms) {
                return dnf;
            }
        }
        catch (ComplexFilterException dnf) {
            // empty catch block
        }
        try {
            RowFilter cnf = filter.cnf();
            if (numTerms < 0) {
                numTerms = filter.numTerms();
            }
            if (cnf.numTerms() < numTerms) {
                return cnf;
            }
        }
        catch (ComplexFilterException complexFilterException) {
            // empty catch block
        }
        return filter;
    }

    abstract RowFilter reduce(long var1, boolean var3);

    abstract RowFilter expandOperators(boolean var1);

    public abstract boolean isDnf();

    public abstract RowFilter dnf();

    abstract RowFilter dnf(long var1, boolean var3);

    public abstract boolean isCnf();

    public abstract RowFilter cnf();

    abstract RowFilter cnf(long var1, boolean var3);

    public abstract int isMatch(RowFilter var1);

    public abstract int isSubMatch(RowFilter var1);

    public abstract int matchHashCode();

    public abstract RowFilter not();

    public RowFilter or(RowFilter filter) {
        Objects.requireNonNull(filter);
        RowFilter[] subFilters = new RowFilter[]{this, filter};
        return OrFilter.flatten(subFilters, 0, subFilters.length);
    }

    public RowFilter and(RowFilter filter) {
        Objects.requireNonNull(filter);
        RowFilter[] subFilters = new RowFilter[]{this, filter};
        return AndFilter.flatten(subFilters, 0, subFilters.length);
    }

    public abstract RowFilter sort();

    public abstract RowFilter prioritize(Map<String, ColumnInfo> var1);

    public abstract boolean isSufficient(Map<String, ColumnInfo> var1);

    public abstract RowFilter retain(Map<String, ColumnInfo> var1, boolean var2, RowFilter var3);

    public RowFilter[] split(Map<String, ColumnInfo> columns) {
        RowFilter[] result = new RowFilter[2];
        if (this.isSufficient(columns)) {
            result[0] = this;
            result[1] = TrueFilter.THE;
        } else {
            result[0] = TrueFilter.THE;
            result[1] = this;
        }
        return result;
    }

    protected void splitCombine(Map<String, ColumnInfo> columns, RowFilter[] result) {
        int ix = this.isSufficient(columns) ? 0 : 1;
        result[ix] = result[ix].and(this);
    }

    public RowFilter[] rangeExtract(ColumnInfo ... keyColumns) {
        return new RowFilter[]{null, null, this, null};
    }

    public RowFilter[][] multiRangeExtract(boolean disjoint, boolean reverse, ColumnInfo ... keyColumns) {
        RowFilter[][] rowFilterArrayArray;
        RowFilter[] range = this.rangeExtract(keyColumns);
        if (range == null) {
            rowFilterArrayArray = null;
        } else {
            RowFilter[][] rowFilterArrayArray2 = new RowFilter[1][];
            rowFilterArrayArray = rowFilterArrayArray2;
            rowFilterArrayArray2[0] = range;
        }
        return rowFilterArrayArray;
    }

    public static void splitRemainders(Map<String, ColumnInfo> columns, RowFilter[] ... ranges) {
        for (RowFilter[] range : ranges) {
            RowFilter remainder = range[2];
            if (remainder == null) continue;
            RowFilter original = remainder;
            try {
                remainder = remainder.cnf();
            }
            catch (ComplexFilterException complexFilterException) {
                // empty catch block
            }
            RowFilter[] split = remainder.split(columns);
            if (split[0] == TrueFilter.THE) {
                split[1] = RowFilter.reduceFromCnf(original, remainder);
            } else if (split[1] == TrueFilter.THE) {
                split[0] = RowFilter.reduceFromCnf(original, remainder);
            }
            range[2] = split[0];
            range[3] = split[1];
        }
    }

    private static RowFilter reduceFromCnf(RowFilter from, RowFilter cnf) {
        int fromTerms = from.numTerms();
        if (cnf.numTerms() < fromTerms) {
            return cnf;
        }
        try {
            RowFilter dnf = cnf.dnf();
            if (dnf.numTerms() < fromTerms) {
                return dnf;
            }
        }
        catch (ComplexFilterException complexFilterException) {
            // empty catch block
        }
        return from;
    }

    public boolean matchesOne(RowFilter high, ColumnInfo ... keyColumns) {
        return false;
    }

    public abstract boolean matchesOne(String var1);

    public final int hashCode() {
        return this.mHash;
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        this.appendTo(b);
        return b.toString();
    }

    abstract void appendTo(StringBuilder var1);

    @Override
    public int compareTo(RowFilter filter) {
        return this.getClass().getName().compareTo(filter.getClass().getName());
    }
}

