/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.FileIO;
import org.cojen.tupl.io.LengthOption;
import org.cojen.tupl.io.Mapping;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.UnsafeAccess;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.util.Clutch;
import org.cojen.tupl.util.Latch;

abstract class AbstractFileIO
extends FileIO {
    static final int PAGE_SIZE;
    private static final int MAPPING_SHIFT = 30;
    private static final int MAPPING_SIZE = 0x40000000;
    private static final long SYNC_YIELD_THRESHOLD_NANOS = 10000000000L;
    private static final long SYNC_YIELD_MAX_NANOS = 100000000L;
    private static final VarHandle cSyncStartNanosHandle;
    private final boolean mReadOnly;
    private final Latch mRemapLatch;
    protected final Clutch mAccessLock;
    private final Latch mSyncLatch;
    private Mapping[] mMappings;
    private int mLastMappingSize;
    protected volatile Throwable mCause;
    private volatile long mSyncStartNanos;

    AbstractFileIO(EnumSet<OpenOption> options) {
        this.mReadOnly = options.contains((Object)OpenOption.READ_ONLY);
        this.mRemapLatch = new Latch();
        this.mAccessLock = Clutch.make();
        this.mSyncLatch = new Latch();
    }

    @Override
    public final boolean isReadOnly() {
        return this.mReadOnly;
    }

    @Override
    public final long length() throws IOException {
        this.mAccessLock.acquireShared();
        try {
            long l = this.doLength();
            return l;
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCause);
        }
        finally {
            this.mAccessLock.releaseShared();
        }
    }

    @Override
    public final void truncateLength(long length) throws IOException {
        this.setLength(length, true, LengthOption.PREALLOCATE_NEVER);
    }

    @Override
    public final void expandLength(long length, LengthOption option) throws IOException {
        this.setLength(length, false, option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setLength(long length, boolean truncate, LengthOption option) throws IOException {
        this.mRemapLatch.acquireExclusive();
        try {
            boolean remap;
            long prevLength = this.length();
            if (truncate) {
                if (length >= prevLength) {
                    return;
                }
            } else {
                if (length < prevLength) {
                    return;
                }
                if (length == prevLength && option == LengthOption.PREALLOCATE_NEVER) {
                    return;
                }
            }
            boolean bl = remap = this.mMappings != null && length < prevLength;
            if (remap) {
                this.doUnmap(true);
            }
            try {
                Throwable ex = null;
                if (length > prevLength && this.shouldPreallocate(option)) {
                    try {
                        this.doPreallocate(prevLength, length - prevLength);
                    }
                    catch (Throwable e) {
                        ex = e;
                        length = prevLength;
                    }
                }
                this.mAccessLock.acquireShared();
                try {
                    this.doSetLength(length);
                }
                finally {
                    this.mAccessLock.releaseShared();
                }
                if (ex != null) {
                    throw Utils.rethrow(ex);
                }
                if (!remap) return;
            }
            catch (IOException iOException) {
                if (!remap) return;
                this.doMap(false);
                return;
                catch (Throwable throwable) {
                    if (!remap) throw throwable;
                    this.doMap(false);
                    throw throwable;
                }
            }
            this.doMap(false);
            return;
        }
        finally {
            this.mRemapLatch.releaseExclusive();
        }
    }

    @Override
    public final void read(long pos, byte[] buf, int offset, int length) throws IOException {
        this.access(true, pos, buf, offset, length);
    }

    @Override
    public final void read(long pos, ByteBuffer bb) throws IOException {
        this.access(true, pos, bb);
    }

    @Override
    public final void read(long pos, long ptr, int offset, int length) throws IOException {
        this.access(true, pos, ptr + (long)offset, length);
    }

    @Override
    public final void write(long pos, byte[] buf, int offset, int length) throws IOException {
        this.access(false, pos, buf, offset, length);
    }

    @Override
    public final void write(long pos, ByteBuffer bb) throws IOException {
        this.access(false, pos, bb);
    }

    @Override
    public final void write(long pos, long ptr, int offset, int length) throws IOException {
        this.access(false, pos, ptr + (long)offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void access(boolean read, long pos, byte[] buf, int offset, int length) throws IOException {
        this.syncWait();
        try {
            this.mAccessLock.acquireShared();
            try {
                Mapping[] mappings = this.mMappings;
                if (mappings != null) {
                    int mlen;
                    int mi;
                    while ((mi = (int)(pos >> 30)) < (mlen = mappings.length)) {
                        int mavail;
                        Mapping mapping = mappings[mi];
                        int mpos = (int)(pos & 0x3FFFFFFFL);
                        if (mi == mlen - 1) {
                            mavail = this.mLastMappingSize - mpos;
                            if (mavail <= 0) {
                                break;
                            }
                        } else {
                            mavail = 0x40000000 - mpos;
                        }
                        if (mavail > length) {
                            mavail = length;
                        }
                        if (read) {
                            mapping.read(mpos, buf, offset, mavail);
                        } else {
                            mapping.write(mpos, buf, offset, mavail);
                        }
                        if ((length -= mavail) <= 0) {
                            return;
                        }
                        pos += (long)mavail;
                        offset += mavail;
                    }
                }
                if (read) {
                    this.doRead(pos, buf, offset, length);
                } else {
                    this.doWrite(pos, buf, offset, length);
                }
            }
            finally {
                this.mAccessLock.releaseShared();
            }
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void access(boolean read, long pos, ByteBuffer bb) throws IOException {
        if (bb.remaining() <= 0) {
            return;
        }
        this.syncWait();
        try {
            this.mAccessLock.acquireShared();
            try {
                Mapping[] mappings = this.mMappings;
                if (mappings != null) {
                    int mlen;
                    int mi;
                    while ((mi = (int)(pos >> 30)) < (mlen = mappings.length)) {
                        int mavail;
                        Mapping mapping = mappings[mi];
                        int mpos = (int)(pos & 0x3FFFFFFFL);
                        if (mi == mlen - 1) {
                            mavail = this.mLastMappingSize - mpos;
                            if (mavail <= 0) {
                                break;
                            }
                        } else {
                            mavail = 0x40000000 - mpos;
                        }
                        if (mavail >= bb.remaining()) {
                            if (read) {
                                mapping.read(mpos, bb);
                            } else {
                                mapping.write(mpos, bb);
                            }
                            return;
                        }
                        if (read) {
                            mapping.read(mpos, bb, mavail);
                        } else {
                            mapping.write(mpos, bb, mavail);
                        }
                        pos += (long)mavail;
                    }
                }
                if (read) {
                    this.doRead(pos, bb);
                } else {
                    this.doWrite(pos, bb);
                }
            }
            finally {
                this.mAccessLock.releaseShared();
            }
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCause);
        }
    }

    private void access(boolean read, long pos, long ptr, int length) throws IOException {
        if (length > 0) {
            this.access(read, pos, DirectAccess.ref(ptr, length));
        }
    }

    @Override
    public void read(long pos, byte[] buf, int offset, int length, ByteBuffer tail) throws IOException {
        this.accessv(true, pos, buf, offset, length, tail);
    }

    @Override
    public void read(long pos, ByteBuffer bb, ByteBuffer tail) throws IOException {
        this.accessv(true, pos, bb, tail);
    }

    @Override
    public void read(long pos, long ptr, int offset, int length, ByteBuffer tail) throws IOException {
        this.accessv(true, pos, ptr + (long)offset, length, tail);
    }

    @Override
    public void write(long pos, byte[] buf, int offset, int length, ByteBuffer tail) throws IOException {
        this.accessv(false, pos, buf, offset, length, tail);
    }

    @Override
    public void write(long pos, ByteBuffer bb, ByteBuffer tail) throws IOException {
        this.accessv(false, pos, bb, tail);
    }

    @Override
    public void write(long pos, long ptr, int offset, int length, ByteBuffer tail) throws IOException {
        this.accessv(false, pos, ptr + (long)offset, length, tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accessv(boolean read, long pos, byte[] buf, int offset, int length, ByteBuffer tail) throws IOException {
        if (tail.remaining() <= 0) {
            this.access(read, pos, buf, offset, length);
            return;
        }
        this.syncWait();
        try {
            this.mAccessLock.acquireShared();
            try {
                Mapping[] mappings = this.mMappings;
                if (mappings != null) {
                    int mlen;
                    int mi;
                    while ((mi = (int)(pos >> 30)) < (mlen = mappings.length)) {
                        int mavail;
                        Mapping mapping = mappings[mi];
                        int mpos = (int)(pos & 0x3FFFFFFFL);
                        if (mi == mlen - 1) {
                            mavail = this.mLastMappingSize - mpos;
                            if (mavail <= 0) {
                                break;
                            }
                        } else {
                            mavail = 0x40000000 - mpos;
                        }
                        if (length <= 0) {
                            if (mavail >= tail.remaining()) {
                                if (read) {
                                    mapping.read(mpos, tail);
                                } else {
                                    mapping.write(mpos, tail);
                                }
                                return;
                            }
                            if (read) {
                                mapping.read(mpos, tail, mavail);
                            } else {
                                mapping.write(mpos, tail, mavail);
                            }
                        } else {
                            if (mavail > length) {
                                mavail = length;
                            }
                            if (read) {
                                mapping.read(mpos, buf, offset, mavail);
                            } else {
                                mapping.write(mpos, buf, offset, mavail);
                            }
                            length -= mavail;
                        }
                        pos += (long)mavail;
                    }
                }
                if (read) {
                    this.doRead(pos, buf, offset, length, tail);
                } else {
                    this.doWrite(pos, buf, offset, length, tail);
                }
            }
            finally {
                this.mAccessLock.releaseShared();
            }
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accessv(boolean read, long pos, ByteBuffer bb, ByteBuffer tail) throws IOException {
        if (tail.remaining() <= 0) {
            this.access(read, pos, bb);
            return;
        }
        this.syncWait();
        try {
            this.mAccessLock.acquireShared();
            try {
                Mapping[] mappings = this.mMappings;
                if (mappings != null) {
                    int mlen;
                    int mi;
                    while ((mi = (int)(pos >> 30)) < (mlen = mappings.length)) {
                        int bbLen;
                        int mavail;
                        Mapping mapping = mappings[mi];
                        int mpos = (int)(pos & 0x3FFFFFFFL);
                        if (mi == mlen - 1) {
                            mavail = this.mLastMappingSize - mpos;
                            if (mavail <= 0) {
                                break;
                            }
                        } else {
                            mavail = 0x40000000 - mpos;
                        }
                        if ((bbLen = bb.remaining()) <= 0) {
                            if (mavail >= tail.remaining()) {
                                if (read) {
                                    mapping.read(mpos, tail);
                                } else {
                                    mapping.write(mpos, tail);
                                }
                                return;
                            }
                            if (read) {
                                mapping.read(mpos, tail, mavail);
                            } else {
                                mapping.write(mpos, tail, mavail);
                            }
                            pos += (long)mavail;
                            continue;
                        }
                        if (mavail >= bbLen) {
                            if (read) {
                                mapping.read(mpos, bb);
                            } else {
                                mapping.write(mpos, bb);
                            }
                            pos += (long)bbLen;
                            continue;
                        }
                        if (read) {
                            mapping.read(mpos, bb, mavail);
                        } else {
                            mapping.write(mpos, bb, mavail);
                        }
                        pos += (long)mavail;
                    }
                }
                if (read) {
                    this.doRead(pos, bb, tail);
                } else {
                    this.doWrite(pos, bb, tail);
                }
            }
            finally {
                this.mAccessLock.releaseShared();
            }
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCause);
        }
    }

    private void accessv(boolean read, long pos, long ptr, int length, ByteBuffer tail) throws IOException {
        if (length > 0) {
            this.accessv(read, pos, DirectAccess.ref(ptr, length), tail);
        } else {
            this.access(read, pos, tail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sync(boolean metadata) throws IOException {
        if (this.mReadOnly) {
            return;
        }
        boolean shouldReset = this.mSyncStartNanos == 0L && cSyncStartNanosHandle.compareAndSet(this, 0, System.nanoTime());
        try {
            this.mSyncLatch.acquireShared();
            try {
                this.mAccessLock.acquireShared();
                try {
                    Mapping[] mappings = this.mMappings;
                    if (mappings != null) {
                        for (Mapping m : mappings) {
                            m.sync(false);
                        }
                    }
                    this.doSync(metadata);
                }
                finally {
                    this.mAccessLock.releaseShared();
                }
            }
            catch (IOException e) {
                throw Utils.rethrow(e, this.mCause);
            }
            finally {
                this.mSyncLatch.releaseShared();
            }
        }
        finally {
            if (shouldReset) {
                this.mSyncStartNanos = 0L;
            }
        }
    }

    @Override
    public final void map() throws IOException {
        this.mRemapLatch.acquireExclusive();
        try {
            this.doMap(false);
        }
        finally {
            this.mRemapLatch.releaseExclusive();
        }
    }

    @Override
    public final void remap() throws IOException {
        this.mRemapLatch.acquireExclusive();
        try {
            this.doMap(true);
        }
        finally {
            this.mRemapLatch.releaseExclusive();
        }
    }

    @Override
    public final void unmap() throws IOException {
        this.unmap(true);
    }

    protected void unmap(boolean reopen) throws IOException {
        this.mRemapLatch.acquireExclusive();
        try {
            this.doUnmap(reopen);
        }
        finally {
            this.mRemapLatch.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnmap(boolean reopen) throws IOException {
        boolean contended = this.mAccessLock.isContended();
        this.mAccessLock.acquireExclusive();
        try {
            IOException ex;
            block10: {
                Mapping[] mappings = this.mMappings;
                if (mappings == null) {
                    return;
                }
                this.mMappings = null;
                this.mLastMappingSize = 0;
                ex = null;
                for (Mapping m : mappings) {
                    ex = Utils.closeQuietly(ex, m);
                }
                if (reopen) {
                    try {
                        this.reopen();
                    }
                    catch (IOException e) {
                        if (ex != null) break block10;
                        ex = e;
                    }
                }
            }
            if (ex != null) {
                throw ex;
            }
        }
        finally {
            this.mAccessLock.releaseExclusive(contended);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMap(boolean remap) throws IOException {
        int newLastSize;
        Mapping[] newMappings;
        Mapping[] oldMappings;
        this.mAccessLock.acquireShared();
        try {
            long count;
            oldMappings = this.mMappings;
            if (oldMappings == null && remap) {
                return;
            }
            long length = this.doLength();
            if (oldMappings != null) {
                long oldMappedLength;
                long l = oldMappedLength = oldMappings.length == 0 ? 0L : (long)(oldMappings.length - 1) * 0x40000000L + (long)this.mLastMappingSize;
                if (length == oldMappedLength) {
                    return;
                }
            }
            if ((count = (length + 0x3FFFFFFFL) / 0x40000000L) > Integer.MAX_VALUE) {
                throw new IOException("Mapping is too large");
            }
            try {
                newMappings = new Mapping[(int)count];
            }
            catch (OutOfMemoryError e) {
                throw new IOException("Mapping is too large");
            }
            newLastSize = count == 0L ? 0 : (int)(0x40000000L - (count * 0x40000000L - length));
            try {
                for (int i = 0; i < newMappings.length; ++i) {
                    Mapping oldMapping;
                    int mappingSize = i < newMappings.length - 1 ? 0x40000000 : newLastSize;
                    newMappings[i] = oldMappings != null && i < oldMappings.length && mappingSize == (oldMapping = oldMappings[i]).size() ? oldMapping : this.openMapping(this.mReadOnly, (long)i * 0x40000000L, mappingSize);
                }
            }
            catch (Throwable e) {
                for (int i = 0; i < newMappings.length; ++i) {
                    Mapping newMapping = newMappings[i];
                    if (newMapping == null || oldMappings != null && i < oldMappings.length && newMapping == oldMappings[i]) continue;
                    Utils.closeQuietly(newMapping);
                }
                throw e;
            }
        }
        finally {
            this.mAccessLock.releaseShared();
        }
        boolean contended = this.mAccessLock.isContended();
        this.mAccessLock.acquireExclusive();
        this.mMappings = newMappings;
        this.mLastMappingSize = newLastSize;
        this.mAccessLock.releaseExclusive(contended);
        if (oldMappings != null) {
            IOException ex = null;
            for (int i = 0; i < oldMappings.length; ++i) {
                Mapping oldMapping = oldMappings[i];
                if (i < newMappings.length && oldMapping == newMappings[i]) continue;
                ex = Utils.closeQuietly(ex, oldMapping);
            }
            if (ex != null) {
                throw ex;
            }
        }
    }

    protected void syncWait() throws InterruptedIOException {
        long syncTimeNanos;
        long syncStartNanos = this.mSyncStartNanos;
        if (syncStartNanos != 0L && (syncTimeNanos = System.nanoTime() - syncStartNanos) > 10000000000L) {
            long sleepNanos = Math.min(syncTimeNanos / 1000L, 100000000L);
            try {
                if (this.mSyncLatch.tryAcquireExclusiveNanos(sleepNanos)) {
                    this.mSyncLatch.releaseExclusive();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
    }

    protected boolean shouldPreallocate(LengthOption option) {
        return option == LengthOption.PREALLOCATE_ALWAYS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPreallocate(long pos, long length) throws IOException {
        this.mAccessLock.acquireExclusive();
        try {
            long currLength = this.doLength();
            byte[] buf = new byte[1];
            long endPos = pos + length;
            while (pos < endPos) {
                block8: {
                    block7: {
                        block6: {
                            if (this.mAccessLock.hasQueuedThreads()) {
                                this.mAccessLock.releaseExclusive();
                                this.mAccessLock.acquireExclusive();
                            }
                            if (pos >= currLength) break block6;
                            this.doRead(pos, buf, 0, 1);
                            if (buf[0] == 0) break block7;
                            break block8;
                        }
                        buf[0] = 0;
                    }
                    this.doWrite(pos, buf, 0, buf.length);
                }
                pos += (long)PAGE_SIZE;
            }
        }
        finally {
            this.mAccessLock.releaseExclusive();
        }
    }

    protected abstract long doLength() throws IOException;

    protected abstract void doSetLength(long var1) throws IOException;

    protected abstract void doRead(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract void doRead(long var1, byte[] var3, int var4, int var5, ByteBuffer var6) throws IOException;

    protected abstract void doRead(long var1, ByteBuffer var3) throws IOException;

    protected abstract void doRead(long var1, ByteBuffer var3, ByteBuffer var4) throws IOException;

    protected abstract void doWrite(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract void doWrite(long var1, byte[] var3, int var4, int var5, ByteBuffer var6) throws IOException;

    protected abstract void doWrite(long var1, ByteBuffer var3) throws IOException;

    protected abstract void doWrite(long var1, ByteBuffer var3, ByteBuffer var4) throws IOException;

    protected abstract Mapping openMapping(boolean var1, long var2, int var4) throws IOException;

    protected abstract void reopen() throws IOException;

    protected abstract void doSync(boolean var1) throws IOException;

    static {
        int pageSize = 4096;
        try {
            pageSize = UnsafeAccess.tryObtain().pageSize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PAGE_SIZE = pageSize;
        try {
            cSyncStartNanosHandle = MethodHandles.lookup().findVarHandle(AbstractFileIO.class, "mSyncStartNanos", Long.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }
}

