/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.cojen.tupl.io.UnsafeAccess;
import sun.misc.Unsafe;

public class DirectAccess {
    private static final Unsafe UNSAFE;
    private static final Class<?> cDirectByteBufferClass;
    private static final long cDirectAddressOffset;
    private static final long cDirectCapacityOffset;
    private static final ThreadLocal<ByteBuffer> cLocalBuffer;
    private static final ThreadLocal<ByteBuffer> cLocalBuffer2;
    private final ThreadLocal<ByteBuffer> mLocalBuffer;

    public DirectAccess() {
        if (!DirectAccess.isSupported()) {
            throw new UnsupportedOperationException();
        }
        this.mLocalBuffer = new ThreadLocal();
    }

    public ByteBuffer prepare(long ptr, int length) {
        return DirectAccess.ref(this.mLocalBuffer, ptr, length);
    }

    public static boolean isSupported() {
        return cLocalBuffer2 != null;
    }

    public static ByteBuffer ref(long ptr, int length) {
        return DirectAccess.ref(cLocalBuffer, ptr, length);
    }

    public static ByteBuffer ref2(long ptr, int length) {
        return DirectAccess.ref(cLocalBuffer2, ptr, length);
    }

    public static long getAddress(Buffer buf) {
        if (!buf.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer");
        }
        try {
            return UNSAFE.getLong(buf, cDirectAddressOffset);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static ByteBuffer ref(ThreadLocal<ByteBuffer> local, long ptr, int length) {
        if (local == null) {
            throw new UnsupportedOperationException();
        }
        ByteBuffer bb = local.get();
        if (bb == null) {
            bb = DirectAccess.allocDirect();
            local.set(bb);
        }
        DirectAccess.ref(bb, ptr, length);
        return bb;
    }

    public static void unref(ByteBuffer bb) {
        bb.position(0).limit(0);
        try {
            UNSAFE.putInt(bb, cDirectCapacityOffset, 0);
            UNSAFE.putLong(bb, cDirectAddressOffset, 0L);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static ByteBuffer allocDirect() {
        try {
            ByteBuffer bb = (ByteBuffer)UNSAFE.allocateInstance(cDirectByteBufferClass);
            bb.clear();
            return bb;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static void ref(ByteBuffer bb, long ptr, int length) {
        UNSAFE.putLong(bb, cDirectAddressOffset, ptr);
        UNSAFE.putInt(bb, cDirectCapacityOffset, length);
        bb.position(0).limit(length);
    }

    static {
        ThreadLocal local2;
        ThreadLocal local;
        long capOffset;
        long addrOffset;
        Class<?> clazz;
        UNSAFE = UnsafeAccess.tryObtain();
        try {
            clazz = Class.forName("java.nio.DirectByteBuffer");
            addrOffset = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
            capOffset = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("capacity"));
            local = new ThreadLocal();
            local2 = new ThreadLocal();
        }
        catch (Throwable e) {
            clazz = null;
            addrOffset = 0L;
            capOffset = 0L;
            local = null;
            local2 = null;
        }
        cDirectByteBufferClass = clazz;
        cDirectAddressOffset = addrOffset;
        cDirectCapacityOffset = capOffset;
        cLocalBuffer = local;
        cLocalBuffer2 = local2;
    }
}

