/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Objects;
import org.cojen.tupl.io.FileIO;
import org.cojen.tupl.io.LengthOption;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.Utils;

public class FilePageArray
extends PageArray {
    final FileIO mFio;

    public FilePageArray(int pageSize, File file, EnumSet<OpenOption> options) throws IOException {
        this(pageSize, FileIO.open(file, options));
    }

    public FilePageArray(int pageSize, FileIO fio) {
        super(pageSize);
        this.mFio = Objects.requireNonNull(fio);
    }

    @Override
    public int directPageSize() {
        int size = this.pageSize();
        if (this.mFio.isDirectIO()) {
            size = -size;
        }
        return size;
    }

    @Override
    public boolean isReadOnly() {
        return this.mFio.isReadOnly();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mFio.length() == 0L;
    }

    @Override
    public long pageCount() throws IOException {
        return this.mFio.length() / (long)this.mPageSize;
    }

    @Override
    public void truncatePageCount(long count) throws IOException {
        if (this.allowPageCountAdjust(count)) {
            this.mFio.truncateLength(count * (long)this.mPageSize);
        }
    }

    @Override
    public void expandPageCount(long count) throws IOException {
        if (this.allowPageCountAdjust(count)) {
            this.mFio.expandLength(count * (long)this.mPageSize, LengthOption.PREALLOCATE_OPTIONAL);
        }
    }

    private boolean allowPageCountAdjust(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException(String.valueOf(count));
        }
        return !this.isReadOnly();
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.mFio.read(index * (long)this.mPageSize, dst, offset, length);
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length, ByteBuffer tail) throws IOException {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.mFio.read(index * (long)this.mPageSize, dst, offset, length, tail);
    }

    @Override
    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.mFio.read(index * (long)this.mPageSize, dstPtr, offset, length);
    }

    @Override
    public void readPage(long index, long dstPtr, int offset, int length, ByteBuffer tail) throws IOException {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.mFio.read(index * (long)this.mPageSize, dstPtr, offset, length, tail);
    }

    @Override
    public void writePage(long index, byte[] src, int offset) throws IOException {
        int pageSize = this.mPageSize;
        this.mFio.write(index * (long)pageSize, src, offset, pageSize);
    }

    @Override
    public void writePage(long index, byte[] src, int offset, ByteBuffer tail) throws IOException {
        int pageSize = this.mPageSize;
        this.mFio.write(index * (long)pageSize, src, offset, pageSize - tail.remaining(), tail);
    }

    @Override
    public void writePage(long index, long srcPtr, int offset) throws IOException {
        int pageSize = this.mPageSize;
        this.mFio.write(index * (long)pageSize, srcPtr, offset, pageSize);
    }

    @Override
    public void writePage(long index, long srcPtr, int offset, ByteBuffer tail) throws IOException {
        int pageSize = this.mPageSize;
        this.mFio.write(index * (long)pageSize, srcPtr, offset, pageSize - tail.remaining(), tail);
    }

    @Override
    public void sync(boolean metadata) throws IOException {
        this.mFio.sync(metadata);
        this.mFio.remap();
    }

    @Override
    public void close(Throwable cause) throws IOException {
        Utils.close(this.mFio, cause);
    }
}

