/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.util.EnumSet;
import org.cojen.tupl.io.AbstractFileIO;
import org.cojen.tupl.io.Mapping;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.LatchCondition;

final class JavaFileIO
extends AbstractFileIO {
    private final File mFile;
    private final String mMode;
    private final Latch mFilePoolLatch;
    private final LatchCondition mFilePoolCondition;
    private final FileAccess[] mFilePool;
    private int mFilePoolTop;

    JavaFileIO(File file, EnumSet<OpenOption> options, int openFileCount) throws IOException {
        this(file, options, openFileCount, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaFileIO(File file, EnumSet<OpenOption> options, int openFileCount, boolean allowMap) throws IOException {
        super(options);
        String mode;
        if (options.contains((Object)OpenOption.NON_DURABLE)) {
            throw new UnsupportedOperationException("Unsupported options: " + options);
        }
        this.mFile = file;
        if (this.isReadOnly()) {
            mode = "r";
        } else {
            if (!options.contains((Object)OpenOption.CREATE) && !file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }
            mode = options.contains((Object)OpenOption.SYNC_IO) ? "rwd" : "rw";
        }
        this.mMode = mode;
        if (openFileCount < 1) {
            openFileCount = 1;
        }
        this.mFilePoolLatch = new Latch();
        this.mFilePoolCondition = new LatchCondition();
        this.mFilePool = new FileAccess[openFileCount];
        try {
            this.mFilePoolLatch.acquireExclusive();
            try {
                for (int i = 0; i < openFileCount; ++i) {
                    this.mFilePool[i] = this.openRaf();
                }
            }
            finally {
                this.mFilePoolLatch.releaseExclusive();
            }
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(this, e);
        }
        if (allowMap && options.contains((Object)OpenOption.MAPPED)) {
            this.map();
        }
        if (options.contains((Object)OpenOption.CREATE)) {
            JavaFileIO.dirSync(file);
        }
    }

    @Override
    public boolean isDirectIO() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doLength() throws IOException {
        FileAccess file = this.accessFile();
        try {
            long l = file.length();
            return l;
        }
        finally {
            this.yieldFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetLength(long length) throws IOException {
        FileAccess file = this.accessFile();
        try {
            file.setLength(length);
        }
        finally {
            this.yieldFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead(long pos, byte[] buf, int offset, int length) throws IOException {
        try {
            FileAccess file = this.accessFile();
            try {
                file.seek(pos);
                file.readFully(buf, offset, length);
            }
            finally {
                this.yieldFile(file);
            }
        }
        catch (EOFException e) {
            throw new EOFException("Attempt to read past end of file: " + pos);
        }
    }

    @Override
    protected void doRead(long pos, byte[] buf, int offset, int length, ByteBuffer tail) throws IOException {
        this.doRead(pos, ByteBuffer.wrap(buf, offset, length), tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead(long pos, ByteBuffer bb) throws IOException {
        boolean interrupted = false;
        FileAccess file = this.accessFile();
        try {
            while (true) {
                try {
                    FileChannel channel = file.getChannel();
                    while (bb.hasRemaining()) {
                        int amt = channel.read(bb, pos);
                        if (amt < 0) {
                            throw new EOFException("Attempt to read past end of file: " + pos);
                        }
                        pos += (long)amt;
                    }
                }
                catch (ClosedByInterruptException e) {
                    interrupted = true;
                    Thread.interrupted();
                    file = this.openRaf();
                    continue;
                }
                break;
            }
        }
        finally {
            this.yieldFile(file);
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead(long pos, ByteBuffer bb, ByteBuffer tail) throws IOException {
        boolean interrupted = false;
        FileAccess file = this.accessFile();
        try {
            while (true) {
                try {
                    FileChannel channel = file.positionChannel(pos);
                    while (bb.hasRemaining()) {
                        long amt = channel.read(new ByteBuffer[]{bb, tail});
                        if (amt < 0L) {
                            throw new EOFException("Attempt to read past end of file: " + channel.position());
                        }
                        pos += amt;
                    }
                    while (tail.hasRemaining()) {
                        int amt = channel.read(tail);
                        if (amt < 0) {
                            throw new EOFException("Attempt to read past end of file: " + channel.position());
                        }
                        pos += (long)amt;
                    }
                }
                catch (ClosedByInterruptException e) {
                    interrupted = true;
                    Thread.interrupted();
                    file = this.openRaf();
                    continue;
                }
                break;
            }
        }
        finally {
            this.yieldFile(file);
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWrite(long pos, byte[] buf, int offset, int length) throws IOException {
        FileAccess file = this.accessFile();
        try {
            file.seek(pos);
            file.write(buf, offset, length);
        }
        finally {
            this.yieldFile(file);
        }
    }

    @Override
    protected void doWrite(long pos, byte[] buf, int offset, int length, ByteBuffer tail) throws IOException {
        this.doWrite(pos, ByteBuffer.wrap(buf, offset, length), tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWrite(long pos, ByteBuffer bb) throws IOException {
        boolean interrupted = false;
        FileAccess file = this.accessFile();
        try {
            while (true) {
                try {
                    FileChannel channel = file.getChannel();
                    while (bb.hasRemaining()) {
                        pos += (long)channel.write(bb, pos);
                    }
                }
                catch (ClosedByInterruptException e) {
                    interrupted = true;
                    Thread.interrupted();
                    file = this.openRaf();
                    continue;
                }
                break;
            }
        }
        finally {
            this.yieldFile(file);
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWrite(long pos, ByteBuffer bb, ByteBuffer tail) throws IOException {
        boolean interrupted = false;
        FileAccess file = this.accessFile();
        try {
            while (true) {
                try {
                    FileChannel channel = file.positionChannel(pos);
                    while (bb.hasRemaining()) {
                        pos += channel.write(new ByteBuffer[]{bb, tail});
                    }
                    while (tail.hasRemaining()) {
                        pos += (long)channel.write(tail);
                    }
                }
                catch (ClosedByInterruptException e) {
                    interrupted = true;
                    Thread.interrupted();
                    file = this.openRaf();
                    continue;
                }
                break;
            }
        }
        finally {
            this.yieldFile(file);
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected Mapping openMapping(boolean readOnly, long pos, int size) throws IOException {
        return Mapping.open(this.mFile, readOnly, pos, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reopen() throws IOException {
        IOException ex = null;
        this.mFilePoolLatch.acquireExclusive();
        try {
            try {
                this.closePool();
            }
            catch (IOException e) {
                ex = e;
            }
            for (int i = 0; i < this.mFilePool.length; ++i) {
                try {
                    this.mFilePool[i] = this.openRaf();
                    continue;
                }
                catch (IOException e) {
                    if (ex != null) continue;
                    ex = e;
                }
            }
        }
        finally {
            this.mFilePoolLatch.releaseExclusive();
        }
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSync(boolean metadata) throws IOException {
        boolean interrupted = false;
        FileAccess file = this.accessFile();
        try {
            while (true) {
                try {
                    file.getChannel().force(metadata);
                }
                catch (ClosedByInterruptException e) {
                    interrupted = true;
                    Thread.interrupted();
                    file = this.openRaf();
                    continue;
                }
                break;
            }
        }
        finally {
            this.yieldFile(file);
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Throwable cause) throws IOException {
        IOException ex;
        block13: {
            ex = null;
            this.mAccessLock.acquireExclusive();
            try {
                if (cause != null && this.mCause == null) {
                    this.mCause = cause;
                }
                this.mFilePoolLatch.acquireExclusive();
                try {
                    this.closePool();
                }
                catch (IOException e) {
                    ex = e;
                }
                finally {
                    this.mFilePoolLatch.releaseExclusive();
                }
            }
            finally {
                this.mAccessLock.releaseExclusive();
            }
            try {
                this.unmap(false);
            }
            catch (IOException e) {
                if (ex != null) break block13;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private void closePool() throws IOException {
        if (this.mFilePoolTop != 0) {
            throw new AssertionError();
        }
        IOException ex = null;
        for (FileAccess file : this.mFilePool) {
            if (file == null) continue;
            try {
                file.close();
            }
            catch (IOException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAccess accessFile() throws InterruptedIOException {
        FileAccess[] pool = this.mFilePool;
        Latch latch = this.mFilePoolLatch;
        latch.acquireExclusive();
        try {
            int top;
            while ((top = this.mFilePoolTop) == pool.length) {
                if (this.mFilePoolCondition.await(latch) >= 1) continue;
                throw new InterruptedIOException();
            }
            FileAccess file = pool[top];
            this.mFilePoolTop = top + 1;
            FileAccess fileAccess = file;
            return fileAccess;
        }
        finally {
            latch.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void yieldFile(FileAccess file) {
        FileAccess[] pool = this.mFilePool;
        Latch latch = this.mFilePoolLatch;
        latch.acquireExclusive();
        try {
            pool[--this.mFilePoolTop] = file;
            this.mFilePoolCondition.signal(latch);
        }
        finally {
            latch.releaseExclusive();
        }
    }

    private FileAccess openRaf() throws IOException {
        try {
            return new FileAccess(this.mFile, this.mMode);
        }
        catch (FileNotFoundException e) {
            Object message = null;
            if (this.mFile.isDirectory()) {
                message = "File is a directory";
            } else if (!this.mFile.isFile()) {
                message = "Not a normal file";
            } else if ("r".equals(this.mMode)) {
                if (!this.mFile.exists()) {
                    message = "File does not exist";
                } else if (!this.mFile.canRead()) {
                    message = "File cannot be read";
                }
            } else if (!this.mFile.canRead()) {
                message = !this.mFile.canWrite() ? "File cannot be read or written" : "File cannot be read";
            } else if (!this.mFile.canWrite()) {
                message = "File cannot be written";
            }
            if (message == null) {
                throw e;
            }
            String path = this.mFile.getPath();
            String originalMessage = e.getMessage();
            message = !originalMessage.contains(path) ? (String)message + ": " + this.mFile.getPath() + " " + originalMessage : (String)message + ": " + originalMessage;
            throw new FileNotFoundException((String)message);
        }
    }

    static class FileAccess
    extends RandomAccessFile {
        private long mPosition;

        FileAccess(File file, String mode) throws IOException {
            super(file, mode);
            this.seek(0L);
        }

        FileChannel positionChannel(long pos) throws IOException {
            this.mPosition = -1L;
            FileChannel channel = this.getChannel();
            channel.position(pos);
            return channel;
        }

        @Override
        public void seek(long pos) throws IOException {
            if (pos != this.mPosition) {
                try {
                    super.seek(pos);
                    this.mPosition = pos;
                }
                catch (Throwable e) {
                    this.mPosition = -1L;
                    throw e;
                }
            }
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            try {
                int amt = super.read(buf, offset, length);
                if (amt > 0) {
                    this.mPosition += (long)amt;
                }
                return amt;
            }
            catch (Throwable e) {
                this.mPosition = -1L;
                throw e;
            }
        }

        @Override
        public void write(byte[] buf) throws IOException {
            this.write(buf, 0, buf.length);
        }

        @Override
        public void write(byte[] buf, int offset, int length) throws IOException {
            try {
                super.write(buf, offset, length);
                this.mPosition += (long)length;
            }
            catch (Throwable e) {
                this.mPosition = -1L;
                throw e;
            }
        }

        @Override
        public void setLength(long length) throws IOException {
            this.mPosition = -1L;
            super.setLength(length);
        }
    }
}

