/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.util.Runner;

public class JoinedPageArray
extends PageArray {
    private PageArray mFirst;
    private PageArray mSecond;
    private final long mJoinIndex;
    private final int mDirectPageSize;
    private final boolean mReadOnly;

    public static PageArray join(PageArray first, long joinIndex, PageArray second) throws IOException {
        if (first.pageSize() != second.pageSize() || joinIndex <= 0L) {
            throw new IllegalArgumentException();
        }
        long pageCount = first.pageCount();
        if (pageCount > joinIndex) {
            throw new IllegalStateException("First page array is too large: " + pageCount + " > " + joinIndex);
        }
        return new JoinedPageArray(first, joinIndex, second);
    }

    private JoinedPageArray(PageArray first, long joinIndex, PageArray second) {
        super(first.pageSize());
        this.mFirst = first;
        this.mSecond = second;
        this.mJoinIndex = joinIndex;
        int directPageSize = first.directPageSize();
        if (second.directPageSize() != directPageSize) {
            directPageSize = this.pageSize();
        }
        this.mDirectPageSize = directPageSize;
        this.mReadOnly = first.isReadOnly() || second.isReadOnly();
    }

    @Override
    public final int directPageSize() {
        return this.mDirectPageSize;
    }

    @Override
    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    @Override
    public boolean isFullyMapped() {
        return this.mFirst.isFullyMapped() && this.mSecond.isFullyMapped();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mFirst.isEmpty() && this.mSecond.isEmpty();
    }

    @Override
    public long pageCount() throws IOException {
        return this.mJoinIndex + this.mSecond.pageCount();
    }

    @Override
    public void truncatePageCount(long count) throws IOException {
        long diff = count - this.mJoinIndex;
        if (diff > 0L) {
            this.mSecond.truncatePageCount(diff);
        } else {
            this.mSecond.truncatePageCount(0L);
            this.mFirst.truncatePageCount(count);
        }
    }

    @Override
    public void expandPageCount(long count) throws IOException {
        long diff = count - this.mJoinIndex;
        if (diff > 0L) {
            this.mSecond.expandPageCount(diff);
        } else {
            this.mFirst.expandPageCount(count);
        }
    }

    @Override
    public long pageCountLimit() throws IOException {
        long limit = this.mFirst.pageCountLimit();
        if ((limit < 0L || limit >= this.mJoinIndex) && (limit = this.mSecond.pageCountLimit()) >= 0L) {
            limit += this.mJoinIndex;
        }
        return limit;
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
        this.action(index, (pa, ix) -> pa.readPage(ix, dst, offset, length));
    }

    @Override
    public void readPage(long index, byte[] dst, int off, int len, ByteBuffer tail) throws IOException {
        this.action(index, (pa, ix) -> pa.readPage(ix, dst, off, len, tail));
    }

    @Override
    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        this.action(index, (pa, ix) -> pa.readPage(ix, dstPtr, offset, length));
    }

    @Override
    public void readPage(long index, long dstPtr, int off, int len, ByteBuffer tail) throws IOException {
        this.action(index, (pa, ix) -> pa.readPage(ix, dstPtr, off, len, tail));
    }

    @Override
    public void writePage(long index, byte[] src, int offset) throws IOException {
        this.action(index, (pa, ix) -> pa.writePage(ix, src, offset));
    }

    @Override
    public void writePage(long index, byte[] src, int off, ByteBuffer tail) throws IOException {
        this.action(index, (pa, ix) -> pa.writePage(ix, src, off, tail));
    }

    @Override
    public void writePage(long index, long srcPtr, int offset) throws IOException {
        this.action(index, (pa, ix) -> pa.writePage(ix, srcPtr, offset));
    }

    @Override
    public void writePage(long index, long srcPtr, int off, ByteBuffer tail) throws IOException {
        this.action(index, (pa, ix) -> pa.writePage(ix, srcPtr, off, tail));
    }

    @Override
    public byte[] evictPage(long index, byte[] buf) throws IOException {
        PageArray pa;
        if (index < this.mJoinIndex) {
            pa = this.mFirst;
        } else {
            pa = this.mSecond;
            index -= this.mJoinIndex;
        }
        return pa.evictPage(index, buf);
    }

    @Override
    public long evictPage(long index, long bufPtr) throws IOException {
        PageArray pa;
        if (index < this.mJoinIndex) {
            pa = this.mFirst;
        } else {
            pa = this.mSecond;
            index -= this.mJoinIndex;
        }
        return pa.evictPage(index, bufPtr);
    }

    @Override
    public long directPagePointer(long index) throws IOException {
        PageArray pa;
        if (index < this.mJoinIndex) {
            pa = this.mFirst;
        } else {
            pa = this.mSecond;
            index -= this.mJoinIndex;
        }
        return pa.directPagePointer(index);
    }

    @Override
    public long copyPage(long srcIndex, long dstIndex) throws IOException {
        PageArray dst;
        PageArray src;
        if (srcIndex < this.mJoinIndex) {
            src = this.mFirst;
        } else {
            src = this.mSecond;
            srcIndex -= this.mJoinIndex;
        }
        if (dstIndex < this.mJoinIndex) {
            dst = this.mFirst;
        } else {
            dst = this.mSecond;
            dstIndex -= this.mJoinIndex;
        }
        if (src == dst) {
            return dst.copyPage(srcIndex, dstIndex);
        }
        return dst.copyPageFromPointer(src.directPagePointer(srcIndex), dstIndex);
    }

    @Override
    public long copyPageFromPointer(long srcPointer, long dstIndex) throws IOException {
        PageArray pa;
        if (dstIndex < this.mJoinIndex) {
            pa = this.mFirst;
        } else {
            pa = this.mSecond;
            dstIndex -= this.mJoinIndex;
        }
        return pa.copyPageFromPointer(srcPointer, dstIndex);
    }

    @Override
    public void sync(boolean metadata) throws IOException {
        Future<?> task = Runner.current().submit(() -> {
            try {
                this.mFirst.sync(metadata);
            }
            catch (IOException e) {
                Utils.rethrow(e);
            }
        });
        Throwable ex = null;
        try {
            this.mSecond.sync(metadata);
        }
        catch (Throwable e) {
            ex = e;
        }
        try {
            task.get();
        }
        catch (Throwable e) {
            e = e instanceof InterruptedException ? new InterruptedIOException() : Utils.rootCause(e);
            if (ex == null) {
                ex = e;
            }
            Utils.suppress(ex, e);
        }
        if (ex != null) {
            Utils.rethrow(ex);
        }
    }

    @Override
    public void syncPage(long index) throws IOException {
        PageArray pa;
        if (index < this.mJoinIndex) {
            pa = this.mFirst;
        } else {
            pa = this.mSecond;
            index -= this.mJoinIndex;
        }
        pa.syncPage(index);
    }

    @Override
    public void close(Throwable cause) throws IOException {
        IOException ex = Utils.closeQuietly(null, this.mFirst, cause);
        if ((ex = Utils.closeQuietly(ex, this.mSecond, cause)) != null) {
            throw ex;
        }
    }

    @Override
    public PageArray open() throws IOException {
        this.mFirst = this.mFirst.open();
        this.mSecond = this.mSecond.open();
        return this;
    }

    private void action(long index, Task task) throws IOException {
        PageArray pa;
        if (index < this.mJoinIndex) {
            pa = this.mFirst;
        } else {
            pa = this.mSecond;
            index -= this.mJoinIndex;
        }
        task.perform(pa, index);
    }

    private static interface Task {
        public void perform(PageArray var1, long var2) throws IOException;
    }
}

