/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.PageCompressor;

class LZ4Compressor
implements PageCompressor {
    private final net.jpountz.lz4.LZ4Compressor mCompressor;
    private final LZ4FastDecompressor mDecompressor;
    private byte[] mCompressedBytes;
    private ByteBuffer mDirectBuffer;

    LZ4Compressor() {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        this.mCompressor = factory.fastCompressor();
        this.mDecompressor = factory.fastDecompressor();
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen) {
        byte[] dst = this.mCompressedBytes;
        if (dst == null) {
            this.mCompressedBytes = dst = new byte[srcLen / 16];
        }
        while (true) {
            try {
                return this.mCompressor.compress(src, srcOff, srcLen, dst, 0, dst.length);
            }
            catch (LZ4Exception e) {
                dst = this.expandCapacity(srcLen);
                continue;
            }
            break;
        }
    }

    @Override
    public int compress(long srcPtr, int srcOff, int srcLen) {
        ByteBuffer bb;
        byte[] dst = this.mCompressedBytes;
        if (dst == null) {
            this.mCompressedBytes = dst = new byte[srcLen / 16];
        }
        if ((bb = this.mDirectBuffer) == null) {
            this.mDirectBuffer = bb = DirectAccess.allocDirect();
        }
        while (true) {
            DirectAccess.ref(bb, srcPtr + (long)srcOff, srcLen);
            ByteBuffer wrapped = ByteBuffer.wrap(dst, 0, dst.length);
            try {
                this.mCompressor.compress(bb, wrapped);
                return wrapped.position();
            }
            catch (LZ4Exception e) {
                dst = this.expandCapacity(srcLen);
                continue;
            }
            break;
        }
    }

    private byte[] expandCapacity(int srcLen) {
        int newLen = this.mCompressedBytes.length << 1;
        newLen = Math.min(newLen, this.mCompressor.maxCompressedLength(srcLen));
        this.mCompressedBytes = new byte[newLen];
        return this.mCompressedBytes;
    }

    @Override
    public byte[] compressedBytes() {
        return this.mCompressedBytes;
    }

    @Override
    public void decompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff, int dstLen) {
        this.mDecompressor.decompress(src, srcOff, dst, dstOff, dstLen);
    }

    @Override
    public void decompress(byte[] src, int srcOff, int srcLen, long dstPtr, int dstOff, int dstLen) {
        ByteBuffer bb = this.mDirectBuffer;
        if (bb == null) {
            this.mDirectBuffer = bb = DirectAccess.allocDirect();
        }
        DirectAccess.ref(bb, dstPtr + (long)dstOff, dstLen);
        this.mDecompressor.decompress(ByteBuffer.wrap(src, srcOff, srcLen), bb);
    }

    @Override
    public void close() {
    }
}

