/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.EnumSet;
import org.cojen.tupl.DatabaseFullException;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.PosixMappedPageArray;
import org.cojen.tupl.io.UnsafeAccess;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.io.WindowsMappedPageArray;

public abstract class MappedPageArray
extends PageArray {
    private static final VarHandle cMappingPtrHandle;
    private static final VarHandle cCauseHandle;
    private final long mPageCount;
    private final boolean mReadOnly;
    private volatile long mMappingPtr;
    private volatile Throwable mCause;

    public static boolean isSupported() {
        return Native.SIZE_T_SIZE >= 8;
    }

    public static MappedPageArray open(int pageSize, long pageCount, File file, EnumSet<OpenOption> options) throws IOException {
        if (pageSize < 1 || pageCount < 0L || pageCount > Long.MAX_VALUE / (long)pageSize) {
            throw new IllegalArgumentException();
        }
        if (!MappedPageArray.isSupported()) {
            throw new UnsupportedOperationException("Not a 64-bit platform");
        }
        if (options == null) {
            options = EnumSet.noneOf(OpenOption.class);
        }
        if (Platform.isWindows()) {
            return new WindowsMappedPageArray(pageSize, pageCount, file, options);
        }
        return new PosixMappedPageArray(pageSize, pageCount, file, options);
    }

    MappedPageArray(int pageSize, long pageCount, EnumSet<OpenOption> options) {
        super(pageSize);
        this.mPageCount = pageCount;
        this.mReadOnly = options.contains((Object)OpenOption.READ_ONLY);
    }

    @Override
    public final boolean isFullyMapped() {
        return true;
    }

    @Override
    public final boolean isReadOnly() {
        return this.mReadOnly;
    }

    @Override
    public boolean isEmpty() {
        return this.pageCount() == 0L;
    }

    @Override
    public long pageCount() {
        return this.mPageCount;
    }

    @Override
    public void truncatePageCount(long count) {
    }

    @Override
    public void expandPageCount(long count) {
    }

    @Override
    public long pageCountLimit() {
        return this.mPageCount;
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
        this.readCheck(index);
        UnsafeAccess.copy(this.mappingPtr() + index * (long)this.mPageSize, dst, offset, (long)length);
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length, ByteBuffer tail) throws IOException {
        this.readCheck(index);
        long srcPtr = this.mappingPtr() + index * (long)this.mPageSize;
        UnsafeAccess.copy(srcPtr, dst, offset, (long)length);
        MappedPageArray.readTail(srcPtr + (long)length, tail);
    }

    @Override
    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        this.readCheck(index);
        long srcPtr = this.mappingPtr() + index * (long)this.mPageSize;
        if (srcPtr != (dstPtr += (long)offset)) {
            UnsafeAccess.copy(srcPtr, dstPtr, length);
        }
    }

    @Override
    public void readPage(long index, long dstPtr, int offset, int length, ByteBuffer tail) throws IOException {
        this.readCheck(index);
        long srcPtr = this.mappingPtr() + index * (long)this.mPageSize;
        if (srcPtr != (dstPtr += (long)offset)) {
            UnsafeAccess.copy(srcPtr, dstPtr, length);
        }
        MappedPageArray.readTail(srcPtr + (long)length, tail);
    }

    private static void readTail(long srcPtr, ByteBuffer tail) {
        int rem = tail.remaining();
        int pos = tail.position();
        if (tail.isDirect()) {
            UnsafeAccess.copy(srcPtr, DirectAccess.getAddress(tail) + (long)pos, rem);
        } else {
            UnsafeAccess.copy(srcPtr, tail.array(), tail.arrayOffset() + pos, (long)rem);
        }
        tail.position(pos + rem);
    }

    @Override
    public void writePage(long index, byte[] src, int offset) throws IOException {
        this.writeCheck(index);
        int pageSize = this.mPageSize;
        UnsafeAccess.copy(src, offset, this.mappingPtr() + index * (long)pageSize, (long)pageSize);
    }

    @Override
    public void writePage(long index, byte[] src, int offset, ByteBuffer tail) throws IOException {
        this.writeCheck(index);
        int pageSize = this.mPageSize;
        long dstPtr = this.mappingPtr() + index * (long)pageSize;
        int length = pageSize - tail.remaining();
        UnsafeAccess.copy(src, offset, dstPtr, (long)length);
        MappedPageArray.writeTail(dstPtr + (long)length, tail);
    }

    @Override
    public void writePage(long index, long srcPtr, int offset) throws IOException {
        this.writeCheck(index);
        int pageSize = this.mPageSize;
        long dstPtr = this.mappingPtr() + index * (long)pageSize;
        if (dstPtr != (srcPtr += (long)offset)) {
            UnsafeAccess.copy(srcPtr, dstPtr, pageSize);
        }
    }

    @Override
    public void writePage(long index, long srcPtr, int offset, ByteBuffer tail) throws IOException {
        this.writeCheck(index);
        int pageSize = this.mPageSize;
        long dstPtr = this.mappingPtr() + index * (long)pageSize;
        int length = pageSize - tail.remaining();
        if (dstPtr != (srcPtr += (long)offset)) {
            UnsafeAccess.copy(srcPtr, dstPtr, length);
        }
        MappedPageArray.writeTail(dstPtr + (long)length, tail);
    }

    private static void writeTail(long dstPtr, ByteBuffer tail) {
        int rem = tail.remaining();
        int pos = tail.position();
        if (tail.isDirect()) {
            UnsafeAccess.copy(DirectAccess.getAddress(tail) + (long)pos, dstPtr, rem);
        } else {
            UnsafeAccess.copy(tail.array(), tail.arrayOffset() + pos, dstPtr, (long)rem);
        }
        tail.position(pos + rem);
    }

    @Override
    public long directPagePointer(long index) throws IOException {
        this.readCheck(index);
        return this.mappingPtr() + index * (long)this.mPageSize;
    }

    @Override
    public long copyPage(long srcIndex, long dstIndex) throws IOException {
        this.readCheck(srcIndex);
        this.writeCheck(dstIndex);
        int pageSize = this.mPageSize;
        long ptr = this.mappingPtr();
        long dstPtr = ptr + dstIndex * (long)pageSize;
        UnsafeAccess.copy(ptr + srcIndex * (long)pageSize, dstPtr, pageSize);
        return dstPtr;
    }

    @Override
    public long copyPageFromPointer(long srcPointer, long dstIndex) throws IOException {
        this.writeCheck(dstIndex);
        int pageSize = this.mPageSize;
        long dstPtr = this.mappingPtr() + dstIndex * (long)pageSize;
        UnsafeAccess.copy(srcPointer, dstPtr, pageSize);
        return dstPtr;
    }

    @Override
    public void sync(boolean metadata) throws IOException {
        this.doSync(this.mappingPtr(), metadata);
    }

    @Override
    public void syncPage(long index) throws IOException {
        this.writeCheck(index);
        this.doSyncPage(this.mappingPtr(), index);
    }

    @Override
    public final void close(Throwable cause) throws IOException {
        long ptr;
        do {
            if ((ptr = this.mMappingPtr) == 0L) {
                return;
            }
            cCauseHandle.compareAndSet(this, null, cause);
        } while (!cMappingPtrHandle.compareAndSet(this, ptr, 0));
        this.mCause = cause;
        this.doClose(ptr);
    }

    @Override
    public MappedPageArray open() throws IOException {
        return this.mMappingPtr == 0L ? this.doOpen() : this;
    }

    void setMappingPtr(long ptr) throws IOException {
        while (!cMappingPtrHandle.compareAndSet(this, 0, ptr)) {
            if (this.mMappingPtr == 0L) continue;
            throw new IllegalStateException();
        }
    }

    abstract MappedPageArray doOpen() throws IOException;

    abstract void doSync(long var1, boolean var3) throws IOException;

    abstract void doSyncPage(long var1, long var3) throws IOException;

    abstract void doClose(long var1) throws IOException;

    long mappingPtr() throws IOException {
        long mappingPtr = this.mMappingPtr;
        if (mappingPtr == 0L) {
            ClosedChannelException cce = new ClosedChannelException();
            cce.initCause(this.mCause);
            throw cce;
        }
        return mappingPtr;
    }

    private void readCheck(long index) throws IOException {
        if (index < 0L) {
            throw new IOException("Negative page index: " + index);
        }
        if (index >= this.mPageCount) {
            throw new IOException("Page index too high: " + index + " > " + this.mPageCount);
        }
    }

    private void writeCheck(long index) throws IOException {
        if (index < 0L) {
            throw new IOException("Negative page index: " + index);
        }
        if (index >= this.mPageCount) {
            throw new DatabaseFullException("Mapped file length limit reached: " + this.mPageCount * (long)this.mPageSize);
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cMappingPtrHandle = lookup.findVarHandle(MappedPageArray.class, "mMappingPtr", Long.TYPE);
            cCauseHandle = lookup.findVarHandle(MappedPageArray.class, "mCause", Throwable.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }
}

