/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.cojen.tupl.io.NioMapping;

abstract class Mapping
implements Closeable {
    Mapping() {
    }

    static Mapping open(File file, boolean readOnly, long position, int size) throws IOException {
        return new NioMapping(file, readOnly, position, size);
    }

    abstract int size();

    abstract void read(int var1, byte[] var2, int var3, int var4);

    abstract void read(int var1, ByteBuffer var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(int start, ByteBuffer bb, int len) {
        int limit = bb.limit();
        bb.limit(bb.position() + len);
        try {
            this.read(start, bb);
        }
        finally {
            bb.limit(limit);
        }
    }

    abstract void write(int var1, byte[] var2, int var3, int var4);

    abstract void write(int var1, ByteBuffer var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(int start, ByteBuffer bb, int len) {
        int limit = bb.limit();
        bb.limit(bb.position() + len);
        try {
            this.write(start, bb);
        }
        finally {
            bb.limit(limit);
        }
    }

    abstract void sync(boolean var1) throws IOException;
}

