/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cojen.tupl.io.CauseCloseable;
import org.cojen.tupl.io.UnsafeAccess;

public abstract class PageArray
implements CauseCloseable {
    final int mPageSize;

    protected PageArray(int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size must be at least 1: " + pageSize);
        }
        this.mPageSize = pageSize;
    }

    public final boolean isDirectIO() {
        return this.directPageSize() < 0;
    }

    public final int pageSize() {
        return this.mPageSize;
    }

    public int directPageSize() {
        return this.pageSize();
    }

    public boolean isFullyMapped() {
        return false;
    }

    public abstract boolean isReadOnly();

    public abstract boolean isEmpty() throws IOException;

    public abstract long pageCount() throws IOException;

    public abstract void truncatePageCount(long var1) throws IOException;

    public abstract void expandPageCount(long var1) throws IOException;

    public long pageCountLimit() throws IOException {
        return -1L;
    }

    public void readPage(long index, byte[] dst) throws IOException {
        this.readPage(index, dst, 0, this.mPageSize);
    }

    public abstract void readPage(long var1, byte[] var3, int var4, int var5) throws IOException;

    public void readPage(long index, byte[] dst, int offset, int length, ByteBuffer tail) throws IOException {
        byte[] page = new byte[length + tail.remaining()];
        this.readPage(index, page, 0, page.length);
        System.arraycopy(page, 0, dst, offset, length);
        tail.put(page, length, tail.remaining());
    }

    public void readPage(long index, long dstPtr) throws IOException {
        this.readPage(index, dstPtr, 0, this.mPageSize);
    }

    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readPage(long index, long dstPtr, int offset, int length, ByteBuffer tail) throws IOException {
        byte[] page = new byte[length + tail.remaining()];
        this.readPage(index, page, 0, page.length);
        UnsafeAccess.copy(page, 0, dstPtr + (long)offset, (long)length);
        tail.put(page, length, tail.remaining());
    }

    public void writePage(long index, byte[] src) throws IOException {
        this.writePage(index, src, 0);
    }

    public abstract void writePage(long var1, byte[] var3, int var4) throws IOException;

    public abstract void writePage(long var1, byte[] var3, int var4, ByteBuffer var5) throws IOException;

    public void writePage(long index, long srcPtr) throws IOException {
        this.writePage(index, srcPtr, 0);
    }

    public void writePage(long index, long srcPtr, int offset) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writePage(long index, long srcPtr, int offset, ByteBuffer tail) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] evictPage(long index, byte[] buf) throws IOException {
        this.writePage(index, buf);
        return buf;
    }

    public long evictPage(long index, long bufPtr) throws IOException {
        this.writePage(index, bufPtr);
        return bufPtr;
    }

    public long directPagePointer(long index) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long dirtyPage(long index) throws IOException {
        return this.directPagePointer(index);
    }

    public long copyPage(long srcIndex, long dstIndex) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long copyPageFromPointer(long srcPointer, long dstIndex) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void sync(boolean var1) throws IOException;

    public void syncPage(long index) throws IOException {
        this.sync(false);
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    @Override
    public abstract void close(Throwable var1) throws IOException;

    public PageArray open() throws IOException {
        return this;
    }
}

