/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.cojen.tupl.io.AbstractFileIO;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.JavaFileIO;
import org.cojen.tupl.io.LengthOption;
import org.cojen.tupl.io.Mapping;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PosixMapping;
import org.cojen.tupl.io.Utils;

final class PosixFileIO
extends AbstractFileIO {
    private static final int REOPEN_NON_DURABLE = 1;
    private static final int REOPEN_SYNC_IO = 2;
    private static final int REOPEN_DIRECT_IO = 4;
    private final File mFile;
    private final int mReopenOptions;
    private final ThreadLocal<BufRef> mBufRef;
    private final ThreadLocal<BufRef> mBufRefAlt;
    private final ThreadLocal<BufRef> mIovecRef;
    private final boolean mReadahead;
    private final boolean mCloseDontNeed;
    private int mFileDescriptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PosixFileIO(File file, EnumSet<OpenOption> options) throws IOException {
        super(options);
        this.mFile = file;
        if (options.contains((Object)OpenOption.NON_DURABLE)) {
            this.mReopenOptions = 1;
        } else {
            int reopenOpts = 0;
            if (options.contains((Object)OpenOption.SYNC_IO)) {
                reopenOpts |= 2;
            }
            if (options.contains((Object)OpenOption.DIRECT_IO)) {
                reopenOpts |= 4;
            }
            this.mReopenOptions = reopenOpts;
            if (options.contains((Object)OpenOption.CREATE)) {
                new JavaFileIO(file, options, 1, false).close();
            }
        }
        this.mReadahead = options.contains((Object)OpenOption.READAHEAD);
        this.mCloseDontNeed = options.contains((Object)OpenOption.CLOSE_DONTNEED);
        this.mAccessLock.acquireExclusive();
        try {
            this.mFileDescriptor = PosixFileIO.openFd(file, options);
        }
        finally {
            this.mAccessLock.releaseExclusive();
        }
        this.mBufRef = new ThreadLocal();
        this.mBufRefAlt = new ThreadLocal();
        this.mIovecRef = new ThreadLocal();
        if (options.contains((Object)OpenOption.MAPPED)) {
            this.map();
        }
        if (options.contains((Object)OpenOption.CREATE)) {
            PosixFileIO.dirSync(file);
        }
    }

    @Override
    public boolean isDirectIO() {
        return (this.mReopenOptions & 4) != 0;
    }

    @Override
    protected long doLength() throws IOException {
        return PosixFileIO.lseekEndFd(this.fd(), 0L);
    }

    @Override
    protected void doSetLength(long length) throws IOException {
        PosixFileIO.ftruncateFd(this.fd(), length);
    }

    @Override
    protected void doRead(long pos, byte[] buf, int offset, int length) throws IOException {
        BufRef ref = this.bufRef(length);
        PosixFileIO.preadFd(this.fd(), ref.mPointer, length, pos);
        ByteBuffer bb = ref.mBuffer;
        bb.position(0);
        bb.get(buf, offset, length);
    }

    @Override
    protected void doRead(long pos, byte[] buf, int offset, int length, ByteBuffer tail) throws IOException {
        ByteBuffer bb = this.bufRef((int)length).mBuffer;
        bb.position(0);
        this.doRead(pos, bb, tail);
        bb.position(0);
        bb.get(buf, offset, length);
    }

    private void doRead(long pos, ByteBuffer bb1, byte[] buf2, int offset2, int length2) throws IOException {
        ByteBuffer bb2 = this.bufRefAlt((int)length2).mBuffer;
        bb2.position(0);
        this.doRead(pos, bb1, bb2);
        bb2.position(0);
        bb2.get(buf2, offset2, length2);
    }

    @Override
    protected void doRead(long pos, ByteBuffer bb) throws IOException {
        int bufPos = bb.position();
        int bufLen = bb.limit() - bufPos;
        if (bb.isDirect()) {
            PosixFileIO.preadFd(this.fd(), DirectAccess.getAddress(bb) + (long)bufPos, bufLen, pos);
        } else {
            this.doRead(pos, bb.array(), bb.arrayOffset() + bufPos, bufLen);
        }
        bb.position(bb.limit());
    }

    @Override
    protected void doRead(long pos, ByteBuffer bb, ByteBuffer tail) throws IOException {
        int bbPos = bb.position();
        int bbLen = bb.limit() - bbPos;
        if (!bb.isDirect()) {
            this.doRead(pos, bb.array(), bb.arrayOffset() + bbPos, bbLen, tail);
            return;
        }
        int tailPos = tail.position();
        int tailLen = tail.limit() - tailPos;
        if (!tail.isDirect()) {
            this.doRead(pos, bb, tail.array(), tail.arrayOffset() + tailPos, tailLen);
            return;
        }
        BufRef iovecRef = this.iovecRef();
        ByteBuffer iovecBuf = iovecRef.mBuffer;
        iovecBuf.putLong(0, DirectAccess.getAddress(bb) + (long)bbPos);
        iovecBuf.putLong(8, bbLen);
        iovecBuf.putLong(16, DirectAccess.getAddress(tail) + (long)tailPos);
        iovecBuf.putLong(24, tailLen);
        int fd = this.fd();
        while (true) {
            int amt;
            if ((amt = PosixFileIO.preadv(fd, iovecRef.mPointer, 2, pos)) <= 0) {
                if (amt < 0) {
                    throw PosixFileIO.lastErrorToException();
                }
                if (bbLen > 0) {
                    throw new EOFException("Attempt to read past end of file: " + pos);
                }
                return;
            }
            pos += (long)amt;
            if (amt >= bbLen) {
                bb.position(bb.limit());
                int tailAmt = amt - bbLen;
                tail.position(tailPos += tailAmt);
                if ((tailLen -= tailAmt) > 0) {
                    PosixFileIO.preadFd(fd, DirectAccess.getAddress(tail) + (long)tailPos, tailLen, pos);
                    tail.position(tail.limit());
                }
                return;
            }
            bb.position(bbPos += amt);
            iovecBuf.putLong(0, DirectAccess.getAddress(bb) + (long)bbPos);
            iovecBuf.putLong(8, bbLen -= amt);
        }
    }

    @Override
    protected void doWrite(long pos, byte[] buf, int offset, int length) throws IOException {
        BufRef ref = this.bufRef(length);
        ByteBuffer bb = ref.mBuffer;
        bb.position(0);
        bb.put(buf, offset, length);
        PosixFileIO.pwriteFd(this.fd(), ref.mPointer, length, pos);
    }

    @Override
    protected void doWrite(long pos, byte[] buf, int offset, int length, ByteBuffer tail) throws IOException {
        BufRef ref = this.bufRef(length);
        ByteBuffer bb = ref.mBuffer;
        bb.position(0);
        bb.put(buf, offset, length);
        bb.flip();
        this.doWrite(pos, bb, tail);
    }

    private void doWrite(long pos, ByteBuffer bb1, byte[] buf2, int offset2, int length2) throws IOException {
        BufRef ref2 = this.bufRefAlt(length2);
        ByteBuffer bb2 = ref2.mBuffer;
        bb2.position(0);
        bb2.put(buf2, offset2, length2);
        bb2.flip();
        this.doWrite(pos, bb1, bb2);
    }

    @Override
    protected void doWrite(long pos, ByteBuffer bb) throws IOException {
        int bufPos = bb.position();
        int bufLen = bb.limit() - bufPos;
        if (bb.isDirect()) {
            PosixFileIO.pwriteFd(this.fd(), DirectAccess.getAddress(bb) + (long)bufPos, bufLen, pos);
        } else {
            this.doWrite(pos, bb.array(), bb.arrayOffset() + bufPos, bufLen);
        }
        bb.position(bb.limit());
    }

    @Override
    protected void doWrite(long pos, ByteBuffer bb, ByteBuffer tail) throws IOException {
        int bbPos = bb.position();
        int bbLen = bb.limit() - bbPos;
        if (!bb.isDirect()) {
            this.doWrite(pos, bb.array(), bb.arrayOffset() + bbPos, bbLen, tail);
            return;
        }
        int tailPos = tail.position();
        int tailLen = tail.limit() - tailPos;
        if (!tail.isDirect()) {
            this.doWrite(pos, bb, tail.array(), tail.arrayOffset() + tailPos, tailLen);
            return;
        }
        BufRef iovecRef = this.iovecRef();
        ByteBuffer iovecBuf = iovecRef.mBuffer;
        iovecBuf.putLong(0, DirectAccess.getAddress(bb) + (long)bbPos);
        iovecBuf.putLong(8, bbLen);
        iovecBuf.putLong(16, DirectAccess.getAddress(tail) + (long)tailPos);
        iovecBuf.putLong(24, tailLen);
        int fd = this.fd();
        while (true) {
            int amt;
            if ((amt = PosixFileIO.pwritev(fd, iovecRef.mPointer, 2, pos)) < 0) {
                throw PosixFileIO.lastErrorToException();
            }
            pos += (long)amt;
            if (amt >= bbLen) {
                bb.position(bb.limit());
                int tailAmt = amt - bbLen;
                tail.position(tailPos += tailAmt);
                if ((tailLen -= tailAmt) > 0) {
                    PosixFileIO.pwriteFd(fd, DirectAccess.getAddress(tail) + (long)tailPos, tailLen, pos);
                    tail.position(tail.limit());
                }
                return;
            }
            bb.position(bbPos += amt);
            iovecBuf.putLong(0, DirectAccess.getAddress(bb) + (long)bbPos);
            iovecBuf.putLong(8, bbLen -= amt);
        }
    }

    @Override
    protected Mapping openMapping(boolean readOnly, long pos, int size) throws IOException {
        if (this.mReadahead) {
            PosixFileIO.fadvise(this.mFileDescriptor, pos, size, 3);
        }
        return new PosixMapping(this.mFileDescriptor, readOnly, pos, size);
    }

    @Override
    protected void reopen() throws IOException {
        PosixFileIO.closeFd(this.fd());
        EnumSet<OpenOption> options = EnumSet.noneOf(OpenOption.class);
        if (this.isReadOnly()) {
            options.add(OpenOption.READ_ONLY);
        }
        if ((this.mReopenOptions & 2) != 0) {
            options.add(OpenOption.SYNC_IO);
        }
        if ((this.mReopenOptions & 1) != 0) {
            options.add(OpenOption.NON_DURABLE);
        }
        if ((this.mReopenOptions & 4) != 0) {
            options.add(OpenOption.DIRECT_IO);
        }
        this.mFileDescriptor = PosixFileIO.openFd(this.mFile, options);
    }

    @Override
    protected void doSync(boolean metadata) throws IOException {
        int fd = this.fd();
        if (metadata) {
            PosixFileIO.fsyncFd(fd);
        } else {
            PosixFileIO.fdatasyncFd(fd);
        }
    }

    @Override
    public void close(Throwable cause) throws IOException {
        int fd;
        this.mAccessLock.acquireExclusive();
        try {
            fd = this.mFileDescriptor;
            if (fd == 0) {
                return;
            }
            this.mCause = cause;
            this.mFileDescriptor = 0;
        }
        finally {
            this.mAccessLock.releaseExclusive();
        }
        IOException ex = null;
        try {
            this.unmap(false);
        }
        catch (IOException e) {
            ex = e;
        }
        if (this.mCloseDontNeed) {
            PosixFileIO.fadvise(fd, 0L, 0L, 4);
        }
        try {
            PosixFileIO.closeFd(fd);
        }
        catch (IOException e) {
            Utils.suppress(e, ex);
            throw e;
        }
    }

    private BufRef bufRef(int size) {
        BufRef ref = this.mBufRef.get();
        if (ref == null || ref.mBuffer.capacity() < size) {
            ref = new BufRef(ByteBuffer.allocateDirect(size));
            this.mBufRef.set(ref);
        }
        ref.mBuffer.limit(size);
        return ref;
    }

    private BufRef bufRefAlt(int size) {
        BufRef ref = this.mBufRefAlt.get();
        if (ref == null || ref.mBuffer.capacity() < size) {
            ref = new BufRef(ByteBuffer.allocateDirect(size));
            this.mBufRefAlt.set(ref);
        }
        ref.mBuffer.limit(size);
        return ref;
    }

    private BufRef iovecRef() {
        BufRef ref = this.mIovecRef.get();
        if (ref == null) {
            ByteBuffer bb = ByteBuffer.allocateDirect(32);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            ref = new BufRef(bb);
            this.mIovecRef.set(ref);
        }
        return ref;
    }

    private int fd() throws IOException {
        int fd = this.mFileDescriptor;
        if (fd == 0) {
            ClosedChannelException ex = new ClosedChannelException();
            ex.initCause(this.mCause);
            throw ex;
        }
        return fd;
    }

    static int openFd(File file, EnumSet<OpenOption> options) throws IOException {
        int fd;
        String path = file.getPath();
        int flags = 0;
        if (!options.contains((Object)OpenOption.READ_ONLY)) {
            flags |= 2;
        }
        if (options.contains((Object)OpenOption.NON_DURABLE)) {
            if (options.contains((Object)OpenOption.CREATE)) {
                flags |= 0x40;
            }
            int mode = 384;
            fd = RT.shm_open(path, flags, mode);
        } else {
            if (options.contains((Object)OpenOption.SYNC_IO)) {
                flags |= 0x1000;
            }
            if (options.contains((Object)OpenOption.DIRECT_IO)) {
                flags |= 0x4000;
            }
            fd = PosixFileIO.open(path, flags);
        }
        if (fd == -1) {
            throw PosixFileIO.lastErrorToException();
        }
        if (options.contains((Object)OpenOption.RANDOM_ACCESS)) {
            try {
                PosixFileIO.fadvise(fd, 0L, 0L, 1);
            }
            catch (Throwable e) {
                try {
                    PosixFileIO.closeFd(fd);
                }
                catch (IOException e2) {
                    Utils.suppress(e, e2);
                }
                throw e;
            }
        }
        return fd;
    }

    static long lseekSetFd(int fd, long fileOffset) throws IOException {
        return PosixFileIO.lseekFd(fd, fileOffset, 0);
    }

    static long lseekCurFd(int fd, long fileOffset) throws IOException {
        return PosixFileIO.lseekFd(fd, fileOffset, 1);
    }

    static long lseekEndFd(int fd, long fileOffset) throws IOException {
        return PosixFileIO.lseekFd(fd, fileOffset, 2);
    }

    static long lseekFd(int fd, long fileOffset, int whence) throws IOException {
        long result = PosixFileIO.lseek(fd, fileOffset, whence);
        if (result == -1L) {
            throw PosixFileIO.lastErrorToException(fileOffset);
        }
        return result;
    }

    static void preadFd(int fd, long bufPtr, int length, long fileOffset) throws IOException {
        while (true) {
            int amt;
            if ((amt = PosixFileIO.pread(fd, bufPtr, length, fileOffset)) <= 0) {
                if (amt < 0) {
                    throw PosixFileIO.lastErrorToException(fileOffset);
                }
                if (length > 0) {
                    throw new EOFException("Attempt to read past end of file: " + fileOffset);
                }
                return;
            }
            if ((length -= amt) <= 0) {
                return;
            }
            bufPtr += (long)amt;
            fileOffset += (long)amt;
        }
    }

    static void pwriteFd(int fd, long bufPtr, int length, long fileOffset) throws IOException {
        while (true) {
            int amt;
            if ((amt = PosixFileIO.pwrite(fd, bufPtr, length, fileOffset)) < 0) {
                throw PosixFileIO.lastErrorToException(fileOffset);
            }
            if ((length -= amt) <= 0) {
                return;
            }
            bufPtr += (long)amt;
            fileOffset += (long)amt;
        }
    }

    static void ftruncateFd(int fd, long length) throws IOException {
        if (PosixFileIO.ftruncate(fd, length) == -1) {
            throw PosixFileIO.lastErrorToException();
        }
    }

    static void fsyncFd(int fd) throws IOException {
        int result = Platform.isMac() ? PosixFileIO.fcntl(fd, 51) : PosixFileIO.fsync(fd);
        if (result == -1) {
            throw PosixFileIO.lastErrorToException();
        }
    }

    static void fdatasyncFd(int fd) throws IOException {
        int result = Platform.isMac() ? PosixFileIO.fcntl(fd, 51) : PosixFileIO.fdatasync(fd);
        if (result == -1) {
            throw PosixFileIO.lastErrorToException();
        }
    }

    static void fadvise(int fd, long offset, long length, int advice) throws IOException {
        int result = PosixFileIO.platform().fadvise(fd, offset, length, advice);
        if (result != 0) {
            throw new IOException(PosixFileIO.errorMessage(result));
        }
    }

    static void closeFd(int fd) throws IOException {
        if (PosixFileIO.close(fd) == -1) {
            throw PosixFileIO.lastErrorToException();
        }
    }

    static long mmapFd(long length, int prot, int flags, int fd, long offset) throws IOException {
        long ptr = PosixFileIO.mmap(0L, length, prot, flags, fd, offset);
        if (ptr == -1L) {
            throw PosixFileIO.lastErrorToException(offset);
        }
        return ptr;
    }

    static void msyncAddr(long addr, long length) throws IOException {
        long endAddr = addr + length;
        if (PosixFileIO.msync(addr = addr / (long)PAGE_SIZE * (long)PAGE_SIZE, endAddr - addr, 4) == -1) {
            throw PosixFileIO.lastErrorToException();
        }
    }

    static void munmapAddr(long addr, long length) throws IOException {
        if (PosixFileIO.munmap(addr, length) == -1) {
            throw PosixFileIO.lastErrorToException();
        }
    }

    static IOException lastErrorToException() {
        return new IOException(PosixFileIO.errorMessage(Native.getLastError()));
    }

    static IOException lastErrorToException(long offset) {
        return new IOException(PosixFileIO.errorMessage(Native.getLastError()) + ": offset=" + offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String errorMessage(int errnum) {
        int bufLen = 200;
        long bufPtr = Native.malloc((long)200L);
        if (bufPtr != 0L) {
            try {
                long result = PosixFileIO.strerror_r(errnum, bufPtr, 200);
                if (result != -1L && result != 22L && result != 34L) {
                    String string = new Pointer(result == 0L ? bufPtr : result).getString(0L);
                    return string;
                }
            }
            finally {
                Native.free((long)bufPtr);
            }
        }
        return "Error " + errnum;
    }

    @Override
    protected boolean shouldPreallocate(LengthOption option) {
        return option == LengthOption.PREALLOCATE_ALWAYS || option == LengthOption.PREALLOCATE_OPTIONAL && PosixFileIO.platform() != NullIO.INSTANCE;
    }

    @Override
    protected void doPreallocate(long pos, long length) throws IOException {
        PlatformIO platform = PosixFileIO.platform();
        if (platform == NullIO.INSTANCE) {
            super.doPreallocate(pos, length);
            return;
        }
        int result = platform.fallocate(this.fd(), pos, length);
        if (result != 0) {
            throw new IOException(PosixFileIO.errorMessage(result));
        }
    }

    private static PlatformIO platform() {
        return PlatformHolder.INSTANCE;
    }

    static native long strerror_r(int var0, long var1, int var3);

    static native int open(String var0, int var1);

    static native long lseek(int var0, long var1, int var3);

    static native int pread(int var0, long var1, int var3, long var4);

    static native int pwrite(int var0, long var1, int var3, long var4);

    static native int preadv(int var0, long var1, int var3, long var4);

    static native int pwritev(int var0, long var1, int var3, long var4);

    static native int ftruncate(int var0, long var1);

    static native int fcntl(int var0, int var1);

    static native int fsync(int var0);

    static native int fdatasync(int var0);

    static native int close(int var0);

    static native long mmap(long var0, long var2, int var4, int var5, int var6, long var7);

    static native int msync(long var0, long var2, int var4);

    static native int munmap(long var0, long var2);

    static {
        Native.register((String)Platform.C_LIBRARY_NAME);
    }

    static class BufRef {
        final ByteBuffer mBuffer;
        final long mPointer;

        BufRef(ByteBuffer buffer) {
            this.mBuffer = buffer;
            this.mPointer = Pointer.nativeValue((Pointer)Native.getDirectBufferPointer((Buffer)buffer));
        }
    }

    static class RT {
        RT() {
        }

        static native int shm_open(String var0, int var1, int var2);

        static {
            Native.register((String)"rt");
        }
    }

    private static abstract class PlatformIO {
        private PlatformIO() {
        }

        public abstract int fallocate(int var1, long var2, long var4);

        public abstract int fadvise(int var1, long var2, long var4, int var6);
    }

    private static class NullIO
    extends PlatformIO {
        static final NullIO INSTANCE = new NullIO();

        private NullIO() {
        }

        @Override
        public int fallocate(int fd, long pos, long length) {
            return 0;
        }

        @Override
        public int fadvise(int fd, long offset, long length, int advice) {
            return 0;
        }
    }

    public static class PlatformHolder {
        public static final PlatformIO INSTANCE;

        static {
            PlatformIO inst;
            if (Platform.isMac()) {
                inst = NullIO.INSTANCE;
            } else {
                try {
                    inst = new DefaultIO();
                }
                catch (UnsatisfiedLinkError e) {
                    inst = NullIO.INSTANCE;
                }
            }
            INSTANCE = inst;
        }
    }

    private static class MacIO
    extends PlatformIO {
        private MacIO() {
        }

        @Override
        public int fallocate(int fd, long pos, long length) {
            Fstore.ByReference fstore = new Fstore.ByReference();
            fstore.fst_flags = 4;
            fstore.fst_posmode = 3;
            fstore.fst_offset = 0L;
            fstore.fst_length = length;
            int cmd = 42;
            int result = MacIO.fcntl(fd, cmd, fstore);
            if (result == -1) {
                return Native.getLastError();
            }
            return 0;
        }

        @Override
        public int fadvise(int fd, long offset, long length, int advice) {
            return 0;
        }

        static native int fcntl(int var0, int var1, Fstore.ByReference var2);

        static {
            Native.register((String)Platform.C_LIBRARY_NAME);
        }

        public static class Fstore
        extends Structure {
            public int fst_flags;
            public int fst_posmode;
            public long fst_offset;
            public long fst_length;
            public long fst_bytesalloc;
            private static final String[] FIELDS = new String[]{"fst_flags", "fst_posmode", "fst_offset", "fst_length", "fst_bytesalloc"};

            protected List<String> getFieldOrder() {
                return Arrays.asList(FIELDS);
            }

            public static class ByReference
            extends Fstore
            implements Structure.ByReference {
            }
        }
    }

    private static class DefaultIO
    extends PlatformIO {
        private DefaultIO() {
        }

        @Override
        public int fallocate(int fd, long pos, long length) {
            return DefaultIO.posix_fallocate(fd, pos, length);
        }

        @Override
        public int fadvise(int fd, long offset, long length, int advice) {
            return DefaultIO.posix_fadvise(fd, offset, length, advice);
        }

        static native int posix_fallocate(int var0, long var1, long var3);

        static native int posix_fadvise(int var0, long var1, long var3, int var5);

        static {
            Native.register((String)Platform.C_LIBRARY_NAME);
        }
    }
}

